/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.roi.CvImageMatte;
import com.ge.med.cse.cvf.roi.CvPolygonRoi;
import com.ge.med.cse.cvf.roi.CvRectangularRoi;
import com.ge.med.cse.cvf.roi.CvUserAnnotationModel;
import com.ge.med.jnu.JnMatrix;
import com.ge.med.jnu.JnVector;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpCPI;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.filter.XpImageLut;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CvCPI
extends XpCPI {
    private static double SMALL_NUM = 0.001;
    private static final double EPSILON = 1.0E-4;
    private static final int VP_DIM = 512;
    private static JnMatrix m = new JnMatrix(3, 3);
    private static JnVector b = new JnVector(3);
    private static JnVector v0 = new JnVector(3);
    private static JnVector v1 = new JnVector(3);
    private static Point2D tempPt1 = new Point2D.Double();
    private static Point2D tempPt2 = new Point2D.Double();
    private static Point2D tempPt3 = new Point2D.Double();
    private static XpDicomElement sopUID = new XpDicomElement(8, 24);
    private static XpDicomElement sopClassUID = new XpDicomElement(8, 22);

    public static void applyCPI(XpCPI cpi, List sceneList) {
        int i2;
        int len;
        List refImgSeq;
        int i3;
        Dimension vpDim = new Dimension(512, 512);
        int nscenes = sceneList.size();
        XpCPI.DisplayedArea dispArea = null;
        XpCPI.GraphicAnnotation gAnnot = null;
        XpCPI.SoftcopyVoiLut voiLUT = null;
        List<XpCPI.DisplayedArea> lda = cpi.getDisplayedArea();
        List<XpCPI.SoftcopyVoiLut> svl = cpi.getSoftcopyVoiLut();
        List<XpCPI.GraphicAnnotation> ga = cpi.getGraphicAnnotation();
        XpCPI.SpatialTransformation st = cpi.getSpatialTransformation();
        XpCPI.SoftcopyPresentationLut spl = cpi.getSoftcopyPresentationLut();
        int imgWidth = 0;
        int imgHeight = 0;
        PLutIndexColorModel icm = null;
        SceneCache scenes = new SceneCache(sceneList);
        if (lda != null) {
            for (i3 = 0; i3 < lda.size(); ++i3) {
                dispArea = lda.get(i3);
                refImgSeq = dispArea.refImgSequence;
                if (refImgSeq.size() > 0) continue;
                CvCPI.putAllImages(sceneList, refImgSeq);
            }
        }
        if (svl != null) {
            for (i3 = 0; i3 < svl.size(); ++i3) {
                voiLUT = svl.get(i3);
                refImgSeq = voiLUT.refImgSequence;
                if (refImgSeq.size() > 0) continue;
                CvCPI.putAllImages(sceneList, refImgSeq);
            }
        }
        if (ga != null) {
            for (i3 = 0; i3 < ga.size(); ++i3) {
                gAnnot = ga.get(i3);
                refImgSeq = gAnnot.refImgSequence;
                if (refImgSeq.size() > 0) continue;
                CvCPI.putAllImages(sceneList, refImgSeq);
            }
        }
        if (ga != null) {
            int len2 = ga.size();
            for (int i4 = 0; i4 < len2; ++i4) {
                gAnnot = ga.get(i4);
                List<XpCPI.GraphicObject> rois = gAnnot.graphicSequence;
                List<XpCPI.TextObject> uannos = gAnnot.textSequence;
                int nframes = gAnnot.refImgSequence.size();
                for (int j2 = 0; j2 < nframes; ++j2) {
                    XpImageScene[] isArray;
                    XpCPI.GSPSFrame frame = (XpCPI.GSPSFrame)gAnnot.refImgSequence.get(j2);
                    for (XpImageScene is : isArray = scenes.getScene(frame)) {
                        if (is == null) continue;
                        int nrois = rois.size();
                        for (int k2 = 0; k2 < nrois; ++k2) {
                            XpCPI.GraphicObject gobj = rois.get(k2);
                            RoiActor ra = CvCPI.createROI(gobj.graphicType, gobj.graphicData, gobj.filled, gobj.graphicUnits);
                            if (ra == null) continue;
                            is.add(ra);
                            if (is.getSelectedState() == 1) continue;
                            ra.setSelected(false);
                        }
                        int nannos = uannos.size();
                        for (int k3 = 0; k3 < nannos; ++k3) {
                            XpCPI.TextObject tobj = uannos.get(k3);
                            double bbX = tobj.boundingBox.getX();
                            double bbY = tobj.boundingBox.getY();
                            byte csystem = tobj.bboxUnits;
                            CPoint anchor = new CPoint(bbX, bbY, 0.0, csystem);
                            CPoint target = new CPoint(tobj.anchorPoint.getX(), tobj.anchorPoint.getY(), 0.0, tobj.anchorUnits);
                            String text = tobj.textValue;
                            CvUserAnnotationModel uam = new CvUserAnnotationModel(text, anchor, target);
                            is.add(uam);
                            uam.setShowTarget(tobj.anchorVisibility);
                        }
                    }
                }
            }
        }
        double panx = 0.0;
        double pany = 0.0;
        if (lda != null) {
            len = lda.size();
            for (i2 = 0; i2 < len; ++i2) {
                XpImageScene[] sceneArray;
                dispArea = lda.get(i2);
                XpCPI.GSPSFrame firstframe = (XpCPI.GSPSFrame)dispArea.refImgSequence.get(0);
                for (XpImageScene scene2 : sceneArray = scenes.getScene(firstframe)) {
                    if (scene2 != null) {
                        XpImage img = scene2.getFrame();
                        imgWidth = img.getSlice().width;
                        imgHeight = img.getSlice().height;
                    }
                    double uzoom = dispArea.pixelMagnificationRatio;
                    double tx = dispArea.tlDisplay.getX();
                    double ty = dispArea.tlDisplay.getY();
                    double bx = dispArea.brDisplay.getX();
                    double by = dispArea.brDisplay.getY();
                    double px = bx;
                    double py = ty;
                    double[] data = new double[]{tx, ty, 1.0, bx, by, 1.0, px, py, 1.0};
                    double[] dataX = new double[]{1.0, vpDim.getWidth(), vpDim.getWidth()};
                    double[] dataY = new double[]{1.0, vpDim.getHeight(), 1.0};
                    m.set(data);
                    try {
                        b.set(dataX);
                        m.LUDSolve(b, v0);
                        b.set(dataY);
                        m.LUDSolve(b, v1);
                    }
                    catch (Exception e2) {
                        continue;
                    }
                    double m00 = CvCPI.v0.data[0];
                    double m01 = CvCPI.v0.data[1];
                    double m02 = CvCPI.v0.data[2];
                    double m10 = CvCPI.v1.data[0];
                    double m11 = CvCPI.v1.data[1];
                    double m12 = CvCPI.v1.data[2];
                    AffineTransform at = new AffineTransform(m00, m10, m01, m11, m02, m12);
                    double vp_tx = 0.5 * vpDim.getWidth();
                    double vp_ty = 0.5 * vpDim.getHeight();
                    double im_tx = 0.5 * (double)imgWidth;
                    double im_ty = 0.5 * (double)imgHeight;
                    tempPt1.setLocation(im_tx, im_ty);
                    at.transform(tempPt1, tempPt2);
                    tempPt1.setLocation(vpDim.getWidth() / 2.0, vpDim.getHeight() / 2.0);
                    try {
                        at.inverseTransform(tempPt1, tempPt2);
                    }
                    catch (NoninvertibleTransformException ex1) {
                        ex1.printStackTrace();
                    }
                    panx = im_tx - tempPt2.getX();
                    pany = im_ty - tempPt2.getY();
                    double zoom = 1.0;
                    try {
                        if (imgWidth >= imgHeight) {
                            tempPt1.setLocation(vpDim.getWidth(), vp_ty);
                            at.inverseTransform(tempPt1, tempPt2);
                            tempPt1.setLocation(0.0, vp_ty);
                            at.inverseTransform(tempPt1, tempPt3);
                            double px1 = tempPt2.getX();
                            double px2 = tempPt3.getX();
                            double diffX = Math.abs(px2 - px1);
                            zoom = (double)imgWidth / diffX;
                        } else {
                            tempPt1.setLocation(vp_tx, vpDim.getHeight());
                            at.inverseTransform(tempPt1, tempPt2);
                            tempPt1.setLocation(vp_tx, 0.0);
                            at.inverseTransform(tempPt1, tempPt3);
                            double diffY = Math.abs(tempPt3.getY() - tempPt2.getY());
                            zoom = (double)imgHeight / diffY;
                        }
                    }
                    catch (NoninvertibleTransformException ex) {
                        continue;
                    }
                    int psmode = 100;
                    if (dispArea.presSize.equals("MAGNIFY")) {
                        zoom = uzoom;
                        psmode = 102;
                    } else if (dispArea.presSize.equals("TRUE SIZE")) {
                        psmode = 101;
                    }
                    int nframes = dispArea.refImgSequence.size();
                    for (int j3 = 0; j3 < nframes; ++j3) {
                        XpImageScene[] isArray;
                        XpCPI.GSPSFrame frame = (XpCPI.GSPSFrame)dispArea.refImgSequence.get(j3);
                        for (XpImageScene is : isArray = scenes.getScene(frame)) {
                            if (is == null) continue;
                            XpImageRenderAttributes ira = is.getImageRenderAttributes();
                            ira.setPan(panx, pany);
                            ira.setZoom(zoom);
                            ira.setPresentationSizeMode(psmode);
                            is.setImageRenderAttributes(ira);
                        }
                    }
                }
            }
        }
        if (svl != null) {
            len = svl.size();
            for (i2 = 0; i2 < len; ++i2) {
                voiLUT = svl.get(i2);
                if (!voiLUT.wwwlSpecified) continue;
                double ww = voiLUT.windowWidth;
                double wl = voiLUT.windowCenter;
                int nframes = voiLUT.refImgSequence.size();
                for (int j4 = 0; j4 < nframes; ++j4) {
                    XpImageScene[] isArray;
                    XpCPI.GSPSFrame frame = (XpCPI.GSPSFrame)voiLUT.refImgSequence.get(j4);
                    for (XpImageScene is : isArray = scenes.getScene(frame)) {
                        if (is == null) continue;
                        XpImageRenderAttributes ira = is.getImageRenderAttributes();
                        ira.setWindowing(ww, wl);
                        is.setImageRenderAttributes(ira);
                    }
                }
            }
        }
        for (int i5 = 0; i5 < nscenes; ++i5) {
            double angle;
            XpImageScene is = scenes.get(i5);
            XpImageRenderAttributes ira = is.getImageRenderAttributes();
            ira.setVideoInverted(spl.pLutShape.equals("INVERSE"));
            String lutExplanation = spl.lutExplanation;
            Integer[] lutDesc = spl.lutDescriptor;
            Integer[] lutData = spl.lutData;
            if (lutExplanation != null) {
                IndexColorModel ic;
                if (lutExplanation.equals("g1")) {
                    ic = XpImageLut.g1().getLUT();
                    ira.setColormap(ic);
                } else if (lutExplanation.equals("g2")) {
                    ic = XpImageLut.g2().getLUT();
                    ira.setColormap(ic);
                } else if (lutExplanation.equals("g3")) {
                    ic = XpImageLut.g3().getLUT();
                    ira.setColormap(ic);
                } else if (lutData != null) {
                    if (icm == null) {
                        int[] rgbs = CvCPI.getLutData(lutData, lutDesc);
                        icm = new PLutIndexColorModel(lutExplanation, 16, rgbs.length, rgbs, 0, false, -1, 1);
                    }
                    ira.setColormap(icm);
                }
            }
            XpImageOrientation ior = ira.getImageOrientation();
            double stangle = st.angle;
            if (st.flipHorizontal) {
                stangle = -stangle;
            }
            ior.apply(stangle, st.flipHorizontal);
            XpImage img = is.getFrame();
            if (img instanceof XpMedicalImage && (angle = XpImageUtils.gehcAzimuth((XpMedicalImage)img)) != 0.0) {
                XpImageOrientation eff = new XpImageOrientation();
                eff.rotate(-Math.toRadians(angle));
                int iorstate = ior.getState();
                if (angle == 270.0) {
                    ior.setPan(-panx, -pany);
                    double tmpval = 0.0;
                    switch (iorstate) {
                        case 0: {
                            tmpval = panx;
                            panx = -pany;
                            pany = tmpval;
                            break;
                        }
                        case 1: {
                            pany = -pany;
                            panx = -panx;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            tmpval = panx;
                            panx = pany;
                            pany = -tmpval;
                            break;
                        }
                        case 4: {
                            tmpval = panx;
                            panx = pany;
                            pany = tmpval;
                            break;
                        }
                        case 5: {
                            panx = -panx;
                            break;
                        }
                        case 6: {
                            pany = -pany;
                            break;
                        }
                        case 7: {
                            tmpval = panx;
                            panx = -pany;
                            pany = -tmpval;
                        }
                    }
                    ior.setPan(panx, pany);
                }
                eff.apply(ior);
                ior.set(eff);
            }
            ira.setImageOrientation(ior);
            is.setImageRenderAttributes(ira);
            XpImage img2 = is.getFrame();
            imgWidth = img2.getSlice().width;
            imgHeight = img2.getSlice().height;
        }
    }

    public static RoiActor createROI(String graphicType, List gdata, boolean filled, byte csystem) {
        XpStatisticsRoi ra = null;
        if (!graphicType.equals("POINT")) {
            if (graphicType.equals("POLYLINE")) {
                int npts = gdata.size();
                List rgdata = CvCPI.dupPointList(gdata);
                boolean isRect = false;
                if (npts == 5) {
                    Point2D p1 = (Point2D)rgdata.get(0);
                    Point2D p2 = (Point2D)rgdata.get(1);
                    Point2D p3 = (Point2D)rgdata.get(2);
                    Point2D p4 = (Point2D)rgdata.get(3);
                    Point2D p5 = (Point2D)rgdata.get(4);
                    if (p1.getX() == p5.getX() && p1.getY() == p5.getY()) {
                        double cx = (p1.getX() + p2.getX() + p3.getX() + p4.getX()) / 4.0;
                        double cy = (p1.getY() + p2.getY() + p3.getY() + p4.getY()) / 4.0;
                        double angle = Math.atan((p1.getY() - p2.getY()) / (p2.getX() - p1.getX()));
                        XpGeomUtils gu = new XpGeomUtils();
                        gu.getRotatedPoint(p1.getX(), p1.getY(), angle, cx, cy, p1);
                        gu.getRotatedPoint(p2.getX(), p2.getY(), angle, cx, cy, p2);
                        gu.getRotatedPoint(p3.getX(), p3.getY(), angle, cx, cy, p3);
                        gu.getRotatedPoint(p4.getX(), p4.getY(), angle, cx, cy, p4);
                        gu.getRotatedPoint(p5.getX(), p5.getY(), angle, cx, cy, p5);
                        double diff1 = Math.abs(p2.getX() - p3.getX());
                        double diff2 = Math.abs(p1.getX() - p4.getX());
                        if (diff1 < SMALL_NUM && diff2 < SMALL_NUM) {
                            double ulX = Double.MAX_VALUE;
                            double ulY = Double.MAX_VALUE;
                            double brX = Double.MIN_VALUE;
                            double brY = Double.MIN_VALUE;
                            for (int i2 = 0; i2 < rgdata.size(); ++i2) {
                                Point2D p6 = (Point2D)rgdata.get(i2);
                                double x2 = p6.getX();
                                double y2 = p6.getY();
                                if (x2 < ulX) {
                                    ulX = x2;
                                }
                                if (x2 > brX) {
                                    brX = x2;
                                }
                                if (y2 < ulY) {
                                    ulY = y2;
                                }
                                if (!(y2 > brY)) continue;
                                brY = y2;
                            }
                            double w2 = Math.abs(ulX - brX);
                            double h2 = Math.abs(ulY - brY);
                            Rectangle2D.Double r2 = new Rectangle2D.Double(ulX, ulY, w2, h2);
                            CvRectangularRoi.Rectangle xrr = new CvRectangularRoi.Rectangle(r2);
                            xrr.setAngle(angle);
                            ra = xrr;
                            isRect = true;
                        }
                    }
                }
                if (!isRect) {
                    Point2D[] pts = new Point2D[npts];
                    for (int i3 = 0; i3 < npts; ++i3) {
                        Point2D p7 = (Point2D)gdata.get(i3);
                        double x3 = p7.getX();
                        double y3 = p7.getY();
                        pts[i3] = new Point2D.Double(x3, y3);
                    }
                    boolean doHandles = true;
                    if (pts.length > 50) {
                        doHandles = false;
                    }
                    ra = new CvPolygonRoi(pts, false, doHandles);
                    ra.setClosed(filled);
                }
            } else if (graphicType.equals("INTERPOLATED")) {
                int npts = gdata.size();
                Point2D[] pts = new Point2D[npts];
                for (int i4 = 0; i4 < npts; ++i4) {
                    Point2D p8 = (Point2D)gdata.get(i4);
                    double x4 = p8.getX();
                    double y4 = p8.getY();
                    pts[i4] = new Point2D.Double(x4, y4);
                }
                boolean doHandles = true;
                if (pts.length > 50) {
                    doHandles = false;
                }
                ra = new CvPolygonRoi(pts, false, doHandles);
            } else if (graphicType.equals("CIRCLE")) {
                Point2D center = (Point2D)gdata.get(0);
                Point2D circ = (Point2D)gdata.get(1);
                double cx = center.getX();
                double cy = center.getY();
                double dx = circ.getX() - cx;
                double dy = circ.getY() - cy;
                double radius = Math.sqrt(dx * dx + dy * dy);
                double x5 = cx - radius;
                double y5 = cy - radius;
                double dim = 2.0 * radius;
                Ellipse2D.Double e2 = new Ellipse2D.Double(x5, y5, dim, dim);
                ra = new CvRectangularRoi.Ellipse(e2);
            } else if (graphicType.equals("ELLIPSE")) {
                List rgdata = CvCPI.dupPointList(gdata);
                double ulX = Double.MAX_VALUE;
                double ulY = Double.MAX_VALUE;
                double brX = Double.MIN_VALUE;
                double brY = Double.MIN_VALUE;
                Point2D p1 = (Point2D)rgdata.get(0);
                Point2D p2 = (Point2D)rgdata.get(1);
                Point2D p3 = (Point2D)rgdata.get(2);
                Point2D p4 = (Point2D)rgdata.get(3);
                double cx = (p1.getX() + p2.getX() + p3.getX() + p4.getX()) / 4.0;
                double cy = (p1.getY() + p2.getY() + p3.getY() + p4.getY()) / 4.0;
                double num = p1.getY() - p2.getY();
                double denom = p2.getX() - p1.getX();
                if (Math.abs(denom) > 1.0E-4 || Math.abs(num) > 1.0E-4) {
                    double angle = 0.0;
                    if (Math.abs(denom) > 1.0E-4) {
                        angle = Math.atan(num / denom);
                    }
                    XpGeomUtils gu = new XpGeomUtils();
                    gu.getRotatedPoint(p1.getX(), p1.getY(), angle, cx, cy, p1);
                    gu.getRotatedPoint(p2.getX(), p2.getY(), angle, cx, cy, p2);
                    gu.getRotatedPoint(p3.getX(), p3.getY(), angle, cx, cy, p3);
                    gu.getRotatedPoint(p4.getX(), p4.getY(), angle, cx, cy, p4);
                    for (int i5 = 0; i5 < rgdata.size(); ++i5) {
                        Point2D p9 = (Point2D)rgdata.get(i5);
                        double x6 = p9.getX();
                        double y6 = p9.getY();
                        if (x6 < ulX) {
                            ulX = x6;
                        }
                        if (x6 > brX) {
                            brX = x6;
                        }
                        if (y6 < ulY) {
                            ulY = y6;
                        }
                        if (!(y6 > brY)) continue;
                        brY = y6;
                    }
                    double w3 = Math.abs(ulX - brX);
                    double h3 = Math.abs(ulY - brY);
                    Ellipse2D.Double e3 = new Ellipse2D.Double(ulX, ulY, w3, h3);
                    CvRectangularRoi.Ellipse rr = new CvRectangularRoi.Ellipse(e3);
                    rr.setAngle(angle);
                    ra = rr;
                }
            }
        }
        return ra;
    }

    private static List dupPointList(List data) {
        ArrayList<Point2D.Double> dupdata = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Point2D p2 = (Point2D)data.get(i2);
            Point2D.Double np = new Point2D.Double();
            np.setLocation(p2);
            dupdata.add(np);
        }
        return dupdata;
    }

    private static int[] getLutData(Integer[] data, Integer[] lutDesc) {
        int len = lutDesc[0];
        int nbits = lutDesc[2];
        int maxval = (int)Math.pow(2.0, nbits);
        int[] rgbs = new int[data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            int val = data[i2];
            double n2 = (double)val / (double)maxval * 255.0;
            int grey = (int)n2 & 0xFF;
            rgbs[i2] = grey << 16 & 0xFF0000 | grey << 8 & 0xFF00 | grey & 0xFF;
        }
        return rgbs;
    }

    private static Shape getShape(XpCPI.DisplayShutter ds) {
        Shape s2 = null;
        if (ds.shutterShape.equals("RECTANGULAR")) {
            Point2D ul = ds.rectULPoint;
            Point2D br = ds.rectBRPoint;
            double w2 = Math.abs(ul.getX() - br.getX());
            double h2 = Math.abs(ul.getY() - br.getY());
            s2 = new Rectangle2D.Double(ul.getX(), ul.getY(), w2, h2);
        } else if (ds.shutterShape.equals("CIRCULAR")) {
            double r2 = ds.circularRadius;
            double x2 = ds.circularCenter.getX() - r2;
            double y2 = ds.circularCenter.getY() - r2;
            s2 = new Ellipse2D.Double(x2, y2, 2.0 * r2, 2.0 * r2);
        }
        if (ds.shutterShape.equals("POLYGONAL")) {
            GeneralPath gp = new GeneralPath();
            gp.reset();
            int len = ds.polygonalVertices.size();
            for (int i2 = 0; i2 < len; ++i2) {
                Point2D p2 = ds.polygonalVertices.get(i2);
                if (i2 == 0) {
                    gp.moveTo((float)p2.getX(), (float)p2.getY());
                    continue;
                }
                gp.lineTo((float)p2.getX(), (float)p2.getY());
            }
            if (len > 2) {
                Point2D p3 = ds.polygonalVertices.get(0);
                gp.lineTo((float)p3.getX(), (float)p3.getY());
            }
            s2 = gp;
        }
        return s2;
    }

    public static void applyDisplayShutter(XpCPI cpi, List sceneList) {
        XpCPI.DisplayShutter ds = null;
        ds = cpi.getDisplayShutter(0);
        if (ds == null) {
            ds = cpi.getDisplayShutter(1);
        }
        if (ds != null) {
            int size = sceneList.size();
            Shape s2 = CvCPI.getShape(ds);
            if (s2 != null && s2 instanceof RectangularShape) {
                for (int i2 = size - 1; i2 > -1; --i2) {
                    XpImageScene is = (XpImageScene)sceneList.get(i2);
                    if (is == null) continue;
                    CvImageMatte ra = new CvImageMatte((RectangularShape)s2);
                    is.add(ra);
                }
            }
        }
    }

    public static void applyDisplayShutter(XpCPI cpi, ROICapable cc) {
        Shape s2;
        XpCPI.DisplayShutter ds = cpi.getDisplayShutter(0);
        if (ds == null) {
            ds = cpi.getDisplayShutter(1);
        }
        if (ds != null && (s2 = CvCPI.getShape(ds)) != null && s2 instanceof RectangularShape && cc instanceof ROICapable) {
            CvImageMatte ra = new CvImageMatte((RectangularShape)s2);
            cc.add(ra);
            return;
        }
    }

    private static class PLutIndexColorModel
    extends IndexColorModel {
        private String plutName = "";

        public PLutIndexColorModel(String lutName, int bits, int size, int[] cmap, int start, boolean hasalpha, int trans, int transferType) {
            super(bits, size, cmap, start, hasalpha, trans, transferType);
            this.plutName = lutName;
        }

        @Override
        public final String toString() {
            return this.plutName;
        }
    }

    private static class SceneCache {
        private List<XpImageScene> scenes = null;
        private Map<String, XpImageScene> cache = new HashMap<String, XpImageScene>();
        private boolean cacheBuild = true;

        public SceneCache(List scenes) {
            this.scenes = scenes;
        }

        public XpImageScene[] getScene(XpCPI.GSPSFrame frame) {
            int len = this.scenes.size();
            XpImageScene[] imgScenes = null;
            if (frame.ReferencedFrameNum.size() > 0) {
                ArrayList<XpImageScene> imgSceneList = new ArrayList<XpImageScene>();
                for (int i2 = 0; i2 < this.scenes.size(); ++i2) {
                    XpImage xpImg = this.scenes.get(i2).getFrame();
                    if (!(xpImg instanceof XpMedicalImage)) continue;
                    XpMedicalImage img = (XpMedicalImage)xpImg;
                    img.getValue(sopUID);
                    int frameNumber = XpCPI.getFrameNumber(img);
                    if (sopUID.value == null) continue;
                    String str = (String)sopUID.value;
                    Integer frameIndex = new Integer(frameNumber + 1);
                    if (!str.equals(frame.SOPInstanceUID) || !frame.ReferencedFrameNum.contains(frameIndex)) continue;
                    imgSceneList.add(this.scenes.get(i2));
                }
                imgScenes = imgSceneList.toArray(new XpImageScene[imgSceneList.size()]);
                return imgScenes;
            }
            if (this.cacheBuild) {
                this.cacheBuild = false;
                for (int i3 = 0; i3 < len; ++i3) {
                    XpImageScene is = this.scenes.get(i3);
                    XpImage img = is.getFrame();
                    if (!(img instanceof XpMedicalImage)) continue;
                    XpMedicalImage mimg = (XpMedicalImage)img;
                    mimg.getValue(sopUID);
                    if (sopUID.value == null) continue;
                    this.cache.put((String)sopUID.value, is);
                }
            }
            imgScenes = new XpImageScene[]{this.cache.get(frame.SOPInstanceUID)};
            return imgScenes;
        }

        public XpImageScene get(int i2) {
            return this.scenes.get(i2);
        }

        public final int size() {
            return this.scenes.size();
        }
    }
}

