/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.annotation.XpCVAnnotationGenerator;
import com.ge.med.cse.cvf.crossref.XpReferenceImageApp;
import com.ge.med.cse.cvf.textpage.TextPage;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomPrintablePort;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpViewport;
import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.HashMap;
import javax.swing.JComponent;

public class DicomPageablePort
implements Pageable {
    private XpViewport port_ = null;
    private JComponent comp_ = null;
    private int start_ = 0;
    private int end_ = 0;
    private int interval_ = 1;
    private int numpages = 0;
    private boolean isRefAllOn_ = false;
    private String annotLevel_;
    private int customAnnotMask_;
    private int[] annotkey = null;
    private Dimension portSize_ = null;
    private HashMap<Integer, Printable> cache = new HashMap();

    public DicomPageablePort(XpViewport port, int startindex, int endindex, int interval) {
        if (!(port instanceof FramePositioningCapable)) {
            throw new IllegalArgumentException("Port not FramePositioningCapable !!");
        }
        this.port_ = port;
        this.start_ = startindex < 0 ? 0 : startindex;
        this.end_ = endindex >= ((FramePositioningCapable)((Object)this.port_)).getNumFrames() ? ((FramePositioningCapable)((Object)this.port_)).getNumFrames() - 1 : endindex;
        this.interval_ = interval;
        this.numpages = (this.end_ - this.start_) / this.interval_ + 1;
    }

    public DicomPageablePort(JComponent comp) {
        if (!(comp instanceof TextPage)) {
            throw new IllegalArgumentException("This component cant be made as DicomPageablePort !!");
        }
        this.comp_ = (TextPage)comp;
        this.numpages = ((TextPage)this.comp_).getPageCount();
    }

    public void setReferenceOn(boolean refOn) {
        this.isRefAllOn_ = refOn;
    }

    public void setSize(Dimension dim) {
        this.portSize_ = dim;
    }

    public Dimension getSize() {
        return this.portSize_;
    }

    public void dispose() {
        for (Printable p2 : this.cache.values()) {
            if (!(p2 instanceof DicomPrintablePort)) continue;
            ((DicomPrintablePort)p2).dispose();
        }
        this.cache.clear();
        if (this.isRefAllOn_) {
            XpReferenceImageApp.removeReferenceImage(this.port_, false);
        }
        this.port_.dispose();
        this.port_ = null;
    }

    public void setFilmAnnotationSetting(String annotLevel, int customAnnotMask) {
        this.annotLevel_ = annotLevel;
        this.customAnnotMask_ = customAnnotMask;
    }

    public void setLargeFontKeys(int[] akey) {
        this.annotkey = akey;
    }

    @Override
    public int getNumberOfPages() {
        return this.numpages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0 || pageIndex >= this.numpages) {
            throw new ArrayIndexOutOfBoundsException(pageIndex + " >= " + this.numpages);
        }
        return new PageFormat();
    }

    public void disposePrintable(int pageIndex) {
        Printable p2 = this.cache.get(new Integer(pageIndex));
        if (p2 instanceof DicomPrintablePort) {
            ((DicomPrintablePort)p2).dispose();
        }
        this.cache.remove(new Integer(pageIndex));
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0 || pageIndex >= this.numpages) {
            throw new ArrayIndexOutOfBoundsException(pageIndex + " >= " + this.numpages);
        }
        Printable printable = null;
        printable = this.cache.get(new Integer(pageIndex));
        if (printable != null) {
            return printable;
        }
        if (this.comp_ != null && this.comp_ instanceof TextPage) {
            TextPage pageToPrint = (TextPage)this.comp_;
            pageToPrint.setPage(pageIndex);
            printable = CvUtils.getDicomPrintable(pageToPrint);
            pageToPrint.revalidate();
            pageToPrint.repaint();
            this.cache.put(new Integer(pageIndex), printable);
            return printable;
        }
        int frameindex = this.start_ + pageIndex * this.interval_;
        if (frameindex < 0 || frameindex >= ((FramePositioningCapable)((Object)this.port_)).getNumFrames()) {
            throw new ArrayIndexOutOfBoundsException(frameindex + " >= " + ((FramePositioningCapable)((Object)this.port_)).getNumFrames());
        }
        ((FramePositioningCapable)((Object)this.port_)).setFrameIndex(frameindex);
        XpViewport vp = null;
        if (this.port_ instanceof XpCompositePort) {
            vp = (XpViewport)((XpCompositePort)this.port_).getPort(0).clone();
            vp.setSize((int)this.portSize_.getWidth(), (int)this.portSize_.getHeight());
        }
        if (this.isRefAllOn_) {
            XpReferenceImageApp.copyRefPort(this.port_, vp, 0);
            vp.putClientProperty("reference_viewport", "true");
        }
        String annonGenerator = CvPropertiesManager.getProperty("cvf.annotation.generator", XpCVAnnotationGenerator.class.getName());
        try {
            if (vp != null) {
                vp.setAnnotationGenerator(Class.forName(annonGenerator, true, this.getClass().getClassLoader()), null);
            }
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
            return printable;
        }
        printable = CvUtils.getDicomPrintable(vp);
        if (printable instanceof DicomPrintablePort) {
            ((DicomPrintablePort)printable).setFilmAnnotationItems(this.annotLevel_, this.customAnnotMask_);
            if (this.annotkey != null) {
                ((DicomPrintablePort)printable).setLargeFontAnnotation(this.annotkey);
            }
        }
        this.cache.put(new Integer(pageIndex), printable);
        return printable;
    }
}

