/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.idc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class XJTMailer {
    private Socket socket;
    private BufferedReader reader;
    private PrintWriter writer;
    private String smtp;
    private String sender;
    private int port;

    public XJTMailer(String smtp, int port, String sender) {
        this.smtp = smtp;
        this.sender = sender;
        this.port = port;
    }

    private void init(String smtp, int port) throws IOException {
        this.socket = new Socket(smtp, port);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.writer = new PrintWriter(this.socket.getOutputStream());
        if (this.getResponse() / 100 != 2) {
            this.socket.close();
            throw new ConnectException("invalid smtp server " + smtp);
        }
    }

    private void close() throws IOException {
        this.socket.close();
    }

    public void send(String recipient, String subject, String message) throws UnknownHostException, IOException {
        this.init(this.smtp, this.port);
        this.sendCommand("HELO " + InetAddress.getLocalHost().getHostName(), 2);
        this.sendCommand("MAIL From:<" + this.sender + ">", 2);
        this.sendCommand("RCPT TO:<" + recipient + ">", 2);
        this.sendCommand("DATA", 3);
        this.sendMessage(this.sender, recipient, subject, message);
        this.sendCommand("QUIT", 2);
        this.close();
    }

    public void sendHTML(String recipient, String subject, String message) throws UnknownHostException, IOException {
        this.init(this.smtp, this.port);
        this.sendCommand("HELO " + InetAddress.getLocalHost().getHostName(), 2);
        this.sendCommand("MAIL From:<" + this.sender + ">", 2);
        this.sendCommand("RCPT TO:<" + recipient + ">", 2);
        this.sendCommand("DATA", 3);
        this.sendHTMLMessage(this.sender, recipient, subject, message);
        this.sendCommand("QUIT", 2);
        this.close();
    }

    protected void sendCommand(String cmd) {
        this.writer.write(cmd);
        this.writer.write("\r\n");
        this.writer.flush();
    }

    protected void sendCommand(String cmd, int code) throws IOException {
        this.sendCommand(cmd);
        int rc = this.getResponse();
        if (rc / 100 != code) {
            throw new ConnectException(cmd + rc);
        }
    }

    protected void sendHTMLMessage(String sender, String recipient, String subject, String message) throws IOException {
        this.writer.write("From: " + sender + "\r\n");
        this.writer.write("To: " + recipient + "\r\n");
        this.writer.write("Subject: " + subject + "\r\n");
        this.writer.write("Content-Type: text/html; charset=\"us-ascii\"\r\n");
        this.writer.write("\r\n");
        this.writer.write(this.createMessage(message));
        this.writer.write("\r\n.\r\n");
        this.writer.flush();
        if (this.getResponse() / 100 != 2) {
            throw new ConnectException("send HTML email failed");
        }
    }

    protected void sendMessage(String sender, String recipient, String subject, String message) throws IOException {
        this.writer.write("From: " + sender + "\r\n");
        this.writer.write("To: " + recipient + "\r\n");
        this.writer.write("Subject: " + subject + "\r\n");
        this.writer.write("\r\n");
        this.writer.write(this.createMessage(message));
        this.writer.write("\r\n.\r\n");
        this.writer.flush();
        if (this.getResponse() / 100 != 2) {
            throw new ConnectException("send email failed");
        }
    }

    protected String createMessage(String text) {
        StringBuffer buf = new StringBuffer();
        int start = 0;
        int end = 0;
        if (text != null) {
            buf.ensureCapacity(text.length() + 100);
            do {
                String line;
                if ((end = text.indexOf(10, start)) == -1) {
                    line = text.substring(start);
                } else {
                    line = text.substring(start, end);
                    ++end;
                }
                if (line.length() > 0 && line.charAt(0) == '.') {
                    buf.append('.');
                }
                buf.append(line);
                if (end != -1) {
                    buf.append("\r\n");
                }
                start = end;
            } while (end != -1);
        }
        return buf.toString();
    }

    protected int getResponse() throws IOException {
        String line;
        boolean moreLines;
        int responseCode = 0;
        StringBuffer text = new StringBuffer();
        do {
            if (null != (line = this.reader.readLine())) {
                moreLines = line.charAt(3) == '-';
                text.append(line.substring(4, line.length()));
                continue;
            }
            moreLines = false;
        } while (moreLines);
        if (null != line) {
            responseCode = Integer.parseInt(line.substring(0, 3));
        }
        return responseCode;
    }

    public static void main(String[] args) {
        try {
            XJTMailer mailer = new XJTMailer("amermsx.med.ge.com", 25, "xjtmailer@ge.com");
            mailer.send("gabriel.fernandez@med.ge.com", "title", "message");
            mailer.sendHTML("gabriel.fernandez@med.ge.com", "title", "message");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

