/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.Jama;

import com.ge.med.jnu.Jama.Matrix;
import java.io.Serializable;

public class LUDecomposition
implements Serializable {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix A2) {
        this.LU = A2.getArrayCopy();
        this.m = A2.getRowDimension();
        this.n = A2.getColumnDimension();
        this.piv = new int[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            this.piv[i2] = i2;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        for (int j2 = 0; j2 < this.n; ++j2) {
            int i3;
            int i4;
            for (i4 = 0; i4 < this.m; ++i4) {
                LUcolj[i4] = this.LU[i4][j2];
            }
            i4 = 0;
            while (i4 < this.m) {
                double[] LUrowi = this.LU[i4];
                int kmax = Math.min(i4, j2);
                double s2 = 0.0;
                for (int k2 = 0; k2 < kmax; ++k2) {
                    s2 += LUrowi[k2] * LUcolj[k2];
                }
                int n2 = i4++;
                double d2 = LUcolj[n2] - s2;
                LUcolj[n2] = d2;
                LUrowi[j2] = d2;
            }
            int p2 = j2;
            for (i3 = j2 + 1; i3 < this.m; ++i3) {
                if (!(Math.abs(LUcolj[i3]) > Math.abs(LUcolj[p2]))) continue;
                p2 = i3;
            }
            if (p2 != j2) {
                int k3;
                for (k3 = 0; k3 < this.n; ++k3) {
                    double t2 = this.LU[p2][k3];
                    this.LU[p2][k3] = this.LU[j2][k3];
                    this.LU[j2][k3] = t2;
                }
                k3 = this.piv[p2];
                this.piv[p2] = this.piv[j2];
                this.piv[j2] = k3;
                this.pivsign = -this.pivsign;
            }
            if (!(j2 < this.m & this.LU[j2][j2] != 0.0)) continue;
            for (i3 = j2 + 1; i3 < this.m; ++i3) {
                double[] dArray = this.LU[i3];
                int n3 = j2;
                dArray[n3] = dArray[n3] / this.LU[j2][j2];
            }
        }
    }

    public boolean isNonsingular() {
        for (int j2 = 0; j2 < this.n; ++j2) {
            if (this.LU[j2][j2] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getL() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] L2 = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                L2[i2][j2] = i2 > j2 ? this.LU[i2][j2] : (i2 == j2 ? 1.0 : 0.0);
            }
        }
        return X;
    }

    public Matrix getU() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] U = X.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                U[i2][j2] = i2 <= j2 ? this.LU[i2][j2] : 0.0;
            }
        }
        return X;
    }

    public int[] getPivot() {
        int[] p2 = new int[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            p2[i2] = this.piv[i2];
        }
        return p2;
    }

    public double[] getDoublePivot() {
        double[] vals = new double[this.m];
        for (int i2 = 0; i2 < this.m; ++i2) {
            vals[i2] = this.piv[i2];
        }
        return vals;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d2 = this.pivsign;
        for (int j2 = 0; j2 < this.n; ++j2) {
            d2 *= this.LU[j2][j2];
        }
        return d2;
    }

    public Matrix solve(Matrix B) {
        int j2;
        int i2;
        int k2;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getColumnDimension();
        Matrix Xmat = B.getMatrix(this.piv, 0, nx - 1);
        double[][] X = Xmat.getArray();
        for (k2 = 0; k2 < this.n; ++k2) {
            for (i2 = k2 + 1; i2 < this.n; ++i2) {
                for (j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = X[i2];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] - X[k2][j2] * this.LU[i2][k2];
                }
            }
        }
        for (k2 = this.n - 1; k2 >= 0; --k2) {
            int j3 = 0;
            while (j3 < nx) {
                double[] dArray = X[k2];
                int n3 = j3++;
                dArray[n3] = dArray[n3] / this.LU[k2][k2];
            }
            for (i2 = 0; i2 < k2; ++i2) {
                for (j2 = 0; j2 < nx; ++j2) {
                    double[] dArray = X[i2];
                    int n4 = j2;
                    dArray[n4] = dArray[n4] - X[k2][j2] * this.LU[i2][k2];
                }
            }
        }
        return Xmat;
    }
}

