/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.Jama;

import com.ge.med.jnu.Jama.CholeskyDecomposition;
import com.ge.med.jnu.Jama.EigenvalueDecomposition;
import com.ge.med.jnu.Jama.LUDecomposition;
import com.ge.med.jnu.Jama.QRDecomposition;
import com.ge.med.jnu.Jama.SingularValueDecomposition;
import com.ge.med.jnu.Jama.util.Maths;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public class Matrix
implements Cloneable,
Serializable {
    private double[][] A;
    private int m;
    private int n;

    public Matrix(int m2, int n2) {
        this.m = m2;
        this.n = n2;
        this.A = new double[m2][n2];
    }

    public Matrix(int m2, int n2, double s2) {
        this.m = m2;
        this.n = n2;
        this.A = new double[m2][n2];
        for (int i2 = 0; i2 < m2; ++i2) {
            for (int j2 = 0; j2 < n2; ++j2) {
                this.A[i2][j2] = s2;
            }
        }
    }

    public Matrix(double[][] A2) {
        this.m = A2.length;
        this.n = A2[0].length;
        for (int i2 = 0; i2 < this.m; ++i2) {
            if (A2[i2].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.A = A2;
    }

    public Matrix(double[][] A2, int m2, int n2) {
        this.A = A2;
        this.m = m2;
        this.n = n2;
    }

    public Matrix(double[] vals, int m2) {
        this.m = m2;
        int n2 = this.n = m2 != 0 ? vals.length / m2 : 0;
        if (m2 * this.n != vals.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new double[m2][this.n];
        for (int i2 = 0; i2 < m2; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                this.A[i2][j2] = vals[i2 + j2 * m2];
            }
        }
    }

    public static Matrix constructWithCopy(double[][] A2) {
        int m2 = A2.length;
        int n2 = A2[0].length;
        Matrix X = new Matrix(m2, n2);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < m2; ++i2) {
            if (A2[i2].length != n2) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            for (int j2 = 0; j2 < n2; ++j2) {
                C[i2][j2] = A2[i2][j2];
            }
        }
        return X;
    }

    public Matrix copy() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                C[i2][j2] = this.A[i2][j2];
            }
        }
        return X;
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] C = new double[this.m][this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                C[i2][j2] = this.A[i2][j2];
            }
        }
        return C;
    }

    public double[] getColumnPackedCopy() {
        double[] vals = new double[this.m * this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                vals[i2 + j2 * this.m] = this.A[i2][j2];
            }
        }
        return vals;
    }

    public double[] getRowPackedCopy() {
        double[] vals = new double[this.m * this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                vals[i2 * this.n + j2] = this.A[i2][j2];
            }
        }
        return vals;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int i2, int j2) {
        return this.A[i2][j2];
    }

    public Matrix getMatrix(int i0, int i1, int j0, int j1) {
        Matrix X = new Matrix(i1 - i0 + 1, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            for (int i2 = i0; i2 <= i1; ++i2) {
                for (int j2 = j0; j2 <= j1; ++j2) {
                    B[i2 - i0][j2 - j0] = this.A[i2][j2];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public Matrix getMatrix(int[] r2, int[] c2) {
        Matrix X = new Matrix(r2.length, c2.length);
        double[][] B = X.getArray();
        try {
            for (int i2 = 0; i2 < r2.length; ++i2) {
                for (int j2 = 0; j2 < c2.length; ++j2) {
                    B[i2][j2] = this.A[r2[i2]][c2[j2]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public Matrix getMatrix(int i0, int i1, int[] c2) {
        Matrix X = new Matrix(i1 - i0 + 1, c2.length);
        double[][] B = X.getArray();
        try {
            for (int i2 = i0; i2 <= i1; ++i2) {
                for (int j2 = 0; j2 < c2.length; ++j2) {
                    B[i2 - i0][j2] = this.A[i2][c2[j2]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public Matrix getMatrix(int[] r2, int j0, int j1) {
        Matrix X = new Matrix(r2.length, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            for (int i2 = 0; i2 < r2.length; ++i2) {
                for (int j2 = j0; j2 <= j1; ++j2) {
                    B[i2][j2 - j0] = this.A[r2[i2]][j2];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public void set(int i2, int j2, double s2) {
        this.A[i2][j2] = s2;
    }

    public void setMatrix(int i0, int i1, int j0, int j1, Matrix X) {
        try {
            for (int i2 = i0; i2 <= i1; ++i2) {
                for (int j2 = j0; j2 <= j1; ++j2) {
                    this.A[i2][j2] = X.get(i2 - i0, j2 - j0);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r2, int[] c2, Matrix X) {
        try {
            for (int i2 = 0; i2 < r2.length; ++i2) {
                for (int j2 = 0; j2 < c2.length; ++j2) {
                    this.A[r2[i2]][c2[j2]] = X.get(i2, j2);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r2, int j0, int j1, Matrix X) {
        try {
            for (int i2 = 0; i2 < r2.length; ++i2) {
                for (int j2 = j0; j2 <= j1; ++j2) {
                    this.A[r2[i2]][j2] = X.get(i2, j2 - j0);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int i0, int i1, int[] c2, Matrix X) {
        try {
            for (int i2 = i0; i2 <= i1; ++i2) {
                for (int j2 = 0; j2 < c2.length; ++j2) {
                    this.A[i2][c2[j2]] = X.get(i2 - i0, j2);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public Matrix transpose() {
        Matrix X = new Matrix(this.n, this.m);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                C[j2][i2] = this.A[i2][j2];
            }
        }
        return X;
    }

    public double norm1() {
        double f2 = 0.0;
        for (int j2 = 0; j2 < this.n; ++j2) {
            double s2 = 0.0;
            for (int i2 = 0; i2 < this.m; ++i2) {
                s2 += Math.abs(this.A[i2][j2]);
            }
            f2 = Math.max(f2, s2);
        }
        return f2;
    }

    public double norm2() {
        return new SingularValueDecomposition(this).norm2();
    }

    public double normInf() {
        double f2 = 0.0;
        for (int i2 = 0; i2 < this.m; ++i2) {
            double s2 = 0.0;
            for (int j2 = 0; j2 < this.n; ++j2) {
                s2 += Math.abs(this.A[i2][j2]);
            }
            f2 = Math.max(f2, s2);
        }
        return f2;
    }

    public double normF() {
        double f2 = 0.0;
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                f2 = Maths.hypot(f2, this.A[i2][j2]);
            }
        }
        return f2;
    }

    public Matrix uminus() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                C[i2][j2] = -this.A[i2][j2];
            }
        }
        return X;
    }

    public Matrix plus(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                C[i2][j2] = this.A[i2][j2] + B.A[i2][j2];
            }
        }
        return X;
    }

    public Matrix plusEquals(Matrix B) {
        this.checkMatrixDimensions(B);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                this.A[i2][j2] = this.A[i2][j2] + B.A[i2][j2];
            }
        }
        return this;
    }

    public Matrix minus(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                C[i2][j2] = this.A[i2][j2] - B.A[i2][j2];
            }
        }
        return X;
    }

    public Matrix minusEquals(Matrix B) {
        this.checkMatrixDimensions(B);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                this.A[i2][j2] = this.A[i2][j2] - B.A[i2][j2];
            }
        }
        return this;
    }

    public Matrix arrayTimes(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                C[i2][j2] = this.A[i2][j2] * B.A[i2][j2];
            }
        }
        return X;
    }

    public Matrix arrayTimesEquals(Matrix B) {
        this.checkMatrixDimensions(B);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                this.A[i2][j2] = this.A[i2][j2] * B.A[i2][j2];
            }
        }
        return this;
    }

    public Matrix arrayRightDivide(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                C[i2][j2] = this.A[i2][j2] / B.A[i2][j2];
            }
        }
        return X;
    }

    public Matrix arrayRightDivideEquals(Matrix B) {
        this.checkMatrixDimensions(B);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                this.A[i2][j2] = this.A[i2][j2] / B.A[i2][j2];
            }
        }
        return this;
    }

    public Matrix arrayLeftDivide(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                C[i2][j2] = B.A[i2][j2] / this.A[i2][j2];
            }
        }
        return X;
    }

    public Matrix arrayLeftDivideEquals(Matrix B) {
        this.checkMatrixDimensions(B);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                this.A[i2][j2] = B.A[i2][j2] / this.A[i2][j2];
            }
        }
        return this;
    }

    public Matrix times(double s2) {
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                C[i2][j2] = s2 * this.A[i2][j2];
            }
        }
        return X;
    }

    public Matrix timesEquals(double s2) {
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                this.A[i2][j2] = s2 * this.A[i2][j2];
            }
        }
        return this;
    }

    public Matrix times(Matrix B) {
        if (B.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix X = new Matrix(this.m, B.n);
        double[][] C = X.getArray();
        double[] Bcolj = new double[this.n];
        for (int j2 = 0; j2 < B.n; ++j2) {
            for (int k2 = 0; k2 < this.n; ++k2) {
                Bcolj[k2] = B.A[k2][j2];
            }
            for (int i2 = 0; i2 < this.m; ++i2) {
                double[] Arowi = this.A[i2];
                double s2 = 0.0;
                for (int k3 = 0; k3 < this.n; ++k3) {
                    s2 += Arowi[k3] * Bcolj[k3];
                }
                C[i2][j2] = s2;
            }
        }
        return X;
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public CholeskyDecomposition chol() {
        return new CholeskyDecomposition(this);
    }

    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    public Matrix solve(Matrix B) {
        return this.m == this.n ? new LUDecomposition(this).solve(B) : new QRDecomposition(this).solve(B);
    }

    public Matrix solveTranspose(Matrix B) {
        return this.transpose().solve(B.transpose());
    }

    public Matrix inverse() {
        return this.solve(Matrix.identity(this.m, this.m));
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    public int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    public double cond() {
        return new SingularValueDecomposition(this).cond();
    }

    public double trace() {
        double t2 = 0.0;
        for (int i2 = 0; i2 < Math.min(this.m, this.n); ++i2) {
            t2 += this.A[i2][i2];
        }
        return t2;
    }

    public static Matrix random(int m2, int n2) {
        Matrix A2 = new Matrix(m2, n2);
        double[][] X = A2.getArray();
        for (int i2 = 0; i2 < m2; ++i2) {
            for (int j2 = 0; j2 < n2; ++j2) {
                X[i2][j2] = Math.random();
            }
        }
        return A2;
    }

    public static Matrix identity(int m2, int n2) {
        Matrix A2 = new Matrix(m2, n2);
        double[][] X = A2.getArray();
        for (int i2 = 0; i2 < m2; ++i2) {
            for (int j2 = 0; j2 < n2; ++j2) {
                X[i2][j2] = i2 == j2 ? 1.0 : 0.0;
            }
        }
        return A2;
    }

    public void print(int w2, int d2) {
        this.print(new PrintWriter(System.out, true), w2, d2);
    }

    public void print(PrintWriter output, int w2, int d2) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d2);
        format.setMinimumFractionDigits(d2);
        format.setGroupingUsed(false);
        this.print(output, format, w2 + 2);
    }

    public void print(NumberFormat format, int width) {
        this.print(new PrintWriter(System.out, true), format, width);
    }

    public void print(PrintWriter output, NumberFormat format, int width) {
        output.println();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                String s2 = format.format(this.A[i2][j2]);
                int padding = Math.max(1, width - s2.length());
                for (int k2 = 0; k2 < padding; ++k2) {
                    output.print(' ');
                }
                output.print(s2);
            }
            output.println();
        }
        output.println();
    }

    public static Matrix read(BufferedReader input) throws IOException {
        int j2;
        StreamTokenizer tokenizer = new StreamTokenizer(input);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(true);
        Vector<Object> v2 = new Vector<Object>();
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            v2.addElement(Double.valueOf(tokenizer.sval));
        } while (tokenizer.nextToken() == -3);
        int n2 = v2.size();
        double[] row = new double[n2];
        for (j2 = 0; j2 < n2; ++j2) {
            row[j2] = (Double)v2.elementAt(j2);
        }
        v2.removeAllElements();
        v2.addElement(row);
        while (tokenizer.nextToken() == -3) {
            row = new double[n2];
            v2.addElement(row);
            j2 = 0;
            do {
                if (j2 >= n2) {
                    throw new IOException("Row " + v2.size() + " is too long.");
                }
                row[j2++] = Double.valueOf(tokenizer.sval);
            } while (tokenizer.nextToken() == -3);
            if (j2 >= n2) continue;
            throw new IOException("Row " + v2.size() + " is too short.");
        }
        int m2 = v2.size();
        double[][] A2 = new double[m2][];
        v2.copyInto((Object[])A2);
        return new Matrix(A2);
    }

    private void checkMatrixDimensions(Matrix B) {
        if (B.m != this.m || B.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }
}

