/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.Jama;

import com.ge.med.jnu.Jama.Matrix;
import com.ge.med.jnu.Jama.util.Maths;
import java.io.Serializable;

public class QRDecomposition
implements Serializable {
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(Matrix A2) {
        this.QR = A2.getArrayCopy();
        this.m = A2.getRowDimension();
        this.n = A2.getColumnDimension();
        this.Rdiag = new double[this.n];
        for (int k2 = 0; k2 < this.n; ++k2) {
            int i2;
            double nrm = 0.0;
            for (i2 = k2; i2 < this.m; ++i2) {
                nrm = Maths.hypot(nrm, this.QR[i2][k2]);
            }
            if (nrm != 0.0) {
                if (this.QR[k2][k2] < 0.0) {
                    nrm = -nrm;
                }
                for (i2 = k2; i2 < this.m; ++i2) {
                    double[] dArray = this.QR[i2];
                    int n2 = k2;
                    dArray[n2] = dArray[n2] / nrm;
                }
                double[] dArray = this.QR[k2];
                int n3 = k2;
                dArray[n3] = dArray[n3] + 1.0;
                for (int j2 = k2 + 1; j2 < this.n; ++j2) {
                    int i3;
                    double s2 = 0.0;
                    for (i3 = k2; i3 < this.m; ++i3) {
                        s2 += this.QR[i3][k2] * this.QR[i3][j2];
                    }
                    s2 = -s2 / this.QR[k2][k2];
                    for (i3 = k2; i3 < this.m; ++i3) {
                        double[] dArray2 = this.QR[i3];
                        int n4 = j2;
                        dArray2[n4] = dArray2[n4] + s2 * this.QR[i3][k2];
                    }
                }
            }
            this.Rdiag[k2] = -nrm;
        }
    }

    public boolean isFullRank() {
        for (int j2 = 0; j2 < this.n; ++j2) {
            if (this.Rdiag[j2] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix getH() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] H = X.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                H[i2][j2] = i2 >= j2 ? this.QR[i2][j2] : 0.0;
            }
        }
        return X;
    }

    public Matrix getR() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] R2 = X.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                R2[i2][j2] = i2 < j2 ? this.QR[i2][j2] : (i2 == j2 ? this.Rdiag[i2] : 0.0);
            }
        }
        return X;
    }

    public Matrix getQ() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] Q = X.getArray();
        for (int k2 = this.n - 1; k2 >= 0; --k2) {
            for (int i2 = 0; i2 < this.m; ++i2) {
                Q[i2][k2] = 0.0;
            }
            Q[k2][k2] = 1.0;
            for (int j2 = k2; j2 < this.n; ++j2) {
                int i3;
                if (this.QR[k2][k2] == 0.0) continue;
                double s2 = 0.0;
                for (i3 = k2; i3 < this.m; ++i3) {
                    s2 += this.QR[i3][k2] * Q[i3][j2];
                }
                s2 = -s2 / this.QR[k2][k2];
                for (i3 = k2; i3 < this.m; ++i3) {
                    double[] dArray = Q[i3];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] + s2 * this.QR[i3][k2];
                }
            }
        }
        return X;
    }

    public Matrix solve(Matrix B) {
        int j2;
        int k2;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = B.getColumnDimension();
        double[][] X = B.getArrayCopy();
        for (k2 = 0; k2 < this.n; ++k2) {
            for (j2 = 0; j2 < nx; ++j2) {
                int i2;
                double s2 = 0.0;
                for (i2 = k2; i2 < this.m; ++i2) {
                    s2 += this.QR[i2][k2] * X[i2][j2];
                }
                s2 = -s2 / this.QR[k2][k2];
                for (i2 = k2; i2 < this.m; ++i2) {
                    double[] dArray = X[i2];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] + s2 * this.QR[i2][k2];
                }
            }
        }
        for (k2 = this.n - 1; k2 >= 0; --k2) {
            j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k2];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / this.Rdiag[k2];
            }
            for (int i3 = 0; i3 < k2; ++i3) {
                for (int j3 = 0; j3 < nx; ++j3) {
                    double[] dArray = X[i3];
                    int n4 = j3;
                    dArray[n4] = dArray[n4] - X[k2][j3] * this.QR[i3][k2];
                }
            }
        }
        return new Matrix(X, this.n, nx).getMatrix(0, this.n - 1, 0, nx - 1);
    }
}

