/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.Jama;

import com.ge.med.jnu.Jama.Matrix;
import com.ge.med.jnu.Jama.util.Maths;
import java.io.Serializable;

public class SingularValueDecomposition
implements Serializable {
    private double[][] U;
    private double[][] V;
    private double[] s;
    private int m;
    private int n;

    public SingularValueDecomposition(Matrix Arg) {
        int i2;
        double t2;
        int k2;
        int j2;
        double[][] A2 = Arg.getArrayCopy();
        this.m = Arg.getRowDimension();
        this.n = Arg.getColumnDimension();
        int nu = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][nu];
        this.V = new double[this.n][this.n];
        double[] e2 = new double[this.n];
        double[] work = new double[this.m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        for (int k3 = 0; k3 < Math.max(nct, nrt); ++k3) {
            int i3;
            int i4;
            if (k3 < nct) {
                this.s[k3] = 0.0;
                for (i4 = k3; i4 < this.m; ++i4) {
                    this.s[k3] = Maths.hypot(this.s[k3], A2[i4][k3]);
                }
                if (this.s[k3] != 0.0) {
                    if (A2[k3][k3] < 0.0) {
                        this.s[k3] = -this.s[k3];
                    }
                    for (i4 = k3; i4 < this.m; ++i4) {
                        double[] dArray = A2[i4];
                        int n2 = k3;
                        dArray[n2] = dArray[n2] / this.s[k3];
                    }
                    double[] dArray = A2[k3];
                    int n3 = k3;
                    dArray[n3] = dArray[n3] + 1.0;
                }
                this.s[k3] = -this.s[k3];
            }
            for (j2 = k3 + 1; j2 < this.n; ++j2) {
                if (k3 < nct & this.s[k3] != 0.0) {
                    double t3 = 0.0;
                    for (i3 = k3; i3 < this.m; ++i3) {
                        t3 += A2[i3][k3] * A2[i3][j2];
                    }
                    t3 = -t3 / A2[k3][k3];
                    for (i3 = k3; i3 < this.m; ++i3) {
                        double[] dArray = A2[i3];
                        int n4 = j2;
                        dArray[n4] = dArray[n4] + t3 * A2[i3][k3];
                    }
                }
                e2[j2] = A2[k3][j2];
            }
            if (wantu & k3 < nct) {
                for (i4 = k3; i4 < this.m; ++i4) {
                    this.U[i4][k3] = A2[i4][k3];
                }
            }
            if (k3 >= nrt) continue;
            e2[k3] = 0.0;
            for (i4 = k3 + 1; i4 < this.n; ++i4) {
                e2[k3] = Maths.hypot(e2[k3], e2[i4]);
            }
            if (e2[k3] != 0.0) {
                if (e2[k3 + 1] < 0.0) {
                    e2[k3] = -e2[k3];
                }
                i4 = k3 + 1;
                while (i4 < this.n) {
                    int n5 = i4++;
                    e2[n5] = e2[n5] / e2[k3];
                }
                int n6 = k3 + 1;
                e2[n6] = e2[n6] + 1.0;
            }
            e2[k3] = -e2[k3];
            if (k3 + 1 < this.m & e2[k3] != 0.0) {
                for (i4 = k3 + 1; i4 < this.m; ++i4) {
                    work[i4] = 0.0;
                }
                for (j2 = k3 + 1; j2 < this.n; ++j2) {
                    for (int i5 = k3 + 1; i5 < this.m; ++i5) {
                        int n7 = i5;
                        work[n7] = work[n7] + e2[j2] * A2[i5][j2];
                    }
                }
                for (j2 = k3 + 1; j2 < this.n; ++j2) {
                    double t4 = -e2[j2] / e2[k3 + 1];
                    for (i3 = k3 + 1; i3 < this.m; ++i3) {
                        double[] dArray = A2[i3];
                        int n8 = j2;
                        dArray[n8] = dArray[n8] + t4 * work[i3];
                    }
                }
            }
            if (!wantv) continue;
            for (i4 = k3 + 1; i4 < this.n; ++i4) {
                this.V[i4][k3] = e2[i4];
            }
        }
        int p2 = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A2[nct][nct];
        }
        if (this.m < p2) {
            this.s[p2 - 1] = 0.0;
        }
        if (nrt + 1 < p2) {
            e2[nrt] = A2[nrt][p2 - 1];
        }
        e2[p2 - 1] = 0.0;
        if (wantu) {
            for (j2 = nct; j2 < nu; ++j2) {
                for (int i6 = 0; i6 < this.m; ++i6) {
                    this.U[i6][j2] = 0.0;
                }
                this.U[j2][j2] = 1.0;
            }
            for (k2 = nct - 1; k2 >= 0; --k2) {
                int i7;
                if (this.s[k2] != 0.0) {
                    for (int j3 = k2 + 1; j3 < nu; ++j3) {
                        t2 = 0.0;
                        for (i2 = k2; i2 < this.m; ++i2) {
                            t2 += this.U[i2][k2] * this.U[i2][j3];
                        }
                        t2 = -t2 / this.U[k2][k2];
                        for (i2 = k2; i2 < this.m; ++i2) {
                            double[] dArray = this.U[i2];
                            int n9 = j3;
                            dArray[n9] = dArray[n9] + t2 * this.U[i2][k2];
                        }
                    }
                    for (i7 = k2; i7 < this.m; ++i7) {
                        this.U[i7][k2] = -this.U[i7][k2];
                    }
                    this.U[k2][k2] = 1.0 + this.U[k2][k2];
                    for (i7 = 0; i7 < k2 - 1; ++i7) {
                        this.U[i7][k2] = 0.0;
                    }
                    continue;
                }
                for (i7 = 0; i7 < this.m; ++i7) {
                    this.U[i7][k2] = 0.0;
                }
                this.U[k2][k2] = 1.0;
            }
        }
        if (wantv) {
            for (k2 = this.n - 1; k2 >= 0; --k2) {
                if (k2 < nrt & e2[k2] != 0.0) {
                    for (int j4 = k2 + 1; j4 < nu; ++j4) {
                        t2 = 0.0;
                        for (i2 = k2 + 1; i2 < this.n; ++i2) {
                            t2 += this.V[i2][k2] * this.V[i2][j4];
                        }
                        t2 = -t2 / this.V[k2 + 1][k2];
                        for (i2 = k2 + 1; i2 < this.n; ++i2) {
                            double[] dArray = this.V[i2];
                            int n10 = j4;
                            dArray[n10] = dArray[n10] + t2 * this.V[i2][k2];
                        }
                    }
                }
                for (int i8 = 0; i8 < this.n; ++i8) {
                    this.V[i8][k2] = 0.0;
                }
                this.V[k2][k2] = 1.0;
            }
        }
        int pp = p2 - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        block35: while (p2 > 0) {
            int kase;
            int k4;
            for (k4 = p2 - 2; k4 >= -1 && k4 != -1; --k4) {
                if (!(Math.abs(e2[k4]) <= eps * (Math.abs(this.s[k4]) + Math.abs(this.s[k4 + 1])))) continue;
                e2[k4] = 0.0;
                break;
            }
            if (k4 == p2 - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p2 - 1; ks >= k4 && ks != k4; --ks) {
                    double t5 = (ks != p2 ? Math.abs(e2[ks]) : 0.0) + (ks != k4 + 1 ? Math.abs(e2[ks - 1]) : 0.0);
                    if (!(Math.abs(this.s[ks]) <= eps * t5)) continue;
                    this.s[ks] = 0.0;
                    break;
                }
                if (ks == k4) {
                    kase = 3;
                } else if (ks == p2 - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k4 = ks;
                }
            }
            ++k4;
            switch (kase) {
                case 1: {
                    int i9;
                    double sn;
                    double cs;
                    double t6;
                    double f2 = e2[p2 - 2];
                    e2[p2 - 2] = 0.0;
                    for (int j5 = p2 - 2; j5 >= k4; --j5) {
                        t6 = Maths.hypot(this.s[j5], f2);
                        cs = this.s[j5] / t6;
                        sn = f2 / t6;
                        this.s[j5] = t6;
                        if (j5 != k4) {
                            f2 = -sn * e2[j5 - 1];
                            e2[j5 - 1] = cs * e2[j5 - 1];
                        }
                        if (!wantv) continue;
                        for (i9 = 0; i9 < this.n; ++i9) {
                            t6 = cs * this.V[i9][j5] + sn * this.V[i9][p2 - 1];
                            this.V[i9][p2 - 1] = -sn * this.V[i9][j5] + cs * this.V[i9][p2 - 1];
                            this.V[i9][j5] = t6;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int i9;
                    double sn;
                    double cs;
                    double t6;
                    double f3 = e2[k4 - 1];
                    e2[k4 - 1] = 0.0;
                    for (int j6 = k4; j6 < p2; ++j6) {
                        t6 = Maths.hypot(this.s[j6], f3);
                        cs = this.s[j6] / t6;
                        sn = f3 / t6;
                        this.s[j6] = t6;
                        f3 = -sn * e2[j6];
                        e2[j6] = cs * e2[j6];
                        if (!wantu) continue;
                        for (i9 = 0; i9 < this.m; ++i9) {
                            t6 = cs * this.U[i9][j6] + sn * this.U[i9][k4 - 1];
                            this.U[i9][k4 - 1] = -sn * this.U[i9][j6] + cs * this.U[i9][k4 - 1];
                            this.U[i9][j6] = t6;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p2 - 1]), Math.abs(this.s[p2 - 2])), Math.abs(e2[p2 - 2])), Math.abs(this.s[k4])), Math.abs(e2[k4]));
                    double sp = this.s[p2 - 1] / scale;
                    double spm1 = this.s[p2 - 2] / scale;
                    double epm1 = e2[p2 - 2] / scale;
                    double sk = this.s[k4] / scale;
                    double ek = e2[k4] / scale;
                    double b2 = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c2 = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b2 != 0.0 | c2 != 0.0) {
                        shift = Math.sqrt(b2 * b2 + c2);
                        if (b2 < 0.0) {
                            shift = -shift;
                        }
                        shift = c2 / (b2 + shift);
                    }
                    double f4 = (sk + sp) * (sk - sp) + shift;
                    double g2 = sk * ek;
                    for (int j7 = k4; j7 < p2 - 1; ++j7) {
                        int i10;
                        double t7 = Maths.hypot(f4, g2);
                        double cs = f4 / t7;
                        double sn = g2 / t7;
                        if (j7 != k4) {
                            e2[j7 - 1] = t7;
                        }
                        f4 = cs * this.s[j7] + sn * e2[j7];
                        e2[j7] = cs * e2[j7] - sn * this.s[j7];
                        g2 = sn * this.s[j7 + 1];
                        this.s[j7 + 1] = cs * this.s[j7 + 1];
                        if (wantv) {
                            for (i10 = 0; i10 < this.n; ++i10) {
                                t7 = cs * this.V[i10][j7] + sn * this.V[i10][j7 + 1];
                                this.V[i10][j7 + 1] = -sn * this.V[i10][j7] + cs * this.V[i10][j7 + 1];
                                this.V[i10][j7] = t7;
                            }
                        }
                        t7 = Maths.hypot(f4, g2);
                        cs = f4 / t7;
                        sn = g2 / t7;
                        this.s[j7] = t7;
                        f4 = cs * e2[j7] + sn * this.s[j7 + 1];
                        this.s[j7 + 1] = -sn * e2[j7] + cs * this.s[j7 + 1];
                        g2 = sn * e2[j7 + 1];
                        e2[j7 + 1] = cs * e2[j7 + 1];
                        if (!wantu || j7 >= this.m - 1) continue;
                        for (i10 = 0; i10 < this.m; ++i10) {
                            t7 = cs * this.U[i10][j7] + sn * this.U[i10][j7 + 1];
                            this.U[i10][j7 + 1] = -sn * this.U[i10][j7] + cs * this.U[i10][j7 + 1];
                            this.U[i10][j7] = t7;
                        }
                    }
                    e2[p2 - 2] = f4;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.s[k4] <= 0.0) {
                        double d2 = this.s[k4] = this.s[k4] < 0.0 ? -this.s[k4] : 0.0;
                        if (wantv) {
                            for (int i11 = 0; i11 <= pp; ++i11) {
                                this.V[i11][k4] = -this.V[i11][k4];
                            }
                        }
                    }
                    while (k4 < pp && !(this.s[k4] >= this.s[k4 + 1])) {
                        int i12;
                        double t8 = this.s[k4];
                        this.s[k4] = this.s[k4 + 1];
                        this.s[k4 + 1] = t8;
                        if (wantv && k4 < this.n - 1) {
                            for (i12 = 0; i12 < this.n; ++i12) {
                                t8 = this.V[i12][k4 + 1];
                                this.V[i12][k4 + 1] = this.V[i12][k4];
                                this.V[i12][k4] = t8;
                            }
                        }
                        if (wantu && k4 < this.m - 1) {
                            for (i12 = 0; i12 < this.m; ++i12) {
                                t8 = this.U[i12][k4 + 1];
                                this.U[i12][k4 + 1] = this.U[i12][k4];
                                this.U[i12][k4] = t8;
                            }
                        }
                        ++k4;
                    }
                    iter = 0;
                    --p2;
                }
            }
        }
    }

    public Matrix getU() {
        return new Matrix(this.U, this.m, Math.min(this.m + 1, this.n));
    }

    public Matrix getV() {
        return new Matrix(this.V, this.n, this.n);
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public Matrix getS() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] S2 = X.getArray();
        for (int i2 = 0; i2 < this.n; ++i2) {
            for (int j2 = 0; j2 < this.n; ++j2) {
                S2[i2][j2] = 0.0;
            }
            S2[i2][i2] = this.s[i2];
        }
        return X;
    }

    public double norm2() {
        return this.s[0];
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.s[0] * eps;
        int r2 = 0;
        for (int i2 = 0; i2 < this.s.length; ++i2) {
            if (!(this.s[i2] > tol)) continue;
            ++r2;
        }
        return r2;
    }
}

