/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnSingularMatrixException;
import com.ge.med.jnu.JnUtils;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.JnVector4d;
import java.io.PrintStream;

public class JnMatrix4d
implements Cloneable {
    private static double[] identity = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    public double m00 = 0.0;
    public double m01 = 0.0;
    public double m02 = 0.0;
    public double m03 = 0.0;
    public double m10 = 0.0;
    public double m11 = 0.0;
    public double m12 = 0.0;
    public double m13 = 0.0;
    public double m20 = 0.0;
    public double m21 = 0.0;
    public double m22 = 0.0;
    public double m23 = 0.0;
    public double m30 = 0.0;
    public double m31 = 0.0;
    public double m32 = 0.0;
    public double m33 = 0.0;

    public JnMatrix4d() {
    }

    public JnMatrix4d(JnMatrix4d m2) {
        this.set(m2);
    }

    public JnMatrix4d(double[] data) {
        this.set(data);
    }

    public final boolean equals(Object o2) {
        if (o2 instanceof double[]) {
            double[] a2 = (double[])o2;
            boolean r1 = this.m00 == a2[0] && this.m01 == a2[1] && this.m02 == a2[2] && this.m03 == a2[3];
            boolean r2 = this.m10 == a2[4] && this.m11 == a2[5] && this.m12 == a2[6] && this.m13 == a2[7];
            boolean r3 = this.m20 == a2[8] && this.m21 == a2[9] && this.m22 == a2[10] && this.m23 == a2[11];
            boolean r4 = this.m30 == a2[12] && this.m31 == a2[13] && this.m32 == a2[14] && this.m33 == a2[15];
            return r1 && r2 && r3 && r4;
        }
        JnMatrix4d m2 = (JnMatrix4d)o2;
        boolean r1 = this.m00 == m2.m00 && this.m01 == m2.m01 && this.m02 == m2.m02 && this.m03 == m2.m03;
        boolean r2 = this.m10 == m2.m10 && this.m11 == m2.m11 && this.m12 == m2.m12 && this.m13 == m2.m13;
        boolean r3 = this.m20 == m2.m20 && this.m21 == m2.m21 && this.m22 == m2.m22 && this.m23 == m2.m23;
        boolean r4 = this.m30 == m2.m30 && this.m31 == m2.m31 && this.m32 == m2.m32 && this.m33 == m2.m33;
        return r1 && r2 && r3 && r4;
    }

    public final void set(double[] data) {
        this.m00 = data[0];
        this.m01 = data[1];
        this.m02 = data[2];
        this.m03 = data[3];
        this.m10 = data[4];
        this.m11 = data[5];
        this.m12 = data[6];
        this.m13 = data[7];
        this.m20 = data[8];
        this.m21 = data[9];
        this.m22 = data[10];
        this.m23 = data[11];
        this.m30 = data[12];
        this.m31 = data[13];
        this.m32 = data[14];
        this.m33 = data[15];
    }

    public final void set(JnMatrix4d m2) {
        this.m00 = m2.m00;
        this.m01 = m2.m01;
        this.m02 = m2.m02;
        this.m03 = m2.m03;
        this.m10 = m2.m10;
        this.m11 = m2.m11;
        this.m12 = m2.m12;
        this.m13 = m2.m13;
        this.m20 = m2.m20;
        this.m21 = m2.m21;
        this.m22 = m2.m22;
        this.m23 = m2.m23;
        this.m30 = m2.m30;
        this.m31 = m2.m31;
        this.m32 = m2.m32;
        this.m33 = m2.m33;
    }

    public final void get(double[] data) {
        data[0] = this.m00;
        data[1] = this.m01;
        data[2] = this.m02;
        data[3] = this.m03;
        data[4] = this.m10;
        data[5] = this.m11;
        data[6] = this.m12;
        data[7] = this.m13;
        data[8] = this.m20;
        data[9] = this.m21;
        data[10] = this.m22;
        data[11] = this.m23;
        data[12] = this.m30;
        data[13] = this.m31;
        data[14] = this.m32;
        data[15] = this.m33;
    }

    public final void add(double scalar) {
        this.m00 += scalar;
        this.m01 += scalar;
        this.m02 += scalar;
        this.m03 += scalar;
        this.m10 += scalar;
        this.m11 += scalar;
        this.m12 += scalar;
        this.m13 += scalar;
        this.m20 += scalar;
        this.m21 += scalar;
        this.m22 += scalar;
        this.m23 += scalar;
        this.m30 += scalar;
        this.m31 += scalar;
        this.m32 += scalar;
        this.m33 += scalar;
    }

    public final void add(double scalar, JnMatrix4d m1) {
        this.m00 = m1.m00 + scalar;
        this.m01 = m1.m01 + scalar;
        this.m02 = m1.m02 + scalar;
        this.m03 = m1.m03 + scalar;
        this.m10 = m1.m10 + scalar;
        this.m11 = m1.m11 + scalar;
        this.m12 = m1.m12 + scalar;
        this.m13 = m1.m13 + scalar;
        this.m20 = m1.m20 + scalar;
        this.m21 = m1.m21 + scalar;
        this.m22 = m1.m22 + scalar;
        this.m23 = m1.m23 + scalar;
        this.m30 = m1.m30 + scalar;
        this.m31 = m1.m31 + scalar;
        this.m32 = m1.m32 + scalar;
        this.m33 = m1.m33 + scalar;
    }

    public final void setIdentity() {
        this.set(identity);
    }

    public final void setScale(double s2) {
        this.set(identity);
        this.m00 = s2;
        this.m11 = s2;
        this.m22 = s2;
    }

    public final void transform(JnVector3d t2) {
        double x2 = this.m00 * t2.x + this.m01 * t2.y + this.m02 * t2.z + this.m03;
        double y2 = this.m10 * t2.x + this.m11 * t2.y + this.m12 * t2.z + this.m13;
        double z2 = this.m20 * t2.x + this.m21 * t2.y + this.m22 * t2.z + this.m23;
        t2.x = x2;
        t2.y = y2;
        t2.z = z2;
    }

    public final void transform(double[] t2) {
        if (t2.length == 3) {
            double x2 = this.m00 * t2[0] + this.m01 * t2[1] + this.m02 * t2[2] + this.m03;
            double y2 = this.m10 * t2[0] + this.m11 * t2[1] + this.m12 * t2[2] + this.m13;
            double z2 = this.m20 * t2[0] + this.m21 * t2[1] + this.m22 * t2[2] + this.m23;
            t2[0] = x2;
            t2[1] = y2;
            t2[2] = z2;
        } else {
            double x3 = this.m00 * t2[0] + this.m01 * t2[1] + this.m02 * t2[2] + this.m03 * t2[3];
            double y3 = this.m10 * t2[0] + this.m11 * t2[1] + this.m12 * t2[2] + this.m13 * t2[3];
            double z3 = this.m20 * t2[0] + this.m21 * t2[1] + this.m22 * t2[2] + this.m23 * t2[3];
            double w2 = this.m30 * t2[0] + this.m31 * t2[1] + this.m32 * t2[2] + this.m33 * t2[3];
            t2[0] = x3;
            t2[1] = y3;
            t2[2] = z3;
            t2[3] = w2;
        }
    }

    public final void transform(JnVector3d t2, JnVector3d res) {
        res.x = this.m00 * t2.x + this.m01 * t2.y + this.m02 * t2.z + this.m03;
        res.y = this.m10 * t2.x + this.m11 * t2.y + this.m12 * t2.z + this.m13;
        res.z = this.m20 * t2.x + this.m21 * t2.y + this.m22 * t2.z + this.m23;
    }

    public final void transform(JnVector4d t2) {
        double x2 = this.m00 * t2.x + this.m01 * t2.y + this.m02 * t2.z + this.m03 * t2.w;
        double y2 = this.m10 * t2.x + this.m11 * t2.y + this.m12 * t2.z + this.m13 * t2.w;
        double z2 = this.m20 * t2.x + this.m21 * t2.y + this.m22 * t2.z + this.m23 * t2.w;
        double w2 = this.m30 * t2.x + this.m31 * t2.y + this.m32 * t2.z + this.m33 * t2.w;
        t2.x = x2;
        t2.y = y2;
        t2.z = z2;
        t2.w = w2;
    }

    public final void transform(JnVector4d t2, JnVector4d res) {
        res.x = this.m00 * t2.x + this.m01 * t2.y + this.m02 * t2.z + this.m03 * t2.w;
        res.y = this.m10 * t2.x + this.m11 * t2.y + this.m12 * t2.z + this.m13 * t2.w;
        res.z = this.m20 * t2.x + this.m21 * t2.y + this.m22 * t2.z + this.m23 * t2.w;
        res.w = this.m30 * t2.x + this.m31 * t2.y + this.m32 * t2.z + this.m33 * t2.w;
    }

    public final void mul(double scalar) {
        this.m00 *= scalar;
        this.m01 *= scalar;
        this.m02 *= scalar;
        this.m03 *= scalar;
        this.m10 *= scalar;
        this.m11 *= scalar;
        this.m12 *= scalar;
        this.m13 *= scalar;
        this.m20 *= scalar;
        this.m21 *= scalar;
        this.m22 *= scalar;
        this.m23 *= scalar;
        this.m30 *= scalar;
        this.m31 *= scalar;
        this.m32 *= scalar;
        this.m33 *= scalar;
    }

    public final void mul(double scalar, JnMatrix4d m2) {
        this.m00 = m2.m00 * scalar;
        this.m01 = m2.m01 * scalar;
        this.m02 = m2.m02 * scalar;
        this.m03 = m2.m03 * scalar;
        this.m10 = m2.m10 * scalar;
        this.m11 = m2.m11 * scalar;
        this.m12 = m2.m12 * scalar;
        this.m13 = m2.m13 * scalar;
        this.m20 = m2.m20 * scalar;
        this.m21 = m2.m21 * scalar;
        this.m22 = m2.m22 * scalar;
        this.m23 = m2.m23 * scalar;
        this.m30 = m2.m30 * scalar;
        this.m31 = m2.m31 * scalar;
        this.m32 = m2.m32 * scalar;
        this.m33 = m2.m33 * scalar;
    }

    public final void mul(JnMatrix4d m1, JnMatrix4d m2) {
        double d00 = m1.m00 * m2.m00 + m1.m01 * m2.m10 + m1.m02 * m2.m20 + m1.m03 * m2.m30;
        double d01 = m1.m00 * m2.m01 + m1.m01 * m2.m11 + m1.m02 * m2.m21 + m1.m03 * m2.m31;
        double d02 = m1.m00 * m2.m02 + m1.m01 * m2.m12 + m1.m02 * m2.m22 + m1.m03 * m2.m32;
        double d03 = m1.m00 * m2.m03 + m1.m01 * m2.m13 + m1.m02 * m2.m23 + m1.m03 * m2.m33;
        double d10 = m1.m10 * m2.m00 + m1.m11 * m2.m10 + m1.m12 * m2.m20 + m1.m13 * m2.m30;
        double d11 = m1.m10 * m2.m01 + m1.m11 * m2.m11 + m1.m12 * m2.m21 + m1.m13 * m2.m31;
        double d12 = m1.m10 * m2.m02 + m1.m11 * m2.m12 + m1.m12 * m2.m22 + m1.m13 * m2.m32;
        double d13 = m1.m10 * m2.m03 + m1.m11 * m2.m13 + m1.m12 * m2.m23 + m1.m13 * m2.m33;
        double d20 = m1.m20 * m2.m00 + m1.m21 * m2.m10 + m1.m22 * m2.m20 + m1.m23 * m2.m30;
        double d21 = m1.m20 * m2.m01 + m1.m21 * m2.m11 + m1.m22 * m2.m21 + m1.m23 * m2.m31;
        double d22 = m1.m20 * m2.m02 + m1.m21 * m2.m12 + m1.m22 * m2.m22 + m1.m23 * m2.m32;
        double d23 = m1.m20 * m2.m03 + m1.m21 * m2.m13 + m1.m22 * m2.m23 + m1.m23 * m2.m33;
        double d30 = m1.m30 * m2.m00 + m1.m31 * m2.m10 + m1.m32 * m2.m20 + m1.m33 * m2.m30;
        double d31 = m1.m30 * m2.m01 + m1.m31 * m2.m11 + m1.m32 * m2.m21 + m1.m33 * m2.m31;
        double d32 = m1.m30 * m2.m02 + m1.m31 * m2.m12 + m1.m32 * m2.m22 + m1.m33 * m2.m32;
        double d33 = m1.m30 * m2.m03 + m1.m31 * m2.m13 + m1.m32 * m2.m23 + m1.m33 * m2.m33;
        this.set(d00, d01, d02, d03, d10, d11, d12, d13, d20, d21, d22, d23, d30, d31, d32, d33);
    }

    public final void set(double d00, double d01, double d02, double d03, double d10, double d11, double d12, double d13, double d20, double d21, double d22, double d23, double d30, double d31, double d32, double d33) {
        this.m00 = d00;
        this.m01 = d01;
        this.m02 = d02;
        this.m03 = d03;
        this.m10 = d10;
        this.m11 = d11;
        this.m12 = d12;
        this.m13 = d13;
        this.m20 = d20;
        this.m21 = d21;
        this.m22 = d22;
        this.m23 = d23;
        this.m30 = d30;
        this.m31 = d31;
        this.m32 = d32;
        this.m33 = d33;
    }

    public final void setColumns(JnVector3d cx, JnVector3d cy, JnVector3d cz, JnVector3d cw) {
        this.m00 = cx.x;
        this.m10 = cx.y;
        this.m20 = cx.z;
        this.m30 = 0.0;
        this.m01 = cy.x;
        this.m11 = cy.y;
        this.m21 = cy.z;
        this.m31 = 0.0;
        this.m02 = cz.x;
        this.m12 = cz.y;
        this.m22 = cz.z;
        this.m32 = 0.0;
        this.m03 = cw.x;
        this.m13 = cw.y;
        this.m23 = cw.z;
        this.m33 = 1.0;
    }

    public final void setColumns(double[] cx, double[] cy, double[] cz, double[] cw) {
        this.m00 = cx[0];
        this.m10 = cx[1];
        this.m20 = cx[2];
        this.m30 = 0.0;
        this.m01 = cy[0];
        this.m11 = cy[1];
        this.m21 = cy[2];
        this.m31 = 0.0;
        this.m02 = cz[0];
        this.m12 = cz[1];
        this.m22 = cz[2];
        this.m32 = 0.0;
        this.m03 = cw[0];
        this.m13 = cw[1];
        this.m23 = cw[2];
        this.m33 = 1.0;
    }

    public final void mul(JnMatrix4d m1) {
        double d00 = m1.m00 * this.m00 + m1.m01 * this.m10 + m1.m02 * this.m20 + m1.m03 * this.m30;
        double d01 = m1.m00 * this.m01 + m1.m01 * this.m11 + m1.m02 * this.m21 + m1.m03 * this.m31;
        double d02 = m1.m00 * this.m02 + m1.m01 * this.m12 + m1.m02 * this.m22 + m1.m03 * this.m32;
        double d03 = m1.m00 * this.m03 + m1.m01 * this.m13 + m1.m02 * this.m23 + m1.m03 * this.m33;
        double d10 = m1.m10 * this.m00 + m1.m11 * this.m10 + m1.m12 * this.m20 + m1.m13 * this.m30;
        double d11 = m1.m10 * this.m01 + m1.m11 * this.m11 + m1.m12 * this.m21 + m1.m13 * this.m31;
        double d12 = m1.m10 * this.m02 + m1.m11 * this.m12 + m1.m12 * this.m22 + m1.m13 * this.m32;
        double d13 = m1.m10 * this.m03 + m1.m11 * this.m13 + m1.m12 * this.m23 + m1.m13 * this.m33;
        double d20 = m1.m20 * this.m00 + m1.m21 * this.m10 + m1.m22 * this.m20 + m1.m23 * this.m30;
        double d21 = m1.m20 * this.m01 + m1.m21 * this.m11 + m1.m22 * this.m21 + m1.m23 * this.m31;
        double d22 = m1.m20 * this.m02 + m1.m21 * this.m12 + m1.m22 * this.m22 + m1.m23 * this.m32;
        double d23 = m1.m20 * this.m03 + m1.m21 * this.m13 + m1.m22 * this.m23 + m1.m23 * this.m33;
        double d30 = m1.m30 * this.m00 + m1.m31 * this.m10 + m1.m32 * this.m20 + m1.m33 * this.m30;
        double d31 = m1.m30 * this.m01 + m1.m31 * this.m11 + m1.m32 * this.m21 + m1.m33 * this.m31;
        double d32 = m1.m30 * this.m02 + m1.m31 * this.m12 + m1.m32 * this.m22 + m1.m33 * this.m32;
        double d33 = m1.m30 * this.m03 + m1.m31 * this.m13 + m1.m32 * this.m23 + m1.m33 * this.m33;
        this.set(d00, d01, d02, d03, d10, d11, d12, d13, d20, d21, d22, d23, d30, d31, d32, d33);
    }

    public final void negate() {
        this.mul(-1.0);
    }

    public final void setTranslation(JnVector3d translate) {
        this.setTranslation(translate.x, translate.y, translate.z);
    }

    public final void setRotate(double angle, double x2, double y2, double z2) {
        double length = Math.sqrt(x2 * x2 + y2 * y2 + z2 * z2);
        double xx = x2 / length;
        double yy = y2 / length;
        double zz = z2 / length;
        double cosa = Math.cos(angle);
        double sina = Math.sin(angle);
        this.m00 = xx * xx;
        this.m01 = xx * yy;
        this.m02 = xx * zz;
        this.m10 = yy * xx;
        this.m11 = yy * yy;
        this.m12 = yy * zz;
        this.m20 = zz * xx;
        this.m21 = zz * yy;
        this.m22 = zz * zz;
        this.m00 += cosa * (1.0 - this.m00);
        this.m01 += cosa * -this.m01 + sina * -zz;
        this.m02 += cosa * -this.m02 + sina * yy;
        this.m10 += cosa * -this.m10 + sina * zz;
        this.m11 += cosa * (1.0 - this.m11);
        this.m12 += cosa * -this.m12 + sina * -xx;
        this.m20 += cosa * -this.m20 + sina * -yy;
        this.m21 += cosa * -this.m21 + sina * xx;
        this.m22 += cosa * (1.0 - this.m22);
        this.m03 = 0.0;
        this.m13 = 0.0;
        this.m23 = 0.0;
        this.m33 = 1.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
    }

    public final void rotX(double angle) {
        double c2 = Math.cos(angle);
        double s2 = Math.sin(angle);
        this.m00 = 1.0;
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.m11 = c2;
        this.m12 = -s2;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = s2;
        this.m22 = c2;
        this.m23 = 0.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
        this.m33 = 1.0;
    }

    public final void rotY(double angle) {
        double c2 = Math.cos(angle);
        double s2 = Math.sin(angle);
        this.m00 = c2;
        this.m01 = 0.0;
        this.m02 = s2;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = -s2;
        this.m21 = 0.0;
        this.m22 = c2;
        this.m23 = 0.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
        this.m33 = 1.0;
    }

    public final void rotZ(double angle) {
        double c2 = Math.cos(angle);
        double s2 = Math.sin(angle);
        this.m00 = c2;
        this.m01 = -s2;
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m10 = s2;
        this.m11 = c2;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
        this.m33 = 1.0;
    }

    public final JnMatrix4d transpose() {
        double d01 = this.m01;
        double d02 = this.m02;
        double d03 = this.m03;
        double d10 = this.m10;
        double d12 = this.m12;
        double d13 = this.m13;
        double d20 = this.m20;
        double d21 = this.m21;
        double d23 = this.m23;
        double d30 = this.m30;
        double d31 = this.m31;
        double d32 = this.m32;
        this.m01 = d10;
        this.m10 = d01;
        this.m02 = d20;
        this.m20 = d02;
        this.m12 = d21;
        this.m21 = d12;
        this.m03 = d30;
        this.m13 = d31;
        this.m23 = d32;
        this.m30 = d03;
        this.m31 = d13;
        this.m32 = d23;
        return this;
    }

    public final void setTranslation(double tx, double ty, double tz) {
        this.m03 = tx;
        this.m13 = ty;
        this.m23 = tz;
    }

    public final void translate(double tx, double ty, double tz) {
        this.m03 += tx;
        this.m13 += ty;
        this.m23 += tz;
    }

    public final double determinant() {
        double a1 = this.m00;
        double b1 = this.m01;
        double c1 = this.m02;
        double d1 = this.m03;
        double a2 = this.m10;
        double b2 = this.m11;
        double c2 = this.m12;
        double d2 = this.m13;
        double a3 = this.m20;
        double b3 = this.m21;
        double c3 = this.m22;
        double d3 = this.m23;
        double a4 = this.m30;
        double b4 = this.m31;
        double c4 = this.m32;
        double d4 = this.m33;
        double ans = a1 * JnUtils.det3x3(b2, b3, b4, c2, c3, c4, d2, d3, d4) - b1 * JnUtils.det3x3(a2, a3, a4, c2, c3, c4, d2, d3, d4) + c1 * JnUtils.det3x3(a2, a3, a4, b2, b3, b4, d2, d3, d4) - d1 * JnUtils.det3x3(a2, a3, a4, b2, b3, b4, c2, c3, c4);
        return ans;
    }

    public final void invert() {
        double det = this.determinant();
        if (Math.abs(det) < 1.0E-10) {
            throw new JnSingularMatrixException("SingularMatrixException Determinant=" + det + "  [" + this + "]");
        }
        this.adjoint(this);
        this.mul(1.0 / det);
    }

    public final void adjoint(JnMatrix4d out) {
        double a1 = this.m00;
        double b1 = this.m01;
        double c1 = this.m02;
        double d1 = this.m03;
        double a2 = this.m10;
        double b2 = this.m11;
        double c2 = this.m12;
        double d2 = this.m13;
        double a3 = this.m20;
        double b3 = this.m21;
        double c3 = this.m22;
        double d3 = this.m23;
        double a4 = this.m30;
        double b4 = this.m31;
        double c4 = this.m32;
        double d4 = this.m33;
        out.m00 = JnUtils.det3x3(b2, b3, b4, c2, c3, c4, d2, d3, d4);
        out.m10 = -JnUtils.det3x3(a2, a3, a4, c2, c3, c4, d2, d3, d4);
        out.m20 = JnUtils.det3x3(a2, a3, a4, b2, b3, b4, d2, d3, d4);
        out.m30 = -JnUtils.det3x3(a2, a3, a4, b2, b3, b4, c2, c3, c4);
        out.m01 = -JnUtils.det3x3(b1, b3, b4, c1, c3, c4, d1, d3, d4);
        out.m11 = JnUtils.det3x3(a1, a3, a4, c1, c3, c4, d1, d3, d4);
        out.m21 = -JnUtils.det3x3(a1, a3, a4, b1, b3, b4, d1, d3, d4);
        out.m31 = JnUtils.det3x3(a1, a3, a4, b1, b3, b4, c1, c3, c4);
        out.m02 = JnUtils.det3x3(b1, b2, b4, c1, c2, c4, d1, d2, d4);
        out.m12 = -JnUtils.det3x3(a1, a2, a4, c1, c2, c4, d1, d2, d4);
        out.m22 = JnUtils.det3x3(a1, a2, a4, b1, b2, b4, d1, d2, d4);
        out.m32 = -JnUtils.det3x3(a1, a2, a4, b1, b2, b4, c1, c2, c4);
        out.m03 = -JnUtils.det3x3(b1, b2, b3, c1, c2, c3, d1, d2, d3);
        out.m13 = JnUtils.det3x3(a1, a2, a3, c1, c2, c3, d1, d2, d3);
        out.m23 = -JnUtils.det3x3(a1, a2, a3, b1, b2, b3, d1, d2, d3);
        out.m33 = JnUtils.det3x3(a1, a2, a3, b1, b2, b3, c1, c2, c3);
    }

    public final void invert(JnMatrix4d m2) {
        this.set(m2);
        this.invert();
    }

    public final void printMatrix() {
        this.printMatrix(System.out);
    }

    public final void printMatrix(PrintStream ps) {
        double[] data = new double[16];
        this.get(data);
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                String val = JnUtils.format(data[i2 * 4 + j2]);
                ps.print(val + " ");
            }
            ps.println();
        }
    }

    public final String toString() {
        return "[ " + this.m00 + "," + this.m01 + "," + this.m02 + "," + this.m03 + " \n " + this.m10 + "," + this.m11 + "," + this.m12 + "," + this.m13 + " \n " + this.m20 + "," + this.m21 + "," + this.m22 + "," + this.m23 + " \n " + this.m30 + "," + this.m31 + "," + this.m32 + "," + this.m33 + " ]";
    }

    public Object clone() {
        Object o2 = null;
        try {
            o2 = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o2;
    }

    public int hashCode() {
        int result = 1;
        long bits = JnUtils.doubleToLongBits(this.m00);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m01);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m02);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m03);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m10);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m11);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m12);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m13);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m20);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m21);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m22);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m23);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m30);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m31);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m32);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.m33);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

