/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;

public class JnRegionGrow {
    public static final String REGION_GROW_UPDATE = "REGION_GROW_UPDATE";
    public static final String REGION_GROW_START = "REGION_GROW_START";
    public static final String REGION_GROW_FINISH = "REGION_GROW_FINISH";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private int dx = 0;
    private int dy = 0;
    private int dz = 0;
    private Object data = null;
    private int data_offset = 0;
    private byte[] ggrid = null;
    private byte[] vbgrid = null;
    private int browsize = 0;
    private int bpgsize = 0;
    private PositionQueue ps = null;
    private int pixelFrequency = 16384;
    private boolean cancel = false;
    private int vox_counter = 0;
    private static final int[][] N = new int[][]{{0, -1, 0}, {-1, 0, 1}, {0, 1, 1}, {1, 1, 0}, {0, 0, -1}, {-1, -1, 0}, {0, -1, -1}, {1, 0, 0}, {-1, 1, 0}, {0, 1, -1}, {1, -1, 0}, {0, -1, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 0, 1}, {1, 0, 1}, {0, 1, 0}, {-1, 0, 0}};
    private boolean doit = true;

    public JnRegionGrow(byte[] ggrid, Object data, int data_offset, int dx, int dy, int dz) {
        this.init(ggrid, data, data_offset, dx, dy, dz);
    }

    public JnRegionGrow(byte[] ggrid, Object data, int data_offset, int dx, int dy) {
        this.init(ggrid, data, data_offset, dx, dy, 0);
    }

    public void clear() {
        this.cancel = false;
        this.ps.clear();
        Arrays.fill(this.ggrid, (byte)0);
        Arrays.fill(this.vbgrid, (byte)0);
    }

    public void setUpdateFrequency(int pixelFrequency) {
        this.pixelFrequency = pixelFrequency;
    }

    public void cancel() {
        this.cancel = true;
    }

    private void init(byte[] ggrid, Object data, int data_offset, int dx, int dy, int dz) {
        this.ggrid = ggrid;
        this.data = data;
        this.data_offset = data_offset;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.browsize = dx + 7 >> 3;
        this.bpgsize = this.browsize * dy;
        this.vbgrid = new byte[dy * dz * this.browsize];
        int maxQueue = dx * dy * dz >> 4;
        this.ps = new PositionQueue(maxQueue);
    }

    private static boolean bvalue(byte[] bgrid, int bpgsize, int browsize, int x2, int y2, int z2) {
        int bidx = z2 * bpgsize + y2 * browsize + (x2 >> 3);
        int bmod = x2 % 8;
        return (bgrid[bidx] & 1 << bmod) != 0;
    }

    private void queueNeighborhood(byte[] bgrid, int x2, int y2, int z2) {
        for (int i2 = 0; i2 < N.length; ++i2) {
            int nx = x2 + N[i2][0];
            int ny = y2 + N[i2][1];
            int nz = z2 + N[i2][2];
            if (nx <= 0 || ny <= 0 || nz <= 0 || nx >= this.dx - 1 || ny >= this.dy - 1 || nz >= this.dz - 1 || !JnRegionGrow.bvalue(bgrid, this.bpgsize, this.browsize, nx, ny, nz) || JnRegionGrow.bvalue(this.vbgrid, this.bpgsize, this.browsize, nx, ny, nz)) continue;
            ++this.vox_counter;
            this.ps.enqueue(nx, ny, nz);
            int bidx = nz * this.bpgsize + ny * this.browsize + (nx >> 3);
            int bmod = nx % 8;
            int n2 = bidx;
            this.vbgrid[n2] = (byte)(this.vbgrid[n2] | 1 << bmod);
        }
    }

    public void growAt(int x2, int y2, int z2, byte[] bgrid_domain, RegionConnectionEval eval) {
        int bidx = z2 * this.bpgsize + y2 * this.browsize + (x2 >> 3);
        int bmod = x2 % 8;
        this.firePropertyChange(REGION_GROW_START, null, this.ggrid);
        this.cancel = false;
        short[] pos = new short[3];
        int n2 = bidx;
        this.vbgrid[n2] = (byte)(this.vbgrid[n2] | 1 << bmod);
        int n3 = bidx;
        this.ggrid[n3] = (byte)(this.ggrid[n3] | 1 << bmod);
        this.queueNeighborhood(bgrid_domain, x2, y2, z2);
        int nproc = 1;
        while (!this.cancel && this.ps.dequeue(pos)) {
            short cx = pos[0];
            short cy = pos[1];
            short cz = pos[2];
            bidx = cz * this.bpgsize + cy * this.browsize + (cx >> 3);
            bmod = cx % 8;
            if (eval.eval(cx, cy, cz, this.data, this.data_offset, this.dx, this.dy, this.dz)) {
                int n4 = bidx;
                this.ggrid[n4] = (byte)(this.ggrid[n4] | 1 << bmod);
            }
            if (++nproc % this.pixelFrequency == 0) {
                this.firePropertyChange(REGION_GROW_UPDATE, null, this.ggrid);
            }
            this.queueNeighborhood(bgrid_domain, cx, cy, cz);
        }
        this.firePropertyChange(REGION_GROW_FINISH, null, this.ggrid);
    }

    public void growAt(int x2, int y2, RegionConnectionEval eval) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.pcs.removePropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener l2) {
        this.pcs.removePropertyChangeListener(propName, l2);
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.pcs.addPropertyChangeListener(l2);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.pcs.addPropertyChangeListener(prop, l2);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    protected void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    private static class PositionQueue {
        private int maxQueue = 0;
        private int tailpos = 0;
        private int headpos = 0;
        private int nElements = 0;
        private short[] queue = null;

        public PositionQueue(int maxQueue) {
            this.maxQueue = maxQueue;
            this.queue = new short[3 * maxQueue];
            this.clear();
        }

        public int getNumElements() {
            return this.nElements;
        }

        public void clear() {
            this.tailpos = 0;
            this.headpos = 0;
            this.nElements = 0;
        }

        public void enqueue(int x2, int y2, int z2) {
            if (this.nElements >= this.maxQueue) {
                throw new RuntimeException("RegionGrow positional queue is full: " + this.nElements + "   MAX_QUEUE=" + this.maxQueue);
            }
            this.queue[this.tailpos] = (short)x2;
            this.queue[this.tailpos + 1] = (short)y2;
            this.queue[this.tailpos + 2] = (short)z2;
            this.tailpos += 3;
            ++this.nElements;
            if (this.tailpos >= this.queue.length) {
                this.tailpos = 0;
            }
        }

        public boolean dequeue(short[] xyz) {
            if (this.nElements <= 0) {
                return false;
            }
            xyz[0] = this.queue[this.headpos];
            xyz[1] = this.queue[this.headpos + 1];
            xyz[2] = this.queue[this.headpos + 2];
            this.headpos += 3;
            --this.nElements;
            if (this.headpos >= this.queue.length) {
                this.headpos = 0;
            }
            return true;
        }
    }

    public static interface RegionConnectionEval {
        public boolean eval(int var1, int var2, int var3, Object var4, int var5, int var6, int var7, int var8);
    }
}

