/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnUtilsBase;
import java.text.DecimalFormat;
import java.util.logging.Logger;

public class JnUtils
extends JnUtilsBase {
    private static final DecimalFormat df = new DecimalFormat("####.##");
    public static final double ZERO = 1.0E-10;

    public static final boolean zero(double val) {
        return Math.abs(val) < 1.0E-10;
    }

    public static final boolean one(double val) {
        double diff = 1.0 - val;
        return Math.abs(diff) < 1.0E-10;
    }

    public static String format(double d2) {
        return df.format(d2);
    }

    public static final float fastInvSqrt(float x2) {
        float xhalf = 0.5f * x2;
        int i2 = JnUtils.floatToIntBits(x2);
        i2 = 1597463007 - (i2 >> 1);
        x2 = JnUtils.intBitsToFloat(i2);
        x2 *= 1.5f - xhalf * x2 * x2;
        return x2;
    }

    public static float fastSqrt(float val) {
        int tmp = JnUtils.floatToIntBits(val);
        tmp -= 0x800000;
        tmp >>= 1;
        return JnUtils.intBitsToFloat(tmp += 0x20000000);
    }

    public static double det3x3(double a1, double a2, double a3, double b1, double b2, double b3, double c1, double c2, double c3) {
        double ans = a1 * JnUtils.det2x2(b2, b3, c2, c3) - b1 * JnUtils.det2x2(a2, a3, c2, c3) + c1 * JnUtils.det2x2(a2, a3, b2, b3);
        return ans;
    }

    public static double det2x2(double a2, double b2, double c2, double d2) {
        double ans = a2 * d2 - b2 * c2;
        return ans;
    }

    public static double log2(double val) {
        return Math.log(val) / 0.69314718;
    }

    public static boolean isDyadic(int x2) {
        return (x2 & x2 - 1) == 0;
    }

    public static int log2(int x2) {
        int n2 = 0;
        for (int prod = 1; prod <= x2; prod *= 2) {
            ++n2;
        }
        return n2 - 1;
    }

    public static int pow2(int x2) {
        return 1 << x2;
    }

    public static Logger getLogger() {
        return Logger.getLogger("com.ge.med.jnu");
    }

    public static long doubleToLongBits(double val) {
        return Double.doubleToLongBits(val);
    }

    public static int floatToIntBits(float val) {
        return Float.floatToIntBits(val);
    }

    public static float intBitsToFloat(int bits) {
        return Float.intBitsToFloat(bits);
    }

    public static void main(String[] args) {
        System.out.println(1.0 / Math.sqrt(2.0));
        System.out.println(JnUtils.fastInvSqrt(2.0f));
    }
}

