/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnTuple3d;
import com.ge.med.jnu.JnUtils;
import com.ge.med.jnu.JnVector4d;

public class JnVector3d
extends JnTuple3d {
    public JnVector3d() {
    }

    public JnVector3d(double x2, double y2, double z2) {
        this.set(x2, y2, z2);
    }

    public JnVector3d(double[] v2) {
        this.set(v2);
    }

    public final double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public final void get(double[] v2) {
        v2[0] = this.x;
        v2[1] = this.y;
        v2[2] = this.z;
    }

    public final JnVector3d set(JnVector3d v2) {
        this.x = v2.x;
        this.y = v2.y;
        this.z = v2.z;
        return this;
    }

    public final JnVector3d set(double x2, double y2, double z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        return this;
    }

    public final JnVector3d set(double[] v2) {
        this.x = v2[0];
        this.y = v2[1];
        this.z = v2[2];
        return this;
    }

    public final JnVector3d add(double[] v1, double[] v2) {
        this.x = v1[0] + v2[0];
        this.y = v1[1] + v2[1];
        this.z = v1[2] + v2[2];
        return this;
    }

    public final JnVector3d sub(double[] v2) {
        this.x -= v2[0];
        this.y -= v2[1];
        this.z -= v2[2];
        return this;
    }

    public final JnVector3d sub(double[] v1, double[] v2) {
        this.x = v1[0] - v2[0];
        this.y = v1[1] - v2[1];
        this.z = v1[2] - v2[2];
        return this;
    }

    public final JnVector3d add(double[] v2) {
        this.x += v2[0];
        this.y += v2[1];
        this.z += v2[2];
        return this;
    }

    public final JnVector3d add(JnVector3d v1, JnVector3d v2) {
        this.x = v1.x + v2.x;
        this.y = v1.y + v2.y;
        this.z = v1.z + v2.z;
        return this;
    }

    public final JnVector3d add(JnVector3d v2) {
        this.x += v2.x;
        this.y += v2.y;
        this.z += v2.z;
        return this;
    }

    public final JnVector3d sub(JnVector3d v2) {
        this.x -= v2.x;
        this.y -= v2.y;
        this.z -= v2.z;
        return this;
    }

    public final JnVector3d sub(JnVector3d v1, JnVector3d v2) {
        this.x = v1.x - v2.x;
        this.y = v1.y - v2.y;
        this.z = v1.z - v2.z;
        return this;
    }

    public final JnVector3d scale(double s2) {
        this.x *= s2;
        this.y *= s2;
        this.z *= s2;
        return this;
    }

    public final JnVector3d scaleAdd(double s2, JnVector3d v2) {
        this.x += s2 * v2.x;
        this.y += s2 * v2.y;
        this.z += s2 * v2.z;
        return this;
    }

    public final JnVector3d scaleAdd(double s2, JnVector3d v1, JnVector3d v2) {
        this.x = s2 * v1.x + v2.x;
        this.y = s2 * v1.y + v2.y;
        this.z = s2 * v1.z + v2.z;
        return this;
    }

    public final JnVector3d scaleAdd(double s2, double[] v2) {
        this.x += s2 * v2[0];
        this.y += s2 * v2[1];
        this.z += s2 * v2[2];
        return this;
    }

    public final JnVector3d scaleAdd(double s2, double[] v1, double[] v2) {
        this.x = s2 * v1[0] + v2[0];
        this.y = s2 * v1[1] + v2[1];
        this.z = s2 * v1[2] + v2[2];
        return this;
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final double dot(JnVector3d v2) {
        return this.x * v2.x + this.y * v2.y + this.z * v2.z;
    }

    public final double dot(double[] v2) {
        return this.x * v2[0] + this.y * v2[1] + this.z * v2[2];
    }

    public static JnVector3d cross(JnVector3d v1, JnVector3d v2) {
        JnVector3d result = new JnVector3d();
        JnVector3d.cross(v1, v2, result);
        return result;
    }

    public static void cross(JnVector3d v1, JnVector3d v2, JnVector3d result) {
        result.x = v1.y * v2.z - v1.z * v2.y;
        result.y = v1.z * v2.x - v1.x * v2.z;
        result.z = v1.x * v2.y - v1.y * v2.x;
    }

    public static JnVector3d cross(double[] v1, double[] v2) {
        JnVector3d result = new JnVector3d();
        result.x = v1[1] * v2[2] - v1[2] * v2[1];
        result.y = v1[2] * v2[0] - v1[0] * v2[2];
        result.z = v1[0] * v2[1] - v1[1] * v2[0];
        return result;
    }

    public static void cross(double[] v1, double[] v2, double[] result) {
        result[0] = v1[1] * v2[2] - v1[2] * v2[1];
        result[1] = v1[2] * v2[0] - v1[0] * v2[2];
        result[2] = v1[0] * v2[1] - v1[1] * v2[0];
    }

    public static double length(double[] v2) {
        return Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1] + v2[2] * v2[2]);
    }

    public static double distance(double[] v0, double[] v1) {
        double dx = v0[0] - v1[0];
        double dy = v0[1] - v1[1];
        double dz = v0[2] - v1[2];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static void scale(double[] v2, double s2) {
        v2[0] = v2[0] * s2;
        v2[1] = v2[1] * s2;
        v2[2] = v2[2] * s2;
    }

    public static void scaleAdd(double[] v0, double[] v1, double s2, double[] res) {
        res[0] = v0[0] + s2 * v1[0];
        res[1] = v0[1] + s2 * v1[1];
        res[2] = v0[2] + s2 * v1[2];
    }

    public static void scaleAdd(double[] p0, double[] v0, double s0, double[] v1, double s1, double[] res) {
        res[0] = p0[0] + s0 * v0[0] + s1 * v1[0];
        res[1] = p0[1] + s0 * v0[1] + s1 * v1[1];
        res[2] = p0[2] + s0 * v0[2] + s1 * v1[2];
    }

    public static void scaleAdd(double[] p0, double[] v0, double s0, double[] v1, double s1, double[] v2, double s2, double[] res) {
        res[0] = p0[0] + s0 * v0[0] + s1 * v1[0] + s2 * v2[0];
        res[1] = p0[1] + s0 * v0[1] + s1 * v1[1] + s2 * v2[1];
        res[2] = p0[2] + s0 * v0[2] + s1 * v1[2] + s2 * v2[2];
    }

    public static double[] center(double[][] pts) {
        double[] result = new double[]{0.0, 0.0, 0.0};
        for (int i2 = 0; i2 < pts.length; ++i2) {
            result[0] = result[0] + pts[i2][0];
            result[1] = result[1] + pts[i2][1];
            result[2] = result[2] + pts[i2][2];
        }
        result[0] = result[0] / (double)pts.length;
        result[1] = result[1] / (double)pts.length;
        result[2] = result[2] / (double)pts.length;
        return result;
    }

    public static void normalize(double[] v2) {
        double len = JnVector3d.length(v2);
        v2[0] = v2[0] / len;
        v2[1] = v2[1] / len;
        v2[2] = v2[2] / len;
    }

    public static void sub(double[] v1, double[] v2, double[] res) {
        res[0] = v1[0] - v2[0];
        res[1] = v1[1] - v2[1];
        res[2] = v1[2] - v2[2];
    }

    public static double dot(double[] v1, double[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public static void add(double[] v1, double[] v2, double[] res) {
        res[0] = v1[0] + v2[0];
        res[1] = v1[1] + v2[1];
        res[2] = v1[2] + v2[2];
    }

    public static void vprint(double[] v2) {
        System.err.println("[" + v2[0] + "," + v2[1] + "," + v2[2] + "]");
    }

    public static void vprint(String title, double[] v2) {
        System.err.println("" + title + " : [" + v2[0] + "," + v2[1] + "," + v2[2] + "]");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        JnVector3d v3d = (JnVector3d)other;
        return this.x == v3d.x && this.y == v3d.y && this.z == v3d.z;
    }

    public final double angle(JnVector3d v2) {
        double dotVal = this.dot(v2);
        double l1 = this.length();
        double l2 = v2.length();
        double angle = Math.acos(dotVal / (l1 * l2));
        return angle;
    }

    public final JnVector3d normalize() {
        double lenInv = 1.0 / this.length();
        this.x *= lenInv;
        this.y *= lenInv;
        this.z *= lenInv;
        return this;
    }

    public final double[] generateArray() {
        double[] a2 = new double[]{this.x, this.y, this.z};
        return a2;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public final JnVector3d setLocation(double x2, double y2, double z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        return this;
    }

    public final void setLocation(JnVector3d v2) {
        this.setLocation(v2.x, v2.y, v2.z);
    }

    public final void setLocation(double[] v2) {
        this.setLocation(v2[0], v2[1], v2[2]);
    }

    public final void setLocation(JnVector4d v2) {
        this.setLocation(v2.x, v2.y, v2.z);
    }

    public final double magnitudeSq() {
        return this.lengthSquared();
    }

    public final double magnitude() {
        return this.length();
    }

    public final JnVector3d subtract(JnVector3d p2) {
        return this.sub(p2);
    }

    public final JnVector3d multiplyBy(double d2) {
        return this.scale(d2);
    }

    public final double distance(JnVector3d p2) {
        return Math.sqrt(this.sqDistance(p2));
    }

    public final double sqDistance(JnVector3d p2) {
        double dx = p2.x - this.x;
        double dy = p2.y - this.y;
        double dz = p2.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final double distanceToPlane(JnVector3d planeNormal, JnVector3d planePoint) {
        double d2 = planeNormal.x * (this.x - planePoint.x) + planeNormal.y * (this.y - planePoint.y) + planeNormal.z * (this.z - planePoint.z);
        return Math.abs(d2);
    }

    public final void fillArray(double[] array) {
        array[0] = this.x;
        array[1] = this.y;
        array[2] = this.z;
    }

    public final void fillArray(double[] array, int offset, int stride) {
        array[offset] = this.x;
        array[offset + stride] = this.y;
        array[offset + 2 * stride] = this.z;
    }

    public final void fillArray(double[] array, int offset) {
        this.fillArray(array, offset, 1);
    }

    public Object clone() {
        Object o2 = null;
        try {
            o2 = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o2;
    }

    public int hashCode() {
        int result = 1;
        long bits = JnUtils.doubleToLongBits(this.x);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.y);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.z);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

