/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnUtils;

public class JnVector4d
implements Cloneable {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double w = 0.0;

    public JnVector4d() {
    }

    public JnVector4d(double x2, double y2, double z2, double w2) {
        this.set(x2, y2, z2, w2);
    }

    public final double[] toArray() {
        return new double[]{this.x, this.y, this.z, this.w};
    }

    public final void get(double[] v2) {
        v2[0] = this.x;
        v2[1] = this.y;
        v2[2] = this.z;
        if (v2.length > 3) {
            v2[3] = this.w;
        }
    }

    public final void set(JnVector4d v2) {
        this.x = v2.x;
        this.y = v2.y;
        this.z = v2.z;
        this.w = v2.w;
    }

    public final void set(double[] v2) {
        this.x = v2[0];
        this.y = v2[1];
        this.z = v2[2];
        this.w = v2.length > 3 ? v2[3] : 1.0;
    }

    public final void set(double x2, double y2, double z2, double w2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.w = w2;
    }

    public final void add(JnVector4d v2) {
        this.x += v2.x;
        this.y += v2.y;
        this.z += v2.z;
        this.w += v2.w;
    }

    public final void add(JnVector4d v1, JnVector4d v2) {
        this.x = v1.x + v2.x;
        this.y = v1.y + v2.y;
        this.z = v1.z + v2.z;
        this.w = v1.w + v2.w;
    }

    public final void sub(JnVector4d v2) {
        this.x -= v2.x;
        this.y -= v2.y;
        this.z -= v2.z;
        this.w -= v2.w;
    }

    public final void sub(JnVector4d v1, JnVector4d v2) {
        this.x = v1.x - v2.x;
        this.y = v1.y - v2.y;
        this.z = v1.z - v2.z;
        this.w = v1.w - v2.w;
    }

    public final void add(double[] v2) {
        this.x += v2[0];
        this.y += v2[1];
        this.z += v2[2];
        this.w += v2[3];
    }

    public final void add(double[] v1, double[] v2) {
        this.x = v1[0] + v2[0];
        this.y = v1[1] + v2[1];
        this.z = v1[2] + v2[2];
        this.w = v1.length > 3 ? v1[3] + v2[3] : 1.0;
    }

    public final void sub(double[] v2) {
        this.x -= v2[0];
        this.y -= v2[1];
        this.z -= v2[2];
        this.w -= v2.length > 3 ? v2[3] : 1.0;
    }

    public final void sub(double[] v1, double[] v2) {
        this.x = v1[0] - v2[0];
        this.y = v1[1] - v2[1];
        this.z = v1[2] - v2[2];
        this.w = v1.length > 3 ? v1[3] - v2[3] : 1.0;
    }

    public final void scale(double s2) {
        this.x *= s2;
        this.y *= s2;
        this.z *= s2;
        this.w *= s2;
    }

    public final void scaleAdd(double s2, JnVector4d v2) {
        this.x += s2 * v2.x;
        this.y += s2 * v2.y;
        this.z += s2 * v2.z;
        this.w += s2 * v2.w;
    }

    public final void scaleAdd(double s2, JnVector4d v1, JnVector4d v2) {
        this.x = s2 * v1.x + v2.x;
        this.y = s2 * v1.y + v2.y;
        this.z = s2 * v1.z + v2.z;
        this.w = s2 * v1.w + v2.w;
    }

    public final void scaleAdd(double s2, double[] v2) {
        this.x += s2 * v2[0];
        this.y += s2 * v2[1];
        this.z += s2 * v2[2];
        this.w += s2 * v2[3];
    }

    public final void scaleAdd(double s2, double[] v1, double[] v2) {
        this.x = s2 * v1[0] + v2[0];
        this.y = s2 * v1[1] + v2[1];
        this.z = s2 * v1[2] + v2[2];
        this.w = s2 * v1[3] + v2[3];
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final double dot(JnVector4d v2) {
        return this.x * v2.x + this.y * v2.y + this.z * v2.z + this.w * v2.w;
    }

    public final double angle(JnVector4d v2) {
        double dotVal = this.dot(v2);
        double l1 = this.length();
        double l2 = v2.length();
        double angle = Math.acos(dotVal / (l1 * l2));
        return angle;
    }

    public final void normalize() {
        double len = this.length();
        this.x /= len;
        this.y /= len;
        this.z /= len;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        JnVector4d v3d = (JnVector4d)other;
        return this.x == v3d.x && this.y == v3d.y && this.z == v3d.z && this.w == v3d.w;
    }

    public final String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "," + this.w + "]";
    }

    public Object clone() {
        Object o2 = null;
        try {
            o2 = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o2;
    }

    public int hashCode() {
        int result = 1;
        long bits = JnUtils.doubleToLongBits(this.x);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.y);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.z);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.w);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

