/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.compression;

import com.ge.med.jnu.JnParallelTaskManager;
import com.ge.med.jnu.compression.CEError;
import com.ge.med.jnu.compression.TCe16Ll;

public class JnLuminanceCodec {
    private TCe16Ll[] comp = null;
    private CompressWorker[] cworker = null;
    private DecompressWorker[] dworker = null;
    private JnParallelTaskManager ptm = new JnParallelTaskManager();
    private byte[][] tempOut = null;
    private int width = 0;
    private int height = 0;

    public JnLuminanceCodec(String modality, int width, int height, int bitsAllocated, int bitsStored) {
        this.comp = new TCe16Ll[JnParallelTaskManager.NCPUS];
        this.cworker = new CompressWorker[JnParallelTaskManager.NCPUS];
        this.dworker = new DecompressWorker[JnParallelTaskManager.NCPUS];
        this.tempOut = new byte[JnParallelTaskManager.NCPUS][];
        for (int i2 = 0; i2 < this.comp.length; ++i2) {
            this.comp[i2] = new TCe16Ll(modality, height, width, bitsAllocated, bitsStored);
            this.tempOut[i2] = new byte[4 * width * (int)Math.ceil(height / JnParallelTaskManager.NCPUS)];
            this.cworker[i2] = new CompressWorker(this.comp[i2], this.tempOut[i2]);
            this.dworker[i2] = new DecompressWorker(this.comp[i2]);
        }
        this.width = width;
        this.height = height;
    }

    private static void putInt(byte[] b2, int off, int val) {
        b2[off + 3] = (byte)(val >>> 0);
        b2[off + 2] = (byte)(val >>> 8);
        b2[off + 1] = (byte)(val >>> 16);
        b2[off + 0] = (byte)(val >>> 24);
    }

    public static int getInt(byte[] b2, int off) {
        return ((b2[off + 3] & 0xFF) << 0) + ((b2[off + 2] & 0xFF) << 8) + ((b2[off + 1] & 0xFF) << 16) + ((b2[off + 0] & 0xFF) << 24);
    }

    public boolean compress(short[] inBuf, int inBufIdx, int[] inSize, byte[] outBuf, int outBufIdx, int[] outSize) {
        this.ptm.setWorkers(this.cworker);
        int brows = (int)Math.ceil((double)this.height / (double)this.cworker.length);
        int inLen = this.width * this.height;
        int bsize = this.width * brows;
        for (int i2 = 0; i2 < this.cworker.length; ++i2) {
            int idx = inBufIdx + i2 * bsize;
            int diff = inBufIdx + inLen - idx;
            int blockSize = diff >= bsize ? bsize : diff;
            this.cworker[i2].setInput(inBuf, idx, blockSize);
        }
        this.ptm.launch(null);
        boolean status = true;
        int totalLen = 0;
        for (int i3 = 0; i3 < this.cworker.length; ++i3) {
            status &= this.cworker[i3].getErrorCode() == CEError.NoErr;
        }
        JnLuminanceCodec.putInt(outBuf, outBufIdx, this.cworker.length);
        int start = outBufIdx + 4;
        for (int i4 = 0; i4 < this.cworker.length; ++i4) {
            int len = this.cworker[i4].getCompressedSize();
            int inbsize = this.cworker[i4].getInputBlockSize();
            byte[] temp = this.cworker[i4].getCompressedBuff();
            JnLuminanceCodec.putInt(outBuf, start, len);
            JnLuminanceCodec.putInt(outBuf, start += 4, inbsize);
            start += 4;
            for (int j2 = 0; j2 < len; ++j2) {
                outBuf[start + j2] = temp[j2];
            }
            totalLen += len + 8;
            start += len;
        }
        System.err.println(">>> totalLen=" + totalLen);
        outSize[0] = totalLen;
        return status;
    }

    public boolean decompress(byte[] inBuf, int inBufIdx, int[] inSize, short[] outBuf, int outBufIdx, int[] outSize) {
        this.ptm.setWorkers(this.dworker);
        int readIdx = inBufIdx;
        int nSegments = JnLuminanceCodec.getInt(inBuf, readIdx);
        readIdx += 4;
        int[] cbLen = new int[nSegments];
        int[] cbIdx = new int[nSegments];
        int[] dbLen = new int[nSegments];
        int[] dbIdx = new int[nSegments];
        System.err.println("# of segments: " + nSegments + "  outsize=" + outSize[0]);
        int outIdx = outBufIdx;
        for (int i2 = 0; i2 < nSegments; ++i2) {
            this.comp[0].PrepareToExpand();
            int len = JnLuminanceCodec.getInt(inBuf, readIdx);
            int outBlockSize = JnLuminanceCodec.getInt(inBuf, readIdx += 4);
            cbLen[i2] = len;
            cbIdx[i2] = readIdx += 4;
            dbLen[i2] = outBlockSize;
            dbIdx[i2] = outIdx;
            readIdx += len;
            outIdx += outBlockSize;
        }
        int nworkers = this.dworker.length;
        int eff_workers = Math.min(nworkers, nSegments);
        for (int s2 = 0; s2 < nSegments; s2 += nworkers) {
            int i3;
            for (i3 = 0; i3 < eff_workers; ++i3) {
                this.dworker[i3].setParams(inBuf, cbIdx[s2 + i3], cbLen[s2 + i3], outBuf, dbIdx[s2 + i3], dbLen[s2 + i3]);
            }
            for (i3 = eff_workers; i3 < nworkers; ++i3) {
                this.dworker[i3].setParams(null, -1, -1, null, -1, -1);
            }
            this.ptm.launch(null);
        }
        return true;
    }

    private class DecompressWorker
    implements JnParallelTaskManager.Worker {
        private int inputBlockSize = 0;
        private byte[] inBuf = null;
        private int inBufIdx = 0;
        private short[] outp = null;
        private int outp_idx = 0;
        private int outp_size = 0;
        private TCe16Ll comp = null;

        public DecompressWorker(TCe16Ll comp) {
            this.comp = comp;
        }

        public void setParams(byte[] inBuf, int inBufIdx, int inputBlockSize, short[] outBuf, int outBufIdx, int outputBlockSize) {
            this.inputBlockSize = inputBlockSize;
            this.inBuf = inBuf;
            this.inBufIdx = inBufIdx;
            this.outp = outBuf;
            this.outp_idx = outBufIdx;
            this.outp_size = outputBlockSize;
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            int[] inSize = new int[]{this.inputBlockSize};
            int[] outSize = new int[]{this.outp_size};
            if (this.inBufIdx >= 0 && this.outp_idx >= 0) {
                this.comp.PrepareToExpand();
                this.comp.Expand(this.inBuf, this.inBufIdx, inSize, this.outp, this.outp_idx, outSize);
            }
        }

        public CEError getErrorCode() {
            return this.comp.GetErrorCode();
        }

        public String getErrorText() {
            return this.comp.GetErrorText();
        }
    }

    private class CompressWorker
    implements JnParallelTaskManager.Worker {
        private int inputBlockSize = 0;
        private short[] inBuf = null;
        private int inBufIdx = 0;
        private byte[] temp = null;
        private TCe16Ll comp = null;
        private int compSize = 0;

        public CompressWorker(TCe16Ll comp, byte[] tempOut) {
            this.comp = comp;
            this.temp = tempOut;
        }

        public void setInput(short[] inBuf, int inBufIdx, int inputBlockSize) {
            this.inputBlockSize = inputBlockSize;
            this.inBuf = inBuf;
            this.inBufIdx = inBufIdx;
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            int[] inSize = new int[]{this.inputBlockSize};
            int[] outSize = new int[]{this.temp.length};
            this.comp.PrepareToCompress();
            this.comp.Compress(this.inBuf, this.inBufIdx, inSize, this.temp, 0, outSize);
            this.compSize = outSize[0];
        }

        public int getInputBlockSize() {
            return this.inputBlockSize;
        }

        public int getCompressedSize() {
            return this.compSize;
        }

        public byte[] getCompressedBuff() {
            return this.temp;
        }

        public CEError getErrorCode() {
            return this.comp.GetErrorCode();
        }

        public String getErrorText() {
            return this.comp.GetErrorText();
        }
    }
}

