/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.compression;

import com.ge.med.jnu.compression.CEError;
import com.ge.med.jnu.compression.CrExType;

public abstract class MCompressorExpander {
    private static final String[] fgErrorText = new String[]{"No error has occurred", "General (unknown) error", "CE could not allocate enough memory", "Expand input stream was bad", "A required input parameter was NULL", "Not prepared for comression", "Compress or Decompress did not have enough memory for result", "Invalid source buffer pointer", "Invalid destination buffer pointer", "Invalid source buffer size", "Invalid destination buffer size", "Invalid State Info", "Premature End Of Input Stream", "Premature End Of Output Stream", "End Of Compression Block reached", "Newer Compression Stream Encountered", "End Of Frame reached", "Invalid Checksum", "Input image dimension too small for Multi-Resolution compression", "A parameter was out of range", "Source buffer too small to complete request", "Destination buffer too small to complete request"};
    protected String fName = "Unknown";
    protected CEError fErr = CEError.NoErr;
    protected CrExType fType = CrExType.Uncompressed;
    protected double fEstCompressRatio = 1.0;
    private int rows = -1;
    private int cols = -1;
    private int bitsAllocated = -1;
    private int bitsStored = -1;
    private String modality = null;
    private long frameSize = -1L;

    public MCompressorExpander(String modality, int rows, int cols, int bitsAllocated, int bitsStored) {
        this.rows = rows;
        this.cols = cols;
        this.modality = modality;
        this.bitsAllocated = bitsAllocated;
        this.bitsStored = bitsStored;
    }

    public static String getError(CEError e2) {
        switch (e2) {
            case NoErr: {
                return fgErrorText[0];
            }
            case Error: {
                return fgErrorText[1];
            }
            case OutOfMemory: {
                return fgErrorText[2];
            }
            case BadInputStream: {
                return fgErrorText[3];
            }
            case NullParameter: {
                return fgErrorText[4];
            }
            case NotPrepared: {
                return fgErrorText[5];
            }
            case EndOfOutputBuffer: {
                return fgErrorText[6];
            }
            case InvalidSrcBufPtr: {
                return fgErrorText[7];
            }
            case InvalidDstBufPtr: {
                return fgErrorText[8];
            }
            case InvalidSrcBufSize: {
                return fgErrorText[9];
            }
            case InvalidDstBufSize: {
                return fgErrorText[10];
            }
            case InvalidStateInfo: {
                return fgErrorText[11];
            }
            case PrematureEndOfInStream: {
                return fgErrorText[12];
            }
            case PrematureEndOfOutStream: {
                return fgErrorText[13];
            }
            case EndOfCBlock: {
                return fgErrorText[14];
            }
            case NewerStreamVer: {
                return fgErrorText[15];
            }
            case EndOfFrame: {
                return fgErrorText[16];
            }
            case InvalidChecksum: {
                return fgErrorText[17];
            }
            case ImageTooSmall: {
                return fgErrorText[18];
            }
            case InvalidParameter: {
                return fgErrorText[19];
            }
            case SrcBufTooSmall: {
                return fgErrorText[20];
            }
            case DstBufTooSmall: {
                return fgErrorText[21];
            }
        }
        return "Unknown error code";
    }

    public abstract boolean PrepareToCompress();

    public abstract boolean Compress(short[] var1, int var2, int[] var3, byte[] var4, int var5, int[] var6);

    public abstract boolean EndCompression(byte[] var1, int var2, int[] var3);

    public abstract boolean PrepareToExpand();

    public abstract boolean Expand(byte[] var1, int var2, int[] var3, short[] var4, int var5, int[] var6);

    public CrExType GetType() {
        return this.fType;
    }

    public double GetEstCompressRatio() {
        return this.fEstCompressRatio;
    }

    public String GetName() {
        return this.fName;
    }

    public CEError GetErrorCode() {
        return this.fErr;
    }

    public String GetErrorText() {
        return MCompressorExpander.getError(this.fErr);
    }

    public String GetCEErrorText() {
        return null;
    }

    public void SetType(CrExType x2) {
        this.fType = x2;
    }

    public int GetRows() {
        return this.rows;
    }

    public int GetCols() {
        return this.cols;
    }

    public String GetModality() {
        return this.modality;
    }

    public int GetBitsStored() {
        return this.bitsStored;
    }

    public long GetFrameSize() {
        if (this.frameSize < 0L) {
            long bytesPerPixel = 0L;
            long samplesPerPixel = 1L;
            bytesPerPixel = (this.bitsAllocated - 1) / 8 + 1;
            if (bytesPerPixel == 0L) {
                bytesPerPixel = 2L;
            }
            long size = bytesPerPixel * (long)this.rows * (long)this.cols * samplesPerPixel;
            if (samplesPerPixel == 2L && (this.rows * this.cols & 1) != 0) {
                size += bytesPerPixel;
            }
            this.frameSize = size;
        }
        return this.frameSize;
    }

    public static enum CEColorSpace {
        CS_Unknown,
        CS_GrayScale,
        CS_RGB,
        CS_CMYK,
        CS_YCbCr;

    }
}

