/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.compression;

import com.ge.med.jnu.compression.CEError;
import com.ge.med.jnu.compression.CrExType;
import com.ge.med.jnu.compression.MCompressorExpander;

public class TCe16Ll
extends MCompressorExpander {
    private static final int kTCe16LlVer = 1;
    private static final int DiffTablesize = 2048;
    private static final int DiffTableCenter = 1024;
    private static LkUpTblDscrpt Scheme_0 = new LkUpTblDscrpt(2048, 21, new int[][]{{0, 0, 1}, {1, 1, 3}, {-1, -1, 3}, {2, 3, 5}, {-2, -3, 5}, {4, 7, 7}, {-4, -7, 7}, {8, 15, 9}, {-8, -15, 9}, {16, 31, 11}, {-16, -31, 11}, {32, 63, 13}, {-32, -63, 13}, {64, 127, 15}, {-64, -127, 15}, {128, 255, 17}, {-128, -255, 17}, {256, 511, 19}, {-256, -511, 19}, {512, 1023, 27}, {-512, -1024, 27}, {0}});
    private static LkUpTblDscrpt Scheme_1 = new LkUpTblDscrpt(2048, 20, new int[][]{{0, 1, 3}, {-1, -2, 3}, {2, 5, 5}, {-3, -6, 5}, {6, 13, 7}, {-7, -14, 7}, {14, 29, 9}, {-15, -30, 9}, {30, 61, 11}, {-31, -62, 11}, {62, 125, 13}, {-63, -126, 13}, {126, 253, 15}, {-127, -254, 15}, {254, 509, 17}, {-255, -510, 17}, {510, 1021, 19}, {-511, -1022, 19}, {1022, 1023, 26}, {-1023, -1024, 26}, {0}});
    private static LkUpTblDscrpt Scheme_2 = new LkUpTblDscrpt(2048, 18, new int[][]{{0, 3, 4}, {-1, -4, 4}, {4, 11, 6}, {-5, -12, 6}, {12, 27, 8}, {-13, -28, 8}, {28, 59, 10}, {-29, -60, 10}, {60, 123, 12}, {-61, -124, 12}, {124, 251, 14}, {-125, -252, 14}, {252, 507, 16}, {-253, -508, 16}, {508, 1019, 18}, {-509, -1020, 18}, {1020, 1023, 25}, {-1021, -1024, 25}, {0}});
    private static LkUpTblDscrpt Scheme_3 = new LkUpTblDscrpt(2048, 16, new int[][]{{0, 7, 5}, {-1, -8, 5}, {8, 23, 7}, {-9, -24, 7}, {24, 55, 9}, {-25, -56, 9}, {56, 119, 11}, {-57, -120, 11}, {120, 247, 13}, {-121, -248, 13}, {248, 503, 15}, {-249, -504, 15}, {504, 1015, 17}, {-505, -1016, 17}, {1016, 1023, 24}, {-1017, -1024, 24}, {0}});
    private static LkUpTblDscrpt Scheme_4 = new LkUpTblDscrpt(2048, 14, new int[][]{{0, 15, 6}, {-1, -16, 6}, {16, 47, 8}, {-17, -48, 8}, {48, 111, 10}, {-49, -112, 10}, {112, 239, 12}, {-113, -240, 12}, {240, 495, 14}, {-241, -496, 14}, {496, 1007, 16}, {-497, -1008, 16}, {1008, 1023, 23}, {-1009, -1024, 23}, {0}});
    private static LkUpTblDscrpt Scheme_5 = new LkUpTblDscrpt(2048, 12, new int[][]{{0, 31, 7}, {-1, -32, 7}, {32, 95, 9}, {-33, -96, 9}, {96, 223, 11}, {-97, -224, 11}, {224, 479, 13}, {-225, -480, 13}, {480, 991, 15}, {-481, -992, 15}, {992, 1023, 22}, {-993, -1024, 22}, {0}});
    private static LkUpTblDscrpt Scheme_6 = new LkUpTblDscrpt(2048, 10, new int[][]{{0, 63, 8}, {-1, -64, 8}, {64, 191, 10}, {-65, -192, 10}, {192, 447, 12}, {-193, -448, 12}, {448, 959, 14}, {-450, -960, 14}, {960, 1023, 21}, {-963, -1024, 21}, {0}});
    private static LkUpTblDscrpt Scheme_7 = new LkUpTblDscrpt(2048, 8, new int[][]{{0, 127, 9}, {-1, -128, 9}, {128, 383, 11}, {-129, -384, 11}, {384, 895, 13}, {-385, -896, 13}, {896, 1023, 20}, {-897, -1024, 20}, {0}});
    private static LkUpTblDscrpt Scheme_8 = new LkUpTblDscrpt(2048, 6, new int[][]{{0, 255, 10}, {-1, -256, 10}, {256, 767, 12}, {-257, -768, 12}, {768, 1023, 19}, {-769, -1024, 19}, {0}});
    private static LkUpTblDscrpt Scheme_9 = new LkUpTblDscrpt(2048, 4, new int[][]{{0, 511, 11}, {-1, -512, 11}, {512, 1023, 18}, {-512, -1024, 18}, {0}});
    private static LkUpTblDscrpt Scheme_A = new LkUpTblDscrpt(2048, 21, new int[][]{{0, 0, 2}, {1, 1, 2}, {-1, -1, 2}, {2, 3, 5}, {-2, -3, 5}, {4, 7, 7}, {-4, -7, 7}, {8, 15, 9}, {-8, -15, 9}, {16, 31, 11}, {-16, -31, 11}, {32, 63, 13}, {-32, -63, 13}, {64, 127, 15}, {-64, -127, 15}, {128, 255, 17}, {-128, -255, 17}, {256, 511, 19}, {-256, -511, 19}, {512, 1023, 27}, {-512, -1024, 27}, {0}});
    protected int fStreamVers;
    protected int fBlockLength;
    protected int[] fTableMap = new int[4];
    protected int[] fCodeLengthLookUp_01;
    protected int[] fCodeLengthLookUp_23;
    protected dtc_comp_state fCompState = new dtc_comp_state();
    protected dtc_decomp_state fExpandState = new dtc_decomp_state();
    static boolean gCodeLenghtLookupTablesInited = false;
    static int[] gCodeLengthLookUp_01 = new int[2048];
    static int[] gCodeLengthLookUp_12 = new int[2048];
    static int[] gCodeLengthLookUp_23 = new int[2048];
    static int[] gCodeLengthLookUp_34 = new int[2048];
    static int[] gCodeLengthLookUp_45 = new int[2048];
    static int[] gCodeLengthLookUp_56 = new int[2048];
    static int[] gCodeLengthLookUp_67 = new int[2048];
    static int[] gCodeLengthLookUp_78 = new int[2048];
    static int[] gCodeLengthLookUp_89 = new int[2048];
    static int[] gCodeLengthLookUp_02 = new int[2048];
    static int[] gCodeLengthLookUp_03 = new int[2048];
    static int[] gCodeLengthLookUp_04 = new int[2048];
    static int[] gCodeLengthLookUp_05 = new int[2048];
    static int[] gCodeLengthLookUp_06 = new int[2048];
    static int[] gCodeLengthLookUp_07 = new int[2048];
    static int[] gCodeLengthLookUp_0A = new int[2048];
    private static final int kDesiredRows = 24;

    private static int encodeSwapped(int theLW, byte[] dest, int destIdx) {
        int d2 = destIdx;
        dest[d2++] = (byte)(theLW & 0xFF);
        dest[d2++] = (byte)((theLW & 0xFF00) >> 8);
        dest[d2++] = (byte)((theLW & 0xFF0000) >> 16);
        dest[d2++] = (byte)((theLW & 0xFF000000) >> 24);
        return d2;
    }

    private static int SWAPLW(byte[] srcPtr, int srcPtrIdx) {
        return (srcPtr[srcPtrIdx + 3] & 0xFF) << 24 | (srcPtr[srcPtrIdx + 2] & 0xFF) << 16 | (srcPtr[srcPtrIdx + 1] & 0xFF) << 8 | srcPtr[srcPtrIdx] & 0xFF;
    }

    public TCe16Ll(String modality, int rows, int cols, int bitsAllocated, int bitsStored) {
        super(modality, rows, cols, bitsAllocated, bitsStored);
        this.fType = CrExType.Hoffman_Ll_16bit_3to1;
        this.fName = "16 bit lossless:  Adaptive, tables";
        this.fEstCompressRatio = this.GetModality().startsWith("CT") || this.GetModality().startsWith("MR") || this.GetBitsStored() >= 14 ? 1.9 : 2.5;
        this.PrepareToCompress();
        this.PrepareToExpand();
        if (!gCodeLenghtLookupTablesInited) {
            this.GenerateTable(gCodeLengthLookUp_01, Scheme_0, Scheme_1);
            this.GenerateTable(gCodeLengthLookUp_12, Scheme_1, Scheme_2);
            this.GenerateTable(gCodeLengthLookUp_23, Scheme_2, Scheme_3);
            this.GenerateTable(gCodeLengthLookUp_34, Scheme_3, Scheme_4);
            this.GenerateTable(gCodeLengthLookUp_45, Scheme_4, Scheme_5);
            this.GenerateTable(gCodeLengthLookUp_56, Scheme_5, Scheme_6);
            this.GenerateTable(gCodeLengthLookUp_67, Scheme_6, Scheme_7);
            this.GenerateTable(gCodeLengthLookUp_78, Scheme_7, Scheme_8);
            this.GenerateTable(gCodeLengthLookUp_89, Scheme_8, Scheme_9);
            this.GenerateTable(gCodeLengthLookUp_02, Scheme_0, Scheme_2);
            this.GenerateTable(gCodeLengthLookUp_03, Scheme_0, Scheme_3);
            this.GenerateTable(gCodeLengthLookUp_04, Scheme_0, Scheme_4);
            this.GenerateTable(gCodeLengthLookUp_05, Scheme_0, Scheme_5);
            this.GenerateTable(gCodeLengthLookUp_06, Scheme_0, Scheme_6);
            this.GenerateTable(gCodeLengthLookUp_07, Scheme_0, Scheme_7);
            this.GenerateTable(gCodeLengthLookUp_0A, Scheme_0, Scheme_A);
            gCodeLenghtLookupTablesInited = true;
        }
    }

    public double GetActCompRatioCompress() {
        double ratio = 0.0;
        if (this.fCompState.tot_cmp_bytes > 0 && this.fCompState.tot_unc_bytes > 0) {
            ratio = (float)this.fCompState.tot_unc_bytes / (float)this.fCompState.tot_cmp_bytes;
        }
        return ratio;
    }

    public double GetActCompRatioExpand() {
        double ratio = 0.0;
        if (this.fExpandState.tot_cmp_bytes > 0 && this.fExpandState.tot_unc_bytes > 0) {
            ratio = (float)this.fExpandState.tot_unc_bytes / (float)this.fExpandState.tot_cmp_bytes;
        }
        return ratio;
    }

    private void GenerateTable(int[] table, LkUpTblDscrpt tableDescriptor1, LkUpTblDscrpt tableDescriptor2) {
        int tablePtr;
        int i2 = 0;
        int k2 = 0;
        int midTablePtr = tableDescriptor1.numberOfTableEntries / 2;
        LkUpTblDscrpt tbl = tableDescriptor1;
        for (i2 = 0; i2 < tbl.numberOfbreakPoints; ++i2) {
            if (tbl.breakPoint[i2].startDifference < tbl.breakPoint[i2].endDifference) {
                k2 = (int)tbl.breakPoint[i2].startDifference;
                tablePtr = midTablePtr + k2;
                while ((long)k2 <= tbl.breakPoint[i2].endDifference) {
                    table[tablePtr++] = tbl.breakPoint[i2].codeLength << 16;
                    ++k2;
                }
                continue;
            }
            k2 = (int)tbl.breakPoint[i2].endDifference;
            tablePtr = midTablePtr + k2;
            while ((long)k2 <= tbl.breakPoint[i2].startDifference) {
                table[tablePtr++] = tbl.breakPoint[i2].codeLength << 16;
                ++k2;
            }
        }
        tbl = tableDescriptor2;
        for (i2 = 0; i2 < tbl.numberOfbreakPoints; ++i2) {
            if (tbl.breakPoint[i2].startDifference < tbl.breakPoint[i2].endDifference) {
                k2 = (int)tbl.breakPoint[i2].startDifference;
                tablePtr = midTablePtr + k2;
                while ((long)k2 <= tbl.breakPoint[i2].endDifference) {
                    int n2 = tablePtr++;
                    table[n2] = table[n2] | tbl.breakPoint[i2].codeLength;
                    ++k2;
                }
                continue;
            }
            k2 = (int)tbl.breakPoint[i2].endDifference;
            tablePtr = midTablePtr + k2;
            while ((long)k2 <= tbl.breakPoint[i2].startDifference) {
                int n3 = tablePtr++;
                table[n3] = table[n3] | tbl.breakPoint[i2].codeLength;
                ++k2;
            }
        }
    }

    @Override
    public boolean PrepareToCompress() {
        this.fCompState.isFirst = true;
        this.fCompState.endOfFrame = false;
        this.fCompState.wrotetablesym = false;
        this.fCompState.endOfBlockWritten = false;
        this.fCompState.tot_unc_bytes = 0;
        this.fCompState.tot_cmp_bytes = 0;
        this.fCompState.codecUsed[0] = 0;
        this.fCompState.codecUsed[1] = 0;
        this.fCompState.codecUsed[2] = 0;
        this.fCompState.codecUsed[3] = 0;
        this.fCompState.checksum = 0;
        this.fErr = CEError.NoErr;
        this.fCompState.nextFrameBoundary = 0;
        return true;
    }

    @Override
    public boolean Compress(short[] inBuf, int inBufIdx, int[] inSize, byte[] outBuf, int outBufIdx, int[] outSize) {
        int testBoundary;
        boolean rstat = false;
        this.fErr = CEError.NoErr;
        if (!this.CheckCompPrms(inBuf, inBufIdx, inSize, outBuf, outBufIdx, outSize)) {
            outSize[0] = 0;
            inSize[0] = 0;
            return false;
        }
        if (this.fCompState.endOfFrame) {
            inSize[0] = 0;
            rstat = this.CompressEnd(outBuf, outBufIdx, outSize);
            if (rstat) {
                this.PrepareToCompress();
                this.fErr = CEError.EndOfFrame;
            }
            return false;
        }
        boolean endOfFrame = false;
        int frameInSize = inSize[0];
        if (this.fCompState.nextFrameBoundary > 0 && (testBoundary = this.fCompState.tot_unc_bytes + frameInSize) >= this.fCompState.nextFrameBoundary) {
            frameInSize = this.fCompState.nextFrameBoundary - this.fCompState.tot_unc_bytes;
            endOfFrame = true;
        }
        int[] usedInSize = new int[]{frameInSize};
        switch (this.fType) {
            case Hoffman_Ll_S16bit_3to1: {
                rstat = this.CompressBlkSgn(inBuf, inBufIdx, usedInSize, outBuf, outBufIdx, outSize, this.fCompState);
                break;
            }
            case Hoffman_Ll_16bit_3to1: {
                rstat = this.CompressBlkUsgn(inBuf, inBufIdx, usedInSize, outBuf, outBufIdx, outSize, this.fCompState);
                break;
            }
            default: {
                this.fErr = CEError.Error;
                return false;
            }
        }
        inSize[0] = usedInSize[0];
        if (usedInSize[0] != frameInSize) {
            this.fErr = CEError.EndOfOutputBuffer;
            rstat = false;
        } else if (rstat) {
            this.fCompState.endOfBlockWritten = false;
            if (rstat && endOfFrame) {
                this.fCompState.endOfFrame = true;
            }
        }
        return rstat;
    }

    @Override
    public boolean EndCompression(byte[] outBuf, int outBufIdx, int[] outSize) {
        return this.CompressEnd(outBuf, outBufIdx, outSize);
    }

    @Override
    public boolean PrepareToExpand() {
        this.fExpandState.tot_unc_bytes = 0;
        this.fExpandState.tot_cmp_bytes = 0;
        this.fExpandState.first_pass = true;
        this.fExpandState.tail = 0;
        this.fExpandState.codeWord = 0;
        this.fExpandState.fillWord = 0;
        this.fExpandState.pixel_value = 0;
        this.fExpandState.pixelCnt = 0;
        this.fExpandState.table = 0;
        this.fExpandState.checksum = 0;
        this.fErr = CEError.NoErr;
        return true;
    }

    @Override
    public boolean Expand(byte[] inBuf, int inIdx, int[] inSize, short[] outBuf, int outIdx, int[] outSize) {
        boolean rstat = false;
        this.fErr = CEError.NoErr;
        int[] inBufIdx = new int[]{inIdx};
        int[] outBufIdx = new int[]{outIdx};
        if (!this.CheckDecompPrms(inBuf, inSize, outBuf, outSize)) {
            return false;
        }
        boolean done = false;
        while (!done) {
            done = true;
            switch (this.fType) {
                case Hoffman_Ll_S16bit_3to1: {
                    rstat = this.DecompressUsgn(inBuf, inBufIdx, inSize, outBuf, outBufIdx, outSize);
                    break;
                }
                case Hoffman_Ll_16bit_3to1: {
                    rstat = this.DecompressUsgn(inBuf, inBufIdx, inSize, outBuf, outBufIdx, outSize);
                    break;
                }
                default: {
                    this.fErr = CEError.Error;
                    return false;
                }
            }
            if (this.fErr != CEError.EndOfCBlock) continue;
            if (inSize[0] > 0 && outSize[0] > 0) {
                done = false;
            }
            this.fErr = CEError.NoErr;
        }
        return rstat;
    }

    private void PickSetOfTables(short[] srcPtr, int srcPtrIdx, int[] srcSize) {
        int offset;
        int imageColumns = this.GetCols();
        this.fBlockLength = imageColumns > 1500 ? 64 : (imageColumns > 1024 ? 52 : (imageColumns > 640 ? 44 : (imageColumns > 512 ? 32 : (imageColumns > 256 ? 24 : (imageColumns > 128 ? 20 : 16)))));
        int srcPixelCount = srcSize[0] / 2;
        if (12 > srcPixelCount / imageColumns) {
            if (this.GetModality().startsWith("CT") || this.GetModality().startsWith("MR") || this.GetBitsStored() >= 14) {
                this.fTableMap[0] = 0;
                this.fTableMap[1] = 3;
                this.fTableMap[2] = 4;
                this.fTableMap[3] = 5;
                this.fCodeLengthLookUp_01 = gCodeLengthLookUp_03;
                this.fCodeLengthLookUp_23 = gCodeLengthLookUp_45;
            } else {
                this.fTableMap[0] = 0;
                this.fTableMap[1] = 1;
                this.fTableMap[2] = 2;
                this.fTableMap[3] = 3;
                this.fCodeLengthLookUp_01 = gCodeLengthLookUp_01;
                this.fCodeLengthLookUp_23 = gCodeLengthLookUp_23;
            }
            return;
        }
        int median = 0;
        boolean hasRunsOfZeros = false;
        if ((long)srcSize[0] >= this.GetFrameSize() / 2L && srcPixelCount > (offset = imageColumns * (this.GetRows() / 3))) {
            srcPixelCount -= offset;
            srcPtrIdx += 2 * offset;
            int median2 = 0;
            boolean hasRunsOfZeros2 = false;
            if (hasRunsOfZeros2) {
                hasRunsOfZeros = true;
            }
            if (median2 > median) {
                median = median2;
            }
        }
        int scheme = median < 8 ? 0 : (median < 18 ? 1 : (median < 45 ? 2 : (median < 90 ? 3 : (median < 180 ? 4 : (median < 320 ? 5 : 6)))));
        if (median < 3 && !hasRunsOfZeros || median == 1) {
            this.fBlockLength += this.fBlockLength / 2;
        }
        this.fBlockLength &= 0xFFFFFFFC;
        switch (scheme) {
            case 0: {
                this.fCodeLengthLookUp_01 = gCodeLengthLookUp_01;
                this.fCodeLengthLookUp_23 = gCodeLengthLookUp_23;
                break;
            }
            case 1: {
                this.fCodeLengthLookUp_01 = gCodeLengthLookUp_12;
                this.fCodeLengthLookUp_23 = gCodeLengthLookUp_34;
                break;
            }
            case 2: {
                this.fCodeLengthLookUp_01 = gCodeLengthLookUp_23;
                this.fCodeLengthLookUp_23 = gCodeLengthLookUp_45;
                break;
            }
            case 3: {
                this.fCodeLengthLookUp_01 = gCodeLengthLookUp_34;
                this.fCodeLengthLookUp_23 = gCodeLengthLookUp_56;
                break;
            }
            case 4: {
                this.fCodeLengthLookUp_01 = gCodeLengthLookUp_45;
                this.fCodeLengthLookUp_23 = gCodeLengthLookUp_67;
                break;
            }
            case 5: {
                this.fCodeLengthLookUp_01 = gCodeLengthLookUp_56;
                this.fCodeLengthLookUp_23 = gCodeLengthLookUp_78;
                break;
            }
            case 6: {
                this.fCodeLengthLookUp_01 = gCodeLengthLookUp_67;
                this.fCodeLengthLookUp_23 = gCodeLengthLookUp_89;
            }
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            this.fTableMap[i2] = scheme + i2;
        }
        if (hasRunsOfZeros && scheme != 0) {
            this.fTableMap[0] = 0;
            switch (scheme) {
                case 1: {
                    this.fCodeLengthLookUp_01 = gCodeLengthLookUp_02;
                    break;
                }
                case 2: {
                    this.fCodeLengthLookUp_01 = gCodeLengthLookUp_03;
                    break;
                }
                case 3: {
                    this.fCodeLengthLookUp_01 = gCodeLengthLookUp_04;
                    break;
                }
                case 4: {
                    this.fCodeLengthLookUp_01 = gCodeLengthLookUp_05;
                    break;
                }
                case 5: {
                    this.fCodeLengthLookUp_01 = gCodeLengthLookUp_06;
                    break;
                }
                case 6: {
                    this.fCodeLengthLookUp_01 = gCodeLengthLookUp_07;
                }
            }
        }
    }

    private void DecodeTableSet(byte[] srcPtr, int[] srcPtrIdx, int[] srcSize) {
        int buf = srcPtrIdx[0];
        int packedTableInfo = 0;
        packedTableInfo = TCe16Ll.SWAPLW(srcPtr, buf);
        srcPtrIdx[0] = buf += 4;
        srcSize[0] = srcSize[0] - 4;
        this.fExpandState.tot_cmp_bytes += 4;
        this.fStreamVers = packedTableInfo >> 24 & 0xFF;
        this.fBlockLength = packedTableInfo >> 16 & 0xFF;
        this.fTableMap[0] = packedTableInfo >> 12 & 0xF;
        this.fTableMap[1] = packedTableInfo >> 8 & 0xF;
        this.fTableMap[2] = packedTableInfo >> 4 & 0xF;
        this.fTableMap[3] = packedTableInfo >> 0 & 0xF;
    }

    private boolean CheckDecompPrms(byte[] srcPtr, int[] srcSize, short[] dstPtr, int[] dstSize) {
        if (srcPtr == null) {
            this.fErr = CEError.InvalidSrcBufPtr;
            return false;
        }
        if (srcSize == null) {
            this.fErr = CEError.InvalidSrcBufSize;
            return false;
        }
        if (this.fExpandState.first_pass && srcSize[0] < 8) {
            this.fErr = CEError.InvalidSrcBufSize;
            return false;
        }
        if (dstPtr == null) {
            this.fErr = CEError.InvalidDstBufPtr;
            return false;
        }
        if (dstSize[0] < 2) {
            this.fErr = CEError.InvalidDstBufSize;
            return false;
        }
        if (dstSize[0] % 2 != 0) {
            this.fErr = CEError.InvalidDstBufSize;
            return false;
        }
        return true;
    }

    private boolean CheckCompPrms(short[] srcPtr, int srcPtrIdx, int[] srcSize, byte[] dstPtr, int dstPtrIdx, int[] dstSize) {
        if (srcPtr == null) {
            this.fErr = CEError.InvalidSrcBufPtr;
            return false;
        }
        if (srcSize[0] < 2) {
            this.fErr = CEError.InvalidSrcBufSize;
            return false;
        }
        if (srcSize[0] % 2 != 0) {
            this.fErr = CEError.InvalidSrcBufSize;
            return false;
        }
        if (dstPtr == null) {
            this.fErr = CEError.InvalidDstBufPtr;
            return false;
        }
        if (dstSize[0] < 4) {
            this.fErr = CEError.EndOfOutputBuffer;
            return false;
        }
        if (dstSize[0] % 4 != 0) {
            this.fErr = CEError.InvalidDstBufSize;
            return false;
        }
        return true;
    }

    private boolean DecompressEnd(byte[] srcPtr, int[] srcPtrIdx, int[] srcSize) {
        int srcBufPtr = 0;
        srcBufPtr = srcPtrIdx[0];
        int tail = this.fExpandState.tail;
        int codeWord = this.fExpandState.codeWord;
        int fillWord = this.fExpandState.fillWord;
        boolean rstat = false;
        if (codeWord == -262144) {
            tail -= 2;
        }
        if ((codeWord & 0xFFE00000) == -2097152 && fillWord == 0 && (tail >= 16 && srcSize[0] >= 8 && srcPtr[srcBufPtr] == 0 || tail < 16 && srcSize[0] >= 4)) {
            if (tail >= 16) {
                ++srcBufPtr;
                srcSize[0] = srcSize[0] - 4;
            }
            if (this.fStreamVers > 0) {
                int checksumSym = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                srcBufPtr += 4;
                if (this.fExpandState.checksum != checksumSym) {
                    this.fErr = CEError.InvalidChecksum;
                    rstat = false;
                    srcSize[0] = srcSize[0] - 4;
                    srcPtrIdx[0] = srcBufPtr;
                    return rstat;
                }
            }
            srcSize[0] = srcSize[0] - 4;
            srcPtrIdx[0] = ++srcBufPtr;
            this.PrepareToExpand();
            this.fErr = CEError.EndOfCBlock;
            rstat = true;
        }
        return rstat;
    }

    private boolean CompressEnd(byte[] dstPtr, int dstPtrIdx, int[] dstSize) {
        int symVal = 0;
        int outputword = 0;
        if (this.fCompState.endOfBlockWritten) {
            dstSize[0] = 0;
            this.fErr = CEError.NoErr;
            return true;
        }
        if (dstPtr == null) {
            this.fErr = CEError.InvalidDstBufPtr;
            return false;
        }
        if (dstSize[0] < 12) {
            dstSize[0] = 12;
            this.fErr = CEError.EndOfOutputBuffer;
            return false;
        }
        if (dstSize[0] % 4 != 0) {
            this.fErr = CEError.InvalidDstBufSize;
            return false;
        }
        int dstBufPtr = dstPtrIdx;
        int dstWordsLeft = dstSize[0] / 4;
        int shift = this.fCompState.shift;
        outputword = this.fCompState.outword;
        symVal = 131070;
        if ((shift -= 17) >= 0) {
            outputword |= symVal << shift;
        } else {
            int shifttemp = -shift;
            dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
            --dstWordsLeft;
            outputword = symVal << (shift += 32);
        }
        dstBufPtr = TCe16Ll.encodeSwapped(outputword, dstPtr, dstBufPtr);
        --dstWordsLeft;
        dstPtr[dstBufPtr++] = 0;
        --dstWordsLeft;
        dstBufPtr = TCe16Ll.encodeSwapped(this.fCompState.checksum, dstPtr, dstBufPtr);
        dstSize[0] = dstSize[0] - --dstWordsLeft * 4;
        this.fCompState.tot_cmp_bytes += dstSize[0];
        this.fCompState.endOfBlockWritten = true;
        return true;
    }

    private boolean CompressBlkUsgn(short[] srcPtr, int srcPtrIdx, int[] srcSize, byte[] dstPtr, int dstPtrIdx, int[] dstSize, dtc_comp_state fCompState) {
        int shifttemp;
        int cNsize;
        int cSize;
        int pixelValue;
        int diffValue;
        int c23size;
        int c01size;
        int prevPix;
        int checksum;
        int pixelBlockCount;
        int shift;
        int prevPixelValue;
        int newPixelValue;
        int outputword;
        int srcBufPtr = 0;
        int dstBufPtr = 0;
        int symVal = 0;
        int table = 0;
        int table1 = 1024;
        int table2 = 1024;
        int i2 = 0;
        srcBufPtr = srcPtrIdx;
        dstBufPtr = dstPtrIdx;
        int srcPixelsLeft = srcSize[0];
        int dstWordsLeft = dstSize[0] / 4;
        if (fCompState.isFirst) {
            fCompState.isFirst = false;
            this.PickSetOfTables(srcPtr, srcPtrIdx, srcSize);
            table1 = 1024;
            table2 = 1024;
            outputword = 0x1000000 | this.fBlockLength << 16 | this.fTableMap[0] << 12 | this.fTableMap[1] << 8 | this.fTableMap[2] << 4 | this.fTableMap[3];
            dstBufPtr = TCe16Ll.encodeSwapped(outputword, dstPtr, dstBufPtr);
            --dstWordsLeft;
            fCompState.tot_unc_bytes = 0;
            fCompState.tot_cmp_bytes = 0;
            fCompState.wrotetablesym = false;
            newPixelValue = 0;
            prevPixelValue = 0;
            shift = 32;
            outputword = 0;
            table = 3;
            pixelBlockCount = this.fBlockLength;
            checksum = 0;
        } else {
            newPixelValue = fCompState.pixel_value;
            prevPixelValue = fCompState.pixel_value;
            shift = fCompState.shift;
            outputword = fCompState.outword;
            table = fCompState.table;
            pixelBlockCount = fCompState.pixelBlockCount;
            checksum = fCompState.checksum;
        }
        if (pixelBlockCount == this.fBlockLength && !fCompState.wrotetablesym) {
            if (srcPixelsLeft >= pixelBlockCount) {
                prevPix = prevPixelValue;
                c01size = 0;
                c23size = 0;
                for (i2 = pixelBlockCount / 4; i2 > 0; --i2) {
                    if ((diffValue = prevPix - (pixelValue = srcPtr[srcBufPtr++] & 0xFFFF)) < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                }
                srcBufPtr -= pixelBlockCount;
                cSize = 0;
                cNsize = 0;
                table = 0;
                cNsize = c01size & 0xFFFF;
                cSize = c01size >>> 16;
                if (cNsize < cSize) {
                    table = 1;
                    cSize = cNsize;
                }
                if ((cNsize = c23size >>> 16) < cSize) {
                    table = 2;
                    cSize = cNsize;
                }
                if ((cNsize = c23size & 0xFFFF) < cSize) {
                    table = 3;
                }
                int n2 = table;
                fCompState.codecUsed[n2] = fCompState.codecUsed[n2] + 1;
            } else if (srcPixelsLeft > 0) {
                pixelBlockCount = srcPixelsLeft;
                table = this.fTableMap[0] == table ? 0 : (this.fTableMap[1] == table ? 1 : (this.fTableMap[2] == table ? 2 : 3));
            } else {
                return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
            }
            symVal = table;
            table = this.fTableMap[table];
            if ((shift -= 2) >= 0) {
                outputword |= symVal << shift;
            } else {
                shifttemp = -shift;
                dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                outputword = symVal << (shift += 32);
                if (--dstWordsLeft == 0) {
                    return TCe16Ll.WroteTableSymMemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                }
            }
        }
        fCompState.wrotetablesym = false;
        if (srcPixelsLeft < pixelBlockCount) {
            pixelBlockCount = srcPixelsLeft;
        }
        srcPixelsLeft -= pixelBlockCount;
        while (true) {
            switch (table) {
                case 0: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue == 0) {
                            --shift;
                            symVal = 0;
                        } else if (diffValue < 0) {
                            if ((diffValue = -diffValue) == 1) {
                                shift -= 3;
                                symVal = 5;
                            } else if ((diffValue -= 2) < 2) {
                                shift -= 5;
                                symVal = 0x1A | diffValue;
                            } else if ((diffValue -= 2) < 4) {
                                shift -= 7;
                                symVal = 0x74 | diffValue;
                            } else if ((diffValue -= 4) < 8) {
                                shift -= 9;
                                symVal = 0x1E8 | diffValue;
                            } else if ((diffValue -= 8) < 16) {
                                shift -= 11;
                                symVal = 0x7D0 | diffValue;
                            } else if ((diffValue -= 16) < 32) {
                                shift -= 13;
                                symVal = 0x1FA0 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 15;
                                symVal = 0x7F40 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 17;
                                symVal = 0x1FE80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 19;
                                symVal = 0x7FD00 | diffValue;
                            } else {
                                shift -= 27;
                                symVal = 0x7FE0000 | newPixelValue;
                            }
                        } else if (diffValue == 1) {
                            shift -= 3;
                            symVal = 4;
                        } else if ((diffValue -= 2) < 2) {
                            shift -= 5;
                            symVal = 0x18 | diffValue;
                        } else if ((diffValue -= 2) < 4) {
                            shift -= 7;
                            symVal = 0x70 | diffValue;
                        } else if ((diffValue -= 4) < 8) {
                            shift -= 9;
                            symVal = 0x1E0 | diffValue;
                        } else if ((diffValue -= 8) < 16) {
                            shift -= 11;
                            symVal = 0x7C0 | diffValue;
                        } else if ((diffValue -= 16) < 32) {
                            shift -= 13;
                            symVal = 0x1F80 | diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 15;
                            symVal = 0x7F00 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 17;
                            symVal = 0x1FE00 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 19;
                            symVal = 0x7FC00 | diffValue;
                        } else {
                            shift -= 27;
                            symVal = 0x7FE0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 1: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 2) {
                                shift -= 3;
                                symVal = 2 | diffValue;
                            } else if ((diffValue -= 2) < 4) {
                                shift -= 5;
                                symVal = 0x14 | diffValue;
                            } else if ((diffValue -= 4) < 8) {
                                shift -= 7;
                                symVal = 0x68 | diffValue;
                            } else if ((diffValue -= 8) < 16) {
                                shift -= 9;
                                symVal = 0x1D0 | diffValue;
                            } else if ((diffValue -= 16) < 32) {
                                shift -= 11;
                                symVal = 0x7A0 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 13;
                                symVal = 0x1F40 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 15;
                                symVal = 0x7E80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 17;
                                symVal = 0x1FD00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 19;
                                symVal = 0x7FA00 | diffValue;
                            } else {
                                shift -= 26;
                                symVal = 0x3FE0000 | newPixelValue;
                            }
                        } else if (diffValue < 2) {
                            shift -= 3;
                            symVal = diffValue;
                        } else if ((diffValue -= 2) < 4) {
                            shift -= 5;
                            symVal = 0x10 | diffValue;
                        } else if ((diffValue -= 4) < 8) {
                            shift -= 7;
                            symVal = 0x60 | diffValue;
                        } else if ((diffValue -= 8) < 16) {
                            shift -= 9;
                            symVal = 0x1C0 | diffValue;
                        } else if ((diffValue -= 16) < 32) {
                            shift -= 11;
                            symVal = 0x780 | diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 13;
                            symVal = 0x1F00 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 15;
                            symVal = 0x7E00 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 17;
                            symVal = 0x1FC00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 19;
                            symVal = 0x7F800 | diffValue;
                        } else {
                            shift -= 26;
                            symVal = 0x3FE0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 2: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 4) {
                                shift -= 4;
                                symVal = 4 | diffValue;
                            } else if ((diffValue -= 4) < 8) {
                                shift -= 6;
                                symVal = 0x28 | diffValue;
                            } else if ((diffValue -= 8) < 16) {
                                shift -= 8;
                                symVal = 0xD0 | diffValue;
                            } else if ((diffValue -= 16) < 32) {
                                shift -= 10;
                                symVal = 0x3A0 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 12;
                                symVal = 0xF40 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 14;
                                symVal = 0x3E80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 16;
                                symVal = 0xFD00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 18;
                                symVal = 0x3FA00 | diffValue;
                            } else {
                                shift -= 25;
                                symVal = 0x1FE0000 | newPixelValue;
                            }
                        } else if (diffValue < 4) {
                            shift -= 4;
                            symVal = diffValue;
                        } else if ((diffValue -= 4) < 8) {
                            shift -= 6;
                            symVal = 0x20 | diffValue;
                        } else if ((diffValue -= 8) < 16) {
                            shift -= 8;
                            symVal = 0xC0 | diffValue;
                        } else if ((diffValue -= 16) < 32) {
                            shift -= 10;
                            symVal = 0x380 | diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 12;
                            symVal = 0xF00 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 14;
                            symVal = 0x3E00 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 16;
                            symVal = 0xFC00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 18;
                            symVal = 0x3F800 | diffValue;
                        } else {
                            shift -= 25;
                            symVal = 0x1FE0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 3: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 8) {
                                shift -= 5;
                                symVal = 8 | diffValue;
                            } else if ((diffValue -= 8) < 16) {
                                shift -= 7;
                                symVal = 0x50 | diffValue;
                            } else if ((diffValue -= 16) < 32) {
                                shift -= 9;
                                symVal = 0x1A0 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 11;
                                symVal = 0x740 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 13;
                                symVal = 0x1E80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 15;
                                symVal = 0x7D00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 17;
                                symVal = 0x1FA00 | diffValue;
                            } else {
                                shift -= 24;
                                symVal = 0xFE0000 | newPixelValue;
                            }
                        } else if (diffValue < 8) {
                            shift -= 5;
                            symVal = 0 | diffValue;
                        } else if ((diffValue -= 8) < 16) {
                            shift -= 7;
                            symVal = 0x40 | diffValue;
                        } else if ((diffValue -= 16) < 32) {
                            shift -= 9;
                            symVal = 0x180 | diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 11;
                            symVal = 0x700 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 13;
                            symVal = 0x1E00 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 15;
                            symVal = 0x7C00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 17;
                            symVal = 0x1F800 | diffValue;
                        } else {
                            shift -= 24;
                            symVal = 0xFE0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 4: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 16) {
                                shift -= 6;
                                symVal = 0x10 | diffValue;
                            } else if ((diffValue -= 16) < 32) {
                                shift -= 8;
                                symVal = 0xA0 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 10;
                                symVal = 0x340 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 12;
                                symVal = 0xE80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 14;
                                symVal = 0x3D00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 16;
                                symVal = 0xFA00 | diffValue;
                            } else {
                                shift -= 23;
                                symVal = 0x7E0000 | newPixelValue;
                            }
                        } else if (diffValue < 16) {
                            shift -= 6;
                            symVal = diffValue;
                        } else if ((diffValue -= 16) < 32) {
                            shift -= 8;
                            symVal = 0x80 | diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 10;
                            symVal = 0x300 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 12;
                            symVal = 0xE00 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 14;
                            symVal = 0x3C00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 16;
                            symVal = 0xF800 | diffValue;
                        } else {
                            shift -= 23;
                            symVal = 0x7E0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 5: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 32) {
                                shift -= 7;
                                symVal = 0x20 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 9;
                                symVal = 0x140 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 11;
                                symVal = 0x680 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 13;
                                symVal = 0x1D00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 15;
                                symVal = 0x7A00 | diffValue;
                            } else {
                                shift -= 22;
                                symVal = 0x3E0000 | newPixelValue;
                            }
                        } else if (diffValue < 32) {
                            shift -= 7;
                            symVal = diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 9;
                            symVal = 0x100 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 11;
                            symVal = 0x600 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 13;
                            symVal = 0x1C00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 15;
                            symVal = 0x7800 | diffValue;
                        } else {
                            shift -= 22;
                            symVal = 0x3E0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 6: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 64) {
                                shift -= 8;
                                symVal = 0x40 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 10;
                                symVal = 0x280 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 12;
                                symVal = 0xD00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 14;
                                symVal = 0x3A00 | diffValue;
                            } else {
                                shift -= 21;
                                symVal = 0x1E0000 | newPixelValue;
                            }
                        } else if (diffValue < 64) {
                            shift -= 8;
                            symVal = diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 10;
                            symVal = 0x200 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 12;
                            symVal = 0xC00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 14;
                            symVal = 0x3800 | diffValue;
                        } else {
                            shift -= 21;
                            symVal = 0x1E0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 7: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 128) {
                                shift -= 9;
                                symVal = 0x80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 11;
                                symVal = 0x500 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 13;
                                symVal = 0x1A00 | diffValue;
                            } else {
                                shift -= 20;
                                symVal = 0xE0000 | newPixelValue;
                            }
                        } else if (diffValue < 128) {
                            shift -= 9;
                            symVal = diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 11;
                            symVal = 0x400 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 13;
                            symVal = 0x1800 | diffValue;
                        } else {
                            shift -= 20;
                            symVal = 0xE0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 8: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 256) {
                                shift -= 10;
                                symVal = 0x100 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 12;
                                symVal = 0xA00 | diffValue;
                            } else {
                                shift -= 19;
                                symVal = 0x60000 | newPixelValue;
                            }
                        } else if (diffValue < 256) {
                            shift -= 10;
                            symVal = diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 12;
                            symVal = 0x800 | diffValue;
                        } else {
                            shift -= 19;
                            symVal = 0x60000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 9: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 512) {
                                shift -= 11;
                                symVal = 0x200 | diffValue;
                            } else {
                                shift -= 18;
                                symVal = 0x20000 | newPixelValue;
                            }
                        } else if (diffValue < 512) {
                            shift -= 11;
                            symVal = diffValue;
                        } else {
                            shift -= 18;
                            symVal = 0x20000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                }
            }
            pixelBlockCount = this.fBlockLength;
            if (srcPixelsLeft >= pixelBlockCount) {
                prevPix = prevPixelValue;
                c01size = 0;
                c23size = 0;
                for (i2 = pixelBlockCount / 4; i2 > 0; --i2) {
                    if ((diffValue = prevPix - (pixelValue = srcPtr[srcBufPtr++] & 0xFFFF)) < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++] & 0xFFFF;
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                }
                srcBufPtr -= pixelBlockCount;
                table = 0;
                cNsize = c01size & 0xFFFF;
                cSize = c01size >>> 16;
                if (cNsize < cSize) {
                    table = 1;
                    cSize = cNsize;
                }
                if ((cNsize = c23size >>> 16) < cSize) {
                    table = 2;
                    cSize = cNsize;
                }
                if ((cNsize = c23size & 0xFFFF) < cSize) {
                    table = 3;
                }
                int n3 = table;
                fCompState.codecUsed[n3] = fCompState.codecUsed[n3] + 1;
            } else if (srcPixelsLeft > 0) {
                pixelBlockCount = srcPixelsLeft;
                table = this.fTableMap[0] == table ? 0 : (this.fTableMap[1] == table ? 1 : (this.fTableMap[2] == table ? 2 : 3));
            } else {
                return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
            }
            symVal = table;
            table = this.fTableMap[table];
            if ((shift -= 2) >= 0) {
                outputword |= symVal << shift;
            } else {
                shifttemp = -shift;
                dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                outputword = symVal << (shift += 32);
                if (--dstWordsLeft == 0) {
                    return TCe16Ll.WroteTableSymMemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                }
            }
            srcPixelsLeft -= pixelBlockCount;
        }
    }

    private boolean CompressBlkSgn(short[] srcPtr, int srcPtrIdx, int[] srcSize, byte[] dstPtr, int dstPtrIdx, int[] dstSize, dtc_comp_state fCompState) {
        int shifttemp;
        int cNsize;
        int cSize;
        int pixelValue;
        int diffValue;
        int c23size;
        int c01size;
        int prevPix;
        int checksum;
        int pixelBlockCount;
        int shift;
        int prevPixelValue;
        int newPixelValue;
        int outputword;
        int srcBufPtr = 0;
        int dstBufPtr = 0;
        int symVal = 0;
        int table = 0;
        int table1 = 1024;
        int table2 = 1024;
        int i2 = 0;
        srcBufPtr = srcPtrIdx;
        dstBufPtr = dstPtrIdx;
        int srcPixelsLeft = srcSize[0];
        int dstWordsLeft = dstSize[0] / 4;
        if (fCompState.isFirst) {
            fCompState.isFirst = false;
            this.PickSetOfTables(srcPtr, srcPtrIdx, srcSize);
            table1 = 1024;
            table2 = 1024;
            outputword = 0x1000000 | this.fBlockLength << 16 | this.fTableMap[0] << 12 | this.fTableMap[1] << 8 | this.fTableMap[2] << 4 | this.fTableMap[3];
            dstBufPtr = TCe16Ll.encodeSwapped(outputword, dstPtr, dstBufPtr);
            --dstWordsLeft;
            fCompState.tot_unc_bytes = 0;
            fCompState.tot_cmp_bytes = 0;
            fCompState.wrotetablesym = false;
            newPixelValue = 0;
            prevPixelValue = 0;
            shift = 32;
            outputword = 0;
            table = 3;
            pixelBlockCount = this.fBlockLength;
            checksum = 0;
        } else {
            newPixelValue = fCompState.pixel_value;
            prevPixelValue = fCompState.pixel_value;
            shift = fCompState.shift;
            outputword = fCompState.outword;
            table = fCompState.table;
            pixelBlockCount = fCompState.pixelBlockCount;
            checksum = fCompState.checksum;
        }
        if (pixelBlockCount == this.fBlockLength && !fCompState.wrotetablesym) {
            if (srcPixelsLeft >= pixelBlockCount) {
                prevPix = prevPixelValue;
                c01size = 0;
                c23size = 0;
                for (i2 = pixelBlockCount / 4; i2 > 0; --i2) {
                    if ((diffValue = prevPix - (pixelValue = srcPtr[srcBufPtr++])) < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++];
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++];
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++];
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                }
                srcBufPtr -= pixelBlockCount;
                cSize = 0;
                cNsize = 0;
                table = 0;
                cNsize = c01size & 0xFFFF;
                cSize = c01size >>> 16;
                if (cNsize < cSize) {
                    table = 1;
                    cSize = cNsize;
                }
                if ((cNsize = c23size >>> 16) < cSize) {
                    table = 2;
                    cSize = cNsize;
                }
                if ((cNsize = c23size & 0xFFFF) < cSize) {
                    table = 3;
                }
                int n2 = table;
                fCompState.codecUsed[n2] = fCompState.codecUsed[n2] + 1;
            } else if (srcPixelsLeft > 0) {
                pixelBlockCount = srcPixelsLeft;
                table = this.fTableMap[0] == table ? 0 : (this.fTableMap[1] == table ? 1 : (this.fTableMap[2] == table ? 2 : 3));
            } else {
                return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
            }
            symVal = table;
            table = this.fTableMap[table];
            if ((shift -= 2) >= 0) {
                outputword |= symVal << shift;
            } else {
                shifttemp = -shift;
                dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                outputword = symVal << (shift += 32);
                if (--dstWordsLeft == 0) {
                    return TCe16Ll.WroteTableSymMemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                }
            }
        }
        fCompState.wrotetablesym = false;
        if (srcPixelsLeft < pixelBlockCount) {
            pixelBlockCount = srcPixelsLeft;
        }
        srcPixelsLeft -= pixelBlockCount;
        while (true) {
            switch (table) {
                case 0: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++];
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue == 0) {
                            --shift;
                            symVal = 0;
                        } else if (diffValue < 0) {
                            if ((diffValue = -diffValue) == 1) {
                                shift -= 3;
                                symVal = 5;
                            } else if ((diffValue -= 2) < 2) {
                                shift -= 5;
                                symVal = 0x1A | diffValue;
                            } else if ((diffValue -= 2) < 4) {
                                shift -= 7;
                                symVal = 0x74 | diffValue;
                            } else if ((diffValue -= 4) < 8) {
                                shift -= 9;
                                symVal = 0x1E8 | diffValue;
                            } else if ((diffValue -= 8) < 16) {
                                shift -= 11;
                                symVal = 0x7D0 | diffValue;
                            } else if ((diffValue -= 16) < 32) {
                                shift -= 13;
                                symVal = 0x1FA0 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 15;
                                symVal = 0x7F40 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 17;
                                symVal = 0x1FE80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 19;
                                symVal = 0x7FD00 | diffValue;
                            } else {
                                shift -= 27;
                                symVal = 0x7FE0000 | newPixelValue;
                            }
                        } else if (diffValue == 1) {
                            shift -= 3;
                            symVal = 4;
                        } else if ((diffValue -= 2) < 2) {
                            shift -= 5;
                            symVal = 0x18 | diffValue;
                        } else if ((diffValue -= 2) < 4) {
                            shift -= 7;
                            symVal = 0x70 | diffValue;
                        } else if ((diffValue -= 4) < 8) {
                            shift -= 9;
                            symVal = 0x1E0 | diffValue;
                        } else if ((diffValue -= 8) < 16) {
                            shift -= 11;
                            symVal = 0x7C0 | diffValue;
                        } else if ((diffValue -= 16) < 32) {
                            shift -= 13;
                            symVal = 0x1F80 | diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 15;
                            symVal = 0x7F00 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 17;
                            symVal = 0x1FE00 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 19;
                            symVal = 0x7FC00 | diffValue;
                        } else {
                            shift -= 27;
                            symVal = 0x7FE0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 1: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++];
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 2) {
                                shift -= 3;
                                symVal = 2 | diffValue;
                            } else if ((diffValue -= 2) < 4) {
                                shift -= 5;
                                symVal = 0x14 | diffValue;
                            } else if ((diffValue -= 4) < 8) {
                                shift -= 7;
                                symVal = 0x68 | diffValue;
                            } else if ((diffValue -= 8) < 16) {
                                shift -= 9;
                                symVal = 0x1D0 | diffValue;
                            } else if ((diffValue -= 16) < 32) {
                                shift -= 11;
                                symVal = 0x7A0 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 13;
                                symVal = 0x1F40 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 15;
                                symVal = 0x7E80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 17;
                                symVal = 0x1FD00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 19;
                                symVal = 0x7FA00 | diffValue;
                            } else {
                                shift -= 26;
                                symVal = 0x3FE0000 | newPixelValue;
                            }
                        } else if (diffValue < 2) {
                            shift -= 3;
                            symVal = diffValue;
                        } else if ((diffValue -= 2) < 4) {
                            shift -= 5;
                            symVal = 0x10 | diffValue;
                        } else if ((diffValue -= 4) < 8) {
                            shift -= 7;
                            symVal = 0x60 | diffValue;
                        } else if ((diffValue -= 8) < 16) {
                            shift -= 9;
                            symVal = 0x1C0 | diffValue;
                        } else if ((diffValue -= 16) < 32) {
                            shift -= 11;
                            symVal = 0x780 | diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 13;
                            symVal = 0x1F00 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 15;
                            symVal = 0x7E00 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 17;
                            symVal = 0x1FC00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 19;
                            symVal = 0x7F800 | diffValue;
                        } else {
                            shift -= 26;
                            symVal = 0x3FE0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 2: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++];
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 4) {
                                shift -= 4;
                                symVal = 4 | diffValue;
                            } else if ((diffValue -= 4) < 8) {
                                shift -= 6;
                                symVal = 0x28 | diffValue;
                            } else if ((diffValue -= 8) < 16) {
                                shift -= 8;
                                symVal = 0xD0 | diffValue;
                            } else if ((diffValue -= 16) < 32) {
                                shift -= 10;
                                symVal = 0x3A0 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 12;
                                symVal = 0xF40 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 14;
                                symVal = 0x3E80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 16;
                                symVal = 0xFD00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 18;
                                symVal = 0x3FA00 | diffValue;
                            } else {
                                shift -= 25;
                                symVal = 0x1FE0000 | newPixelValue;
                            }
                        } else if (diffValue < 4) {
                            shift -= 4;
                            symVal = diffValue;
                        } else if ((diffValue -= 4) < 8) {
                            shift -= 6;
                            symVal = 0x20 | diffValue;
                        } else if ((diffValue -= 8) < 16) {
                            shift -= 8;
                            symVal = 0xC0 | diffValue;
                        } else if ((diffValue -= 16) < 32) {
                            shift -= 10;
                            symVal = 0x380 | diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 12;
                            symVal = 0xF00 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 14;
                            symVal = 0x3E00 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 16;
                            symVal = 0xFC00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 18;
                            symVal = 0x3F800 | diffValue;
                        } else {
                            shift -= 25;
                            symVal = 0x1FE0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 3: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++];
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 8) {
                                shift -= 5;
                                symVal = 8 | diffValue;
                            } else if ((diffValue -= 8) < 16) {
                                shift -= 7;
                                symVal = 0x50 | diffValue;
                            } else if ((diffValue -= 16) < 32) {
                                shift -= 9;
                                symVal = 0x1A0 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 11;
                                symVal = 0x740 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 13;
                                symVal = 0x1E80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 15;
                                symVal = 0x7D00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 17;
                                symVal = 0x1FA00 | diffValue;
                            } else {
                                shift -= 24;
                                symVal = 0xFE0000 | newPixelValue;
                            }
                        } else if (diffValue < 8) {
                            shift -= 5;
                            symVal = 0 | diffValue;
                        } else if ((diffValue -= 8) < 16) {
                            shift -= 7;
                            symVal = 0x40 | diffValue;
                        } else if ((diffValue -= 16) < 32) {
                            shift -= 9;
                            symVal = 0x180 | diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 11;
                            symVal = 0x700 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 13;
                            symVal = 0x1E00 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 15;
                            symVal = 0x7C00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 17;
                            symVal = 0x1F800 | diffValue;
                        } else {
                            shift -= 24;
                            symVal = 0xFE0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 4: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++];
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 16) {
                                shift -= 6;
                                symVal = 0x10 | diffValue;
                            } else if ((diffValue -= 16) < 32) {
                                shift -= 8;
                                symVal = 0xA0 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 10;
                                symVal = 0x340 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 12;
                                symVal = 0xE80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 14;
                                symVal = 0x3D00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 16;
                                symVal = 0xFA00 | diffValue;
                            } else {
                                shift -= 23;
                                symVal = 0x7E0000 | newPixelValue;
                            }
                        } else if (diffValue < 16) {
                            shift -= 6;
                            symVal = diffValue;
                        } else if ((diffValue -= 16) < 32) {
                            shift -= 8;
                            symVal = 0x80 | diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 10;
                            symVal = 0x300 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 12;
                            symVal = 0xE00 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 14;
                            symVal = 0x3C00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 16;
                            symVal = 0xF800 | diffValue;
                        } else {
                            shift -= 23;
                            symVal = 0x7E0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 5: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++];
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 32) {
                                shift -= 7;
                                symVal = 0x20 | diffValue;
                            } else if ((diffValue -= 32) < 64) {
                                shift -= 9;
                                symVal = 0x140 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 11;
                                symVal = 0x680 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 13;
                                symVal = 0x1D00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 15;
                                symVal = 0x7A00 | diffValue;
                            } else {
                                shift -= 22;
                                symVal = 0x3E0000 | newPixelValue;
                            }
                        } else if (diffValue < 32) {
                            shift -= 7;
                            symVal = diffValue;
                        } else if ((diffValue -= 32) < 64) {
                            shift -= 9;
                            symVal = 0x100 | diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 11;
                            symVal = 0x600 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 13;
                            symVal = 0x1C00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 15;
                            symVal = 0x7800 | diffValue;
                        } else {
                            shift -= 22;
                            symVal = 0x3E0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 6: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++];
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 64) {
                                shift -= 8;
                                symVal = 0x40 | diffValue;
                            } else if ((diffValue -= 64) < 128) {
                                shift -= 10;
                                symVal = 0x280 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 12;
                                symVal = 0xD00 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 14;
                                symVal = 0x3A00 | diffValue;
                            } else {
                                shift -= 21;
                                symVal = 0x1E0000 | newPixelValue;
                            }
                        } else if (diffValue < 64) {
                            shift -= 8;
                            symVal = diffValue;
                        } else if ((diffValue -= 64) < 128) {
                            shift -= 10;
                            symVal = 0x200 | diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 12;
                            symVal = 0xC00 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 14;
                            symVal = 0x3800 | diffValue;
                        } else {
                            shift -= 21;
                            symVal = 0x1E0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 7: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++];
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 128) {
                                shift -= 9;
                                symVal = 0x80 | diffValue;
                            } else if ((diffValue -= 128) < 256) {
                                shift -= 11;
                                symVal = 0x500 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 13;
                                symVal = 0x1A00 | diffValue;
                            } else {
                                shift -= 20;
                                symVal = 0xE0000 | newPixelValue;
                            }
                        } else if (diffValue < 128) {
                            shift -= 9;
                            symVal = diffValue;
                        } else if ((diffValue -= 128) < 256) {
                            shift -= 11;
                            symVal = 0x400 | diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 13;
                            symVal = 0x1800 | diffValue;
                        } else {
                            shift -= 20;
                            symVal = 0xE0000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 8: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++];
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 256) {
                                shift -= 10;
                                symVal = 0x100 | diffValue;
                            } else if ((diffValue -= 256) < 512) {
                                shift -= 12;
                                symVal = 0xA00 | diffValue;
                            } else {
                                shift -= 19;
                                symVal = 0x60000 | newPixelValue;
                            }
                        } else if (diffValue < 256) {
                            shift -= 10;
                            symVal = diffValue;
                        } else if ((diffValue -= 256) < 512) {
                            shift -= 12;
                            symVal = 0x800 | diffValue;
                        } else {
                            shift -= 19;
                            symVal = 0x60000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                    break;
                }
                case 9: {
                    do {
                        prevPixelValue = newPixelValue;
                        newPixelValue = srcPtr[srcBufPtr++];
                        checksum += newPixelValue;
                        diffValue = newPixelValue - prevPixelValue;
                        --pixelBlockCount;
                        if (diffValue < 0) {
                            if ((diffValue ^= 0xFFFFFFFF) < 512) {
                                shift -= 11;
                                symVal = 0x200 | diffValue;
                            } else {
                                shift -= 18;
                                symVal = 0x20000 | newPixelValue;
                            }
                        } else if (diffValue < 512) {
                            shift -= 11;
                            symVal = diffValue;
                        } else {
                            shift -= 18;
                            symVal = 0x20000 | newPixelValue;
                        }
                        if (shift >= 0) {
                            outputword |= symVal << shift;
                            continue;
                        }
                        shifttemp = -shift;
                        dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                        outputword = symVal << (shift += 32);
                        if (--dstWordsLeft != 0) continue;
                        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                    } while (pixelBlockCount != 0);
                }
            }
            pixelBlockCount = this.fBlockLength;
            if (srcPixelsLeft >= pixelBlockCount) {
                prevPix = prevPixelValue;
                c01size = 0;
                c23size = 0;
                for (i2 = pixelBlockCount / 4; i2 > 0; --i2) {
                    if ((diffValue = prevPix - (pixelValue = srcPtr[srcBufPtr++])) < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++];
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++];
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                    pixelValue = srcPtr[srcBufPtr++];
                    diffValue = prevPix - pixelValue;
                    if (diffValue < 1024 && diffValue > -1025) {
                        c01size += this.fCodeLengthLookUp_01[table1 + diffValue];
                        c23size += this.fCodeLengthLookUp_23[table2 + diffValue];
                    } else {
                        c01size += this.fCodeLengthLookUp_01[table1 + 1023];
                        c23size += this.fCodeLengthLookUp_23[table2 + 1023];
                    }
                    prevPix = pixelValue;
                }
                srcBufPtr -= pixelBlockCount;
                table = 0;
                cNsize = c01size & 0xFFFF;
                cSize = c01size >>> 16;
                if (cNsize < cSize) {
                    table = 1;
                    cSize = cNsize;
                }
                if ((cNsize = c23size >>> 16) < cSize) {
                    table = 2;
                    cSize = cNsize;
                }
                if ((cNsize = c23size & 0xFFFF) < cSize) {
                    table = 3;
                }
                int n3 = table;
                fCompState.codecUsed[n3] = fCompState.codecUsed[n3] + 1;
            } else if (srcPixelsLeft > 0) {
                pixelBlockCount = srcPixelsLeft;
                table = this.fTableMap[0] == table ? 0 : (this.fTableMap[1] == table ? 1 : (this.fTableMap[2] == table ? 2 : 3));
            } else {
                return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
            }
            symVal = table;
            table = this.fTableMap[table];
            if ((shift -= 2) >= 0) {
                outputword |= symVal << shift;
            } else {
                shifttemp = -shift;
                dstBufPtr = TCe16Ll.encodeSwapped(outputword |= symVal >>> shifttemp, dstPtr, dstBufPtr);
                outputword = symVal << (shift += 32);
                if (--dstWordsLeft == 0) {
                    return TCe16Ll.WroteTableSymMemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, this.fBlockLength, fCompState);
                }
            }
            srcPixelsLeft -= pixelBlockCount;
        }
    }

    public static boolean WroteTableSymMemoryEnd(int[] srcSize, int[] dstSize, int newPixelValue, int shift, int outputword, int srcBufPtr, int srcPtrIdx, int dstWordsLeft, int table, int checksum, int fBlockLength, dtc_comp_state fCompState) {
        fCompState.wrotetablesym = true;
        return TCe16Ll.MemoryEnd(srcSize, dstSize, newPixelValue, shift, outputword, srcBufPtr, srcPtrIdx, dstWordsLeft, table, checksum, fBlockLength, fCompState);
    }

    public static boolean MemoryEnd(int[] srcSize, int[] dstSize, int newPixelValue, int shift, int outputword, int srcBufPtr, int srcPtrIdx, int dstWordsLeft, int table, int checksum, int fBlockLength, dtc_comp_state fCompState) {
        fCompState.pixel_value = newPixelValue;
        fCompState.shift = shift;
        fCompState.outword = outputword;
        srcSize[0] = srcBufPtr - srcPtrIdx;
        dstSize[0] = dstSize[0] - dstWordsLeft * 4;
        fCompState.tot_unc_bytes += srcSize[0];
        fCompState.tot_cmp_bytes += dstSize[0];
        fCompState.table = table;
        fCompState.pixelBlockCount = fBlockLength - fCompState.tot_unc_bytes / 2 % fBlockLength;
        fCompState.checksum = checksum;
        return true;
    }

    private boolean DecompressUsgn(byte[] srcPtr, int[] srcPtrIdx, int[] srcSize, short[] dstPtr, int[] dstPtrIdx, int[] dstSize) {
        int dstBufPtr = 0;
        int srcBufPtr = 0;
        int srcWordsLeft = 0;
        int dstPixelsLeft = 0;
        int codeWord = 0;
        int fillWord = 0;
        int pixel = 0;
        int tail = 0;
        int temp = 0;
        int pixelCnt = 0;
        int pixelCntLeft = 0;
        int table = 0;
        int srcSizeExtra = 0;
        int destSizeExtra = 0;
        boolean rstat = true;
        srcBufPtr = srcPtrIdx[0];
        dstBufPtr = dstPtrIdx[0];
        if (this.fExpandState.first_pass) {
            int[] idx = new int[]{srcBufPtr};
            this.DecodeTableSet(srcPtr, idx, srcSize);
            srcBufPtr = idx[0];
            if (this.fStreamVers > 1) {
                this.fErr = CEError.NewerStreamVer;
                return false;
            }
        }
        srcWordsLeft = srcSize[0] / 4;
        dstPixelsLeft = dstSize[0];
        destSizeExtra = dstSize[0] - dstPixelsLeft;
        srcSizeExtra = srcSize[0] - srcWordsLeft * 4;
        this.fExpandState.tot_cmp_bytes += srcWordsLeft * 4;
        this.fExpandState.tot_unc_bytes += dstPixelsLeft * 2;
        if (this.fExpandState.first_pass) {
            pixel = 0;
            tail = 0;
            codeWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
            --srcWordsLeft;
            fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr += 4);
            srcBufPtr += 4;
            --srcWordsLeft;
            pixelCnt = 0;
            table = -1;
            this.fExpandState.first_pass = false;
        } else {
            pixel = this.fExpandState.pixel_value;
            tail = this.fExpandState.tail;
            codeWord = this.fExpandState.codeWord;
            fillWord = this.fExpandState.fillWord;
            pixelCnt = this.fExpandState.pixelCnt;
            table = this.fExpandState.table;
        }
        if (this.fBlockLength == 0) {
            this.fErr = CEError.BadInputStream;
            return false;
        }
        pixelCntLeft = 0;
        do {
            if (pixelCnt == 0) {
                table = (codeWord & 0xC0000000) >>> 30;
                codeWord <<= 2;
                codeWord |= fillWord >>> 30;
                fillWord <<= 2;
                tail += 2;
                pixelCnt = this.fBlockLength;
                if (dstPixelsLeft < this.fBlockLength) {
                    pixelCntLeft = this.fBlockLength - dstPixelsLeft;
                    pixelCnt = dstPixelsLeft;
                }
                dstPixelsLeft -= pixelCnt;
                table = this.fTableMap[table];
                if (tail >= 32) {
                    fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                    srcBufPtr += 4;
                    if ((tail -= 32) != 0) {
                        codeWord |= fillWord >>> 32 - tail;
                    }
                    fillWord <<= tail;
                    if (--srcWordsLeft == 0) {
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    }
                }
            } else if (dstPixelsLeft >= pixelCnt) {
                dstPixelsLeft -= pixelCnt;
            } else {
                pixelCntLeft = pixelCnt - dstPixelsLeft;
                pixelCnt = dstPixelsLeft;
                dstPixelsLeft = 0;
            }
            switch (table) {
                default: {
                    this.fErr = CEError.BadInputStream;
                    rstat = false;
                    return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                }
                case 0: {
                    do {
                        if ((codeWord & Integer.MIN_VALUE) == 0) {
                            codeWord <<= 1;
                            codeWord |= fillWord >>> 31;
                            fillWord <<= 1;
                            ++tail;
                        } else if ((codeWord & 0x40000000) == 0) {
                            pixel = (codeWord & 0x20000000) != 0 ? --pixel : ++pixel;
                            codeWord <<= 3;
                            codeWord |= fillWord >>> 29;
                            fillWord <<= 3;
                            tail += 3;
                        } else if ((codeWord & 0x20000000) == 0) {
                            temp = (codeWord & 0x8000000) >>> 27;
                            temp += 2;
                            if ((codeWord & 0x10000000) != 0) {
                                temp = -temp;
                            }
                            pixel += temp;
                            codeWord <<= 5;
                            codeWord |= fillWord >>> 27;
                            fillWord <<= 5;
                            tail += 5;
                        } else if ((codeWord & 0x10000000) == 0) {
                            temp = (codeWord & 0x6000000) >>> 25;
                            temp += 4;
                            if ((codeWord & 0x8000000) != 0) {
                                temp = -temp;
                            }
                            pixel += temp;
                            codeWord <<= 7;
                            codeWord |= fillWord >>> 25;
                            fillWord <<= 7;
                            tail += 7;
                        } else if ((codeWord & 0x8000000) == 0) {
                            temp = (codeWord & 0x3800000) >>> 23;
                            temp += 8;
                            if ((codeWord & 0x4000000) != 0) {
                                temp = -temp;
                            }
                            pixel += temp;
                            codeWord <<= 9;
                            codeWord |= fillWord >>> 23;
                            fillWord <<= 9;
                            tail += 9;
                        } else if ((codeWord & 0x4000000) == 0) {
                            temp = (codeWord & 0x1E00000) >>> 21;
                            temp += 16;
                            if ((codeWord & 0x2000000) != 0) {
                                temp = -temp;
                            }
                            pixel += temp;
                            codeWord <<= 11;
                            codeWord |= fillWord >>> 21;
                            fillWord <<= 11;
                            tail += 11;
                        } else if ((codeWord & 0x2000000) == 0) {
                            temp = (codeWord & 0xF80000) >>> 19;
                            temp += 32;
                            if ((codeWord & 0x1000000) != 0) {
                                temp = -temp;
                            }
                            pixel += temp;
                            codeWord <<= 13;
                            codeWord |= fillWord >>> 19;
                            fillWord <<= 13;
                            tail += 13;
                        } else if ((codeWord & 0x1000000) == 0) {
                            temp = (codeWord & 0x7E0000) >>> 17;
                            temp += 64;
                            if ((codeWord & 0x800000) != 0) {
                                temp = -temp;
                            }
                            pixel += temp;
                            codeWord <<= 15;
                            codeWord |= fillWord >>> 17;
                            fillWord <<= 15;
                            tail += 15;
                        } else if ((codeWord & 0x800000) == 0) {
                            temp = (codeWord & 0x3F8000) >>> 15;
                            temp += 128;
                            if ((codeWord & 0x400000) != 0) {
                                temp = -temp;
                            }
                            pixel += temp;
                            codeWord <<= 17;
                            codeWord |= fillWord >>> 15;
                            fillWord <<= 17;
                            tail += 17;
                        } else if ((codeWord & 0x400000) == 0) {
                            temp = (codeWord & 0x1FE000) >>> 13;
                            temp += 256;
                            if ((codeWord & 0x200000) != 0) {
                                temp = -temp;
                            }
                            pixel += temp;
                            codeWord <<= 19;
                            codeWord |= fillWord >>> 13;
                            fillWord <<= 19;
                            tail += 19;
                        } else if ((codeWord & 0x200000) == 0) {
                            pixel = (codeWord & 0x1FFFE0) >>> 5;
                            codeWord <<= 27;
                            codeWord |= fillWord >>> 5;
                            fillWord <<= 27;
                            tail += 27;
                        } else {
                            return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                        }
                        dstPtr[dstBufPtr++] = (short)pixel;
                        --pixelCnt;
                        if (tail < 32) continue;
                        fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                        srcBufPtr += 4;
                        if ((tail -= 32) != 0) {
                            codeWord |= fillWord >>> 32 - tail;
                        }
                        fillWord <<= tail;
                        if (--srcWordsLeft != 0) continue;
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    } while (pixelCnt != 0);
                    break;
                }
                case 1: {
                    do {
                        if ((codeWord & Integer.MIN_VALUE) == 0) {
                            temp = (codeWord & 0x20000000) >>> 29;
                            if ((codeWord & 0x40000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 3;
                            codeWord |= fillWord >>> 29;
                            fillWord <<= 3;
                            tail += 3;
                        } else if ((codeWord & 0x40000000) == 0) {
                            temp = (codeWord & 0x18000000) >>> 27;
                            temp += 2;
                            if ((codeWord & 0x20000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 5;
                            codeWord |= fillWord >>> 27;
                            fillWord <<= 5;
                            tail += 5;
                        } else if ((codeWord & 0x20000000) == 0) {
                            temp = (codeWord & 0xE000000) >>> 25;
                            temp += 6;
                            if ((codeWord & 0x10000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 7;
                            codeWord |= fillWord >>> 25;
                            fillWord <<= 7;
                            tail += 7;
                        } else if ((codeWord & 0x10000000) == 0) {
                            temp = (codeWord & 0x7800000) >>> 23;
                            temp += 14;
                            if ((codeWord & 0x8000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 9;
                            codeWord |= fillWord >>> 23;
                            fillWord <<= 9;
                            tail += 9;
                        } else if ((codeWord & 0x8000000) == 0) {
                            temp = (codeWord & 0x3E00000) >>> 21;
                            temp += 30;
                            if ((codeWord & 0x4000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 11;
                            codeWord |= fillWord >>> 21;
                            fillWord <<= 11;
                            tail += 11;
                        } else if ((codeWord & 0x4000000) == 0) {
                            temp = (codeWord & 0x1F80000) >>> 19;
                            temp += 62;
                            if ((codeWord & 0x2000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 13;
                            codeWord |= fillWord >>> 19;
                            fillWord <<= 13;
                            tail += 13;
                        } else if ((codeWord & 0x2000000) == 0) {
                            temp = (codeWord & 0xFE0000) >>> 17;
                            temp += 126;
                            if ((codeWord & 0x1000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 15;
                            codeWord |= fillWord >>> 17;
                            fillWord <<= 15;
                            tail += 15;
                        } else if ((codeWord & 0x1000000) == 0) {
                            temp = (codeWord & 0x7F8000) >>> 15;
                            temp += 254;
                            if ((codeWord & 0x800000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 17;
                            codeWord |= fillWord >>> 15;
                            fillWord <<= 17;
                            tail += 17;
                        } else if ((codeWord & 0x800000) == 0) {
                            temp = (codeWord & 0x3FE000) >>> 13;
                            temp += 510;
                            if ((codeWord & 0x400000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 19;
                            codeWord |= fillWord >>> 13;
                            fillWord <<= 19;
                            tail += 19;
                        } else if ((codeWord & 0x400000) == 0) {
                            pixel = (codeWord & 0x3FFFC0) >>> 6;
                            codeWord <<= 26;
                            codeWord |= fillWord >>> 6;
                            fillWord <<= 26;
                            tail += 26;
                        } else {
                            return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                        }
                        dstPtr[dstBufPtr++] = (short)pixel;
                        --pixelCnt;
                        if (tail < 32) continue;
                        fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                        srcBufPtr += 4;
                        if ((tail -= 32) != 0) {
                            codeWord |= fillWord >>> 32 - tail;
                        }
                        fillWord <<= tail;
                        if (--srcWordsLeft != 0) continue;
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    } while (pixelCnt != 0);
                    break;
                }
                case 2: {
                    do {
                        if ((codeWord & Integer.MIN_VALUE) == 0) {
                            temp = (codeWord & 0x30000000) >>> 28;
                            if ((codeWord & 0x40000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 4;
                            codeWord |= fillWord >>> 28;
                            fillWord <<= 4;
                            tail += 4;
                        } else if ((codeWord & 0x40000000) == 0) {
                            temp = (codeWord & 0x1C000000) >>> 26;
                            temp += 4;
                            if ((codeWord & 0x20000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 6;
                            codeWord |= fillWord >>> 26;
                            fillWord <<= 6;
                            tail += 6;
                        } else if ((codeWord & 0x20000000) == 0) {
                            temp = (codeWord & 0xF000000) >>> 24;
                            temp += 12;
                            if ((codeWord & 0x10000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 8;
                            codeWord |= fillWord >>> 24;
                            fillWord <<= 8;
                            tail += 8;
                        } else if ((codeWord & 0x10000000) == 0) {
                            temp = (codeWord & 0x7C00000) >>> 22;
                            temp += 28;
                            if ((codeWord & 0x8000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 10;
                            codeWord |= fillWord >>> 22;
                            fillWord <<= 10;
                            tail += 10;
                        } else if ((codeWord & 0x8000000) == 0) {
                            temp = (codeWord & 0x3F00000) >>> 20;
                            temp += 60;
                            if ((codeWord & 0x4000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 12;
                            codeWord |= fillWord >>> 20;
                            fillWord <<= 12;
                            tail += 12;
                        } else if ((codeWord & 0x4000000) == 0) {
                            temp = (codeWord & 0x1FC0000) >>> 18;
                            temp += 124;
                            if ((codeWord & 0x2000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 14;
                            codeWord |= fillWord >>> 18;
                            fillWord <<= 14;
                            tail += 14;
                        } else if ((codeWord & 0x2000000) == 0) {
                            temp = (codeWord & 0xFF0000) >>> 16;
                            temp += 252;
                            if ((codeWord & 0x1000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 16;
                            codeWord |= fillWord >>> 16;
                            fillWord <<= 16;
                            tail += 16;
                        } else if ((codeWord & 0x1000000) == 0) {
                            temp = (codeWord & 0x7FC000) >>> 14;
                            temp += 508;
                            if ((codeWord & 0x800000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 18;
                            codeWord |= fillWord >>> 14;
                            fillWord <<= 18;
                            tail += 18;
                        } else if ((codeWord & 0x800000) == 0) {
                            pixel = (codeWord & 0x7FFF80) >>> 7;
                            codeWord <<= 25;
                            codeWord |= fillWord >>> 7;
                            fillWord <<= 25;
                            tail += 25;
                        } else {
                            return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                        }
                        dstPtr[dstBufPtr++] = (short)pixel;
                        --pixelCnt;
                        if (tail < 32) continue;
                        fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                        srcBufPtr += 4;
                        if ((tail -= 32) != 0) {
                            codeWord |= fillWord >>> 32 - tail;
                        }
                        fillWord <<= tail;
                        if (--srcWordsLeft != 0) continue;
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    } while (pixelCnt != 0);
                    break;
                }
                case 3: {
                    do {
                        if ((codeWord & Integer.MIN_VALUE) == 0) {
                            temp = (codeWord & 0x38000000) >>> 27;
                            if ((codeWord & 0x40000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 5;
                            codeWord |= fillWord >>> 27;
                            fillWord <<= 5;
                            tail += 5;
                        } else if ((codeWord & 0x40000000) == 0) {
                            temp = (codeWord & 0x1E000000) >>> 25;
                            temp += 8;
                            if ((codeWord & 0x20000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 7;
                            codeWord |= fillWord >>> 25;
                            fillWord <<= 7;
                            tail += 7;
                        } else if ((codeWord & 0x20000000) == 0) {
                            temp = (codeWord & 0xF800000) >>> 23;
                            temp += 24;
                            if ((codeWord & 0x10000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 9;
                            codeWord |= fillWord >>> 23;
                            fillWord <<= 9;
                            tail += 9;
                        } else if ((codeWord & 0x10000000) == 0) {
                            temp = (codeWord & 0x7E00000) >>> 21;
                            temp += 56;
                            if ((codeWord & 0x8000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 11;
                            codeWord |= fillWord >>> 21;
                            fillWord <<= 11;
                            tail += 11;
                        } else if ((codeWord & 0x8000000) == 0) {
                            temp = (codeWord & 0x3F80000) >>> 19;
                            temp += 120;
                            if ((codeWord & 0x4000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 13;
                            codeWord |= fillWord >>> 19;
                            fillWord <<= 13;
                            tail += 13;
                        } else if ((codeWord & 0x4000000) == 0) {
                            temp = (codeWord & 0x1FE0000) >>> 17;
                            temp += 248;
                            if ((codeWord & 0x2000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 15;
                            codeWord |= fillWord >>> 17;
                            fillWord <<= 15;
                            tail += 15;
                        } else if ((codeWord & 0x2000000) == 0) {
                            temp = (codeWord & 0xFF8000) >>> 15;
                            temp += 504;
                            if ((codeWord & 0x1000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 17;
                            codeWord |= fillWord >>> 15;
                            fillWord <<= 17;
                            tail += 17;
                        } else if ((codeWord & 0x1000000) == 0) {
                            pixel = (codeWord & 0xFFFF00) >>> 8;
                            codeWord <<= 24;
                            codeWord |= fillWord >>> 8;
                            fillWord <<= 24;
                            tail += 24;
                        } else {
                            return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                        }
                        dstPtr[dstBufPtr++] = (short)pixel;
                        --pixelCnt;
                        if (tail < 32) continue;
                        fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                        srcBufPtr += 4;
                        if ((tail -= 32) != 0) {
                            codeWord |= fillWord >>> 32 - tail;
                        }
                        fillWord <<= tail;
                        if (--srcWordsLeft != 0) continue;
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    } while (pixelCnt != 0);
                    break;
                }
                case 4: {
                    do {
                        if ((codeWord & Integer.MIN_VALUE) == 0) {
                            temp = (codeWord & 0x3C000000) >>> 26;
                            if ((codeWord & 0x40000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 6;
                            codeWord |= fillWord >>> 26;
                            fillWord <<= 6;
                            tail += 6;
                        } else if ((codeWord & 0x40000000) == 0) {
                            temp = (codeWord & 0x1F000000) >>> 24;
                            temp += 16;
                            if ((codeWord & 0x20000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 8;
                            codeWord |= fillWord >>> 24;
                            fillWord <<= 8;
                            tail += 8;
                        } else if ((codeWord & 0x20000000) == 0) {
                            temp = (codeWord & 0xFC00000) >>> 22;
                            temp += 48;
                            if ((codeWord & 0x10000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 10;
                            codeWord |= fillWord >>> 22;
                            fillWord <<= 10;
                            tail += 10;
                        } else if ((codeWord & 0x10000000) == 0) {
                            temp = (codeWord & 0x7F00000) >>> 20;
                            temp += 112;
                            if ((codeWord & 0x8000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 12;
                            codeWord |= fillWord >>> 20;
                            fillWord <<= 12;
                            tail += 12;
                        } else if ((codeWord & 0x8000000) == 0) {
                            temp = (codeWord & 0x3FC0000) >>> 18;
                            temp += 240;
                            if ((codeWord & 0x4000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 14;
                            codeWord |= fillWord >>> 18;
                            fillWord <<= 14;
                            tail += 14;
                        } else if ((codeWord & 0x4000000) == 0) {
                            temp = (codeWord & 0x1FF0000) >>> 16;
                            temp += 496;
                            if ((codeWord & 0x2000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 16;
                            codeWord |= fillWord >>> 16;
                            fillWord <<= 16;
                            tail += 16;
                        } else if ((codeWord & 0x2000000) == 0) {
                            pixel = (codeWord & 0x1FFFE00) >>> 9;
                            codeWord <<= 23;
                            codeWord |= fillWord >>> 9;
                            fillWord <<= 23;
                            tail += 23;
                        } else {
                            return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                        }
                        dstPtr[dstBufPtr++] = (short)pixel;
                        --pixelCnt;
                        if (tail < 32) continue;
                        fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                        srcBufPtr += 4;
                        if ((tail -= 32) != 0) {
                            codeWord |= fillWord >>> 32 - tail;
                        }
                        fillWord <<= tail;
                        if (--srcWordsLeft != 0) continue;
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    } while (pixelCnt != 0);
                    break;
                }
                case 5: {
                    do {
                        if ((codeWord & Integer.MIN_VALUE) == 0) {
                            temp = (codeWord & 0x3E000000) >>> 25;
                            if ((codeWord & 0x40000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 7;
                            codeWord |= fillWord >>> 25;
                            fillWord <<= 7;
                            tail += 7;
                        } else if ((codeWord & 0x40000000) == 0) {
                            temp = (codeWord & 0x1F800000) >>> 23;
                            temp += 32;
                            if ((codeWord & 0x20000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 9;
                            codeWord |= fillWord >>> 23;
                            fillWord <<= 9;
                            tail += 9;
                        } else if ((codeWord & 0x20000000) == 0) {
                            temp = (codeWord & 0xFE00000) >>> 21;
                            temp += 96;
                            if ((codeWord & 0x10000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 11;
                            codeWord |= fillWord >>> 21;
                            fillWord <<= 11;
                            tail += 11;
                        } else if ((codeWord & 0x10000000) == 0) {
                            temp = (codeWord & 0x7F80000) >>> 19;
                            temp += 224;
                            if ((codeWord & 0x8000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 13;
                            codeWord |= fillWord >>> 19;
                            fillWord <<= 13;
                            tail += 13;
                        } else if ((codeWord & 0x8000000) == 0) {
                            temp = (codeWord & 0x3FE0000) >>> 17;
                            temp += 480;
                            if ((codeWord & 0x4000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 15;
                            codeWord |= fillWord >>> 17;
                            fillWord <<= 15;
                            tail += 15;
                        } else if ((codeWord & 0x4000000) == 0) {
                            pixel = (codeWord & 0x3FFFC00) >>> 10;
                            codeWord <<= 22;
                            codeWord |= fillWord >>> 10;
                            fillWord <<= 22;
                            tail += 22;
                        } else {
                            return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                        }
                        dstPtr[dstBufPtr++] = (short)pixel;
                        --pixelCnt;
                        if (tail < 32) continue;
                        fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                        srcBufPtr += 4;
                        if ((tail -= 32) != 0) {
                            codeWord |= fillWord >>> 32 - tail;
                        }
                        fillWord <<= tail;
                        if (--srcWordsLeft != 0) continue;
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    } while (pixelCnt != 0);
                    break;
                }
                case 6: {
                    do {
                        if ((codeWord & Integer.MIN_VALUE) == 0) {
                            temp = (codeWord & 0x3F000000) >>> 24;
                            if ((codeWord & 0x40000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 8;
                            codeWord |= fillWord >>> 24;
                            fillWord <<= 8;
                            tail += 8;
                        } else if ((codeWord & 0x40000000) == 0) {
                            temp = (codeWord & 0x1FC00000) >>> 22;
                            temp += 64;
                            if ((codeWord & 0x20000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 10;
                            codeWord |= fillWord >>> 22;
                            fillWord <<= 10;
                            tail += 10;
                        } else if ((codeWord & 0x20000000) == 0) {
                            temp = (codeWord & 0xFF00000) >>> 20;
                            temp += 192;
                            if ((codeWord & 0x10000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 12;
                            codeWord |= fillWord >>> 20;
                            fillWord <<= 12;
                            tail += 12;
                        } else if ((codeWord & 0x10000000) == 0) {
                            temp = (codeWord & 0x7FC0000) >>> 18;
                            temp += 448;
                            if ((codeWord & 0x8000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 14;
                            codeWord |= fillWord >>> 18;
                            fillWord <<= 14;
                            tail += 14;
                        } else if ((codeWord & 0x8000000) == 0) {
                            pixel = (codeWord & 0x7FFF800) >>> 11;
                            codeWord <<= 21;
                            codeWord |= fillWord >>> 11;
                            fillWord <<= 21;
                            tail += 21;
                        } else {
                            return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                        }
                        dstPtr[dstBufPtr++] = (short)pixel;
                        --pixelCnt;
                        if (tail < 32) continue;
                        fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                        srcBufPtr += 4;
                        if ((tail -= 32) != 0) {
                            codeWord |= fillWord >>> 32 - tail;
                        }
                        fillWord <<= tail;
                        if (--srcWordsLeft != 0) continue;
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    } while (pixelCnt != 0);
                    break;
                }
                case 7: {
                    do {
                        if ((codeWord & Integer.MIN_VALUE) == 0) {
                            temp = (codeWord & 0x3F800000) >>> 23;
                            if ((codeWord & 0x40000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 9;
                            codeWord |= fillWord >>> 23;
                            fillWord <<= 9;
                            tail += 9;
                        } else if ((codeWord & 0x40000000) == 0) {
                            temp = (codeWord & 0x1FE00000) >>> 21;
                            temp += 128;
                            if ((codeWord & 0x20000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 11;
                            codeWord |= fillWord >>> 21;
                            fillWord <<= 11;
                            tail += 11;
                        } else if ((codeWord & 0x20000000) == 0) {
                            temp = (codeWord & 0xFF80000) >>> 19;
                            temp += 384;
                            if ((codeWord & 0x10000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 13;
                            codeWord |= fillWord >>> 19;
                            fillWord <<= 13;
                            tail += 13;
                        } else if ((codeWord & 0x10000000) == 0) {
                            pixel = (codeWord & 0xFFFF000) >>> 12;
                            codeWord <<= 20;
                            codeWord |= fillWord >>> 12;
                            fillWord <<= 20;
                            tail += 20;
                        } else {
                            return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                        }
                        dstPtr[dstBufPtr++] = (short)pixel;
                        --pixelCnt;
                        if (tail < 32) continue;
                        fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                        srcBufPtr += 4;
                        if ((tail -= 32) != 0) {
                            codeWord |= fillWord >>> 32 - tail;
                        }
                        fillWord <<= tail;
                        if (--srcWordsLeft != 0) continue;
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    } while (pixelCnt != 0);
                    break;
                }
                case 8: {
                    do {
                        if ((codeWord & Integer.MIN_VALUE) == 0) {
                            temp = (codeWord & 0x3FC00000) >>> 22;
                            if ((codeWord & 0x40000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 10;
                            codeWord |= fillWord >>> 22;
                            fillWord <<= 10;
                            tail += 10;
                        } else if ((codeWord & 0x40000000) == 0) {
                            temp = (codeWord & 0x1FF00000) >>> 20;
                            temp += 256;
                            if ((codeWord & 0x20000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 12;
                            codeWord |= fillWord >>> 20;
                            fillWord <<= 12;
                            tail += 12;
                        } else if ((codeWord & 0x20000000) == 0) {
                            pixel = (codeWord & 0x1FFFE000) >>> 13;
                            codeWord <<= 19;
                            codeWord |= fillWord >>> 13;
                            fillWord <<= 19;
                            tail += 19;
                        } else {
                            return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                        }
                        dstPtr[dstBufPtr++] = (short)pixel;
                        --pixelCnt;
                        if (tail < 32) continue;
                        fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                        srcBufPtr += 4;
                        if ((tail -= 32) != 0) {
                            codeWord |= fillWord >>> 32 - tail;
                        }
                        fillWord <<= tail;
                        if (--srcWordsLeft != 0) continue;
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    } while (pixelCnt != 0);
                    break;
                }
                case 9: {
                    do {
                        if ((codeWord & Integer.MIN_VALUE) == 0) {
                            temp = (codeWord & 0x3FE00000) >>> 21;
                            if ((codeWord & 0x40000000) != 0) {
                                temp ^= 0xFFFFFFFF;
                            }
                            pixel += temp;
                            codeWord <<= 11;
                            codeWord |= fillWord >>> 21;
                            fillWord <<= 11;
                            tail += 11;
                        } else if ((codeWord & 0x40000000) == 0) {
                            pixel = (codeWord & 0x3FFFC000) >>> 14;
                            codeWord <<= 18;
                            codeWord |= fillWord >>> 14;
                            fillWord <<= 18;
                            tail += 18;
                        } else {
                            return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                        }
                        dstPtr[dstBufPtr++] = (short)pixel;
                        --pixelCnt;
                        if (tail < 32) continue;
                        fillWord = TCe16Ll.SWAPLW(srcPtr, srcBufPtr);
                        srcBufPtr += 4;
                        if ((tail -= 32) != 0) {
                            codeWord |= fillWord >>> 32 - tail;
                        }
                        fillWord <<= tail;
                        if (--srcWordsLeft != 0) continue;
                        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
                    } while (pixelCnt != 0);
                }
            }
        } while (dstPixelsLeft != 0);
        return this.exitDecompress(pixel, tail, codeWord, fillWord, pixelCnt, pixelCntLeft, srcSizeExtra, srcWordsLeft, destSizeExtra, dstPixelsLeft, table, srcPtr, srcPtrIdx, srcSize, srcBufPtr, dstPtrIdx, dstSize, dstBufPtr, rstat);
    }

    private boolean exitDecompress(int pixel, int tail, int codeWord, int fillWord, int pixelCnt, int pixelCntLeft, int srcSizeExtra, int srcWordsLeft, int destSizeExtra, int dstPixelsLeft, int table, byte[] srcPtr, int[] srcPtrIdx, int[] srcSize, int srcBufPtr, int[] dstPtrIdx, int[] dstSize, int dstBufPtr, boolean rstat) {
        this.fExpandState.pixel_value = pixel;
        this.fExpandState.tail = tail;
        this.fExpandState.codeWord = codeWord;
        this.fExpandState.fillWord = fillWord;
        this.fExpandState.pixelCnt = pixelCnt + pixelCntLeft;
        this.fExpandState.table = table;
        srcSize[0] = srcSizeExtra + srcWordsLeft * 4;
        dstSize[0] = destSizeExtra + (dstPixelsLeft + pixelCnt) * 2;
        this.DecompressEnd(srcPtr, srcPtrIdx, srcSize);
        this.fExpandState.tot_cmp_bytes -= srcSize[0];
        this.fExpandState.tot_unc_bytes -= dstSize[0];
        srcPtrIdx[0] = srcBufPtr;
        dstPtrIdx[0] = dstBufPtr;
        return rstat;
    }

    public static class dtc_decomp_state {
        public int tot_unc_bytes;
        public int tot_cmp_bytes;
        public boolean first_pass;
        public int tail;
        public int codeWord;
        public int fillWord;
        public int pixel_value;
        public int pixelCnt;
        public int table;
        public int checksum;
    }

    public static class dtc_comp_state {
        public boolean isFirst;
        public int tot_unc_bytes;
        public int tot_cmp_bytes;
        public int shift;
        public int outword;
        public int pixel_value;
        public int table;
        public int[] codecUsed = new int[4];
        public int pixelBlockCount;
        public boolean wrotetablesym;
        public int nextFrameBoundary;
        public boolean endOfFrame;
        public boolean endOfBlockWritten;
        public int checksum;
    }

    public static class LkUpTblDscrpt {
        public int numberOfTableEntries;
        public int numberOfbreakPoints;
        public TblBkPt[] breakPoint = new TblBkPt[21];

        public LkUpTblDscrpt(int nEntries, int nBPoints, int[][] tblInfo) {
            this.numberOfTableEntries = nEntries;
            this.numberOfbreakPoints = nBPoints;
            for (int i2 = 0; i2 < nBPoints; ++i2) {
                this.breakPoint[i2] = new TblBkPt();
                this.breakPoint[i2].startDifference = tblInfo[i2][0];
                this.breakPoint[i2].endDifference = tblInfo[i2][1];
                this.breakPoint[i2].codeLength = (byte)tblInfo[i2][2];
            }
        }
    }

    private static class TblBkPt {
        public long startDifference;
        public long endDifference;
        public byte codeLength;

        private TblBkPt() {
        }
    }
}

