/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.geom.ParametricCurve3D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class CubicSpline
implements ParametricCurve3D {
    private static final Logger LOGGER = Logger.getLogger(CubicSpline.class.getName());
    protected List controlPoints = null;
    protected double[][][] splineCurve;
    protected double[] segLengths = null;
    protected double totalLen;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    @Override
    public List getControlPoints() {
        return this.controlPoints;
    }

    @Override
    public synchronized void setControlPoints(List points) {
        this.controlPoints = points;
        Iterator itr = this.controlPoints.iterator();
        while (itr.hasNext()) {
            if (itr.next() != null) continue;
            LOGGER.warning("Null value in control point list. The null control point has been removed.");
            itr.remove();
        }
        this.update();
        this.pcs.firePropertyChange("CURVE_PROPERTY", null, this);
    }

    private void update() {
        this.splineCurve = null;
        this.segLengths = null;
        this.totalLen = 0.0;
        int numControlPoints = this.controlPoints.size();
        int numDimensions = ((double[])this.controlPoints.get(0)).length;
        if (numControlPoints == 1) {
            return;
        }
        double[][] ctrlPntsArray = new double[numDimensions][];
        for (int j2 = 0; j2 < numDimensions; ++j2) {
            ctrlPntsArray[j2] = new double[numControlPoints];
        }
        for (int i2 = 0; i2 < numControlPoints; ++i2) {
            double[] controlPoint = (double[])this.controlPoints.get(i2);
            for (int j3 = 0; j3 < numDimensions; ++j3) {
                ctrlPntsArray[j3][i2] = controlPoint[j3];
            }
        }
        this.splineCurve = CubicSpline.calcNaturalCubics(ctrlPntsArray);
        double delta = 0.1;
        double len1 = 0.0;
        double len2 = 10000.0;
        while (len1 - len2 < 0.01) {
            len2 = len1;
            this.segLengths = CubicSpline.curveSegmentLengths(this.splineCurve, delta /= 10.0, this.segLengths);
            len1 = CubicSpline.sum(this.segLengths);
        }
        this.totalLen = len1;
    }

    private static double sum(double[] v2) {
        double ret = 0.0;
        for (int i2 = 0; i2 < v2.length; ++i2) {
            ret += v2[i2];
        }
        return ret;
    }

    @Override
    public synchronized Object clone() {
        CubicSpline copy;
        try {
            copy = (CubicSpline)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            copy = new CubicSpline();
        }
        copy.controlPoints = new ArrayList(this.controlPoints.size());
        Iterator itr = this.controlPoints.iterator();
        while (itr.hasNext()) {
            copy.controlPoints.add(((double[])itr.next()).clone());
        }
        copy.splineCurve = this.splineCurve;
        copy.segLengths = this.segLengths;
        copy.totalLen = this.totalLen;
        return copy;
    }

    @Override
    public void positionAt(double t2, double[] ret) {
        int segIndex;
        double tWithinSeg;
        if (this.controlPoints == null || this.controlPoints.size() == 0) {
            return;
        }
        if (this.controlPoints.size() == 1) {
            double[] point = (double[])this.controlPoints.get(0);
            System.arraycopy(point, 0, ret, 0, ret.length);
            return;
        }
        if (t2 == 1.0) {
            tWithinSeg = 1.0;
            segIndex = this.segLengths.length - 1;
        } else {
            double tAtSegEnd;
            double dtCurrentSeg = 0.0;
            double tAtSegStart = 0.0;
            for (segIndex = 0; segIndex < this.segLengths.length && !(t2 < (tAtSegEnd = tAtSegStart + (dtCurrentSeg = this.segLengths[segIndex] / this.totalLen))); ++segIndex) {
                tAtSegStart = tAtSegEnd;
            }
            double dtFromSegStart = t2 - tAtSegStart;
            tWithinSeg = dtFromSegStart / dtCurrentSeg;
        }
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = CubicSpline.f(this.splineCurve[i2][segIndex], tWithinSeg);
        }
    }

    @Override
    public void velocityAt(double t2, double[] ret) {
        int segIndex;
        double tWithinSeg;
        if (this.controlPoints.size() == 1) {
            Arrays.fill(ret, 0.0);
            return;
        }
        if (t2 == 1.0) {
            tWithinSeg = 1.0;
            segIndex = this.segLengths.length - 1;
        } else {
            double tAtSegEnd;
            double dtCurrentSeg = 0.0;
            double tAtSegStart = 0.0;
            for (segIndex = 0; segIndex < this.segLengths.length && !(t2 < (tAtSegEnd = tAtSegStart + (dtCurrentSeg = this.segLengths[segIndex] / this.totalLen))); ++segIndex) {
                tAtSegStart = tAtSegEnd;
            }
            double dtFromSegStart = t2 - tAtSegStart;
            tWithinSeg = dtFromSegStart / dtCurrentSeg;
        }
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = CubicSpline.df(this.splineCurve[i2][segIndex], tWithinSeg);
        }
    }

    @Override
    public double length() {
        return this.totalLen;
    }

    private static double[][][] calcNaturalCubics(double[][] v2) {
        double[][][] cubics = new double[v2.length][][];
        for (int i2 = 0; i2 < cubics.length; ++i2) {
            cubics[i2] = CubicSpline.calcNaturalCubic(v2[i2].length, v2[i2]);
        }
        return cubics;
    }

    private static double f(double[] a2, double u2) {
        return ((a2[3] * u2 + a2[2]) * u2 + a2[1]) * u2 + a2[0];
    }

    private static double df(double[] a2, double u2) {
        return 3.0 * a2[3] * u2 * u2 + 2.0 * a2[2] * u2 + a2[1];
    }

    public static double[] curveSegmentLengths(double[][][] cubics, double delta, double[] len) {
        if (len == null) {
            len = new double[cubics[0].length];
        }
        double[] p1 = new double[cubics.length];
        double[] p2 = new double[cubics.length];
        for (int seg = 0; seg < len.length; ++seg) {
            double lenSum = 0.0;
            for (int i2 = 0; i2 < cubics.length; ++i2) {
                p1[i2] = CubicSpline.f(cubics[i2][seg], 0.0);
            }
            for (double t2 = delta; t2 < 1.0; t2 += delta) {
                for (int i3 = 0; i3 < cubics.length; ++i3) {
                    p2[i3] = CubicSpline.f(cubics[i3][seg], t2);
                }
                double sum = 0.0;
                for (int i4 = 0; i4 < p2.length; ++i4) {
                    double d2 = p2[i4] - p1[i4];
                    sum += d2 * d2;
                }
                lenSum += Math.sqrt(sum);
                double[] tmpP = p2;
                p2 = p1;
                p1 = tmpP;
            }
            for (int i5 = 0; i5 < cubics.length; ++i5) {
                p2[i5] = CubicSpline.f(cubics[i5][seg], 1.0);
            }
            double sum = 0.0;
            for (int i6 = 0; i6 < p2.length; ++i6) {
                double d3 = p2[i6] - p1[i6];
                sum += d3 * d3;
            }
            len[seg] = lenSum += Math.sqrt(sum);
        }
        return len;
    }

    private static double[][] calcNaturalCubic(int n2, double[] x2) {
        int i2;
        int numCP = n2;
        double[] gamma = new double[numCP];
        double[] delta = new double[numCP];
        double[] D = new double[numCP];
        int numSeg = n2 - 1;
        gamma[0] = 0.5;
        for (i2 = 1; i2 < numSeg; ++i2) {
            gamma[i2] = 1.0 / (4.0 - gamma[i2 - 1]);
        }
        gamma[numSeg] = 1.0 / (2.0 - gamma[numSeg - 1]);
        delta[0] = 3.0 * (x2[1] - x2[0]) * gamma[0];
        for (i2 = 1; i2 < numSeg; ++i2) {
            delta[i2] = (3.0 * (x2[i2 + 1] - x2[i2 - 1]) - delta[i2 - 1]) * gamma[i2];
        }
        delta[numSeg] = (3.0 * (x2[numSeg] - x2[numSeg - 1]) - delta[numSeg - 1]) * gamma[numSeg];
        D[numSeg] = delta[numSeg];
        for (i2 = numSeg - 1; i2 >= 0; --i2) {
            D[i2] = delta[i2] - gamma[i2] * D[i2 + 1];
        }
        double[][] c2 = new double[numSeg][4];
        for (i2 = 0; i2 < numSeg; ++i2) {
            c2[i2] = new double[]{x2[i2], D[i2], 3.0 * (x2[i2 + 1] - x2[i2]) - 2.0 * D[i2] - D[i2 + 1], 2.0 * (x2[i2] - x2[i2 + 1]) + D[i2] + D[i2 + 1]};
        }
        return c2;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(prop, pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }
}

