/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnQuaternion;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.IntersectionPath;
import com.ge.med.jnu.geom.PathIterator3D;
import com.ge.med.jnu.geom.Rectangle3D;
import com.ge.med.jnu.geom.Rectangular3DShape;
import com.ge.med.jnu.geom.ShapeDescriptor;

public class Ellipsoid
extends Rectangular3DShape {
    private Rectangle3D bounds = new Rectangle3D();
    private double A = 0.0;
    private double B = 0.0;
    private double C = 0.0;
    private JnVector3d normal = new JnVector3d();
    private JnVector3d u = new JnVector3d();
    private JnVector3d v = new JnVector3d();
    private JnVector3d br = new JnVector3d();
    private JnMatrix3d rot = new JnMatrix3d();
    private JnQuaternion quat = new JnQuaternion();
    private double[] t = new double[2];

    public Ellipsoid() {
    }

    public Ellipsoid(double x2, double y2, double z2, double w2, double h2, double d2) {
        super(x2, y2, z2, w2, h2, d2);
    }

    @Override
    public void setRect(double x2, double y2, double z2, double w2, double h2, double d2) {
        super.setRect(x2, y2, z2, w2, h2, d2);
        this.C = d2 * 0.5;
        this.A = w2 * 0.5;
        this.B = h2 * 0.5;
        this.A = 1.0 / (this.A * this.A);
        this.B = 1.0 / (this.B * this.B);
        this.C = 1.0 / (this.C * this.C);
    }

    @Override
    public ShapeDescriptor getShapeDescriptor() {
        return new EllipsoidDescriptor();
    }

    @Override
    public boolean contains(double x2, double y2, double z2, double w2, double h2, double d2) {
        boolean bb = super.contains(x2, y2, z2, w2, h2, d2);
        if (!bb) {
            return false;
        }
        if (this.eval(x2, y2, z2) > 1.0) {
            return false;
        }
        if (this.eval(x2 + w2, y2, z2) > 1.0) {
            return false;
        }
        if (this.eval(x2, y2 + h2, z2) > 1.0) {
            return false;
        }
        if (this.eval(x2 + w2, y2 + h2, z2) > 1.0) {
            return false;
        }
        if (this.eval(x2, y2, z2 + d2) > 1.0) {
            return false;
        }
        if (this.eval(x2 + w2, y2, z2 + d2) > 1.0) {
            return false;
        }
        if (this.eval(x2, y2 + h2, z2 + d2) > 1.0) {
            return false;
        }
        return !(this.eval(x2 + w2, y2 + h2, z2 + d2) > 1.0);
    }

    @Override
    public boolean intersects(double x2, double y2, double z2, double w2, double h2, double d2) {
        boolean bb = super.contains(x2, y2, z2, w2, h2, d2);
        if (!bb) {
            return false;
        }
        if (this.eval(x2, y2, z2) <= 1.0) {
            return true;
        }
        if (this.eval(x2 + w2, y2, z2) <= 1.0) {
            return true;
        }
        if (this.eval(x2, y2 + h2, z2) <= 1.0) {
            return true;
        }
        if (this.eval(x2 + w2, y2 + h2, z2) <= 1.0) {
            return true;
        }
        if (this.eval(x2, y2, z2 + d2) <= 1.0) {
            return true;
        }
        if (this.eval(x2 + w2, y2, z2 + d2) <= 1.0) {
            return true;
        }
        if (this.eval(x2, y2 + h2, z2 + d2) <= 1.0) {
            return true;
        }
        return this.eval(x2 + w2, y2 + h2, z2 + d2) <= 1.0;
    }

    @Override
    public boolean contains(double x2, double y2, double z2) {
        return this.eval(x2, y2, z2) <= 1.0;
    }

    private final double eval(double xx, double yy, double zz) {
        double x2 = xx - this.getCenterX();
        double y2 = yy - this.getCenterY();
        double z2 = zz - this.getCenterZ();
        double val = x2 * x2 * this.A + y2 * y2 * this.B + z2 * z2 * this.C;
        return val;
    }

    @Override
    public PathIterator3D getIntersection(JnVector3d ul, JnVector3d ur, JnVector3d bl) {
        this.u.sub(ur, ul);
        this.v.sub(bl, ul);
        JnVector3d.cross(this.u, this.v, this.normal);
        this.normal.normalize();
        double lenU = this.u.length();
        this.br.add(bl, this.u);
        double cx = (ul.x + ur.x + bl.x + this.br.x) * 0.25;
        double cy = (ul.y + ur.y + bl.y + this.br.y) * 0.25;
        double cz = (ul.z + ur.z + bl.z + this.br.z) * 0.25;
        double dx = ul.x - cx;
        double dy = ul.y - cy;
        double dz = ul.z - cz;
        double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx /= len;
        dy /= len;
        dz /= len;
        IntersectionPath pit = new IntersectionPath();
        int npts = 61;
        double dAngle = Math.PI * 2 / (double)(npts - 1);
        int idx = 0;
        boolean skipflag = true;
        for (double angle = 0.0; angle <= Math.PI * 2 && idx < npts - 1; angle += dAngle, ++idx) {
            this.v.set(dx, dy, dz);
            this.quat.set(this.normal.x, this.normal.y, this.normal.z, angle);
            this.quat.build3dRotationMatrix(this.rot);
            this.rot.transform(this.v, this.u);
            boolean intersect = this.rayEllipsoid(cx, cy, cz, this.u, this.t);
            int segtype = 1;
            if (intersect) {
                if (skipflag) {
                    segtype = 0;
                    skipflag = false;
                }
                double scale = this.t[0];
                pit.add(segtype, cx + scale * this.u.x, cy + scale * this.u.y, cz + scale * this.u.z);
                continue;
            }
            skipflag = true;
        }
        JnVector3d firstPt = pit.get(0);
        pit.add(1, firstPt.x, firstPt.y, firstPt.z);
        return pit;
    }

    private boolean rayEllipsoid(double rx, double ry, double rz, JnVector3d u2, double[] t2) {
        double a2 = this.width / 2.0;
        double b2 = this.height / 2.0;
        double c2 = this.depth / 2.0;
        double a22 = a2 * a2;
        double b22 = b2 * b2;
        double c22 = c2 * c2;
        double dx = u2.x;
        double dy = u2.y;
        double dz = u2.z;
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double dz2 = dz * dz;
        double ex = this.getCenterX();
        double ey = this.getCenterY();
        double ez = this.getCenterZ();
        double ex2 = ex * ex;
        double ey2 = ey * ey;
        double ez2 = ez * ez;
        double rx2 = rx * rx;
        double ry2 = ry * ry;
        double rz2 = rz * rz;
        double B = -2.0 * b22 * c22 * dx * ex - 2.0 * a22 * c22 * dy * ey - 2.0 * a22 * b22 * dz * ez + 2.0 * b22 * c22 * dx * rx + 2.0 * a22 * c22 * dy * ry + 2.0 * a22 * b22 * dz * rz;
        double A2 = -b22 * c22 * dx2 - a22 * c22 * dy2 - a22 * b22 * dz2;
        double C = a22 * b22 * c22 - b22 * c22 * ex2 - a22 * c22 * ey2 - a22 * b22 * ez2 + 2.0 * b22 * c22 * ex * rx - b22 * c22 * rx2 + 2.0 * a22 * c22 * ey * ry - a22 * c22 * ry2 + 2.0 * a22 * b22 * ez * rz - a22 * b22 * rz2;
        double v2 = B * B - 4.0 * A2 * C;
        double inv = 1.0 / (2.0 * A2);
        double t1 = B * B;
        double t22 = 4.0 * A2 * C;
        if (v2 < 0.0) {
            return false;
        }
        t2[0] = (B + Math.sqrt(v2)) * inv;
        t2[1] = (B - Math.sqrt(v2)) * inv;
        return true;
    }

    public class EllipsoidDescriptor
    implements ShapeDescriptor.Parametric {
        @Override
        public void evaluate(double u2, double v2, JnVector3d result) {
            double halfD = Ellipsoid.this.depth * 0.5;
            double halfW = Ellipsoid.this.width * 0.5;
            double halfH = Ellipsoid.this.height * 0.5;
            double zH = Ellipsoid.this.z + halfD;
            double radW = 0.0;
            double radH = 0.0;
            double xx = 0.0;
            double yy = 0.0;
            double zz = 0.0;
            double theta = Math.PI * 2 * v2;
            double phi = Math.PI * 2 * u2;
            Ellipsoid.this.getBounds3D(Ellipsoid.this.bounds);
            double costheta = Math.cos(theta);
            double sintheta = Math.sin(theta);
            double cosphi = Math.cos(phi);
            double sinphi = Math.sin(phi);
            xx = Ellipsoid.this.getCenterX() + halfW * costheta * cosphi;
            yy = Ellipsoid.this.getCenterY() + halfH * sintheta * cosphi;
            zz = Ellipsoid.this.getCenterZ() + halfD * sinphi;
            result.x = xx;
            result.y = yy;
            result.z = zz;
        }
    }
}

