/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.PathIterator3D;

public class IntersectionPath
implements PathIterator3D {
    private static String[] types = new String[]{"MOVETO", "LINETO"};
    private boolean done = false;
    private int maxpts = 0;
    private int numpts = 0;
    private JnVector3d[] pts = null;
    private int[] type = null;
    private int cIdx = 0;

    public IntersectionPath() {
        this.resize(128);
        this.reset();
    }

    public final JnVector3d get(int idx) {
        return this.pts[idx];
    }

    private void resize(int newmax) {
        int i2;
        JnVector3d[] newpts = new JnVector3d[newmax];
        int[] newtype = new int[newmax];
        for (i2 = this.maxpts; i2 < newmax; ++i2) {
            newpts[i2] = new JnVector3d();
        }
        for (i2 = 0; i2 < this.maxpts; ++i2) {
            newpts[i2] = this.pts[i2];
            newtype[i2] = this.type[i2];
        }
        this.pts = newpts;
        this.type = newtype;
        this.maxpts = newmax;
    }

    public void add(int typeval, double x2, double y2, double z2) {
        this.pts[this.numpts].setLocation(x2, y2, z2);
        this.type[this.numpts] = typeval;
        ++this.numpts;
    }

    public final int getNumPts() {
        return this.numpts;
    }

    @Override
    public void reset() {
        this.done = false;
        this.cIdx = 0;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        ++this.cIdx;
        if (this.cIdx >= this.numpts) {
            this.done = true;
        }
    }

    @Override
    public int currentSegment(JnVector3d pos) {
        pos.setLocation(this.pts[this.cIdx]);
        return this.type[this.cIdx];
    }

    public String toString() {
        String str = "IntersectionPath[" + this.numpts + "]\n----------------------\n";
        for (int i2 = 0; i2 < this.numpts; ++i2) {
            str = str + types[this.type[i2]] + "   :   " + this.pts[i2] + "\n";
        }
        return str;
    }
}

