/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.jnu.geom.JnRectangularShape;

public abstract class JnRectangle2D
extends JnRectangularShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected JnRectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(JnRectangle2D r2) {
        this.setRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        int out1;
        int out2 = this.outcode(x2, y2);
        if (out2 == 0) {
            return true;
        }
        while ((out1 = this.outcode(x1, y1)) != 0) {
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                double x3 = this.getX();
                if ((out1 & 4) != 0) {
                    x3 += this.getWidth();
                }
                y1 += (x3 - x1) * (y2 - y1) / (x2 - x1);
                x1 = x3;
                continue;
            }
            double y3 = this.getY();
            if ((out1 & 8) != 0) {
                y3 += this.getHeight();
            }
            x1 += (y3 - y1) * (x2 - x1) / (y2 - y1);
            y1 = y3;
        }
        return true;
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(JnPoint2D p2) {
        return this.outcode(p2.getX(), p2.getY());
    }

    @Override
    public void setFrame(double x2, double y2, double w2, double h2) {
        this.setRect(x2, y2, w2, h2);
    }

    @Override
    public JnRectangle2D getBounds2D() {
        return (JnRectangle2D)this.clone();
    }

    @Override
    public boolean contains(double x2, double y2) {
        double x0 = this.getX();
        double y0 = this.getY();
        return x2 >= x0 && y2 >= y0 && x2 < x0 + this.getWidth() && y2 < y0 + this.getHeight();
    }

    public boolean intersects(double x2, double y2, double w2, double h2) {
        if (this.isEmpty() || w2 <= 0.0 || h2 <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return x2 + w2 > x0 && y2 + h2 > y0 && x2 < x0 + this.getWidth() && y2 < y0 + this.getHeight();
    }

    public boolean contains(double x2, double y2, double w2, double h2) {
        if (this.isEmpty() || w2 <= 0.0 || h2 <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return x2 >= x0 && y2 >= y0 && x2 + w2 <= x0 + this.getWidth() && y2 + h2 <= y0 + this.getHeight();
    }

    public void add(double newx, double newy) {
        double x1 = Math.min(this.getMinX(), newx);
        double x2 = Math.max(this.getMaxX(), newx);
        double y1 = Math.min(this.getMinY(), newy);
        double y2 = Math.max(this.getMaxY(), newy);
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(JnPoint2D pt) {
        this.add(pt.getX(), pt.getY());
    }

    public void add(JnRectangle2D r2) {
        double x1 = Math.min(this.getMinX(), r2.getMinX());
        double x2 = Math.max(this.getMaxX(), r2.getMaxX());
        double y1 = Math.min(this.getMinY(), r2.getMinY());
        double y2 = Math.max(this.getMaxY(), r2.getMaxY());
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    public int hashCode() {
        long bits = java.lang.Double.doubleToLongBits(this.getX());
        bits += java.lang.Double.doubleToLongBits(this.getY()) * 37L;
        bits += java.lang.Double.doubleToLongBits(this.getWidth()) * 43L;
        return (int)(bits += java.lang.Double.doubleToLongBits(this.getHeight()) * 47L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JnRectangle2D) {
            JnRectangle2D r2d = (JnRectangle2D)obj;
            return this.getX() == r2d.getX() && this.getY() == r2d.getY() && this.getWidth() == r2d.getWidth() && this.getHeight() == r2d.getHeight();
        }
        return false;
    }

    public static class Double
    extends JnRectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double x2, double y2, double w2, double h2) {
            this.setRect(x2, y2, w2, h2);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        @Override
        public void setRect(double x2, double y2, double w2, double h2) {
            this.x = x2;
            this.y = y2;
            this.width = w2;
            this.height = h2;
        }

        @Override
        public void setRect(JnRectangle2D r2) {
            this.x = r2.getX();
            this.y = r2.getY();
            this.width = r2.getWidth();
            this.height = r2.getHeight();
        }

        @Override
        public int outcode(double x2, double y2) {
            int out = 0;
            if (this.width <= 0.0) {
                out |= 5;
            } else if (x2 < this.x) {
                out |= 1;
            } else if (x2 > this.x + this.width) {
                out |= 4;
            }
            if (this.height <= 0.0) {
                out |= 0xA;
            } else if (y2 < this.y) {
                out |= 2;
            } else if (y2 > this.y + this.height) {
                out |= 8;
            }
            return out;
        }

        @Override
        public JnRectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }

    public static class Float
    extends JnRectangle2D {
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float x2, float y2, float w2, float h2) {
            this.setRect(x2, y2, w2, h2);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(float x2, float y2, float w2, float h2) {
            this.x = x2;
            this.y = y2;
            this.width = w2;
            this.height = h2;
        }

        @Override
        public void setRect(double x2, double y2, double w2, double h2) {
            this.x = (float)x2;
            this.y = (float)y2;
            this.width = (float)w2;
            this.height = (float)h2;
        }

        @Override
        public void setRect(JnRectangle2D r2) {
            this.x = (float)r2.getX();
            this.y = (float)r2.getY();
            this.width = (float)r2.getWidth();
            this.height = (float)r2.getHeight();
        }

        @Override
        public int outcode(double x2, double y2) {
            int out = 0;
            if (this.width <= 0.0f) {
                out |= 5;
            } else if (x2 < (double)this.x) {
                out |= 1;
            } else if (x2 > (double)this.x + (double)this.width) {
                out |= 4;
            }
            if (this.height <= 0.0f) {
                out |= 0xA;
            } else if (y2 < (double)this.y) {
                out |= 2;
            } else if (y2 > (double)this.y + (double)this.height) {
                out |= 8;
            }
            return out;
        }

        @Override
        public JnRectangle2D getBounds2D() {
            return new Float(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }

    public static class Integer
    extends JnRectangle2D {
        public int x;
        public int y;
        public int width;
        public int height;

        public Integer() {
        }

        public Integer(int x2, int y2, int w2, int h2) {
            this.setRect(x2, y2, w2, h2);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0 || this.height <= 0;
        }

        private static int clip(double v2, boolean doceil) {
            if (v2 <= -2.147483648E9) {
                return java.lang.Integer.MIN_VALUE;
            }
            if (v2 >= 2.147483647E9) {
                return java.lang.Integer.MAX_VALUE;
            }
            return (int)(doceil ? Math.ceil(v2) : Math.floor(v2));
        }

        public void setRect(int x2, int y2, int w2, int h2) {
            this.x = x2;
            this.y = y2;
            this.width = w2;
            this.height = h2;
        }

        public void setBounds(int x2, int y2, int w2, int h2) {
            this.setRect(x2, y2, w2, h2);
        }

        public void setBounds(Integer jnr2di) {
            this.setRect(jnr2di);
        }

        @Override
        public void setRect(double x2, double y2, double w2, double h2) {
            this.x = (int)x2;
            this.y = (int)y2;
            this.width = (int)w2;
            this.height = (int)h2;
        }

        @Override
        public void setRect(JnRectangle2D r2) {
            this.setRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
        }

        @Override
        public int outcode(double x2, double y2) {
            int out = 0;
            if (this.width <= 0) {
                out |= 5;
            } else if (x2 < (double)this.x) {
                out |= 1;
            } else if (x2 > (double)this.x + (double)this.width) {
                out |= 4;
            }
            if (this.height <= 0) {
                out |= 0xA;
            } else if (y2 < (double)this.y) {
                out |= 2;
            } else if (y2 > (double)this.y + (double)this.height) {
                out |= 8;
            }
            return out;
        }

        @Override
        public JnRectangle2D getBounds2D() {
            return new Integer(this.x, this.y, this.width, this.height);
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }
}

