/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import java.util.Arrays;

public abstract class PatternVolumeData {
    public int volDataOffset;
    public int dx;
    public int dy;
    public int dz;

    public static class GradientBoxShort
    extends Short {
        public GradientBoxShort(int dx, int dy, int dz) {
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.volDataOffset = 2 * dx * dy;
            this.volData = new short[dx * dy * dz + 2 * this.volDataOffset];
            this.fillPattern();
        }

        public void fillPattern() {
            int px = (int)((double)this.dx * 0.5);
            int py = (int)((double)this.dy * 0.5);
            int pz = (int)((double)this.dz * 0.5);
            int sx = this.dx - px >> 1;
            int sy = this.dy - py >> 1;
            int sz = this.dz - pz >> 1;
            Arrays.fill(this.volData, (short)0);
            int pgsize = this.dx * this.dy;
            for (int z2 = sz; z2 < sz + pz; ++z2) {
                double iz = z2 < sz ? 0.0 : (z2 > sz + pz ? 1.0 : (double)(z2 - sz) / (double)pz);
                short val = (short)(1000.0 + iz * 200.0);
                for (int y2 = sy; y2 < sy + py; ++y2) {
                    int offset = z2 * pgsize + y2 * this.dx;
                    for (int x2 = sx; x2 < sx + px; ++x2) {
                        this.volData[this.volDataOffset + offset + x2] = val;
                    }
                }
            }
        }
    }

    public static class RectPrismShort
    extends Short {
        protected double radiusScale = 0.1;
        protected short fillValue = (short)500;

        public RectPrismShort(int dx, int dy, int dz) {
            this(dx, dy, dz, 0.1, 500);
        }

        public RectPrismShort(int dx, int dy, int dz, double radiusScale, short fillValue) {
            this.radiusScale = radiusScale;
            this.fillValue = fillValue;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.volDataOffset = 2 * dx * dy;
            this.volData = new short[dx * dy * dz + 2 * this.volDataOffset];
            this.fillPattern();
        }

        public void fillPattern() {
            int index = this.volDataOffset;
            double radius = this.radiusScale * (double)this.dx;
            for (int k2 = 0; k2 < this.dz; ++k2) {
                for (int j2 = 0; j2 < this.dy; ++j2) {
                    for (int i2 = 0; i2 < this.dx; ++i2) {
                        int half = (int)((double)this.dx / 2.0);
                        this.volData[index + 0] = (double)Math.abs(i2 - half) <= radius && (double)Math.abs(j2 - half) <= radius ? this.fillValue : (short)0;
                        ++index;
                    }
                }
            }
        }
    }

    public static class CylinderShort
    extends Short {
        protected double radiusScale = 0.1;
        protected short fillValue = (short)500;

        public CylinderShort(int dx, int dy, int dz) {
            this(dx, dy, dz, 0.1, 500);
        }

        public CylinderShort(int dx, int dy, int dz, double radiusScale, short fillValue) {
            this.radiusScale = radiusScale;
            this.fillValue = fillValue;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.volDataOffset = 2 * dx * dy;
            this.volData = new short[dx * dy * dz + 2 * this.volDataOffset];
            this.fillPattern();
        }

        public void fillPattern() {
            int index = this.volDataOffset;
            double radius = this.radiusScale * (double)this.dx;
            for (int k2 = 0; k2 < this.dz; ++k2) {
                for (int j2 = 0; j2 < this.dy; ++j2) {
                    for (int i2 = 0; i2 < this.dx; ++i2) {
                        int half = (int)((double)this.dx / 2.0);
                        this.volData[index + 0] = (double)((i2 - half) * (i2 - half) + (j2 - half) * (j2 - half)) <= radius * radius ? this.fillValue : (short)0;
                        ++index;
                    }
                }
            }
        }
    }

    public static class SphereShort
    extends Short {
        protected double radiusScale = 0.25;
        protected short fillValue = (short)500;

        public SphereShort(int dx, int dy, int dz) {
            this(dx, dy, dz, 0.25, 500);
        }

        public SphereShort(int dx, int dy, int dz, double radiusScale, short fillValue) {
            this.radiusScale = radiusScale;
            this.fillValue = fillValue;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.volDataOffset = 2 * dx * dy;
            this.volData = new short[dx * dy * dz + 2 * this.volDataOffset];
            this.fillPattern();
        }

        public void fillPattern() {
            int index = this.volDataOffset;
            double radius = this.radiusScale * (double)this.dx;
            for (int k2 = 0; k2 < this.dz; ++k2) {
                for (int j2 = 0; j2 < this.dy; ++j2) {
                    for (int i2 = 0; i2 < this.dx; ++i2) {
                        int half = (int)((double)this.dx / 2.0);
                        this.volData[index + 0] = (double)((i2 - half) * (i2 - half) + (j2 - half) * (j2 - half) + (k2 - half) * (k2 - half)) <= radius * radius ? this.fillValue : (short)0;
                        ++index;
                    }
                }
            }
        }
    }

    public static abstract class Byte
    extends PatternVolumeData {
        public byte[] volData;
    }

    public static abstract class Short
    extends PatternVolumeData {
        public short[] volData;
    }
}

