/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;

public class RayBox {
    private static final byte RIGHT = 0;
    private static final byte LEFT = 1;
    private static final byte MIDDLE = 2;
    private static final int NUMDIM = 3;
    private byte[] quadrant = new byte[3];
    private double[] maxT = new double[3];
    private double[] candidatePlane = new double[3];
    private double[] minB = new double[3];
    private double[] maxB = new double[3];
    private double[] origin = new double[3];
    private double[] dir = new double[3];
    private double[] coord = new double[3];

    private void scale(double[] v2, double s2) {
        v2[0] = v2[0] * s2;
        v2[1] = v2[1] * s2;
        v2[2] = v2[2] * s2;
    }

    private void inverse(double[] arg, double[] res) {
        res[0] = 1.0 / arg[0];
        res[1] = 1.0 / arg[1];
        res[2] = 1.0 / arg[2];
    }

    private void set(double[] arg, double[] res) {
        res[0] = arg[0];
        res[1] = arg[1];
        res[2] = arg[2];
    }

    public final boolean hitScanLine(JnVector3d minBPt, JnVector3d maxBPt, JnVector3d p0, JnVector3d step, int w2, int[] t2) {
        minBPt.fillArray(this.minB);
        maxBPt.fillArray(this.maxB);
        p0.fillArray(this.origin);
        step.fillArray(this.dir);
        int hit1 = this.hitRay(this.origin, this.dir);
        if (hit1 != -1) {
            t2[0] = hit1;
            this.origin[0] = this.origin[0] + this.dir[0] * (double)w2;
            this.origin[1] = this.origin[1] + this.dir[1] * (double)w2;
            this.origin[2] = this.origin[2] + this.dir[2] * (double)w2;
            this.scale(this.dir, -1.0);
            int hit2 = this.hitRay(this.origin, this.dir);
            t2[1] = w2 - 1 - hit2;
            return true;
        }
        t2[0] = 1;
        t2[1] = 0;
        return false;
    }

    private int hitRay(double[] origin, double[] dir) {
        int i2;
        int i3;
        boolean inside = true;
        for (i3 = 0; i3 < 3; ++i3) {
            if (origin[i3] < this.minB[i3]) {
                this.quadrant[i3] = 1;
                this.candidatePlane[i3] = this.minB[i3];
                inside = false;
                continue;
            }
            if (origin[i3] > this.maxB[i3]) {
                this.quadrant[i3] = 0;
                this.candidatePlane[i3] = this.maxB[i3];
                inside = false;
                continue;
            }
            this.quadrant[i3] = 2;
        }
        if (inside) {
            return 0;
        }
        for (i3 = 0; i3 < 3; ++i3) {
            this.maxT[i3] = this.quadrant[i3] != 2 && dir[i3] != 0.0 ? (this.candidatePlane[i3] - origin[i3]) / dir[i3] : -1.0;
        }
        int whichPlane = 0;
        for (i2 = 1; i2 < 3; ++i2) {
            if (!(this.maxT[whichPlane] < this.maxT[i2])) continue;
            whichPlane = i2;
        }
        if (this.maxT[whichPlane] < 0.0) {
            return -1;
        }
        for (i2 = 0; i2 < 3; ++i2) {
            if (whichPlane != i2) {
                this.coord[i2] = origin[i2] + this.maxT[whichPlane] * dir[i2];
                if (!(this.quadrant[i2] == 0 && this.coord[i2] > this.maxB[i2]) && (this.quadrant[i2] != 1 || !(this.coord[i2] < this.minB[i2]))) continue;
                return -1;
            }
            this.coord[i2] = this.candidatePlane[i2];
        }
        return (int)(this.maxT[whichPlane] + 1.0);
    }

    public final boolean hitBoundingBox(JnVector3d minBPt, JnVector3d maxBPt, JnVector3d originPt, JnVector3d dirV, JnVector3d coordP) {
        int i2;
        int i3;
        boolean inside = true;
        minBPt.fillArray(this.minB);
        maxBPt.fillArray(this.maxB);
        originPt.fillArray(this.origin);
        dirV.fillArray(this.dir);
        for (i3 = 0; i3 < 3; ++i3) {
            if (this.origin[i3] < this.minB[i3]) {
                this.quadrant[i3] = 1;
                this.candidatePlane[i3] = this.minB[i3];
                inside = false;
                continue;
            }
            if (this.origin[i3] > this.maxB[i3]) {
                this.quadrant[i3] = 0;
                this.candidatePlane[i3] = this.maxB[i3];
                inside = false;
                continue;
            }
            this.quadrant[i3] = 2;
        }
        if (inside) {
            coordP.set(this.origin);
            return true;
        }
        for (i3 = 0; i3 < 3; ++i3) {
            this.maxT[i3] = this.quadrant[i3] != 2 && this.dir[i3] != 0.0 ? (this.candidatePlane[i3] - this.origin[i3]) / this.dir[i3] : -1.0;
        }
        int whichPlane = 0;
        for (i2 = 1; i2 < 3; ++i2) {
            if (!(this.maxT[whichPlane] < this.maxT[i2])) continue;
            whichPlane = i2;
        }
        if (this.maxT[whichPlane] < 0.0) {
            return false;
        }
        for (i2 = 0; i2 < 3; ++i2) {
            if (whichPlane != i2) {
                this.coord[i2] = this.origin[i2] + this.maxT[whichPlane] * this.dir[i2];
                if (!(this.quadrant[i2] == 0 && this.coord[i2] > this.maxB[i2]) && (this.quadrant[i2] != 1 || !(this.coord[i2] < this.minB[i2]))) continue;
                return false;
            }
            this.coord[i2] = this.candidatePlane[i2];
        }
        coordP.set(this.coord);
        return true;
    }

    public static void main(String[] args) {
        int nimgs;
        RayBox rb = new RayBox();
        int TIMES = nimgs = 10000;
        JnVector3d minB = new JnVector3d(0.0, 0.0, 0.0);
        JnVector3d maxB = new JnVector3d(4.0, 4.0, 4.0);
        JnVector3d o2 = new JnVector3d(-2.0, 2.0, 2.0);
        JnVector3d d2 = new JnVector3d(1.0, 0.0, 0.0);
        JnVector3d ipt = new JnVector3d();
        JnVector3d c2 = new JnVector3d(2.0, 2.0, 2.0);
        int[] t2 = new int[2];
        JnVector3d tmp1 = new JnVector3d();
        JnVector3d tmp2 = new JnVector3d();
        JnVector3d tmp3 = new JnVector3d();
        double theta = 0.0;
        double dtheta = Math.PI * 2 / (double)TIMES;
        long total = 0L;
        boolean intersect = true;
        for (int i2 = 0; i2 < TIMES; ++i2) {
            o2.set(10.0 * Math.sin(theta), 0.0, 10.0 * Math.cos(theta));
            d2.sub(c2, o2);
            d2.normalize();
            d2.scale(0.3);
            long t0 = System.currentTimeMillis();
            boolean hit = rb.hitScanLine(minB, maxB, o2, d2, 60, t2);
            long t1 = System.currentTimeMillis();
            total += t1 - t0;
            theta += dtheta;
            intersect = intersect && hit;
        }
        double avgTime = (double)total / (double)nimgs;
        System.out.println("AT=" + avgTime + "  [" + intersect + "]" + " [" + total + "]");
    }
}

