/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.Frustum;
import com.ge.med.jnu.geom.RayCastPlaneVolumeBase;
import java.util.Arrays;

public class RayCastPlaneVolume
extends RayCastPlaneVolumeBase {
    public static final int OUTOFHERE = 999999;
    public static final boolean DEBUG = System.getProperty("jnu.RayCastPlaneVolume.DEBUG", null) != null;
    public static final byte INSIDE = 64;
    private double ratio = 1.0;
    private double costilt = 1.0;
    private double sintilt = 1.0;
    private double[] vol_origin = new double[3];
    private double[] dir_x = new double[3];
    private double[] dir_y = new double[3];
    private double[] dir_z = new double[3];
    private double[] txzero = new double[3];
    private double[] view = new double[3];
    private double[] vox_eyept = new double[3];
    private double[] vox_zvec = new double[3];
    private Frustum frustum = new Frustum();
    private double[][] _bboxPts = new double[8][3];
    private double[] _cbbox1 = new double[3];
    private double[] _cbbox2 = new double[3];
    private int dx = 0;
    private int dy = 0;
    private int dz = 0;
    private double len_x = 0.0;
    private double len_y = 0.0;
    private double len_z = 0.0;
    private double sp_x = 0.0;
    private double sp_y = 0.0;
    private double sp_z = 0.0;
    private double z_distance = 0.0;
    private JnMatrix3d basisMat = new JnMatrix3d();
    private RayBox rb = new RayBox();
    int[] minX = null;
    int[] maxX = null;
    private JnMatrix3d inv = new JnMatrix3d();
    private JnVector3d tmpv = new JnVector3d();
    private double[] ray_origin = new double[3];
    private double[] idir = new double[3];
    private double[] t = new double[2];
    private JnMatrix4d ras2img = new JnMatrix4d();
    private JnMatrix4d modelView = new JnMatrix4d();
    private JnVector3d unit_xvec = new JnVector3d();
    private JnVector3d unit_yvec = new JnVector3d();
    private JnVector3d unit_zvec = new JnVector3d();
    private JnVector3d eye_point = new JnVector3d();
    private JnMatrix4d world2win = new JnMatrix4d();
    private JnVector3d tmp_prj2 = new JnVector3d();
    private int[] p0 = new int[2];
    private int[] p1 = new int[2];
    private double[] tmppt0 = new double[3];
    private double[] tmppt1 = new double[3];

    public RayCastPlaneVolume(double[] vol_origin, double[] dir_x, double[] dir_y, double[] dir_z, int dx, int dy, int dz) {
        this.setVolume(vol_origin, dir_x, dir_y, dir_z, dx, dy, dz);
    }

    public void setVolume(double[] vol_origin, double[] dir_x, double[] dir_y, double[] dir_z, int dx, int dy, int dz) {
        System.arraycopy(vol_origin, 0, this.vol_origin, 0, 3);
        System.arraycopy(dir_x, 0, this.dir_x, 0, 3);
        System.arraycopy(dir_y, 0, this.dir_y, 0, 3);
        System.arraycopy(dir_z, 0, this.dir_z, 0, 3);
        Arrays.fill(this.txzero, 0.0);
        double ras_spx = JnVector3d.length(dir_x);
        double ras_spy = JnVector3d.length(dir_y);
        double ras_spz = JnVector3d.length(dir_z);
        double dot = dir_y[0] * dir_z[0] + dir_y[1] * dir_z[1] + dir_y[2] * dir_z[2];
        double tilt = 1.5707963267948966 - Math.acos(dot / (ras_spy * ras_spz));
        this.ratio = ras_spz / ((ras_spx + ras_spy) * 0.5);
        this.costilt = Math.cos(tilt);
        this.sintilt = Math.sin(tilt);
        this.sp_x = this.length(dir_x);
        this.sp_y = this.length(dir_y);
        this.sp_z = this.length(dir_z);
        this.len_x = (double)dx * this.sp_x;
        this.len_y = (double)dy * this.sp_y;
        this.len_z = (double)dz * this.sp_z;
        this.z_distance = Math.max(this.len_x, this.len_y);
        this.z_distance = Math.max(this.z_distance, this.len_z);
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.basisMat.m00 = dir_x[0];
        this.basisMat.m01 = dir_y[0];
        this.basisMat.m02 = dir_z[0];
        this.basisMat.m10 = dir_x[1];
        this.basisMat.m11 = dir_y[1];
        this.basisMat.m12 = dir_z[1];
        this.basisMat.m20 = dir_x[2];
        this.basisMat.m21 = dir_y[2];
        this.basisMat.m22 = dir_z[2];
        this.basisMat.invert();
        this.calc_bbox(new int[]{0, 0, 0}, new int[]{dx - 1, dy - 1, dz - 1});
        this.from_phys_slices(this.txzero);
    }

    private void from_phys_slices(double[] v2) {
        double ratio = 1.0;
        v2[1] = v2[1] + (v2[2] - 0.5 * (double)this.dz) * 1.0 * this.sintilt;
        v2[2] = v2[2] * (1.0 * this.costilt);
    }

    public final void updateBoundingBox(int[] min, int[] max) {
        this.calc_bbox(min, max);
    }

    private static void set(double[] v2, double[] srcv, double[] dir_x, double sx, double[] dir_y, double sy, double[] dir_z, double sz) {
        v2[0] = srcv[0] + dir_x[0] * sx + dir_y[0] * sy + dir_z[0] * sz;
        v2[1] = srcv[1] + dir_x[1] * sx + dir_y[1] * sy + dir_z[1] * sz;
        v2[2] = srcv[2] + dir_x[2] * sx + dir_y[2] * sy + dir_z[2] * sz;
    }

    private static boolean between(double n2, double n0, double n1) {
        return n2 >= n0 && n2 <= n1 || n2 >= n1 && n2 <= n0;
    }

    private boolean insideVolume(double[] pt) {
        double x0 = this._bboxPts[0][0];
        double y0 = this._bboxPts[0][1];
        double z0 = this._bboxPts[0][2];
        double x1 = this._bboxPts[7][0];
        double y1 = this._bboxPts[7][1];
        double z1 = this._bboxPts[7][2];
        double x2 = pt[0];
        double y2 = pt[1];
        double z2 = pt[2];
        return RayCastPlaneVolume.between(x2, x0, x1) && RayCastPlaneVolume.between(y2, y0, y1) && RayCastPlaneVolume.between(z2, z0, z1);
    }

    private void calc_bbox(int[] min_bb, int[] max_bb) {
        int shrink = 2;
        int sx = min_bb[0] + 2;
        int sy = min_bb[1] + 2;
        int sz = min_bb[2] + 2;
        int ex = max_bb[0] - 2;
        int ey = max_bb[1] - 2;
        int ez = max_bb[2] - 2;
        RayCastPlaneVolume.set(this._bboxPts[0], this.vol_origin, this.dir_x, sx, this.dir_y, sy, this.dir_z, sz);
        RayCastPlaneVolume.set(this._bboxPts[1], this.vol_origin, this.dir_x, ex, this.dir_y, sy, this.dir_z, sz);
        RayCastPlaneVolume.set(this._bboxPts[2], this.vol_origin, this.dir_x, sx, this.dir_y, ey, this.dir_z, sz);
        RayCastPlaneVolume.set(this._bboxPts[3], this.vol_origin, this.dir_x, ex, this.dir_y, ey, this.dir_z, sz);
        RayCastPlaneVolume.set(this._bboxPts[4], this.vol_origin, this.dir_x, sx, this.dir_y, sy, this.dir_z, ez);
        RayCastPlaneVolume.set(this._bboxPts[5], this.vol_origin, this.dir_x, ex, this.dir_y, sy, this.dir_z, ez);
        RayCastPlaneVolume.set(this._bboxPts[6], this.vol_origin, this.dir_x, sx, this.dir_y, ey, this.dir_z, ez);
        RayCastPlaneVolume.set(this._bboxPts[7], this.vol_origin, this.dir_x, ex, this.dir_y, ey, this.dir_z, ez);
        this._cbbox1[0] = sx;
        this._cbbox1[1] = sy;
        this._cbbox1[2] = sz;
        this._cbbox2[0] = ex;
        this._cbbox2[1] = ey;
        this._cbbox2[2] = ez;
    }

    private double length(double[] v2) {
        return Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1] + v2[2] * v2[2]);
    }

    private static final double getViewStartCoord(int coord, int w2, int h2, double[] lookpt, double[] xstep, double[] ystep) {
        double startCoord = lookpt[coord] - (double)(w2 - 1) * 0.5 * xstep[coord] - (double)(h2 - 1) * 0.5 * ystep[coord];
        return startCoord;
    }

    public int raycastPlaneVolume(double fovX, double fovY, JnMatrix3d rot, double[] look_pt, int w2, int h2, int[] start, int[] end, double[] ul_vol, double[] xvec, double[] yvec, double[] zvec, byte[] raster) {
        double pixel_sx = fovX / (double)w2;
        double pixel_sy = fovY / (double)h2;
        double hw = (double)w2 * 0.5;
        double hh = (double)h2 * 0.5;
        if (DEBUG) {
            this.raycast_debug1(w2, h2);
        }
        if (this.minX == null || this.minX.length != h2) {
            this.minX = new int[h2];
            this.maxX = new int[h2];
        }
        Arrays.fill(this.minX, 999999);
        Arrays.fill(this.maxX, -999999);
        this.inv.invert(rot);
        this.tmpv.set(pixel_sx, 0.0, 0.0);
        this.inv.transform(this.tmpv);
        double[] xstep = new double[3];
        double[] ystep = new double[3];
        xstep[0] = this.tmpv.x;
        xstep[1] = this.tmpv.y;
        xstep[2] = this.tmpv.z;
        this.tmpv.set(0.0, pixel_sy, 0.0);
        this.inv.transform(this.tmpv);
        ystep[0] = this.tmpv.x;
        ystep[1] = this.tmpv.y;
        ystep[2] = this.tmpv.z;
        this.tmpv.set(0.0, 0.0, 1.0);
        this.inv.transform(this.tmpv);
        this.tmpv.normalize();
        double view_x = this.tmpv.x;
        double view_y = this.tmpv.y;
        double view_z = this.tmpv.z;
        this.ras2img.setIdentity();
        this.ras2img.m00 = xstep[0];
        this.ras2img.m10 = xstep[1];
        this.ras2img.m20 = xstep[2];
        this.ras2img.m01 = ystep[0];
        this.ras2img.m11 = ystep[1];
        this.ras2img.m21 = ystep[2];
        this.ras2img.m02 = this.tmpv.x;
        this.ras2img.m12 = this.tmpv.y;
        this.ras2img.m22 = this.tmpv.z;
        double ul_x = RayCastPlaneVolume.getViewStartCoord(0, w2, h2, look_pt, xstep, ystep) - view_x * this.z_distance;
        double ul_y = RayCastPlaneVolume.getViewStartCoord(1, w2, h2, look_pt, xstep, ystep) - view_y * this.z_distance;
        double ul_z = RayCastPlaneVolume.getViewStartCoord(2, w2, h2, look_pt, xstep, ystep) - view_z * this.z_distance;
        this.ras2img.m03 = ul_x;
        this.ras2img.m13 = ul_y;
        this.ras2img.m23 = ul_z;
        this.ras2img.invert();
        this.renderBox(w2, h2, this.ras2img, raster, this.minX, this.maxX);
        for (int i2 = 0; i2 < h2; ++i2) {
            int offset = i2 * w2;
            int x0 = this.minX[i2];
            int x1 = this.maxX[i2];
            if (x0 == 999999 || x1 == 999999) continue;
            x0 = x0 < 0 ? 0 : x0;
            x0 = x0 >= w2 ? w2 - 1 : x0;
            x1 = x1 < 0 ? 1 : x1;
            x1 = x1 >= w2 ? w2 - 1 : x1;
            for (int j2 = x0; j2 <= x1; ++j2) {
                raster[offset + j2] = 64;
            }
        }
        if (DEBUG) {
            this.raycast_debug2(raster);
        }
        double zstep_x = view_x * this.sp_x;
        double zstep_y = view_y * this.sp_y;
        double zstep_z = view_z * this.sp_z;
        double zstep_sz = Math.sqrt(zstep_x * zstep_x + zstep_y * zstep_y + zstep_z * zstep_z);
        double zstep_factor = 1.0;
        zvec[0] = view_x * (zstep_sz *= zstep_factor);
        zvec[1] = view_y * zstep_sz;
        zvec[2] = view_z * zstep_sz;
        yvec[0] = ystep[0];
        yvec[1] = ystep[1];
        yvec[2] = ystep[2];
        xvec[0] = xstep[0];
        xvec[1] = xstep[1];
        xvec[2] = xstep[2];
        this.tmpv.set(xvec[0], xvec[1], xvec[2]);
        this.basisMat.transform(this.tmpv);
        xvec[0] = this.tmpv.x;
        xvec[1] = this.tmpv.y;
        xvec[2] = this.tmpv.z;
        this.tmpv.set(yvec[0], yvec[1], yvec[2]);
        this.basisMat.transform(this.tmpv);
        yvec[0] = this.tmpv.x;
        yvec[1] = this.tmpv.y;
        yvec[2] = this.tmpv.z;
        this.tmpv.set(zvec[0], zvec[1], zvec[2]);
        this.basisMat.transform(this.tmpv);
        zvec[0] = this.tmpv.x;
        zvec[1] = this.tmpv.y;
        zvec[2] = this.tmpv.z;
        this.tmpv.set(ul_x - this.vol_origin[0], ul_y - this.vol_origin[1], ul_z - this.vol_origin[2]);
        this.basisMat.transform(this.tmpv);
        ul_vol[0] = this.tmpv.x - 0.5;
        ul_vol[1] = this.tmpv.y - 0.5;
        ul_vol[2] = this.tmpv.z;
        this.idir[0] = zvec[0] != 0.0 ? 1.0 / zvec[0] : 0.0;
        this.idir[1] = zvec[1] != 0.0 ? 1.0 / zvec[1] : 0.0;
        this.idir[2] = zvec[2] != 0.0 ? 1.0 / zvec[2] : 0.0;
        int sum = 0;
        int nc_sum = 0;
        double row_x = ul_vol[0];
        double row_y = ul_vol[1];
        double row_z = ul_vol[2];
        for (int y2 = 0; y2 < h2; ++y2) {
            int offset = y2 * w2;
            double ex = row_x;
            double ey = row_y;
            double ez = row_z;
            for (int x2 = 0; x2 < w2; ++x2) {
                this.ray_origin[0] = ex;
                this.ray_origin[1] = ey;
                this.ray_origin[2] = ez;
                if (raster[offset + x2] != 0) {
                    ++nc_sum;
                    int n_int = this.rb.hitBoundingBox(this._cbbox1, this._cbbox2, this.ray_origin, zvec, this.idir, this.t);
                    if (n_int == 2) {
                        double t1 = this.t[1];
                        double t0 = this.t[0];
                        if (t1 < t0) {
                            t0 = t1;
                            t1 = this.t[0];
                        }
                        int min_t = (int)(t0 + 1.0);
                        int max_t = (int)t1;
                        start[offset + x2] = min_t;
                        end[offset + x2] = max_t;
                        ++sum;
                    } else {
                        start[offset + x2] = -1;
                        end[offset + x2] = -2;
                    }
                }
                ex += xvec[0];
                ey += xvec[1];
                ez += xvec[2];
            }
            row_x += yvec[0];
            row_y += yvec[1];
            row_z += yvec[2];
        }
        return sum;
    }

    public final int raycastPerspectivePlaneVolume(double viewfovX, double viewfovY, JnMatrix3d rot, double[] eye_pt, double[] look_pt, int w2, int h2, int[] start, int[] end, double[] ul_vol, double[] xvec, double[] yvec, double[] zvec, float[] directions, byte[] raster) {
        JnVector3d.sub(look_pt, eye_pt, this.view);
        double focal_len = JnVector3d.length(this.view);
        double proj_len = focal_len * 0.15;
        double fovX = viewfovX * proj_len / focal_len;
        double fovY = viewfovY * proj_len / focal_len;
        double pixel_sx = fovX / (double)w2;
        double pixel_sy = fovY / (double)h2;
        double hw = (double)w2 * 0.5;
        double hh = (double)h2 * 0.5;
        if (DEBUG) {
            this.raycast_debug1(w2, h2);
        }
        if (this.minX == null || this.minX.length != h2) {
            this.minX = new int[h2];
            this.maxX = new int[h2];
        }
        Arrays.fill(this.minX, 999999);
        Arrays.fill(this.maxX, -999999);
        this.inv.invert(rot);
        this.tmpv.set(pixel_sx, 0.0, 0.0);
        this.inv.transform(this.tmpv);
        double xstep_x = this.tmpv.x;
        double xstep_y = this.tmpv.y;
        double xstep_z = this.tmpv.z;
        this.tmpv.set(0.0, pixel_sy, 0.0);
        this.inv.transform(this.tmpv);
        double ystep_x = this.tmpv.x;
        double ystep_y = this.tmpv.y;
        double ystep_z = this.tmpv.z;
        this.tmpv.set(0.0, 0.0, 1.0);
        this.inv.transform(this.tmpv);
        this.tmpv.normalize();
        double view_x = this.tmpv.x;
        double view_y = this.tmpv.y;
        double view_z = this.tmpv.z;
        this.ras2img.setIdentity();
        this.ras2img.m00 = xstep_x;
        this.ras2img.m10 = xstep_y;
        this.ras2img.m20 = xstep_z;
        this.ras2img.m01 = ystep_x;
        this.ras2img.m11 = ystep_y;
        this.ras2img.m21 = ystep_z;
        this.ras2img.m02 = this.tmpv.x;
        this.ras2img.m12 = this.tmpv.y;
        this.ras2img.m22 = this.tmpv.z;
        double ul_x = look_pt[0] - xstep_x * hw - ystep_x * hh - view_x * (focal_len - proj_len);
        double ul_y = look_pt[1] - xstep_y * hw - ystep_y * hh - view_y * (focal_len - proj_len);
        double ul_z = look_pt[2] - xstep_z * hw - ystep_z * hh - view_z * (focal_len - proj_len);
        this.ras2img.m03 = ul_x;
        this.ras2img.m13 = ul_y;
        this.ras2img.m23 = ul_z;
        this.ras2img.invert();
        if (this.insideVolume(eye_pt) && this.insideVolume(look_pt)) {
            Arrays.fill(raster, (byte)64);
        } else {
            this.unit_xvec.set(xstep_x, xstep_y, xstep_z);
            this.unit_xvec.normalize();
            this.unit_yvec.set(ystep_x, ystep_y, ystep_z);
            this.unit_yvec.normalize();
            this.unit_zvec.set(view_x, view_y, view_z);
            this.unit_zvec.normalize();
            this.eye_point.set(eye_pt);
            this.modelView.setColumns(this.unit_xvec, this.unit_yvec, this.unit_zvec, this.eye_point);
            this.modelView.invert();
            this.world2win.set(pixel_sx, 0.0, 0.0, -fovX * 0.5, 0.0, pixel_sy, 0.0, -fovY * 0.5, 0.0, 0.0, 1.0, proj_len, 0.0, 0.0, 0.0, 1.0);
            this.world2win.invert();
            this.renderPerspectiveBox(w2, h2, raster, this.minX, this.maxX, proj_len);
            for (int i2 = 0; i2 < h2; ++i2) {
                int offset = i2 * w2;
                int x0 = this.minX[i2];
                int x1 = this.maxX[i2];
                if (x0 == 999999 || x1 == 999999) continue;
                x0 = x0 < 0 ? 0 : x0;
                x0 = x0 >= w2 ? w2 - 1 : x0;
                x1 = x1 < 0 ? 1 : x1;
                x1 = x1 >= w2 ? w2 - 1 : x1;
                for (int j2 = x0; j2 <= x1; ++j2) {
                    raster[offset + j2] = 64;
                }
            }
        }
        if (DEBUG) {
            this.raycast_debug2(raster);
        }
        double zstep_x = view_x * this.sp_x;
        double zstep_y = view_y * this.sp_y;
        double zstep_z = view_z * this.sp_z;
        double zstep_factor = 0.9;
        double zstep_sz = Math.sqrt(zstep_x * zstep_x + zstep_y * zstep_y + zstep_z * zstep_z) * 0.9;
        zvec[0] = view_x * zstep_sz;
        zvec[1] = view_y * zstep_sz;
        zvec[2] = view_z * zstep_sz;
        yvec[0] = ystep_x;
        yvec[1] = ystep_y;
        yvec[2] = ystep_z;
        xvec[0] = xstep_x;
        xvec[1] = xstep_y;
        xvec[2] = xstep_z;
        this.tmpv.set(xvec[0], xvec[1], xvec[2]);
        this.basisMat.transform(this.tmpv);
        this.tmpv.get(xvec);
        this.tmpv.set(yvec[0], yvec[1], yvec[2]);
        this.basisMat.transform(this.tmpv);
        this.tmpv.get(yvec);
        this.tmpv.set(zvec[0], zvec[1], zvec[2]);
        this.basisMat.transform(this.tmpv);
        this.tmpv.get(zvec);
        this.tmpv.set(ul_x - this.vol_origin[0], ul_y - this.vol_origin[1], ul_z - this.vol_origin[2]);
        this.basisMat.transform(this.tmpv);
        this.tmpv.get(ul_vol);
        this.tmpv.set(eye_pt[0] - this.vol_origin[0], eye_pt[1] - this.vol_origin[1], eye_pt[2] - this.vol_origin[2]);
        this.basisMat.transform(this.tmpv);
        this.tmpv.get(this.vox_eyept);
        this.frustum.genFrustumView(w2, h2, ul_vol, this.vox_eyept, xvec, yvec, zvec, directions);
        int sum = 0;
        double row_x = ul_vol[0];
        double row_y = ul_vol[1];
        double row_z = ul_vol[2];
        for (int y2 = 0; y2 < h2; ++y2) {
            int diroffset = y2 * w2 * 3;
            int offset = y2 * w2;
            double ex = row_x;
            double ey = row_y;
            double ez = row_z;
            int xx = 0;
            int x2 = 0;
            while (x2 < w2) {
                this.ray_origin[0] = ex;
                this.ray_origin[1] = ey;
                this.ray_origin[2] = ez;
                if (raster[offset + x2] != 0) {
                    int dir_idx = diroffset + xx;
                    this.vox_zvec[0] = directions[dir_idx];
                    this.vox_zvec[1] = directions[dir_idx + 1];
                    this.vox_zvec[2] = directions[dir_idx + 2];
                    this.idir[0] = this.vox_zvec[0] != 0.0 ? 1.0 / this.vox_zvec[0] : 0.0;
                    this.idir[1] = this.vox_zvec[1] != 0.0 ? 1.0 / this.vox_zvec[1] : 0.0;
                    this.idir[2] = this.vox_zvec[2] != 0.0 ? 1.0 / this.vox_zvec[2] : 0.0;
                    int n_int = this.rb.hitBoundingBox(this._cbbox1, this._cbbox2, this.ray_origin, this.vox_zvec, this.idir, this.t);
                    if (n_int == 2) {
                        double t1 = this.t[1];
                        double t0 = this.t[0];
                        if (t1 < t0) {
                            t0 = t1;
                            t1 = this.t[0];
                        }
                        if (t0 < 0.0) {
                            t0 = 0.0;
                        }
                        if (t1 < 0.0) {
                            t1 = 0.0;
                        }
                        int min_t = (int)(t0 + 1.0);
                        int max_t = (int)t1;
                        start[offset + x2] = min_t;
                        end[offset + x2] = max_t;
                        ++sum;
                    } else {
                        start[offset + x2] = -1;
                        end[offset + x2] = -2;
                    }
                }
                ex += xvec[0];
                ey += xvec[1];
                ez += xvec[2];
                ++x2;
                xx += 3;
            }
            row_x += yvec[0];
            row_y += yvec[1];
            row_z += yvec[2];
        }
        return sum;
    }

    private void project2(double[] pt, int[] r2, JnMatrix4d projtx) {
        this.tmp_prj2.set(pt);
        projtx.transform(this.tmp_prj2);
        r2[0] = (int)this.tmp_prj2.x;
        r2[1] = (int)this.tmp_prj2.y;
    }

    private void renderBox(int w2, int h2, JnMatrix4d ras2img, byte[] raster, int[] minX, int[] maxX) {
        Arrays.fill(raster, (byte)0);
        double[][] b2 = this._bboxPts;
        this.project2(b2[0], this.p0, ras2img);
        this.project2(b2[1], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[0], this.p0, ras2img);
        this.project2(b2[2], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[2], this.p0, ras2img);
        this.project2(b2[3], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[1], this.p0, ras2img);
        this.project2(b2[3], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[4], this.p0, ras2img);
        this.project2(b2[5], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[4], this.p0, ras2img);
        this.project2(b2[6], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[6], this.p0, ras2img);
        this.project2(b2[7], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[5], this.p0, ras2img);
        this.project2(b2[7], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[0], this.p0, ras2img);
        this.project2(b2[4], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[1], this.p0, ras2img);
        this.project2(b2[5], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[2], this.p0, ras2img);
        this.project2(b2[6], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        this.project2(b2[3], this.p0, ras2img);
        this.project2(b2[7], this.p1, ras2img);
        RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
    }

    private boolean clipLine(double proj_len, double[][] b2, int idx0, int idx1, int[] p0, int[] p1) {
        System.arraycopy(b2[idx0], 0, this.tmppt0, 0, 3);
        System.arraycopy(b2[idx1], 0, this.tmppt1, 0, 3);
        this.modelView.transform(this.tmppt0);
        this.modelView.transform(this.tmppt1);
        if (this.tmppt0[2] < proj_len && this.tmppt1[2] < proj_len) {
            this.tmppt0[2] = this.tmppt1[2] = proj_len;
        }
        if (this.tmppt1[2] < this.tmppt0[2]) {
            this.tmp_prj2.set(this.tmppt1);
            System.arraycopy(this.tmppt0, 0, this.tmppt1, 0, 3);
            this.tmp_prj2.get(this.tmppt0);
        }
        if (this.tmppt0[2] < proj_len) {
            double t2 = (proj_len - this.tmppt0[2]) / (this.tmppt1[2] - this.tmppt0[2]);
            this.tmppt0[0] = this.tmppt0[0] + t2 * (this.tmppt1[0] - this.tmppt0[0]);
            this.tmppt0[1] = this.tmppt0[1] + t2 * (this.tmppt1[1] - this.tmppt0[1]);
            this.tmppt0[2] = proj_len;
        }
        double x0 = this.tmppt0[0];
        double y0 = this.tmppt0[1];
        double z0 = this.tmppt0[2];
        double x1 = this.tmppt1[0];
        double y1 = this.tmppt1[1];
        double z1 = this.tmppt1[2];
        double xx0 = proj_len * x0 / z0;
        double yy0 = proj_len * y0 / z0;
        this.tmp_prj2.set(xx0, yy0, proj_len);
        this.world2win.transform(this.tmp_prj2);
        p0[0] = (int)this.tmp_prj2.x;
        p0[1] = (int)this.tmp_prj2.y;
        double xx1 = proj_len * x1 / z1;
        double yy1 = proj_len * y1 / z1;
        this.tmp_prj2.set(xx1, yy1, proj_len);
        this.world2win.transform(this.tmp_prj2);
        p1[0] = (int)this.tmp_prj2.x;
        p1[1] = (int)this.tmp_prj2.y;
        return true;
    }

    private void renderPerspectiveBox(int w2, int h2, byte[] raster, int[] minX, int[] maxX, double proj_len) {
        Arrays.fill(raster, (byte)0);
        double[][] b2 = this._bboxPts;
        if (this.clipLine(proj_len, b2, 0, 1, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 0, 2, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 2, 3, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 1, 3, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 4, 5, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 4, 6, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 6, 7, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 5, 7, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 0, 4, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 1, 5, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 2, 6, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
        if (this.clipLine(proj_len, b2, 3, 7, this.p0, this.p1)) {
            RayCastPlaneVolume.lineBresenham(this.p0[0], this.p0[1], this.p1[0], this.p1[1], raster, w2, h2, minX, maxX);
        }
    }

    private static void lineBresenham(int x0, int y0, int x1, int y1, byte[] raster, int w2, int h2, int[] minX, int[] maxX) {
        int fraction;
        int stepx;
        int stepy;
        int dy = y1 - y0;
        int dx = x1 - x0;
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        dy <<= 1;
        dx <<= 1;
        if (y0 >= 0 && y0 < h2) {
            if (x0 < minX[y0]) {
                minX[y0] = x0;
            }
            if (x0 > maxX[y0]) {
                maxX[y0] = x0;
            }
            if (x0 >= 0 && x0 < w2) {
                int idx1 = w2 * y0 + x0;
                raster[idx1] = -1;
            }
        }
        if (dx > dy) {
            fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                x0 += stepx;
                fraction += dy;
                if (y0 < 0 || y0 >= h2) continue;
                if (x0 < minX[y0]) {
                    minX[y0] = x0;
                }
                if (x0 > maxX[y0]) {
                    maxX[y0] = x0;
                }
                if (x0 < 0 || x0 >= w2) continue;
                int idx = w2 * y0 + x0;
                raster[idx] = -1;
            }
        } else {
            fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                if ((y0 += stepy) < 0 || y0 >= h2) continue;
                if (x0 < minX[y0]) {
                    minX[y0] = x0;
                }
                if (x0 > maxX[y0]) {
                    maxX[y0] = x0;
                }
                if (x0 < 0 || x0 >= w2) continue;
                int idx = w2 * y0 + x0;
                raster[idx] = -1;
            }
        }
    }

    private static short[] volume(int dx, int dy, int dz) {
        short[] v2 = new short[dx * dy * dz];
        int hz = dz >> 1;
        for (int y2 = 0; y2 < dy; ++y2) {
            for (int x2 = 0; x2 < dx; ++x2) {
                double rx = (double)x2 - (double)dx * 0.5;
                double ry = (double)y2 - (double)dy * 0.5;
                double rad = Math.sqrt(rx * rx + ry * ry);
                v2[hz * dx * dy + y2 * dx + x2] = rad < (double)dx * 0.45 ? 30000 : (short)(20000.0 * Math.random());
            }
        }
        return v2;
    }

    private static class RayBox {
        public static final double FORGET_ABOUT_IT = -99999.0;
        private static final int NUMDIM = 3;
        private double[] Tmin = new double[3];
        private double[] Tmax = new double[3];
        private boolean[] hit = new boolean[3];

        private RayBox() {
        }

        public final int hitBoundingBox(double[] minB, double[] maxB, double[] origin, double[] dir, double[] idir, double[] t2) {
            double x2;
            double z2;
            double tc;
            for (int i2 = 0; i2 < 3; ++i2) {
                if (dir[i2] != 0.0) {
                    this.Tmin[i2] = (minB[i2] - origin[i2]) * idir[i2];
                    this.Tmax[i2] = (maxB[i2] - origin[i2]) * idir[i2];
                    this.hit[i2] = true;
                    continue;
                }
                this.hit[i2] = false;
            }
            int n_intersections = 0;
            if (this.hit[0]) {
                tc = this.Tmin[0];
                double y2 = origin[1] + dir[1] * tc;
                z2 = origin[2] + dir[2] * tc;
                if (y2 >= minB[1] && y2 <= maxB[1] && z2 >= minB[2] && z2 <= maxB[2]) {
                    t2[n_intersections] = tc;
                    ++n_intersections;
                }
                tc = this.Tmax[0];
                y2 = origin[1] + dir[1] * tc;
                z2 = origin[2] + dir[2] * tc;
                if (y2 >= minB[1] && y2 <= maxB[1] && z2 >= minB[2] && z2 <= maxB[2]) {
                    t2[n_intersections] = tc;
                    if (++n_intersections == 2) {
                        return 2;
                    }
                }
            }
            if (this.hit[1]) {
                tc = this.Tmin[1];
                x2 = origin[0] + dir[0] * tc;
                z2 = origin[2] + dir[2] * tc;
                if (x2 >= minB[0] && x2 <= maxB[0] && z2 >= minB[2] && z2 <= maxB[2]) {
                    t2[n_intersections] = tc;
                    if (++n_intersections == 2) {
                        return 2;
                    }
                }
                tc = this.Tmax[1];
                x2 = origin[0] + dir[0] * tc;
                z2 = origin[2] + dir[2] * tc;
                if (x2 >= minB[0] && x2 <= maxB[0] && z2 >= minB[2] && z2 <= maxB[2]) {
                    t2[n_intersections] = tc;
                    if (++n_intersections == 2) {
                        return 2;
                    }
                }
            }
            if (this.hit[2]) {
                tc = this.Tmin[2];
                x2 = origin[0] + dir[0] * tc;
                double y3 = origin[1] + dir[1] * tc;
                if (x2 >= minB[0] && x2 <= maxB[0] && y3 >= minB[1] && y3 <= maxB[1]) {
                    t2[n_intersections] = tc;
                    if (++n_intersections == 2) {
                        return 2;
                    }
                }
                tc = this.Tmax[2];
                x2 = origin[0] + dir[0] * tc;
                y3 = origin[1] + dir[1] * tc;
                if (x2 >= minB[0] && x2 <= maxB[0] && y3 >= minB[1] && y3 <= maxB[1]) {
                    t2[n_intersections] = tc;
                    if (++n_intersections == 2) {
                        return 2;
                    }
                }
            }
            return n_intersections;
        }
    }
}

