/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RaysBlocks {
    public static final int SHIFT = 16;
    public static final int SCALE = 65536;
    private static final int[][] OTHERDIM = new int[][]{{1, 2}, {0, 2}, {0, 1}};
    public static final double EPSILON = 1.0E-4;
    private int dx;
    private int dy;
    private int dz;
    private int blocksX;
    private int blocksY;
    private int blocksZ;
    private VolumeBlock[] blocks = null;
    private int[] debugData = null;
    private JFrame debugFrame = null;
    private boolean debug = false;

    public void setVolume(int dx, int dy, int dz, int blocksX, int blocksY, int blocksZ) {
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.blocksX = blocksX;
        this.blocksY = blocksY;
        this.blocksZ = blocksZ;
        int nblocks = blocksX * blocksY * blocksZ;
        this.blocks = new VolumeBlock[nblocks];
        int bsizeX = (int)Math.ceil((double)dx / (double)blocksX);
        int bsizeY = (int)Math.ceil((double)dy / (double)blocksY);
        int bsizeZ = (int)Math.ceil((double)dz / (double)blocksZ);
        int i2 = 0;
        for (int z2 = 0; z2 < blocksZ; ++z2) {
            for (int y2 = 0; y2 < blocksY; ++y2) {
                for (int x2 = 0; x2 < blocksX; ++x2) {
                    int x0 = Math.min(x2 * bsizeX, dx - 1);
                    int y0 = Math.min(y2 * bsizeY, dy - 1);
                    int z0 = Math.min(z2 * bsizeZ, dz - 1);
                    int x1 = Math.min((x2 + 1) * bsizeX - 1, dx - 1);
                    int y1 = Math.min((y2 + 1) * bsizeY - 1, dy - 1);
                    int z1 = Math.min((z2 + 1) * bsizeZ - 1, dz - 1);
                    this.blocks[i2] = new VolumeBlock(x0, y0, z0, x1, y1, z1);
                    System.err.println("[" + x2 + "," + y2 + "," + z2 + "] : " + this.blocks[i2]);
                    ++i2;
                }
            }
        }
    }

    public final void rb_intersect(Context ctxt, int width, int height, double[] lookpt, double[] dirX, double[] dirY, double[] dirZ, int x0, int y0, int x1, int y1, int xskip, int yskip) {
        double[] res = new double[this.blocks.length * 2];
        int[] path = new int[this.blocks.length];
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!(Math.abs(dirZ[i2]) > 1.0E-4)) continue;
            ctxt.idir[i2] = 1.0 / dirZ[i2];
        }
        if (this.debug) {
            BufferedImage debugImg = new BufferedImage(width, height, 1);
            this.debugData = ((DataBufferInt)debugImg.getRaster().getDataBuffer()).getData();
            Arrays.fill(this.debugData, -16777216);
            if (this.debugFrame == null) {
                this.debugFrame = ImageDisplay.display(debugImg);
            }
        }
        for (int y2 = y0; y2 <= y1; y2 += yskip) {
            JnVector3d.scaleAdd(lookpt, dirY, (double)y2 - (double)height * 0.5, ctxt.rowpoint);
            for (int x2 = x0; x2 <= x1; x2 += xskip) {
                JnVector3d.scaleAdd(ctxt.rowpoint, dirX, (double)x2 - (double)width * 0.5, ctxt.currpoint);
                this.rb_intersect(ctxt, ctxt.currpoint, dirZ, res, path);
                if (!this.debug) continue;
                boolean hitvol = false;
                for (int i3 = 0; i3 < this.blocks.length && path[i3] != -1; ++i3) {
                    if (path[i3] == -1) continue;
                    hitvol = true;
                }
                if (!hitvol) continue;
                this.debugData[y2 * width + x2] = -16711936;
            }
        }
        if (this.debug) {
            this.debugFrame.repaint();
        }
    }

    public final int rb_intersect(Context ctxt, double[] origin, double[] dirZ, double[] result, int[] path) {
        return this.rb_intersect(ctxt, origin, dirZ, result, path, false);
    }

    public final int rb_intersect(Context ctxt, double[] origin, double[] dirZ, double[] result, int[] path, boolean debugflg) {
        double[] dir = dirZ;
        boolean[] hit = ctxt.hit;
        double[][] Tminmax = ctxt.Tminmax;
        double[] tres = ctxt.tres;
        Arrays.fill(result, -32768.0);
        Arrays.fill(path, -1);
        int visited_blocks = 0;
        for (int block = 0; block < this.blocks.length; ++block) {
            int blockidx = block << 1;
            int[] minB = this.blocks[block].pt0;
            int[] maxB = this.blocks[block].pt1;
            Arrays.fill(hit, false);
            for (int i2 = 0; i2 < 3; ++i2) {
                if (!(Math.abs(dir[i2]) > 1.0E-4)) continue;
                Tminmax[0][i2] = ((double)minB[i2] - origin[i2]) * ctxt.idir[i2];
                Tminmax[1][i2] = ((double)maxB[i2] - origin[i2]) * ctxt.idir[i2];
                hit[i2] = true;
                if (!debugflg || !hit[i2]) continue;
                System.err.println("!! " + Tminmax[0][i2] + " " + Tminmax[1][i2] + " " + ctxt.idir[i2]);
            }
            tres[1] = Double.MAX_VALUE;
            tres[0] = Double.MAX_VALUE;
            int nhits = 0;
            block2: for (int i3 = 0; i3 < 3 && nhits < 2; ++i3) {
                if (!hit[i3]) continue;
                for (int j2 = 0; j2 < 2; ++j2) {
                    int idx_dim0 = OTHERDIM[i3][0];
                    int idx_dim1 = OTHERDIM[i3][1];
                    double tc = Tminmax[j2][i3];
                    double pt0 = origin[idx_dim0] + dir[idx_dim0] * tc;
                    double pt1 = origin[idx_dim1] + dir[idx_dim1] * tc;
                    if (!(pt0 >= (double)minB[idx_dim0]) || !(pt0 <= (double)maxB[idx_dim0]) || !(pt1 >= (double)minB[idx_dim1]) || !(pt1 <= (double)maxB[idx_dim1])) continue;
                    tres[nhits++] = tc;
                    if (nhits != 2) continue;
                    ++visited_blocks;
                    if (!(tres[0] > tres[1])) continue block2;
                    double tmp = tres[0];
                    tres[0] = tres[1];
                    tres[1] = tmp;
                    continue block2;
                }
            }
            result[blockidx] = tres[0];
            result[blockidx + 1] = tres[1];
        }
        if (visited_blocks > 0) {
            System.arraycopy(result, 0, ctxt.temp, 0, this.blocks.length << 1);
            for (int i4 = 0; i4 < visited_blocks; ++i4) {
                double min = 99999.0;
                int pos = -1;
                for (int j3 = 0; j3 < ctxt.temp.length; j3 += 2) {
                    if (!(ctxt.temp[j3] < min)) continue;
                    pos = j3;
                    min = ctxt.temp[j3];
                }
                ctxt.temp[pos] = Double.MAX_VALUE;
                path[i4] = pos >> 1;
            }
        }
        return visited_blocks;
    }

    private void vprint(String title, int[] v2) {
        System.err.println(title + " : [" + v2[0] + "," + v2[1] + "," + v2[2] + "]");
    }

    private void vprint(String title, boolean[] v2) {
        System.err.println(title + " : [" + v2[0] + "," + v2[1] + "," + v2[2] + "]");
    }

    public static void main(String[] args) {
        int nBlocks = 8;
        int BLOCKDIM = 2;
        RaysBlocks rbi = new RaysBlocks();
        Context ctxt = new Context(8);
        double[] dirX = new double[]{1.0, 0.0, 0.0};
        double[] dirY = new double[]{0.0, 0.0, 0.4687};
        double[] dirZ = new double[]{0.0, 1.0, 0.0};
        double[] lookpt = new double[]{256.0, 256.0, 103.5};
        int DIM = 600;
        rbi.setVolume(512, 512, 207, 2, 2, 2);
        long total = 0L;
        int iterations = 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            long t0 = System.currentTimeMillis();
            rbi.rb_intersect(ctxt, 600, 600, lookpt, dirX, dirY, dirZ, 0, 0, 599, 599, 1, 1);
            long t1 = System.currentTimeMillis();
            if (i2 <= 0) continue;
            total += t1 - t0;
        }
        double avg = (double)total / 15.0;
        System.err.println("AVG TIME: " + avg);
    }

    private static class ImageDisplay
    extends JPanel {
        private BufferedImage img = null;

        public ImageDisplay(BufferedImage img) {
            this.img = img;
        }

        @Override
        public void paintComponent(Graphics g2) {
            Graphics2D g22 = (Graphics2D)g2;
            g22.drawRenderedImage(this.img, null);
        }

        public static JFrame display(BufferedImage img) {
            ImageDisplay id = new ImageDisplay(img);
            JFrame jf = new JFrame("RaysBlocks Debug");
            id.setPreferredSize(new Dimension(img.getWidth(), img.getHeight()));
            jf.setContentPane(id);
            jf.pack();
            jf.setVisible(true);
            return jf;
        }
    }

    public static class Context {
        public double[] currpoint = new double[3];
        public double[] rowpoint = new double[3];
        public boolean[] hit = new boolean[3];
        public double[][] Tminmax = new double[2][3];
        public double[] idir = new double[3];
        public double[] tres = new double[2];
        public double[] temp = null;

        public Context(int nblocks) {
            this.temp = new double[nblocks << 1];
        }
    }

    private static class VolumeBlock {
        public int[] pt0 = new int[3];
        public int[] pt1 = new int[3];
        public int[] dims = new int[3];

        public VolumeBlock(int x0, int y0, int z0, int x1, int y1, int z1) {
            this.pt0[0] = x0;
            this.pt0[1] = y0;
            this.pt0[2] = z0;
            this.pt1[0] = x1;
            this.pt1[1] = y1;
            this.pt1[2] = z1;
            this.dims[0] = x1 - x0 + 1;
            this.dims[1] = y1 - y0 + 1;
            this.dims[2] = z1 - z0 + 1;
        }

        public String toString() {
            return "(" + this.pt0[0] + "," + this.pt0[1] + "," + this.pt0[2] + ") --> (" + this.pt1[0] + "," + this.pt1[1] + "," + this.pt1[2] + ")  dims=[" + this.dims[0] + "," + this.dims[1] + "," + this.dims[2] + "]";
        }
    }
}

