/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.Rectangle3D;
import com.ge.med.jnu.geom.Shape3D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public abstract class Rectangular3DShape
implements Cloneable,
Shape3D {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double width = 0.0;
    public double height = 0.0;
    public double depth = 0.0;

    public Rectangular3DShape() {
    }

    public Rectangular3DShape(double x2, double y2, double z2, double w2, double h2, double d2) {
        this.setRect(x2, y2, z2, w2, h2, d2);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final double getDepth() {
        return this.depth;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0 || this.depth <= 0.0;
    }

    public void setRect(double x2, double y2, double z2, double w2, double h2, double d2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.width = w2;
        this.height = h2;
        this.depth = d2;
    }

    public final void setRect(Rectangular3DShape r2) {
        this.setRect(r2.getX(), r2.getY(), r2.getZ(), r2.getWidth(), r2.getHeight(), r2.getDepth());
    }

    public final void setFrame(double x2, double y2, double z2, double w2, double h2, double d2) {
        this.setRect(x2, y2, z2, w2, h2, d2);
    }

    @Override
    public final Rectangle3D getBounds3D() {
        return new Rectangle3D(this.x, this.y, this.z, this.width, this.height, this.depth);
    }

    @Override
    public final void getBounds3D(Rectangle3D r3d) {
        r3d.setRect(this.x, this.y, this.z, this.width, this.height, this.depth);
    }

    @Override
    public final boolean contains(JnVector3d p2) {
        return this.contains(p2.x, p2.y, p2.z);
    }

    @Override
    public boolean contains(double x2, double y2, double z2) {
        double x0 = this.getX();
        double y0 = this.getY();
        double z0 = this.getZ();
        return x2 >= x0 && y2 >= y0 && z2 >= z0 && x2 < x0 + this.getWidth() && y2 < y0 + this.getHeight() && z2 < z0 + this.getDepth();
    }

    @Override
    public final boolean intersects(Rectangle3D r2) {
        return this.intersects(r2.getX(), r2.getY(), r2.getZ(), r2.getWidth(), r2.getHeight(), r2.getDepth());
    }

    @Override
    public boolean intersects(double x2, double y2, double z2, double w2, double h2, double d2) {
        if (this.isEmpty() || w2 <= 0.0 || h2 <= 0.0 || d2 <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        double z0 = this.getZ();
        return x2 + w2 > x0 && y2 + h2 > y0 && z2 + d2 > z0 && x2 < x0 + this.getWidth() && y2 < y0 + this.getHeight() && z2 < z0 + this.getDepth();
    }

    @Override
    public final boolean contains(Rectangle3D r2) {
        return this.contains(r2.getX(), r2.getY(), r2.getZ(), r2.getWidth(), r2.getHeight(), r2.getDepth());
    }

    @Override
    public boolean contains(double x2, double y2, double z2, double w2, double h2, double d2) {
        if (this.isEmpty() || w2 <= 0.0 || h2 <= 0.0 || d2 <= 0.0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        double z0 = this.getZ();
        return x2 >= x0 && y2 >= y0 && z2 >= z0 && x2 + w2 <= x0 + this.getWidth() && y2 + h2 <= y0 + this.getHeight() && z2 + d2 <= z0 + this.getDepth();
    }

    public Shape intersection(JnVector3d ul, JnVector3d ur, JnVector3d bl) {
        GeneralPath gp = new GeneralPath();
        return gp;
    }

    public final void getCenter(JnVector3d center) {
        center.x = this.x + this.width * 0.5;
        center.y = this.y + this.height * 0.5;
        center.z = this.z + this.depth * 0.5;
    }

    public final double getCenterX() {
        return this.x + this.width * 0.5;
    }

    public final double getCenterY() {
        return this.y + this.height * 0.5;
    }

    public final double getCenterZ() {
        return this.z + this.depth * 0.5;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",w=" + this.width + ",h=" + this.height + ",d=" + this.depth + "]";
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getX());
        bits += Double.doubleToLongBits(this.getY()) * 37L;
        bits += Double.doubleToLongBits(this.getZ()) * 43L;
        bits += Double.doubleToLongBits(this.getWidth()) * 47L;
        bits += Double.doubleToLongBits(this.getHeight()) * 53L;
        return (int)(bits += Double.doubleToLongBits(this.getDepth()) * 59L) ^ (int)(bits >> 32);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }
}

