/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.Rectangle3D;
import com.ge.med.jnu.geom.Shape3D;

public class VoxelIterator {
    private Rectangle3D bounds = new Rectangle3D();
    private Shape3D shape3d = null;
    private double dx = 1.0;
    private double dy = 1.0;
    private double dz = 1.0;
    private JnVector3d cpos = new JnVector3d();
    private boolean eop = false;
    private int w = 0;
    private int h = 0;
    private int d = 0;
    private int zidx = -1;
    private int xyidx = -1;
    private int[][] contains = null;
    private int[][] end = null;

    public VoxelIterator(Shape3D shape3d, double dx, double dy, double dz) {
        this.shape3d = shape3d;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.reset();
    }

    public boolean reset() {
        this.shape3d.getBounds3D(this.bounds);
        double bw = this.bounds.getWidth();
        double bh = this.bounds.getHeight();
        double bd = this.bounds.getDepth();
        this.w = (int)(bw / this.dx + 0.5);
        this.h = (int)(bh / this.dy + 0.5);
        this.d = (int)(bd / this.dz + 0.5);
        this.contains = new int[2][this.w * this.h];
        double y2 = this.bounds.y;
        int i2 = 0;
        while (i2 < this.h) {
            int offset = i2 * this.w;
            double x2 = this.bounds.x;
            int j2 = 0;
            while (j2 < this.w) {
                this.contains[0][offset + j2] = -1;
                this.contains[1][offset + j2] = -1;
                double z2 = this.bounds.z;
                int k2 = 0;
                while (k2 < this.d) {
                    if (this.shape3d.contains(x2, y2, z2)) {
                        this.contains[0][offset + j2] = k2;
                        break;
                    }
                    ++k2;
                    z2 += this.dz;
                }
                z2 = this.bounds.z + (double)(this.d - 1) * this.dz;
                k2 = this.d - 1;
                while (k2 >= 0) {
                    if (this.shape3d.contains(x2, y2, z2)) {
                        this.contains[1][offset + j2] = k2;
                        break;
                    }
                    --k2;
                    z2 -= this.dz;
                }
                ++j2;
                x2 += this.dx;
            }
            ++i2;
            y2 += this.dy;
        }
        this.zidx = -1;
        this.xyidx = 0;
        for (i2 = 0; i2 < this.contains[0].length; ++i2) {
            if (this.contains[0][i2] == -1) continue;
            this.zidx = this.contains[0][i2];
            this.xyidx = i2;
            break;
        }
        if (this.zidx == -1) {
            System.err.println("[JNU] VoxelIterator.reset: Shape3D contains no interior points??");
            this.eop = true;
            return false;
        }
        this.calcPoint(this.zidx, this.xyidx);
        this.eop = false;
        return true;
    }

    private void calcPoint(int zidx, int xyidx) {
        int xidx = xyidx % this.w;
        int yidx = xyidx / this.w;
        this.cpos.x = this.bounds.x + (double)xidx * this.dx;
        this.cpos.y = this.bounds.y + (double)yidx * this.dy;
        this.cpos.z = this.bounds.z + (double)zidx * this.dz;
    }

    public final boolean isDone() {
        return this.eop;
    }

    public final void next() {
        if (this.zidx != -1) {
            ++this.zidx;
            if (this.zidx <= this.contains[1][this.xyidx]) {
                this.calcPoint(this.zidx, this.xyidx);
                return;
            }
            this.zidx = -1;
            ++this.xyidx;
            while (this.xyidx < this.contains[0].length) {
                if (this.contains[0][this.xyidx] != -1) {
                    this.zidx = this.contains[0][this.xyidx];
                    this.calcPoint(this.zidx, this.xyidx);
                    return;
                }
                ++this.xyidx;
                if (this.xyidx < this.contains[0].length) continue;
                this.zidx = -1;
                this.eop = true;
                return;
            }
        }
    }

    public void currentVoxelPosition(JnVector3d pos) {
        pos.set(this.cpos);
    }

    public final double getDeltaX() {
        return this.dx;
    }

    public final double getDeltaY() {
        return this.dy;
    }

    public final double getDeltaZ() {
        return this.dz;
    }
}

