/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.wl;

import com.ge.med.jnu.wl.Legall53WaveletBase;
import java.awt.Rectangle;

public class Legall53Wavelet
extends Legall53WaveletBase {
    public static void inverse(short[] data, int w2, int h2, int nlevels) {
        Legall53Wavelet.inverse(data, w2, h2, 0, 0, w2, h2, nlevels);
    }

    public static void inverse(short[] data, int width, int height, int x2, int y2, int w2, int h2, int nlevels) {
        Rectangle r2 = new Rectangle();
        r2.x = x2;
        r2.y = y2;
        r2.width = w2;
        r2.height = h2;
        Legall53Wavelet.waveletTreeReconstruction(data, width, height, r2, x2, y2, 0, nlevels);
    }

    public static void inverse(int[] data, int w2, int h2, int nlevels) {
        Rectangle r2 = new Rectangle();
        r2.x = 0;
        r2.y = 0;
        r2.width = w2;
        r2.height = h2;
        Legall53Wavelet.waveletTreeReconstruction(data, w2, h2, r2, 0, 0, 0, nlevels);
    }

    private static void waveletTreeReconstruction(int[] img, int width, int height, Rectangle sb, int d_ulcx, int d_ulcy, int level, int nlevels) {
        if (level != nlevels) {
            Rectangle ll = new Rectangle();
            Rectangle hl = new Rectangle();
            Rectangle lh = new Rectangle();
            Rectangle hh = new Rectangle();
            int ll_ulcx = d_ulcx + 1 >> 1;
            int ll_ulcy = d_ulcy + 1 >> 1;
            int hl_ulcx = d_ulcx >> 1;
            int hl_ulcy = ll_ulcy;
            int lh_ulcx = ll_ulcx;
            int lh_ulcy = d_ulcy >> 1;
            int hh_ulcx = hl_ulcx;
            int hh_ulcy = lh_ulcy;
            ll.x = sb.x;
            ll.y = sb.y;
            ll.width = (d_ulcx + sb.width + 1 >> 1) - (d_ulcx + 1 >> 1);
            ll.height = (d_ulcy + sb.height + 1 >> 1) - (d_ulcy + 1 >> 1);
            hl.x = sb.x + ll.width;
            hl.y = sb.y;
            hl.width = (d_ulcx + sb.width >> 1) - (d_ulcx >> 1);
            hl.height = ll.height;
            lh.x = sb.x;
            lh.y = sb.y + ll.height;
            lh.width = ll.width;
            lh.height = (d_ulcy + sb.height >> 1) - (d_ulcy >> 1);
            hh.x = hl.x;
            hh.y = lh.y;
            hh.width = hl.width;
            hh.height = lh.height;
            Legall53Wavelet.waveletTreeReconstruction(img, width, height, ll, ll_ulcx, ll_ulcy, level + 1, nlevels);
            if (level >= 0) {
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, hl, hl_ulcx, hl_ulcy, level + 1, nlevels);
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, lh, lh_ulcx, lh_ulcy, level + 1, nlevels);
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, hh, hh_ulcx, hh_ulcy, level + 1, nlevels);
                Legall53Wavelet.wavelet2DReconstruction(img, width, height, sb, d_ulcx, d_ulcy);
            }
        }
    }

    private static void waveletTreeReconstruction(short[] img, int width, int height, Rectangle sb, int d_ulcx, int d_ulcy, int level, int nlevels) {
        if (level != nlevels) {
            Rectangle ll = new Rectangle();
            Rectangle hl = new Rectangle();
            Rectangle lh = new Rectangle();
            Rectangle hh = new Rectangle();
            int ll_ulcx = d_ulcx + 1 >> 1;
            int ll_ulcy = d_ulcy + 1 >> 1;
            int hl_ulcx = d_ulcx >> 1;
            int hl_ulcy = ll_ulcy;
            int lh_ulcx = ll_ulcx;
            int lh_ulcy = d_ulcy >> 1;
            int hh_ulcx = hl_ulcx;
            int hh_ulcy = lh_ulcy;
            ll.x = sb.x;
            ll.y = sb.y;
            ll.width = (d_ulcx + sb.width + 1 >> 1) - (d_ulcx + 1 >> 1);
            ll.height = (d_ulcy + sb.height + 1 >> 1) - (d_ulcy + 1 >> 1);
            hl.x = sb.x + ll.width;
            hl.y = sb.y;
            hl.width = (d_ulcx + sb.width >> 1) - (d_ulcx >> 1);
            hl.height = ll.height;
            lh.x = sb.x;
            lh.y = sb.y + ll.height;
            lh.width = ll.width;
            lh.height = (d_ulcy + sb.height >> 1) - (d_ulcy >> 1);
            hh.x = hl.x;
            hh.y = lh.y;
            hh.width = hl.width;
            hh.height = lh.height;
            Legall53Wavelet.waveletTreeReconstruction(img, width, height, ll, ll_ulcx, ll_ulcy, level + 1, nlevels);
            if (level >= 0) {
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, hl, hl_ulcx, hl_ulcy, level + 1, nlevels);
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, lh, lh_ulcx, lh_ulcy, level + 1, nlevels);
                Legall53Wavelet.waveletTreeReconstruction(img, width, height, hh, hh_ulcx, hh_ulcy, level + 1, nlevels);
                Legall53Wavelet.wavelet2DReconstruction(img, width, height, sb, d_ulcx, d_ulcy);
            }
        }
    }

    private static void wavelet2DReconstruction(int[] img, int width, int height, Rectangle sb, int sb_ulcx, int sb_ulcy) {
        int i2;
        int[] data = img;
        if (sb.width == 0 || sb.height == 0) {
            return;
        }
        boolean img_ulx = false;
        boolean img_uly = false;
        int ulx = sb.x;
        int uly = sb.y;
        int w2 = sb.width;
        int h2 = sb.height;
        int[] buf = new int[w2 >= h2 ? w2 : h2];
        int offset = (uly - 0) * width + ulx - 0;
        if (sb_ulcx % 2 == 0) {
            i2 = 0;
            while (i2 < h2) {
                System.arraycopy(data, offset, buf, 0, w2);
                Legall53Wavelet.synthetize_lpf(buf, 0, (w2 + 1) / 2, 1, buf, (w2 + 1) / 2, w2 / 2, 1, data, offset, 1);
                ++i2;
                offset += width;
            }
        } else {
            i2 = 0;
            while (i2 < h2) {
                System.arraycopy(data, offset, buf, 0, w2);
                Legall53Wavelet.synthetize_hpf(buf, 0, w2 / 2, 1, buf, w2 / 2, (w2 + 1) / 2, 1, data, offset, 1);
                ++i2;
                offset += width;
            }
        }
        offset = (uly - 0) * width + ulx - 0;
        int[] data_int = data;
        int[] buf_int = buf;
        if (sb_ulcy % 2 == 0) {
            int j2 = 0;
            while (j2 < w2) {
                i2 = h2 - 1;
                int k2 = offset + i2 * width;
                while (i2 >= 0) {
                    buf_int[i2] = data_int[k2];
                    --i2;
                    k2 -= width;
                }
                Legall53Wavelet.synthetize_lpf(buf, 0, (h2 + 1) / 2, 1, buf, (h2 + 1) / 2, h2 / 2, 1, data, offset, width);
                ++j2;
                ++offset;
            }
        } else {
            int j3 = 0;
            while (j3 < w2) {
                i2 = h2 - 1;
                int k3 = offset + i2 * width;
                while (i2 >= 0) {
                    buf_int[i2] = data_int[k3];
                    --i2;
                    k3 -= width;
                }
                Legall53Wavelet.synthetize_hpf(buf, 0, h2 / 2, 1, buf, h2 / 2, (h2 + 1) / 2, 1, data, offset, width);
                ++j3;
                ++offset;
            }
        }
    }

    private static void wavelet2DReconstruction(short[] img, int width, int height, Rectangle sb, int sb_ulcx, int sb_ulcy) {
        int i2;
        short[] data = img;
        if (sb.width == 0 || sb.height == 0) {
            return;
        }
        boolean img_ulx = false;
        boolean img_uly = false;
        int ulx = sb.x;
        int uly = sb.y;
        int w2 = sb.width;
        int h2 = sb.height;
        short[] buf = new short[w2 >= h2 ? w2 : h2];
        int offset = (uly - 0) * width + ulx - 0;
        if (sb_ulcx % 2 == 0) {
            i2 = 0;
            while (i2 < h2) {
                System.arraycopy(data, offset, buf, 0, w2);
                Legall53Wavelet.synthetize_lpf(buf, 0, (w2 + 1) / 2, 1, buf, (w2 + 1) / 2, w2 / 2, 1, data, offset, 1);
                ++i2;
                offset += width;
            }
        } else {
            i2 = 0;
            while (i2 < h2) {
                System.arraycopy(data, offset, buf, 0, w2);
                Legall53Wavelet.synthetize_hpf(buf, 0, w2 / 2, 1, buf, w2 / 2, (w2 + 1) / 2, 1, data, offset, 1);
                ++i2;
                offset += width;
            }
        }
        offset = (uly - 0) * width + ulx - 0;
        if (sb_ulcy % 2 == 0) {
            int j2 = 0;
            while (j2 < w2) {
                i2 = h2 - 1;
                int k2 = offset + i2 * width;
                while (i2 >= 0) {
                    buf[i2] = data[k2];
                    --i2;
                    k2 -= width;
                }
                Legall53Wavelet.synthetize_lpf(buf, 0, (h2 + 1) / 2, 1, buf, (h2 + 1) / 2, h2 / 2, 1, data, offset, width);
                ++j2;
                ++offset;
            }
        } else {
            int j3 = 0;
            while (j3 < w2) {
                i2 = h2 - 1;
                int k3 = offset + i2 * width;
                while (i2 >= 0) {
                    buf[i2] = data[k3];
                    --i2;
                    k3 -= width;
                }
                Legall53Wavelet.synthetize_hpf(buf, 0, h2 / 2, 1, buf, h2 / 2, (h2 + 1) / 2, 1, data, offset, width);
                ++j3;
                ++offset;
            }
        }
    }

    public static void main(String[] args) {
        int DIM = 512;
        int[] data = new int[DIM * DIM];
        int[] gt = new int[DIM * DIM];
        for (int y2 = 0; y2 < DIM; ++y2) {
            int yoffset = y2 * DIM;
            for (int x2 = 0; x2 < DIM; ++x2) {
                int n2 = 6 * y2 + x2;
                data[yoffset + x2] = n2;
                gt[yoffset + x2] = n2;
            }
        }
        Legall53Wavelet legall53 = new Legall53Wavelet();
        long t0 = System.currentTimeMillis();
        Legall53Wavelet.forward(data, DIM, DIM, 5);
        long tforward = System.currentTimeMillis() - t0;
        System.err.println(">>>> -----------------------------------------------------");
        long t1 = System.currentTimeMillis();
        Legall53Wavelet.inverse(data, DIM, DIM, 5);
        long tinverse = System.currentTimeMillis() - t1;
        int nerrors = 0;
        for (int y3 = 0; y3 < DIM; ++y3) {
            int yoffset = y3 * DIM;
            for (int x3 = 0; x3 < DIM; ++x3) {
                if (gt[yoffset + x3] == data[yoffset + x3]) continue;
                ++nerrors;
            }
        }
        System.err.println("--- tforward=" + tforward + "   tinverse=" + tinverse + " errors=" + nerrors);
    }
}

