/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.border;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.RoundCornerRectangle;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class CuiBorder
implements Border {
    protected double interiorEdge_;
    protected double exteriorEdge_;
    protected double[] cornerRadii_;
    protected boolean[] interiorEdgeVisible_;
    protected boolean[] exteriorEdgeVisible_;
    protected Insets minimumMargin_;
    protected int insetRule_;
    public static final int MAXIMIZE_AREA = 0;
    public static final int MAXIMIZE_WIDTH = 1;
    public static final int MAXIMIZE_HEIGHT = 2;
    protected EdgeProfile profileNormal_;
    protected EdgeProfile profilePressed_;
    public Insets hardInsets_;
    protected Insets softInsets_;
    protected int cornerAllowance_;
    protected Insets focusInsets_;
    protected double focusCorner_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public double getInteriorEdge() {
        return this.interiorEdge_;
    }

    public double getExteriorEdge() {
        return this.exteriorEdge_;
    }

    public double[] getCornerRadii() {
        return this.cornerRadii_;
    }

    public boolean[] getInteriorEdgeVisible() {
        return this.interiorEdgeVisible_;
    }

    public boolean[] getExteriorEdgeVisible() {
        return this.exteriorEdgeVisible_;
    }

    public Insets getMinimumMargin() {
        return this.minimumMargin_;
    }

    public int getInsetRule() {
        return this.insetRule_;
    }

    public CuiBorder() {
        this(CuiLookAndFeel.getInteriorEdge(), CuiLookAndFeel.getExteriorEdge(), new double[]{CuiLookAndFeel.getCornerRadius(), CuiLookAndFeel.getCornerRadius(), CuiLookAndFeel.getCornerRadius(), CuiLookAndFeel.getCornerRadius()}, new boolean[]{true, true, true, true}, new boolean[]{true, true, true, true}, new Insets(0, 0, 0, 0), 0);
    }

    public CuiBorder(double interiorEdge, double exteriorEdge, double[] cornerRadii, boolean[] interiorEdgeVisible, boolean[] exteriorEdgeVisible, Insets minimumMargin, int insetRule) {
        this.interiorEdge_ = interiorEdge;
        this.exteriorEdge_ = exteriorEdge;
        this.cornerRadii_ = cornerRadii;
        this.interiorEdgeVisible_ = interiorEdgeVisible;
        this.exteriorEdgeVisible_ = exteriorEdgeVisible;
        this.minimumMargin_ = minimumMargin;
        this.insetRule_ = insetRule;
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        if (this.hardInsets_ == null || this.softInsets_ == null) {
            int i2;
            int interiorEdge = (int)Math.ceil(this.interiorEdge_);
            int exteriorEdge = (int)Math.ceil(this.exteriorEdge_);
            int[] sides = new int[4];
            int[][] corners = new int[4][2];
            double[][] ruleCoefficients = new double[][]{{0.293, 0.0, 1.0}, {0.293, 1.0, 0.0}};
            for (i2 = 0; i2 < 4; ++i2) {
                sides[i2] = (this.interiorEdgeVisible_[i2] ? interiorEdge : 0) + (this.exteriorEdgeVisible_[i2] ? exteriorEdge : 0);
                double corner = Math.max(0.0, this.cornerRadii_[i2] - this.interiorEdge_);
                corners[i2][0] = (int)Math.ceil(corner * ruleCoefficients[0][this.insetRule_]);
                corners[i2][1] = (int)Math.ceil(corner * ruleCoefficients[1][this.insetRule_]);
            }
            this.hardInsets_ = new Insets(sides[0], sides[1], sides[2], sides[3]);
            this.softInsets_ = new Insets(Math.max(Math.max(corners[3][1], corners[0][1]), this.minimumMargin_.top), Math.max(Math.max(corners[0][0], corners[1][0]), this.minimumMargin_.left), Math.max(Math.max(corners[1][1], corners[2][1]), this.minimumMargin_.bottom), Math.max(Math.max(corners[2][0], corners[3][0]), this.minimumMargin_.right));
            this.cornerAllowance_ = interiorEdge;
            for (i2 = 0; i2 < 4; ++i2) {
                this.cornerAllowance_ = Math.max(this.cornerAllowance_, (int)Math.ceil(this.cornerRadii_[i2]));
            }
            if (c2 instanceof AbstractButton) {
                double maxRadius = 0.0;
                for (int i3 = 0; i3 < 4; ++i3) {
                    maxRadius = Math.max(maxRadius, this.cornerRadii_[i3]);
                }
                this.focusCorner_ = Math.max(1.0, (double)((int)Math.ceil(2.0 * (maxRadius - this.interiorEdge_))));
                int focusInset = 0;
                this.focusInsets_ = new Insets(this.hardInsets_.top + focusInset, this.hardInsets_.left + focusInset, this.hardInsets_.bottom + focusInset, this.hardInsets_.right + focusInset);
            }
        }
        Insets margin = null;
        if (c2 instanceof AbstractButton) {
            margin = ((AbstractButton)c2).getMargin();
        } else if (c2 instanceof JTextComponent) {
            margin = ((JTextComponent)c2).getMargin();
        } else if (c2 instanceof JToolBar) {
            margin = ((JToolBar)c2).getMargin();
        }
        if (margin == null) {
            margin = new Insets(0, 0, 0, 0);
        }
        return new Insets(this.hardInsets_.top + Math.max(this.softInsets_.top, margin.top), this.hardInsets_.left + Math.max(this.softInsets_.left, margin.left), this.hardInsets_.bottom + Math.max(this.softInsets_.bottom, margin.bottom), this.hardInsets_.right + Math.max(this.softInsets_.right, margin.right));
    }

    public Insets getSoftInsets(Component c2) {
        this.getBorderInsets(c2);
        return this.softInsets_;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
        Color interiorColor;
        Container parent;
        Container container = parent = c2 != null ? c2.getParent() : null;
        if (parent instanceof CellRendererPane) {
            parent = parent.getParent();
        }
        if (parent instanceof JComboBox || parent instanceof JSpinner) {
            parent = parent.getParent();
        }
        Color exteriorColor = c2 == null || parent == null || parent.getBackground() == null || !parent.isOpaque() || parent instanceof JComponent && (((JComponent)parent).getClientProperty("picture") != null || ((JComponent)parent).getClientProperty("texture") != null) ? new Color(0, true) : parent.getBackground();
        Color color = interiorColor = c2 == null || c2.getBackground() == null || !c2.isEnabled() ? exteriorColor : c2.getBackground();
        if (this.profileNormal_ == null) {
            this.profileNormal_ = new EdgeProfileRounded(this.interiorEdge_, this.exteriorEdge_);
        }
        EdgeProfile profile = this.profileNormal_;
        if (c2 instanceof AbstractButton) {
            boolean checkOrRadio;
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            boolean pressed = model.isPressed();
            boolean selected = model.isSelected();
            boolean bl = checkOrRadio = button instanceof JCheckBox || button instanceof JRadioButton;
            if (this.profilePressed_ == null) {
                this.profilePressed_ = new EdgeProfileRounded(this.interiorEdge_, this.exteriorEdge_){

                    @Override
                    public double getSlope(double distanceFromShape) {
                        double slope = super.getSlope(distanceFromShape);
                        return distanceFromShape > 0.0 ? -slope : slope;
                    }

                    @Override
                    public String toString() {
                        return "Pressed" + super.toString();
                    }
                };
            }
            if (pressed || selected && !checkOrRadio) {
                profile = this.profilePressed_;
            }
            if (!button.isContentAreaFilled()) {
                interiorColor = exteriorColor;
            } else if (c2.isEnabled() && (pressed || selected)) {
                String classKey = button.getUIClassID();
                if (classKey.endsWith("UI")) {
                    classKey = classKey.substring(0, classKey.length() - 2);
                }
                interiorColor = Utilities.getUIPropertyColor(button, classKey + (pressed ? ".press" : ".select"), Color.gray);
            }
        } else if (c2 instanceof JTextComponent) {
            JTextComponent text = (JTextComponent)c2;
            if (!text.isEditable()) {
                interiorColor = exteriorColor;
            }
        } else if (c2 == null) {
            interiorColor = exteriorColor;
        } else if (!c2.isOpaque()) {
            if (!(parent instanceof JTabbedPane)) {
                interiorColor = exteriorColor;
            } else {
                interiorColor = (Color)((JTabbedPane)parent).getClientProperty("TabbedPane.selected");
                if (interiorColor == null) {
                    interiorColor = UIManager.getColor("TabbedPane.selected");
                }
                if (interiorColor == null) {
                    interiorColor = exteriorColor;
                }
            }
        }
        if (c2 instanceof JInternalFrame) {
            exteriorColor = interiorColor;
        }
        Insets cutoutInsets = this.getBorderInsets(c2);
        int exteriorEdge = (int)Math.ceil(this.exteriorEdge_);
        int interiorEdge = (int)Math.ceil(this.interiorEdge_);
        int ww = 2 * Math.max(exteriorEdge + this.cornerAllowance_, Math.max(cutoutInsets.left, cutoutInsets.right)) + 1;
        int hh = 2 * Math.max(exteriorEdge + this.cornerAllowance_, Math.max(cutoutInsets.top, cutoutInsets.bottom)) + 1;
        Dimension size = new Dimension(Math.min(w2, ww), Math.min(h2, hh));
        Rectangle cutout = new Rectangle(cutoutInsets.left, cutoutInsets.top, size.width - (cutoutInsets.left + cutoutInsets.right), size.height - (cutoutInsets.top + cutoutInsets.bottom));
        Insets shapeInsets = new Insets(this.exteriorEdgeVisible_[0] ? exteriorEdge : (this.interiorEdgeVisible_[0] ? 0 : -Math.max(interiorEdge, this.cornerAllowance_)), this.exteriorEdgeVisible_[1] ? exteriorEdge : (this.interiorEdgeVisible_[1] ? 0 : -Math.max(interiorEdge, this.cornerAllowance_)), this.exteriorEdgeVisible_[2] ? exteriorEdge : (this.interiorEdgeVisible_[2] ? 0 : -Math.max(interiorEdge, this.cornerAllowance_)), this.exteriorEdgeVisible_[3] ? exteriorEdge : (this.interiorEdgeVisible_[3] ? 0 : -Math.max(interiorEdge, this.cornerAllowance_)));
        double[] arcDiameters = new double[]{2.0 * this.cornerRadii_[0], 2.0 * this.cornerRadii_[1], 2.0 * this.cornerRadii_[2], 2.0 * this.cornerRadii_[3]};
        RoundCornerRectangle shape = new RoundCornerRectangle((double)shapeInsets.left, (double)shapeInsets.top, (double)(size.width - (shapeInsets.left + shapeInsets.right)), (double)(size.height - (shapeInsets.top + shapeInsets.bottom)), arcDiameters, arcDiameters);
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, cutout);
        new StretchedImageIcon(renderedShape, w2, h2).paintIcon(c2, g2, x2, y2);
        if (c2 instanceof AbstractButton && ((AbstractButton)c2).isFocusPainted() && (c2.hasFocus() || c2.getParent() instanceof JComboBox && ((JComboBox)c2.getParent()).hasFocus())) {
            String classKey = ((JComponent)c2).getUIClassID();
            if (classKey.endsWith("UI")) {
                classKey = classKey.substring(0, classKey.length() - 2);
            }
            g2.setColor(Utilities.getUIPropertyColor((JComponent)c2, classKey + (((AbstractButton)c2).isSelected() ? ".selectFocus" : ".focus"), Color.white));
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g2).draw(new RoundRectangle2D.Double((double)(x2 + this.focusInsets_.left) + 0.5, (double)(y2 + this.focusInsets_.top) + 0.5, w2 - (this.focusInsets_.left + this.focusInsets_.right) - 1, h2 - (this.focusInsets_.top + this.focusInsets_.bottom) - 1, this.focusCorner_, this.focusCorner_));
        }
    }

    public static class UIResource
    extends CuiBorder
    implements javax.swing.plaf.UIResource {
        public UIResource() {
        }

        public UIResource(double interiorEdge, double exteriorEdge, double[] cornerRadii, boolean[] interiorEdgeVisible, boolean[] exteriorEdgeVisible, Insets minimumMargin, int insetRule) {
            super(interiorEdge, exteriorEdge, cornerRadii, interiorEdgeVisible, exteriorEdgeVisible, minimumMargin, insetRule);
        }
    }
}

