/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.border;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class CuiSplitPaneBorder
implements Border,
UIResource {
    protected double edge_;
    protected int width_;

    public CuiSplitPaneBorder() {
        this(CuiLookAndFeel.getExteriorEdge());
    }

    public CuiSplitPaneBorder(double edge) {
        this.edge_ = edge;
        this.width_ = (int)Math.ceil(this.edge_);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return new Insets(this.width_, this.width_, this.width_, this.width_);
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
        JSplitPane splitPane = (JSplitPane)c2;
        Component left = splitPane.getLeftComponent();
        Component right = splitPane.getRightComponent();
        Color exteriorColor = splitPane.isOpaque() ? splitPane.getBackground() : new Color(0, true);
        Color interiorColor = new Color(0, true);
        Dimension size = new Dimension(2 * this.width_ + 1, 2 * this.width_ + 1);
        EdgeProfileRounded profile = new EdgeProfileRounded(0.0, this.edge_);
        Rectangle shape = new Rectangle(this.width_, this.width_, 1, 1);
        if (left == null || right == null) {
            BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, shape);
            new StretchedImageIcon(renderedShape, w2, h2).paintIcon(c2, g2, x2, y2);
            return;
        }
        if (splitPane.getOrientation() == 1) {
            BufferedImage renderedShapeL = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, new Rectangle(this.width_, this.width_, 1 + this.width_, 1));
            BufferedImage renderedShapeR = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, new Rectangle(0, this.width_, 1 + this.width_, 1));
            int x1 = left.getBounds().x + left.getBounds().width;
            int x22 = right.getBounds().x;
            new StretchedImageIcon(renderedShapeL, x1 - x2 + this.width_, h2).paintIcon(c2, g2, x2, y2);
            new StretchedImageIcon(renderedShapeR, x2 + w2 - x22 + this.width_, h2).paintIcon(c2, g2, x22 - this.width_, y2);
        } else {
            BufferedImage renderedShapeT = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, new Rectangle(this.width_, this.width_, 1, 1 + this.width_));
            BufferedImage renderedShapeB = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, new Rectangle(this.width_, 0, 1, 1 + this.width_));
            int y1 = left.getBounds().y + left.getBounds().height;
            int y22 = right.getBounds().y;
            new StretchedImageIcon(renderedShapeT, w2, y1 - y2 + this.width_).paintIcon(c2, g2, x2, y2);
            new StretchedImageIcon(renderedShapeB, w2, y2 + h2 - y22 + this.width_).paintIcon(c2, g2, x2, y22 - this.width_);
        }
    }

    public static class DividerBorder
    implements Border,
    UIResource {
        protected double edge_;
        protected int width_;

        public DividerBorder() {
            this(CuiLookAndFeel.getExteriorEdge());
        }

        public DividerBorder(double edge) {
            this.edge_ = edge;
            this.width_ = (int)Math.ceil(this.edge_);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            JSplitPane splitPane = ((BasicSplitPaneDivider)c2).getBasicSplitPaneUI().getSplitPane();
            return splitPane.getOrientation() == 1 ? new Insets(0, this.width_, 0, this.width_) : new Insets(this.width_, 0, this.width_, 0);
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            JSplitPane splitPane = ((BasicSplitPaneDivider)c2).getBasicSplitPaneUI().getSplitPane();
            Shape saveClip = ((Graphics2D)g2).getClip();
            g2.clipRect(x2, y2, w2, h2);
            Color exteriorColor = new Color(0, true);
            Color interiorColor = splitPane.isOpaque() ? splitPane.getBackground() : new Color(0, true);
            Dimension size = new Dimension(2 * this.width_ + 1, 2 * this.width_ + 1);
            EdgeProfileRounded profile = new EdgeProfileRounded(this.edge_, 0.0);
            Rectangle shape = new Rectangle(0, 0, 2 * this.width_ + 1, 2 * this.width_ + 1);
            Rectangle cutout = new Rectangle(this.width_, this.width_, 1, 1);
            Rectangle draw = splitPane.getOrientation() == 1 ? new Rectangle(x2, y2 - this.width_, w2, h2 + 2 * this.width_) : new Rectangle(x2 - this.width_, y2, w2 + 2 * this.width_, h2);
            BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, cutout);
            new StretchedImageIcon(renderedShape, draw.width, draw.height).paintIcon(c2, g2, draw.x, draw.y);
        }
    }
}

