/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.border;

import com.ge.med.ptk.shape.RoundCornerRectangle;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.border.MatteBorder;

public class RoundedMatteBorder
extends MatteBorder {
    protected Color cornerColor_;
    protected double[] cornerWidths_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public RoundedMatteBorder(Insets borderInsets, Color matteColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, Color matteColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(Insets borderInsets, double cornerRadius, Color matteColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(new double[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius});
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, double cornerRadius, Color matteColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius});
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(Insets borderInsets, double[] cornerRadii, Color matteColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(cornerRadii);
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, double radiusNW, double radiusSW, double radiusSE, double radiusNE, Color matteColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{radiusNW, radiusSW, radiusSE, radiusNE});
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(Insets borderInsets, Color matteColor, Color cornerColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.cornerColor_ = cornerColor;
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, Color matteColor, Color cornerColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.cornerColor_ = cornerColor;
    }

    public RoundedMatteBorder(Insets borderInsets, double cornerRadius, Color matteColor, Color cornerColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(new double[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius});
        this.cornerColor_ = cornerColor;
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, double cornerRadius, Color matteColor, Color cornerColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius});
        this.cornerColor_ = cornerColor;
    }

    public RoundedMatteBorder(Insets borderInsets, double[] cornerRadii, Color matteColor, Color cornerColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(cornerRadii);
        this.cornerColor_ = cornerColor;
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, double radiusNW, double radiusSW, double radiusSE, double radiusNE, Color matteColor, Color cornerColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{radiusNW, radiusSW, radiusSE, radiusNE});
        this.cornerColor_ = cornerColor;
    }

    private final void setCornerRadii(double[] radii) {
        Insets insets = this.getBorderInsets();
        this.cornerWidths_ = new double[]{2.0 * Math.min(radii[0], (double)Math.max(insets.top, insets.left)), 2.0 * Math.min(radii[1], (double)Math.max(insets.left, insets.bottom)), 2.0 * Math.min(radii[2], (double)Math.max(insets.bottom, insets.right)), 2.0 * Math.min(radii[3], (double)Math.max(insets.right, insets.top))};
    }

    @Override
    public boolean isBorderOpaque() {
        return this.cornerColor_.getAlpha() < 255 ? false : super.isBorderOpaque();
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this.cornerColor_.getAlpha() > 0) {
            g2.setColor(this.cornerColor_);
            g2.fillRect(0, 0, (int)Math.ceil(this.cornerWidths_[0] / 2.0), (int)Math.ceil(this.cornerWidths_[0] / 2.0));
            g2.fillRect(0, y2 + height - (int)Math.ceil(this.cornerWidths_[1] / 2.0), (int)Math.ceil(this.cornerWidths_[1] / 2.0), (int)Math.ceil(this.cornerWidths_[1] / 2.0));
            g2.fillRect(x2 + width - (int)Math.ceil(this.cornerWidths_[1] / 2.0), y2 + height - (int)Math.ceil(this.cornerWidths_[1] / 2.0), (int)Math.ceil(this.cornerWidths_[2] / 2.0), (int)Math.ceil(this.cornerWidths_[2] / 2.0));
            g2.fillRect(x2 + width - (int)Math.ceil(this.cornerWidths_[1] / 2.0), 0, (int)Math.ceil(this.cornerWidths_[3] / 2.0), (int)Math.ceil(this.cornerWidths_[3] / 2.0));
        }
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundCornerRectangle shape = new RoundCornerRectangle((double)x2, (double)y2, (double)width, (double)height, this.cornerWidths_, this.cornerWidths_);
        Shape saveClip = g2.getClip();
        Area clip = new Area(new Rectangle2D.Double(x2, y2, width, height));
        clip.subtract(new Area(new Rectangle2D.Double(x2 + this.getBorderInsets((Component)c2).left, y2 + this.getBorderInsets((Component)c2).top, width - this.getBorderInsets((Component)c2).left - this.getBorderInsets((Component)c2).right, height - this.getBorderInsets((Component)c2).top - this.getBorderInsets((Component)c2).bottom)));
        ((Graphics2D)g2).clip(clip);
        g2.setColor(this.getMatteColor());
        ((Graphics2D)g2).fill(shape);
        g2.setClip(saveClip);
    }
}

