/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.graphics;

import com.ge.med.ptk.graphics.HlsCuiColorSpace;
import com.ge.med.ptk.graphics.MathFunctions;
import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;

public class RenderedShapeFactory {
    protected static Logger logger_ = Logger.getLogger(RenderedShapeFactory.class.getName());
    private static double MAX_SEG = 8.0;
    private static double FLATT = 0.2;
    public static Map cache_ = new HashMap();
    protected static long cumulativeCost_ = 0L;
    protected static ColorSpace hlsColorSpace_ = new HlsCuiColorSpace();
    static int lightingLutBits_ = Integer.getInteger("ptk.lightingLutBits", 0);
    static byte[] lightingLut_ = null;
    private static double maxIntensity_ = -1.0;
    private static double flatIntensity_ = -1.0;
    private static Comparator segmentComparator_ = new Comparator(){

        public int compare(Object o1, Object o2) {
            double x1 = o1 instanceof Line2D.Double ? ((Line2D.Double)o1).x1 : ((Point2D.Double)o1).x;
            double x2 = o2 instanceof Line2D.Double ? ((Line2D.Double)o2).x1 : ((Point2D.Double)o2).x;
            return x1 < x2 ? -1 : 1;
        }
    };
    private static double[][] lights_;
    private static double ambient_;
    private static double[][] diffuse_;
    private static double[][] specular_;
    private static double MAX_HILITE;
    private static double MIN_SHADOW;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static void reset() {
        cache_ = new HashMap();
    }

    public static void load(InputStream in) throws IOException {
        try {
            cache_ = (Map)new ObjectInputStream(in).readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("InputStream does not contain a valid RenderedShapeFactory cache.");
        }
    }

    public static void store(OutputStream out) throws IOException {
        new ObjectOutputStream(out).writeObject(cache_);
    }

    public static BufferedImage getRenderedShape(Dimension renderedAreaSize, Shape objectShape, EdgeProfile edgeProfile, Color interiorColor, Color exteriorColor, Rectangle cutout) {
        String id = "" + renderedAreaSize + objectShape + edgeProfile + (interiorColor == null ? "-" : "" + interiorColor.getRGB()) + (exteriorColor == null ? "-" : "" + exteriorColor.getRGB()) + cutout;
        CacheEntry ce = (CacheEntry)cache_.get(id);
        if (ce == null) {
            long t0 = System.currentTimeMillis();
            ce = new CacheEntry();
            new CacheEntry().image_ = RenderedShapeFactory.createRenderedShape(renderedAreaSize, objectShape, edgeProfile, interiorColor, exteriorColor, cutout);
            long t1 = System.currentTimeMillis();
            ce.cost_ = (int)(t1 - t0);
            logger_.log(Level.FINE, "Key:{0} Render Time:{1} Total:{2}", new String[]{id, "" + ce.cost_, "" + (cumulativeCost_ += t1 - t0)});
            cache_.put(id, ce);
        }
        ++ce.use_;
        logger_.log(Level.FINER, "Key:{0} Use Count:{1}", new String[]{id, "" + ce.use_});
        return ce.image_;
    }

    public static BufferedImage createRenderedShape(Dimension renderedAreaSize, Shape objectShape, EdgeProfile edgeProfile, Color interiorColor, Color exteriorColor, Rectangle cutout) {
        if (interiorColor == null) {
            interiorColor = new Color(0, true);
        }
        if (exteriorColor == null) {
            exteriorColor = new Color(0, true);
        }
        if (edgeProfile == null) {
            edgeProfile = new EdgeProfileRounded(0.0, 0.0);
        }
        if (renderedAreaSize == null || renderedAreaSize.width < 1 || renderedAreaSize.height < 1) {
            return new BufferedImage(1, 1, 2);
        }
        boolean opaque = cutout == null && interiorColor.getAlpha() == 255 && exteriorColor.getAlpha() == 255;
        double alphaInterior = (double)interiorColor.getAlpha() / 255.0;
        double alphaExterior = (double)exteriorColor.getAlpha() / 255.0;
        float[] rgbInterior = new float[]{(float)interiorColor.getRed() / 255.0f, (float)interiorColor.getGreen() / 255.0f, (float)interiorColor.getBlue() / 255.0f};
        float[] rgbExterior = new float[]{(float)exteriorColor.getRed() / 255.0f, (float)exteriorColor.getGreen() / 255.0f, (float)exteriorColor.getBlue() / 255.0f};
        float[] hlsInterior = hlsColorSpace_.fromRGB(rgbInterior);
        float[] hlsExterior = hlsColorSpace_.fromRGB(rgbExterior);
        int pixelInterior = interiorColor.getRGB();
        int pixelExterior = exteriorColor.getRGB();
        int i2 = 0;
        while (i2 < rgbInterior.length) {
            int n2 = i2++;
            rgbInterior[n2] = (float)((double)rgbInterior[n2] * alphaInterior);
        }
        i2 = 0;
        while (i2 < rgbExterior.length) {
            int n3 = i2++;
            rgbExterior[n3] = (float)((double)rgbExterior[n3] * alphaExterior);
        }
        int w2 = renderedAreaSize.width;
        int h2 = renderedAreaSize.height;
        BufferedImage image = new BufferedImage(w2, h2, 2);
        Graphics2D graphics = image.createGraphics();
        if (objectShape == null) {
            graphics.setColor(exteriorColor);
            graphics.fillRect(0, 0, w2, h2);
            if (cutout != null) {
                graphics.setComposite(AlphaComposite.SrcIn);
                graphics.setColor(new Color(0, true));
                graphics.fill(cutout);
            }
            return image;
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(new Color(-65536, true));
        graphics.fillRect(0, 0, w2, h2);
        graphics.setColor(new Color(-16711936, true));
        graphics.fill(objectShape);
        double wi = 2.0 * edgeProfile.getInteriorWidth();
        graphics.setColor(new Color(-2130771968, true));
        graphics.fill(new BasicStroke((float)wi, 2, 0).createStrokedShape(objectShape));
        double we = 2.0 * edgeProfile.getExteriorWidth();
        graphics.setColor(new Color(-2147418368, true));
        graphics.fill(new BasicStroke((float)we, 2, 0).createStrokedShape(objectShape));
        graphics.setColor(new Color(0x770000FF, true));
        graphics.fill(objectShape);
        double[][] offsets = new double[][]{{0.251, 0.249}, {0.751, 0.251}, {0.749, 0.751}, {0.249, 0.749}};
        double[][] offsets2 = new double[][]{{FLATT, -FLATT}, {FLATT, FLATT}, {-FLATT, FLATT}, {-FLATT, -FLATT}};
        int[] startSeg = new int[]{-1};
        Object outline = RenderedShapeFactory.getOutline(objectShape, FLATT);
        int[] pixels = image.getRGB(0, 0, w2, h2, null, 0, w2);
        for (int i3 = 0; i3 < w2 * h2; ++i3) {
            float[] hlsFinal;
            double alphaFinal;
            if (cutout != null && cutout.contains(i3 % w2, i3 / w2)) continue;
            if (pixels[i3] == -65536) {
                pixels[i3] = pixelExterior;
                continue;
            }
            if (pixels[i3] == -16742281) {
                pixels[i3] = pixelInterior;
                continue;
            }
            double light = 0.0;
            for (int j2 = 0; j2 < offsets.length; ++j2) {
                boolean ct;
                Point2D.Double xy;
                double[] da = RenderedShapeFactory.getDistanceAngle(outline, xy, ct, (ct = objectShape.contains(xy = new Point2D.Double((double)(i3 % w2) + offsets[j2][0], (double)(i3 / w2) + offsets[j2][1]))) ? 2.0 * edgeProfile.getInteriorWidth() : 2.0 * edgeProfile.getExteriorWidth(), startSeg);
                for (int k2 = 0; Math.abs(da[0]) <= FLATT && k2 < offsets2.length; ++k2) {
                    Point2D.Double xy2;
                    da = RenderedShapeFactory.getDistanceAngle(outline, xy2, ct, (ct = objectShape.contains(xy2 = new Point2D.Double(xy.getX() + offsets2[(j2 + k2) % offsets2.length][0], xy.getY() + offsets2[(j2 + k2) % offsets2.length][1]))) ? 2.0 * edgeProfile.getInteriorWidth() : 2.0 * edgeProfile.getExteriorWidth(), startSeg);
                }
                double[] sn = RenderedShapeFactory.getSphericalNormal(da, edgeProfile);
                light += RenderedShapeFactory.getLighting(sn);
            }
            light /= (double)offsets.length;
            int inBits = pixels[i3] & 0xFF;
            if (inBits == 0) {
                alphaFinal = alphaExterior;
                hlsFinal = hlsExterior;
            } else if (inBits == 119) {
                alphaFinal = alphaInterior;
                hlsFinal = hlsInterior;
            } else {
                double in = (double)inBits / 119.0;
                double ex = 1.0 - in;
                alphaFinal = alphaInterior * in + alphaExterior * ex;
                double alphaDiv = alphaFinal > 0.0 ? alphaFinal : 1.0;
                float[] rgbFinal = new float[]{(float)(((double)rgbInterior[0] * in + (double)rgbExterior[0] * ex) / alphaDiv), (float)(((double)rgbInterior[1] * in + (double)rgbExterior[1] * ex) / alphaDiv), (float)(((double)rgbInterior[2] * in + (double)rgbExterior[2] * ex) / alphaDiv)};
                hlsFinal = hlsColorSpace_.fromRGB(rgbFinal);
            }
            pixels[i3] = RenderedShapeFactory.getLightedPixel(alphaFinal, hlsFinal, light);
        }
        image.setRGB(0, 0, w2, h2, pixels, 0, w2);
        if (cutout != null) {
            graphics.setComposite(AlphaComposite.SrcIn);
            graphics.setColor(new Color(0, true));
            graphics.fill(cutout);
        }
        if (opaque) {
            BufferedImage i4 = image;
            image = new BufferedImage(w2, h2, 1);
            image.createGraphics().drawImage((Image)i4, 0, 0, null);
        }
        return image;
    }

    public static double getLightingFromLut(double[] sphericalNormal) {
        double ssnn0;
        int sizeI;
        int bits = 5;
        int sizeD = sizeI = 1 << bits;
        if (lightingLut_ == null) {
            double[] lightingLut = new double[1 << 2 * bits];
            double maxIntensity = 0.0;
            double flatIntensity = RenderedShapeFactory.getIntensity(RenderedShapeFactory.sphericalToXYZ(new double[]{0.0, 0.0}));
            for (int sn0 = 0; sn0 < sizeI - 1; ++sn0) {
                for (int sn1 = 0; sn1 < sizeI; ++sn1) {
                    double ssnn02 = (double)sn0 * 2.0 / ((double)sizeD - 2.0) - 1.0;
                    ssnn02 *= Math.abs(ssnn02);
                    double[] sn = new double[]{ssnn02, (double)sn1 * 2.0 * Math.PI / (double)sizeD - Math.PI};
                    double d2 = RenderedShapeFactory.getIntensity(RenderedShapeFactory.sphericalToXYZ(sn));
                    lightingLut[sn0 << bits | sn1] = d2;
                    maxIntensity = Math.max(maxIntensity, d2);
                }
            }
            flatIntensity /= maxIntensity;
            lightingLut_ = new byte[lightingLut.length];
            for (int i2 = 0; i2 < lightingLut.length; ++i2) {
                RenderedShapeFactory.lightingLut_[i2] = (byte)(0xFF & (int)Math.round(255.0 * MathFunctions.smooth(0.0, 1.0, flatIntensity, 0.0, 1.0, 0.5, lightingLut[i2] / maxIntensity)));
            }
        }
        ssnn0 = (ssnn0 = sphericalNormal[0]) < 0.0 ? -Math.sqrt(Math.abs(ssnn0)) : Math.sqrt(ssnn0);
        int sn0 = (int)Math.round(((double)sizeD - 2.0) * (ssnn0 + 1.0) / 2.0);
        sn0 = Math.max(0, Math.min(sizeI - 1, sn0));
        int sn1 = (int)Math.round((double)sizeD * (sphericalNormal[1] + Math.PI) / (Math.PI * 2)) % sizeI;
        return (double)(0xFF & lightingLut_[sn0 << bits | sn1]) / 255.0;
    }

    public static double getLighting(double[] sphericalNormal) {
        if (lightingLutBits_ > 0) {
            return RenderedShapeFactory.getLightingFromLut(sphericalNormal);
        }
        if (maxIntensity_ < 0.0) {
            for (double aa2 = 0.0; aa2 <= Math.PI; aa2 += 0.03) {
                for (double ss = 0.0; ss <= 1.0; ss += 0.01) {
                    maxIntensity_ = Math.max(maxIntensity_, Math.max(RenderedShapeFactory.getIntensity(RenderedShapeFactory.sphericalToXYZ(new double[]{ss, aa2})), Math.max(RenderedShapeFactory.getIntensity(RenderedShapeFactory.sphericalToXYZ(new double[]{ss, -aa2})), Math.max(RenderedShapeFactory.getIntensity(RenderedShapeFactory.sphericalToXYZ(new double[]{-ss, aa2})), RenderedShapeFactory.getIntensity(RenderedShapeFactory.sphericalToXYZ(new double[]{-ss, -aa2}))))));
                }
            }
        }
        if (maxIntensity_ == 0.0) {
            return 0.0;
        }
        if (flatIntensity_ < 0.0) {
            flatIntensity_ = RenderedShapeFactory.getIntensity(RenderedShapeFactory.sphericalToXYZ(new double[]{0.0, 0.0})) / maxIntensity_;
        }
        double intensity = RenderedShapeFactory.getIntensity(RenderedShapeFactory.sphericalToXYZ(sphericalNormal)) / maxIntensity_;
        intensity = MathFunctions.smooth(0.0, 1.0, flatIntensity_, 0.0, 1.0, 0.5, intensity);
        return intensity;
    }

    public static int getLightedPixel(double alpha, float[] hls, double light) {
        int i2;
        double baseAlpha;
        double[][] layers = new double[][]{new double[0], new double[0], new double[0]};
        double colorAlpha = alpha * alpha;
        double bwAlpha = Math.abs(MathFunctions.smooth(0.0, 1.0, 0.5, -1.0, 1.0, 0.0, light));
        double d2 = baseAlpha = colorAlpha < 1.0 ? (alpha - colorAlpha) / (1.0 - colorAlpha) : 0.0;
        if (baseAlpha > 0.0) {
            float[] rgb = hlsColorSpace_.toRGB(hls);
            layers[0] = new double[]{baseAlpha, (double)rgb[0] * baseAlpha, (double)rgb[1] * baseAlpha, (double)rgb[2] * baseAlpha};
        }
        if (bwAlpha > 0.0) {
            double bwValue = light > 0.5 ? 1.0 : 0.0;
            layers[1] = new double[]{bwAlpha, bwValue * bwAlpha, bwValue * bwAlpha, bwValue * bwAlpha};
        }
        if (colorAlpha > 0.0) {
            double l2 = MathFunctions.smooth(0.0, 1.0, 0.5, MIN_SHADOW, MAX_HILITE, hls[1], light);
            float[] rgb = hlsColorSpace_.toRGB(new float[]{hls[0], (float)l2, hls[2]});
            layers[2] = new double[]{colorAlpha, (double)rgb[0] * colorAlpha, (double)rgb[1] * colorAlpha, (double)rgb[2] * colorAlpha};
        }
        double[] composite = new double[4];
        for (i2 = 0; i2 < layers.length; ++i2) {
            for (int j2 = 0; j2 < layers[i2].length; ++j2) {
                composite[j2] = layers[i2][j2] + composite[j2] * (1.0 - layers[i2][0]);
            }
        }
        i2 = 1;
        while (composite[0] > 0.0 && i2 < composite.length) {
            int n2 = i2++;
            composite[n2] = composite[n2] / composite[0];
        }
        return Math.max(0, Math.min(255, (int)Math.round(composite[0] * 255.0))) << 24 | Math.max(0, Math.min(255, (int)Math.round(composite[1] * 255.0))) << 16 | Math.max(0, Math.min(255, (int)Math.round(composite[2] * 255.0))) << 8 | Math.max(0, Math.min(255, (int)Math.round(composite[3] * 255.0))) << 0;
    }

    public static double getIntensity(double[] normal) {
        int i2;
        RenderedShapeFactory.getLights();
        double[] viewer = new double[]{0.0, 0.0, 1.0};
        double intensity = ambient_;
        for (i2 = 0; i2 < diffuse_.length; ++i2) {
            double dot = RenderedShapeFactory.dot(normal, diffuse_[i2]);
            double max = Math.max(0.0, dot);
            intensity += diffuse_[i2][3] * max;
        }
        for (i2 = 0; i2 < specular_.length; ++i2) {
            double[] ref = RenderedShapeFactory.reflect(specular_[i2], normal);
            double dot = RenderedShapeFactory.dot(ref, viewer);
            double max = Math.max(0.0, dot);
            double pow = Math.pow(max, specular_[i2][4]);
            intensity += specular_[i2][3] * pow;
        }
        return intensity;
    }

    public static double[] getSphericalNormal(double[] distanceAngle, EdgeProfile edgeProfile) {
        return new double[]{edgeProfile.getSlope(distanceAngle[0]), distanceAngle[1]};
    }

    public static double[] getDistanceAngle(Object outline, Point2D.Double xy, boolean inside, double limit, int[] startSeg) {
        if (outline instanceof Line2D.Double[]) {
            return RenderedShapeFactory.getDistanceAngle((Line2D.Double[])outline, xy, inside, limit, startSeg);
        }
        return null;
    }

    public static double[] getDistanceAngle(Line2D.Double[] segments, Point2D.Double xy, boolean inside, double limit, int[] startSeg) {
        double distance;
        int segment;
        int segment1 = -1;
        int segment2 = -1;
        double distance1 = Double.POSITIVE_INFINITY;
        double distance2 = Double.POSITIVE_INFINITY;
        double angle = 0.0;
        int start = startSeg[0] < 0 ? Arrays.binarySearch(segments, xy, segmentComparator_) : startSeg[0];
        logger_.log(Level.FINEST, "binarySearch Segments:{0} Start:{1}", new String[]{"" + segments.length, "" + start});
        if (start < 0) {
            start = Math.abs(start + 1);
        }
        for (segment = start; segment < segments.length && !(segments[segment].x1 - xy.x - MAX_SEG > limit) && !(segments[segment].x1 - xy.x - MAX_SEG > distance1); ++segment) {
            double d2;
            if (xy.x - segments[segment].x1 - MAX_SEG > distance1 || xy.y - segments[segment].y1 - MAX_SEG > distance1 || segments[segment].y1 - xy.y - MAX_SEG > distance1) continue;
            distance = segments[segment].ptSegDist(xy);
            if (!(d2 <= distance1 + 1.0E-4)) continue;
            segment2 = segment1;
            segment1 = segment;
            distance2 = distance1;
            distance1 = distance;
        }
        for (segment = start - 1; segment >= 0 && !(xy.x - segments[segment].x1 - MAX_SEG > limit) && !(xy.x - segments[segment].x1 - MAX_SEG > distance1); --segment) {
            double d3;
            if (segments[segment].x1 - xy.x - MAX_SEG > distance1 || xy.y - segments[segment].y1 - MAX_SEG > distance1 || segments[segment].y1 - xy.y - MAX_SEG > distance1) continue;
            distance = segments[segment].ptSegDist(xy);
            if (!(d3 <= distance1 + 1.0E-4)) continue;
            segment2 = segment1;
            segment1 = segment;
            distance2 = distance1;
            distance1 = distance;
        }
        if (segment1 == -1) {
            return new double[]{(limit + 1.0) * (double)(inside ? 1 : -1), 0.0};
        }
        if (segment2 > -1 && distance1 > segments[segment1].ptLineDist(xy) + 1.0E-4) {
            if (segments[segment1].ptLineDist(xy) < segments[segment2].ptLineDist(xy)) {
                segment1 = segment2;
            }
            distance1 = segments[segment1].ptLineDist(xy);
        }
        double deltaX = segments[segment1].getX2() - segments[segment1].getX1();
        double deltaY = segments[segment1].getY2() - segments[segment1].getY1();
        distance = distance1 * (double)(inside ? 1 : -1);
        int direction = segments[segment1].relativeCCW(xy);
        if (segment1 != -1) {
            angle = Math.atan2(deltaX * (double)(inside ? direction : -direction), deltaY * (double)(inside ? -direction : direction));
        }
        startSeg[0] = segment1;
        return new double[]{distance, angle};
    }

    public static Object getOutline(Shape shape, double flatness) {
        long t0 = System.currentTimeMillis();
        PathIterator pi = shape.getPathIterator(null, flatness);
        Vector v2 = new Vector();
        Point2D.Double first = null;
        Point2D.Double current = null;
        Point2D.Double last = null;
        while (!pi.isDone()) {
            double[] co = new double[6];
            switch (pi.currentSegment(co)) {
                case 0: {
                    first = last = (current = new Point2D.Double(co[0], co[1]));
                    break;
                }
                case 1: {
                    current = new Point2D.Double(co[0], co[1]);
                    Line2D.Double segment = new Line2D.Double(last, current);
                    if (!segment.getP1().equals(segment.getP2())) {
                        RenderedShapeFactory.addSegment(segment, v2);
                    }
                    last = current;
                    break;
                }
                case 4: {
                    Line2D.Double segment = new Line2D.Double(last, first);
                    if (segment.getP1().equals(segment.getP2())) break;
                    RenderedShapeFactory.addSegment(segment, v2);
                    break;
                }
            }
            pi.next();
        }
        Object[] segments = new Line2D.Double[v2.size()];
        v2.copyInto(segments);
        Arrays.sort(segments, new Comparator(){

            public int compare(Object o1, Object o2) {
                double x1 = ((Line2D.Double)o1).x1;
                double x2 = ((Line2D.Double)o2).x1;
                if (x1 < x2) {
                    return -1;
                }
                if (x1 > x2) {
                    return 1;
                }
                return 0;
            }
        });
        logger_.log(Level.FINEST, "Segments:{0} Compute Time:{1}", new String[]{"" + segments.length, "" + (System.currentTimeMillis() - t0)});
        return segments;
    }

    private static void addSegment(Line2D.Double segment, Vector v2) {
        Rectangle bounds = segment.getBounds();
        if (Math.abs(segment.x1 - segment.x2) < MAX_SEG && Math.abs(segment.y1 - segment.y2) < MAX_SEG) {
            v2.addElement(segment);
            return;
        }
        double x1 = segment.getX1();
        double y1 = segment.getY1();
        double x2 = segment.getX2();
        double y2 = segment.getY2();
        double xM = (x1 + x2) / 2.0;
        double yM = (y1 + y2) / 2.0;
        RenderedShapeFactory.addSegment(new Line2D.Double(x1, y1, xM, yM), v2);
        RenderedShapeFactory.addSegment(new Line2D.Double(xM, yM, x2, y2), v2);
    }

    public static void setLights(double[][] lights) {
        UIManager.put("ptk.lights", lights);
        lights_ = null;
    }

    public static double[][] getLights() {
        Object object;
        if (lights_ != null) {
            return lights_;
        }
        Object ptk_lights = UIManager.get("ptk.lights");
        if (ptk_lights instanceof double[][]) {
            object = (double[][])ptk_lights;
        } else {
            double[][] dArrayArray = new double[3][];
            dArrayArray[0] = new double[]{0.2, 0.0, 90.0};
            dArrayArray[1] = new double[]{0.45, 270.0, 15.0, 0.2, 2.0};
            object = dArrayArray;
            dArrayArray[2] = new double[]{0.45, 360.0, 15.0, 0.2, 2.0};
        }
        double[][] lights = object;
        int diffuseCount = 0;
        int specularCount = 0;
        for (int i2 = 0; i2 < lights.length; ++i2) {
            if (lights[i2].length == 3 || lights[i2].length == 5 && lights[i2][3] < 1.0) {
                ++diffuseCount;
            }
            if (lights[i2].length != 5) continue;
            ++specularCount;
        }
        double ambient = 0.0;
        double[][] diffuse = new double[diffuseCount][];
        double[][] specular = new double[specularCount][];
        diffuseCount = 0;
        specularCount = 0;
        for (int i3 = 0; i3 < lights.length; ++i3) {
            double specularPower;
            if (lights[i3].length == 1) {
                ambient += lights[i3][0];
            }
            if (lights[i3].length != 3 && lights[i3].length != 5) continue;
            double xyAngle = (lights[i3][1] + 270.0) * 2.0 * Math.PI / 360.0;
            double zAngle = lights[i3][2] * 2.0 * Math.PI / 360.0;
            double z2 = Math.sin(zAngle);
            double x2 = Math.cos(zAngle) * Math.sin(xyAngle);
            double y2 = Math.cos(zAngle) * Math.cos(xyAngle);
            double diffuseMagnitude = lights[i3][0] * (lights[i3].length == 3 ? 1.0 : 1.0 - lights[i3][3]);
            double specularMagnitude = lights[i3][0] * (lights[i3].length == 3 ? 0.0 : lights[i3][3]);
            double d2 = specularPower = lights[i3].length == 3 ? 0.0 : Math.pow(2.0, lights[i3][4]);
            if (lights[i3].length == 3 || lights[i3][3] < 1.0) {
                diffuse[diffuseCount++] = new double[]{x2, y2, z2, diffuseMagnitude};
            }
            if (lights[i3].length != 5) continue;
            specular[specularCount++] = new double[]{x2, y2, z2, specularMagnitude, specularPower};
        }
        ambient_ = ambient;
        diffuse_ = diffuse;
        specular_ = specular;
        lights_ = lights;
        return lights;
    }

    public static double[] sphericalToXYZ(double[] spherical) {
        double slope = spherical[0];
        double angle = spherical[1];
        double x2 = Math.sin(angle);
        double y2 = Math.cos(angle);
        double z2 = 1.0 - Math.abs(slope);
        double xyMagnitude = Math.sqrt(1.0 - z2 * z2) * (slope >= 0.0 ? 1.0 : -1.0);
        return new double[]{x2 * xyMagnitude, y2 * xyMagnitude, z2};
    }

    public static double dot(double[] a2, double[] b2) {
        double dot = 0.0;
        for (int i2 = 0; i2 < 3; ++i2) {
            dot += a2[i2] * b2[i2];
        }
        return dot;
    }

    public static double[] reflect(double[] incident, double[] normal) {
        double normal_dot_incident = RenderedShapeFactory.dot(normal, incident);
        double[] reflect = new double[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            reflect[i2] = 2.0 * normal_dot_incident * normal[i2] - incident[i2];
        }
        return reflect;
    }

    static {
        MAX_HILITE = 1.0;
        MIN_SHADOW = 0.0;
        try {
            if (System.getProperty("ptk.contrast") != null) {
                double contrast = (double)Integer.getInteger("ptk.contrast", 100).intValue() / 100.0;
                contrast = Math.min(Math.max(contrast, 0.0), 1.0);
                double lightness = (double)Integer.getInteger("ptk.lightness", 50).intValue() / 100.0;
                lightness = Math.min(Math.max(lightness, 0.0), 1.0);
                MAX_HILITE = 1.0 * (contrast *= 1.2) + lightness * (1.0 - contrast);
                MIN_SHADOW = 0.0 * contrast + lightness * (1.0 - contrast);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class CacheEntry
    implements Externalizable {
        public BufferedImage image_;
        public transient int use_ = 0;
        public transient int cost_ = 0;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.image_.getWidth());
            out.writeInt(this.image_.getHeight());
            out.writeInt(this.image_.getType());
            out.writeObject(this.image_.getRGB(0, 0, this.image_.getWidth(), this.image_.getHeight(), null, 0, this.image_.getWidth()));
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.image_ = new BufferedImage(in.readInt(), in.readInt(), in.readInt());
            this.image_.setRGB(0, 0, this.image_.getWidth(), this.image_.getHeight(), (int[])in.readObject(), 0, this.image_.getWidth());
        }
    }
}

