/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.laf.Utilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class ContextualProperty {
    protected static Logger logger_ = Logger.getLogger(ContextualProperty.class.getName());
    protected static Resolver defaultResolver_;
    protected static Set installedContextualDefaults_;

    public static Resolver getDefaultResolver() {
        return defaultResolver_ != null ? defaultResolver_ : (defaultResolver_ = new PtkScaleResolver());
    }

    public static void setDefaultResolver(Resolver resolver) {
        defaultResolver_ = resolver;
    }

    public static void setPreferredSize(JComponent c2, Dimension d2) {
        c2.putClientProperty(ContextualProperty.class.getName() + ".preferredSize", d2);
        c2.setPreferredSize(d2.resolve());
    }

    public static void setMinimumSize(JComponent c2, Dimension d2) {
        c2.putClientProperty(ContextualProperty.class.getName() + ".minimumSize", d2);
        c2.setMinimumSize(d2.resolve());
    }

    public static void setMaximumSize(JComponent c2, Dimension d2) {
        c2.putClientProperty(ContextualProperty.class.getName() + ".maximumSize", d2);
        c2.setMaximumSize(d2.resolve());
    }

    public static void updateComponentTreeUI(Component component) {
        ContextualProperty.updateComponentTreeUI0(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void updateComponentTreeUI0(Component component) {
        if (component instanceof JComponent) {
            Object d2;
            JComponent c2 = (JComponent)component;
            ContextualProperty.setContext(c2);
            if (c2.getFont() instanceof Font) {
                c2.setFont(((Font)c2.getFont()).resolve());
            }
            if (c2.getBorder() instanceof Border) {
                c2.setBorder(((Border)c2.getBorder()).resolve());
            }
            if (c2.isPreferredSizeSet() && (d2 = c2.getClientProperty(ContextualProperty.class.getName() + ".preferredSize")) instanceof Dimension) {
                c2.setPreferredSize(((Dimension)d2).resolve());
            }
            if (c2.isMinimumSizeSet() && (d2 = c2.getClientProperty(ContextualProperty.class.getName() + ".minimumSize")) instanceof Dimension) {
                c2.setMinimumSize(((Dimension)d2).resolve());
            }
            if (c2.isMaximumSizeSet() && (d2 = c2.getClientProperty(ContextualProperty.class.getName() + ".maximumSize")) instanceof Dimension) {
                c2.setMaximumSize(((Dimension)d2).resolve());
            }
            if (c2 instanceof JTextComponent && ((JTextComponent)c2).getMargin() instanceof Insets) {
                ((JTextComponent)c2).setMargin(((Insets)((JTextComponent)c2).getMargin()).resolve());
            }
            if (c2 instanceof AbstractButton && ((AbstractButton)c2).getMargin() instanceof Insets) {
                ((AbstractButton)c2).setMargin(((Insets)((AbstractButton)c2).getMargin()).resolve());
            }
            if (c2 instanceof AbstractButton && ((AbstractButton)c2).getIcon() instanceof Icon) {
                ((AbstractButton)c2).setIcon(((Icon)((AbstractButton)c2).getIcon()).resolve());
            }
            if (c2 instanceof AbstractButton && ((AbstractButton)c2).getRolloverIcon() instanceof Icon) {
                ((AbstractButton)c2).setRolloverIcon(((Icon)((AbstractButton)c2).getRolloverIcon()).resolve());
            }
            if (c2 instanceof AbstractButton && ((AbstractButton)c2).getPressedIcon() instanceof Icon) {
                ((AbstractButton)c2).setPressedIcon(((Icon)((AbstractButton)c2).getPressedIcon()).resolve());
            }
            if (c2 instanceof AbstractButton && ((AbstractButton)c2).getSelectedIcon() instanceof Icon) {
                ((AbstractButton)c2).setSelectedIcon(((Icon)((AbstractButton)c2).getSelectedIcon()).resolve());
            }
            if (c2 instanceof AbstractButton && ((AbstractButton)c2).getRolloverSelectedIcon() instanceof Icon) {
                ((AbstractButton)c2).setRolloverSelectedIcon(((Icon)((AbstractButton)c2).getRolloverSelectedIcon()).resolve());
            }
            if (c2 instanceof AbstractButton && ((AbstractButton)c2).getDisabledIcon() instanceof Icon) {
                ((AbstractButton)c2).setDisabledIcon(((Icon)((AbstractButton)c2).getDisabledIcon()).resolve());
            }
            if (c2 instanceof JLabel && ((JLabel)c2).getIcon() instanceof Icon) {
                ((JLabel)c2).setIcon(((Icon)((JLabel)c2).getIcon()).resolve());
            }
            c2.updateUI();
            ContextualProperty.setContext(null);
        }
        Component[] children = null;
        if (component instanceof JMenu) {
            children = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            children = ((Container)component).getComponents();
        }
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                ContextualProperty.updateComponentTreeUI0(children[i2]);
            }
        }
    }

    public static void setContext(Object context) {
        UIManager.put("ContextualProperty.context", context);
    }

    public static Object getContext() {
        return UIManager.get("ContextualProperty.context");
    }

    public static void installSmartDefaults() {
        ContextualProperty.installContextualDefaults();
    }

    public static void installContextualDefaults() {
        long t0 = System.currentTimeMillis();
        ContextualProperty.installContextualDefaults2(UIManager.getLookAndFeelDefaults());
        System.out.println("=============================== " + (System.currentTimeMillis() - t0));
    }

    public static void installSmartDefaults(String[] keys) {
        ContextualProperty.installContextualDefaults(keys);
    }

    public static void installContextualDefaults(String[] keys) {
        long t0 = System.currentTimeMillis();
        ContextualProperty.installSmartDefaults(UIManager.getLookAndFeelDefaults(), keys);
        System.out.println("=============================== " + (System.currentTimeMillis() - t0));
    }

    public static void installSmartDefaults(UIDefaults table, String[] keys) {
        ContextualProperty.installContextualDefaults(table, keys);
    }

    public static void installContextualDefaults(UIDefaults table, String[] keys) {
        for (int i2 = 0; i2 < keys.length; ++i2) {
            UIManager.put(keys[i2], new ActiveValue(keys[i2]));
        }
    }

    public static void installContextualDefaults2(UIDefaults table) {
        Enumeration e2 = table.keys();
        while (e2.hasMoreElements()) {
            Object key = e2.nextElement();
            if (installedContextualDefaults_.contains(key) || !installedContextualDefaults_.add(key)) continue;
            UIManager.put(key, new ActiveValue(key));
        }
    }

    public static void installContextualDefaults3(UIDefaults table) {
        Enumeration e2 = table.keys();
        while (e2.hasMoreElements()) {
            Object key = e2.nextElement();
            Object value = table.get(key);
            if (!(value instanceof java.awt.Font) && !(value instanceof javax.swing.border.Border) && !(value instanceof java.awt.Insets) && !(value instanceof Integer)) continue;
            UIManager.put(key, new ActiveValue(key));
        }
    }

    static {
        installedContextualDefaults_ = new HashSet();
    }

    public static class PtkScaleResolver
    extends AbstractResolver {
        @Override
        public Object resolve(Object rawValue, Object context) {
            try {
                return this.scaleToScreen(rawValue, (JComponent)context, this.getScreen((JComponent)context));
            }
            catch (Exception ex) {
                logger_.log(Level.WARNING, "" + ex, ex);
                return rawValue;
            }
        }

        public int getScreen(JComponent component) {
            int i2;
            Rectangle bounds;
            Window window;
            if (component == null || (window = SwingUtilities.getWindowAncestor(component)) == null || (bounds = window.getBounds()) == null) {
                return this.getDefaultScreen();
            }
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            for (i2 = 0; i2 < devices.length; ++i2) {
                if (!devices[i2].getDefaultConfiguration().getBounds().contains(bounds.getLocation())) continue;
                return i2;
            }
            for (i2 = 0; i2 < devices.length; ++i2) {
                if (!devices[i2].getDefaultConfiguration().getBounds().intersects(bounds)) continue;
                return i2;
            }
            return this.getDefaultScreen();
        }

        public int getDefaultScreen() {
            return 0;
        }

        public Object scaleToScreen(Object rawValue, JComponent component, int screen) {
            if (rawValue instanceof double[]) {
                double[] d2 = (double[])rawValue;
                double[] dd = new double[d2.length];
                for (int i2 = 0; i2 < d2.length; ++i2) {
                    dd[i2] = Utilities.monitor(d2[i2], screen);
                }
                return dd;
            }
            if (rawValue instanceof Integer) {
                Integer i3 = (Integer)rawValue;
                return new Integer(Utilities.monitor((int)i3, screen));
            }
            if (rawValue instanceof Double) {
                Double d3 = (Double)rawValue;
                return new Double(Utilities.monitor(d3, screen));
            }
            if (rawValue instanceof Number) {
                Number n2 = (Number)rawValue;
                return new Double(Utilities.monitor(n2.doubleValue(), screen));
            }
            if (rawValue instanceof java.awt.Dimension) {
                java.awt.Dimension d4 = (java.awt.Dimension)rawValue;
                return Utilities.monitor(d4, screen);
            }
            if (rawValue instanceof java.awt.Insets) {
                java.awt.Insets i4 = (java.awt.Insets)rawValue;
                return Utilities.monitor(i4, screen);
            }
            if (rawValue instanceof java.awt.Font) {
                java.awt.Font f2 = (java.awt.Font)rawValue;
                return f2.deriveFont((float)Utilities.monitor(f2.getSize2D(), screen));
            }
            if (rawValue instanceof javax.swing.border.Border) {
                double factor = Utilities.monitor(1.0, screen);
                return this.getScaledBorder((javax.swing.border.Border)rawValue, component, factor);
            }
            if (rawValue instanceof javax.swing.Icon) {
                double factor = Utilities.monitor(1.0, screen);
                return this.getScaledIcon((javax.swing.Icon)rawValue, component, factor);
            }
            return rawValue;
        }
    }

    public static abstract class AbstractResolver
    implements Resolver {
        @Override
        public Object resolve(Object rawValue, Object context, boolean uiResource) {
            Object v2 = this.resolve(rawValue, context);
            if (!uiResource || v2 instanceof UIResource) {
                return v2;
            }
            if (v2 instanceof java.awt.Font) {
                return new FontUIResource((java.awt.Font)v2);
            }
            if (v2 instanceof javax.swing.border.Border) {
                return new BorderUIResource((javax.swing.border.Border)v2);
            }
            if (v2 instanceof java.awt.Insets) {
                return new InsetsUIResource(((java.awt.Insets)v2).top, ((java.awt.Insets)v2).left, ((java.awt.Insets)v2).bottom, ((java.awt.Insets)v2).right);
            }
            return v2;
        }

        public abstract Object resolve(Object var1, Object var2);

        protected javax.swing.border.Border getScaledBorder(javax.swing.border.Border border, JComponent component, double scale) {
            if (border instanceof CuiBorder) {
                CuiBorder cb = (CuiBorder)border;
                double[] r2 = cb.getCornerRadii();
                java.awt.Insets m2 = cb.getMinimumMargin();
                return border instanceof UIResource ? new CuiBorder.UIResource(cb.getInteriorEdge() * scale, cb.getExteriorEdge() * scale, new double[]{r2[0] * scale, r2[1] * scale, r2[2] * scale, r2[3] * scale}, cb.getInteriorEdgeVisible(), cb.getExteriorEdgeVisible(), new java.awt.Insets((int)Math.ceil((double)m2.top * scale), (int)Math.ceil((double)m2.left * scale), (int)Math.ceil((double)m2.bottom * scale), (int)Math.ceil((double)m2.right * scale)), cb.getInsetRule()) : new CuiBorder.UIResource(cb.getInteriorEdge() * scale, cb.getExteriorEdge() * scale, new double[]{r2[0] * scale, r2[1] * scale, r2[2] * scale, r2[3] * scale}, cb.getInteriorEdgeVisible(), cb.getExteriorEdgeVisible(), new java.awt.Insets((int)Math.ceil((double)m2.top * scale), (int)Math.ceil((double)m2.left * scale), (int)Math.ceil((double)m2.bottom * scale), (int)Math.ceil((double)m2.right * scale)), cb.getInsetRule());
            }
            if (border instanceof CompoundBorder) {
                return new CompoundBorder(this.getScaledBorder(((CompoundBorder)border).getOutsideBorder(), component, scale), this.getScaledBorder(((CompoundBorder)border).getInsideBorder(), component, scale));
            }
            if (border instanceof MatteBorder) {
                java.awt.Insets i2 = border.getBorderInsets(component);
                return new MatteBorder((int)Math.ceil((double)i2.top * scale), (int)Math.ceil((double)i2.left * scale), (int)Math.ceil((double)i2.bottom * scale), (int)Math.ceil((double)i2.right * scale), ((MatteBorder)border).getMatteColor());
            }
            if (border instanceof EmptyBorder) {
                java.awt.Insets i3 = border.getBorderInsets(component);
                return new EmptyBorder((int)Math.ceil((double)i3.top * scale), (int)Math.ceil((double)i3.left * scale), (int)Math.ceil((double)i3.bottom * scale), (int)Math.ceil((double)i3.right * scale));
            }
            return border;
        }

        protected javax.swing.Icon getScaledIcon(javax.swing.Icon icon, JComponent component, double scale) {
            return new ScaledIcon(icon, scale);
        }

        public static class ScaledIcon
        implements javax.swing.Icon {
            protected javax.swing.Icon raw_;
            protected double scale_;

            public ScaledIcon(javax.swing.Icon raw, double scale) {
                this.raw_ = raw;
                this.scale_ = scale;
            }

            @Override
            public int getIconWidth() {
                return (int)Math.round(this.scale_ * (double)this.raw_.getIconWidth());
            }

            @Override
            public int getIconHeight() {
                return (int)Math.round(this.scale_ * (double)this.raw_.getIconHeight());
            }

            @Override
            public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
                if (this.getIconWidth() < 1 || this.getIconHeight() < 1) {
                    return;
                }
                BufferedImage rawImage_ = new BufferedImage(this.raw_.getIconWidth(), this.raw_.getIconHeight(), 2);
                Graphics2D rawGraphics = rawImage_.createGraphics();
                this.raw_.paintIcon(c2, rawGraphics, 0, 0);
                g2.drawImage(rawImage_, x2, y2, this.getIconWidth(), this.getIconHeight(), null);
            }
        }
    }

    public static interface Resolver {
        public Object resolve(Object var1, Object var2, boolean var3);
    }

    public static class Icon
    implements javax.swing.Icon {
        protected javax.swing.Icon rawValue_;
        protected javax.swing.Icon resolvedValue_;
        protected Resolver resolver_;

        public javax.swing.Icon getRawValue() {
            return this.rawValue_;
        }

        public Icon(javax.swing.Icon rawValue) {
            this(rawValue, null);
        }

        public Icon(javax.swing.Icon rawValue, Resolver resolver) {
            this((javax.swing.Icon)(resolver != null ? resolver : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), false), rawValue, resolver);
        }

        protected Icon(javax.swing.Icon resolvedValue, javax.swing.Icon rawValue, Resolver resolver) {
            this.resolvedValue_ = resolvedValue;
            this.rawValue_ = rawValue;
            this.resolver_ = resolver;
        }

        public Icon resolve() {
            return new Icon(this.rawValue_, this.resolver_);
        }

        @Override
        public int getIconWidth() {
            return this.resolvedValue_.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.resolvedValue_.getIconHeight();
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            this.resolvedValue_.paintIcon(c2, g2, x2, y2);
        }
    }

    public static class Border
    implements javax.swing.border.Border {
        protected javax.swing.border.Border rawValue_;
        protected javax.swing.border.Border resolvedValue_;
        protected Resolver resolver_;

        public javax.swing.border.Border getRawValue() {
            return this.rawValue_;
        }

        public Border(javax.swing.border.Border rawValue) {
            this(rawValue, null);
        }

        public Border(javax.swing.border.Border rawValue, Resolver resolver) {
            this((javax.swing.border.Border)(resolver != null ? resolver : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), false), rawValue, resolver);
        }

        protected Border(javax.swing.border.Border resolvedValue, javax.swing.border.Border rawValue, Resolver resolver) {
            this.resolvedValue_ = resolvedValue;
            this.rawValue_ = rawValue;
            this.resolver_ = resolver;
        }

        public Border resolve() {
            return new Border(this.rawValue_, this.resolver_);
        }

        @Override
        public java.awt.Insets getBorderInsets(Component c2) {
            return this.resolvedValue_.getBorderInsets(c2);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.resolvedValue_.isBorderOpaque();
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            this.resolvedValue_.paintBorder(c2, g2, x2, y2, w2, h2);
        }
    }

    public static class Dimension
    extends java.awt.Dimension {
        protected java.awt.Dimension rawValue_;
        protected Resolver resolver_;

        public java.awt.Dimension getRawValue() {
            return this.rawValue_;
        }

        public Dimension(java.awt.Dimension rawValue) {
            this(rawValue, null);
        }

        public Dimension(java.awt.Dimension rawValue, Resolver resolver) {
            this((java.awt.Dimension)(resolver != null ? resolver : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), false), rawValue, resolver);
        }

        protected Dimension(java.awt.Dimension resolvedValue, java.awt.Dimension rawValue, Resolver resolver) {
            super(resolvedValue.width, resolvedValue.height);
            this.rawValue_ = rawValue;
            this.resolver_ = resolver;
        }

        public Dimension resolve() {
            return new Dimension(this.rawValue_, this.resolver_);
        }
    }

    public static class Insets
    extends java.awt.Insets {
        protected java.awt.Insets rawValue_;
        protected Resolver resolver_;

        public java.awt.Insets getRawValue() {
            return this.rawValue_;
        }

        public Insets(java.awt.Insets rawValue) {
            this(rawValue, null);
        }

        public Insets(java.awt.Insets rawValue, Resolver resolver) {
            this((java.awt.Insets)(resolver != null ? resolver : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), false), rawValue, resolver);
        }

        protected Insets(java.awt.Insets resolvedValue, java.awt.Insets rawValue, Resolver resolver) {
            super(resolvedValue.top, resolvedValue.left, resolvedValue.bottom, resolvedValue.right);
            this.rawValue_ = rawValue;
            this.resolver_ = resolver;
        }

        public Insets resolve() {
            return new Insets(this.rawValue_, this.resolver_);
        }
    }

    public static class Font
    extends java.awt.Font {
        protected java.awt.Font rawValue_;
        protected Resolver resolver_;

        public java.awt.Font getRawValue() {
            return this.rawValue_;
        }

        public Font(java.awt.Font rawValue) {
            this(rawValue, null);
        }

        public Font(java.awt.Font rawValue, Resolver resolver) {
            this((java.awt.Font)(resolver != null ? resolver : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), false), rawValue, resolver);
        }

        protected Font(java.awt.Font resolvedValue, java.awt.Font rawValue, Resolver resolver) {
            this(resolvedValue.getName(), resolvedValue.getStyle(), resolvedValue.getSize(), rawValue, resolver);
        }

        protected Font(String name, int style, int size, java.awt.Font rawValue, Resolver resolver) {
            super(name, style, size);
            this.rawValue_ = rawValue;
            this.resolver_ = resolver;
        }

        public Font resolve() {
            return new Font(this.rawValue_, this.resolver_);
        }
    }

    public static class ActiveValue
    implements UIDefaults.ActiveValue {
        protected Object key_;
        protected Resolver resolver_;

        public ActiveValue(Object key) {
            this(key, null);
        }

        public ActiveValue(Object key, Resolver resolver) {
            this.key_ = key;
            this.resolver_ = resolver;
        }

        @Override
        public Object createValue(UIDefaults table) {
            Object rawValue = UIManager.getLookAndFeelDefaults().get(this.key_);
            if (Boolean.TRUE.equals(UIManager.getLookAndFeelDefaults().get(this.key_ + ".contextual"))) {
                return rawValue;
            }
            return (this.resolver_ != null ? this.resolver_ : ContextualProperty.getDefaultResolver()).resolve(rawValue, ContextualProperty.getContext(), true);
        }
    }
}

