/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.NamedShape;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.text.JTextComponent;

public class CuiComboBoxUI
extends BasicComboBoxUI {
    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c2) {
        return new CuiComboBoxUI();
    }

    @Override
    public void installUI(JComponent c2) {
        this.currentValuePane = new CellRendererPane(){

            @Override
            public boolean isOpaque() {
                return CuiComboBoxUI.this.comboBox.isOpaque();
            }

            @Override
            public Color getBackground() {
                return CuiComboBoxUI.this.comboBox.getBackground();
            }

            @Override
            public boolean isFocusTraversable() {
                return true;
            }

            @Override
            public void paintComponent(Graphics g2, Component c2, Container p2, int x2, int y2, int w2, int h2, boolean shouldValidate) {
                Border border = Utilities.getUIPropertyBorder(CuiComboBoxUI.this.comboBox, "ComboBox.text.border");
                if (border == null) {
                    border = new EmptyBorder(0, 0, 0, 0);
                }
                Insets borderInsets = border.getBorderInsets(c2);
                Insets margin = Utilities.getUIPropertyInsets(CuiComboBoxUI.this.comboBox, "ComboBox.text.margin");
                if (margin == null) {
                    margin = new Insets(0, 0, 0, 0);
                }
                Insets softInsets = border instanceof CuiBorder ? ((CuiBorder)border).getSoftInsets(null) : new Insets(0, 0, 0, 0);
                Insets insets = new Insets(borderInsets.top + (margin.top - softInsets.top), borderInsets.left + (margin.left - softInsets.left), borderInsets.bottom + (margin.bottom - softInsets.bottom), borderInsets.right + (margin.right - softInsets.right));
                if (c2 != null && (c2.isOpaque() || c2.getBackground() != null && c2.getBackground().getAlpha() < 255)) {
                    g2.setColor(c2.getBackground());
                    g2.fillRect(x2 + borderInsets.left, y2 + borderInsets.top, w2 - (borderInsets.left + borderInsets.right), margin.top);
                    g2.fillRect(x2 + borderInsets.left, y2 + h2 - insets.bottom, w2 - (borderInsets.left + borderInsets.right), margin.bottom);
                    g2.fillRect(x2 + borderInsets.left, y2 + insets.top, margin.left, h2 - (insets.top + insets.bottom));
                    g2.fillRect(x2 + w2 - insets.right, y2 + insets.top, margin.right, h2 - (insets.top + insets.bottom));
                }
                super.paintComponent(g2, c2, p2, x2 + insets.left, y2 + insets.top, w2 - (insets.left + insets.right), h2 - (insets.top + insets.bottom), shouldValidate);
                border.paintBorder(c2, g2, x2, y2, w2, h2);
            }
        };
        super.installUI(c2);
        this.comboBox.setOpaque(false);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension pref = super.getPreferredSize(c2);
        if (pref.height % 2 != 0) {
            ++pref.height;
        }
        Dimension min = (Dimension)UIManager.get("ComboBox.minimumSize");
        Dimension max = (Dimension)UIManager.get("ComboBox.maximumSize");
        if (max != null) {
            pref.setSize(Math.min(max.width, pref.width), Math.min(max.height, pref.height));
        }
        if (min != null) {
            pref.setSize(Math.max(min.width, pref.width), Math.max(min.height, pref.height));
        }
        return pref;
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Utilities.antiAlias((Graphics2D)g2);
        super.paint(g2, c2);
    }

    @Override
    public void paintCurrentValueBackground(Graphics g2, Rectangle bounds, boolean hasFocus) {
    }

    @Override
    public void paintCurrentValue(Graphics g2, Rectangle bounds, boolean hasFocus) {
        super.paintCurrentValue(g2, bounds, false);
    }

    @Override
    protected Dimension getDisplaySize() {
        Dimension size = super.getDisplaySize();
        if (this.comboBox.isEditable()) {
            return size;
        }
        try {
            Insets insets;
            Border border = Utilities.getUIPropertyBorder(this.comboBox, "ComboBox.text.border");
            if (border == null) {
                border = new EmptyBorder(0, 0, 0, 0);
            }
            try {
                insets = border.getBorderInsets(null);
            }
            catch (Exception ex) {
                insets = new Insets(0, 0, 0, 0);
            }
            Insets margin = Utilities.getUIPropertyInsets(this.comboBox, "ComboBox.text.margin");
            if (margin == null) {
                margin = new Insets(0, 0, 0, 0);
            }
            Insets softInsets = border instanceof CuiBorder ? ((CuiBorder)border).getSoftInsets(null) : new Insets(0, 0, 0, 0);
            insets.top += margin.top - softInsets.top;
            insets.left += margin.left - softInsets.left;
            insets.bottom += margin.bottom - softInsets.bottom;
            insets.right += margin.right - softInsets.right;
            return new Dimension(size.width + (insets.left + insets.right), size.height + (insets.top + insets.bottom));
        }
        catch (Exception ex) {
            return size;
        }
    }

    @Override
    protected Dimension getDefaultSize() {
        Dimension size = super.getDefaultSize();
        if (this.comboBox.isEditable()) {
            return size;
        }
        try {
            Insets insets;
            Border border = Utilities.getUIPropertyBorder(this.comboBox, "ComboBox.text.border");
            if (border == null) {
                border = new EmptyBorder(0, 0, 0, 0);
            }
            try {
                insets = border.getBorderInsets(null);
            }
            catch (Exception ex) {
                insets = new Insets(0, 0, 0, 0);
            }
            Insets margin = Utilities.getUIPropertyInsets(this.comboBox, "ComboBox.text.margin");
            if (margin == null) {
                margin = new Insets(0, 0, 0, 0);
            }
            Insets softInsets = border instanceof CuiBorder ? ((CuiBorder)border).getSoftInsets(null) : new Insets(0, 0, 0, 0);
            insets.top += margin.top - softInsets.top;
            insets.left += margin.left - softInsets.left;
            insets.bottom += margin.bottom - softInsets.bottom;
            insets.right += margin.right - softInsets.right;
            return new Dimension(size.width + (insets.left + insets.right), size.height + (insets.top + insets.bottom));
        }
        catch (Exception ex) {
            return size;
        }
    }

    @Override
    protected JButton createArrowButton() {
        Border border;
        Insets margin;
        JButton button = new JButton(){
            private Icon icon_ = new Icon(){

                private Dimension getSize() {
                    int in = Math.min(this.getWidth(), this.getHeight()) / 4;
                    int h2 = (this.getHeight() - 2 * in) / 2;
                    int w2 = 2 * h2;
                    return new Dimension(w2, h2);
                }

                @Override
                public int getIconWidth() {
                    return this.getSize().width;
                }

                @Override
                public int getIconHeight() {
                    return this.getSize().height;
                }

                @Override
                public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
                    Dimension size = this.getSize();
                    int w2 = size.width;
                    int h2 = size.height;
                    if (size.width <= 0 || size.height <= 0) {
                        return;
                    }
                    float[][] p2 = new float[][]{{0.0f, 0.0f, w2, 0.0f, (float)w2 / 2.0f, h2}};
                    int i2 = 0;
                    String shapeID = "ComboButton[" + i2 + "," + this.getWidth() + "x" + this.getHeight() + "]";
                    Shape shape = (Shape)Utilities.shapeCache_.get(shapeID);
                    if (shape == null) {
                        GeneralPath path = new GeneralPath();
                        path.moveTo(p2[i2][0], p2[i2][1]);
                        path.lineTo(p2[i2][2], p2[i2][3]);
                        path.lineTo(p2[i2][4], p2[i2][5]);
                        path.closePath();
                        shape = new NamedShape(shapeID, path);
                        Utilities.shapeCache_.put(shapeID, shape);
                    }
                    Color interiorColor = !CuiComboBoxUI.this.comboBox.isEnabled() ? UIManager.getColor("P4") : (!this.getModel().isPressed() ? this.getForeground() : this.getBackground());
                    Color exteriorColor = new Color(0, true);
                    BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, null, interiorColor, exteriorColor, null);
                    g2.drawImage(renderedShape, x2, y2, null);
                }
            };

            @Override
            public void updateUI() {
                if (this.getClientProperty("ComboBox.button.uiLock") == null) {
                    super.updateUI();
                }
            }

            @Override
            public Icon getIcon() {
                return this.icon_;
            }
        };
        Color color = Utilities.getUIPropertyColor(this.comboBox, "ComboBox.button.background");
        if (color != null) {
            button.setBackground(color);
        }
        if ((color = Utilities.getUIPropertyColor(this.comboBox, "ComboBox.button.foreground")) != null) {
            button.setForeground(color);
        }
        if ((margin = Utilities.getUIPropertyInsets(this.comboBox, "ComboBox.button.margin")) != null) {
            button.setMargin(margin);
        }
        if ((border = Utilities.getUIPropertyBorder(this.comboBox, "ComboBox.button.border")) != null) {
            button.setBorder(border);
        }
        button.putClientProperty("ComboBox.button.uiLock", Boolean.TRUE);
        this.comboBox.putClientProperty("ComboBox.button", button);
        return button;
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, index >= 0 && isSelected, cellHasFocus);
                this.setOpaque(index >= 0);
                this.setEnabled(CuiComboBoxUI.this.comboBox.isEnabled());
                this.setBorder(new EmptyBorder(0, index >= 0 ? 2 : 0, 0, index >= 0 ? 2 : 0));
                return this;
            }
        };
    }

    @Override
    protected ComboBoxEditor createEditor() {
        MetalComboBoxEditor.UIResource editor = new MetalComboBoxEditor.UIResource();
        Component editorComponent = editor.getEditorComponent();
        Border border = Utilities.getUIPropertyBorder(this.comboBox, "ComboBox.text.border");
        if (editorComponent instanceof JComponent && border != null) {
            ((JComponent)editorComponent).setBorder(border);
        }
        Insets margin = Utilities.getUIPropertyInsets(this.comboBox, "ComboBox.text.margin");
        if (editorComponent instanceof JTextComponent && margin != null) {
            ((JTextComponent)editorComponent).setMargin(margin);
        }
        this.comboBox.putClientProperty("ComboBox.text", editorComponent);
        return editor;
    }

    @Override
    protected ComboPopup createPopup() {
        return new CuiComboPopup(this.comboBox);
    }

    public static class CuiComboPopup
    extends BasicComboPopup {
        public CuiComboPopup(JComboBox comboBox) {
            super(comboBox);
        }

        @Override
        public void setInvoker(Component invoker) {
            Border border = this.getBorder();
            Color background = this.getBackground();
            Color scrollerBackground = this.scroller.getBackground();
            Color listBackground = this.list.getBackground();
            Color listForeground = this.list.getForeground();
            Color listSelectionBackground = this.list.getSelectionBackground();
            Color listSelectionForeground = this.list.getSelectionForeground();
            super.setInvoker(invoker);
            this.setBorder(border);
            this.setBackground(background);
            this.scroller.setBackground(scrollerBackground);
            this.list.setBackground(listBackground);
            this.list.setForeground(listForeground);
            this.list.setSelectionBackground(listSelectionBackground);
            this.list.setSelectionForeground(listSelectionForeground);
            this.invalidate();
        }

        @Override
        public void configureList() {
            super.configureList();
            Color color = Utilities.getUIPropertyColor(this.comboBox, "ComboBox.list.background");
            if (color != null) {
                this.list.setBackground(color);
            }
            if ((color = Utilities.getUIPropertyColor(this.comboBox, "ComboBox.list.foreground")) != null) {
                this.list.setForeground(color);
            }
            if ((color = Utilities.getUIPropertyColor(this.comboBox, "ComboBox.list.selectionBackground")) != null) {
                this.list.setSelectionBackground(color);
            }
            if ((color = Utilities.getUIPropertyColor(this.comboBox, "ComboBox.list.selectionForeground")) != null) {
                this.list.setSelectionForeground(color);
            }
            this.comboBox.putClientProperty("ComboBox.list", this.list);
        }

        @Override
        protected void configureScroller() {
            super.configureScroller();
            Color color = Utilities.getUIPropertyColor(this.comboBox, "ComboBox.popup.background");
            if (color != null) {
                this.setBackground(color != null ? color : this.list.getBackground());
            }
            this.scroller.setBackground(UIManager.getColor("ScrollBar.track"));
            Border border = Utilities.getUIPropertyBorder(this.comboBox, "ComboBox.scrollPane.viewportBorder");
            if (border != null) {
                this.scroller.setViewportBorder(border);
            }
            if ((border = Utilities.getUIPropertyBorder(this.comboBox, "ComboBox.scrollPane.border")) != null) {
                this.scroller.setBorder(border);
            }
            this.comboBox.putClientProperty("ComboBox.scrollPane", this.scroller);
        }

        @Override
        public void configurePopup() {
            super.configurePopup();
            Border border = Utilities.getUIPropertyBorder(this.comboBox, "ComboBox.popup.border");
            if (border != null) {
                this.setBorder(border);
            }
            this.comboBox.putClientProperty("ComboBox.popup", this);
        }

        @Override
        public void show() {
            super.show();
            this.getParent().setBackground(this.getBackground());
        }

        @Override
        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            Rectangle bounds = super.computePopupBounds(px, py, pw, ph);
            bounds.y -= (int)Math.ceil(CuiLookAndFeel.getExteriorEdge());
            bounds.width -= (int)Math.ceil(CuiLookAndFeel.getExteriorEdge());
            return bounds;
        }

        @Override
        protected int getPopupHeightForRowCount(int maxRowCount) {
            int height = super.getPopupHeightForRowCount(maxRowCount);
            Insets sInsets = this.scroller.getInsets();
            Insets vInsets = this.scroller.getViewport().getInsets();
            Insets lInsets = this.list.getInsets();
            return height + sInsets.top + sInsets.bottom + vInsets.top + vInsets.bottom + lInsets.top + lInsets.bottom + 2;
        }
    }
}

