/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSeparatorUI;

public class CuiSeparatorUI
extends MetalSeparatorUI {
    protected static CuiSeparatorUI separatorUI_ = null;
    protected double interiorEdge_ = CuiLookAndFeel.getInteriorEdge();
    protected double exteriorEdge_ = CuiLookAndFeel.getExteriorEdge();

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c2) {
        return separatorUI_ != null ? separatorUI_ : (separatorUI_ = new CuiSeparatorUI());
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Color color;
        double edge = Utilities.getUIPropertyBoolean(c2, "Separator.raised") ? this.exteriorEdge_ : this.interiorEdge_;
        Color color2 = color = c2.getParent() == null || !c2.getParent().isOpaque() ? new Color(0, true) : c2.getParent().getBackground();
        if (c2 instanceof JSeparator && ((JSeparator)c2).getOrientation() == 1) {
            edge = Math.min(edge, (double)(c2.getWidth() / 2));
            int edgeI = (int)Math.ceil(edge);
            int offset = c2.getWidth() / 2;
            Rectangle area = new Rectangle(offset - edgeI, 0, 2 * edgeI, c2.getHeight());
            Rectangle2D.Double shape = new Rectangle2D.Double((double)edgeI - 0.001, 0.0, 0.002, 1.0);
            BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(2 * edgeI, 1), shape, new EdgeProfileRounded(0.0, edge), color, color, null);
            new StretchedImageIcon(renderedShape, area.width, area.height).paintIcon(c2, g2, area.x, area.y);
        } else {
            edge = Math.min(edge, (double)(c2.getHeight() / 2));
            int edgeI = (int)Math.ceil(edge);
            int offset = c2.getHeight() / 2;
            Rectangle area = new Rectangle(0, offset - edgeI, c2.getWidth(), 2 * edgeI);
            Rectangle2D.Double shape = new Rectangle2D.Double(0.0, (double)edgeI - 0.001, 1.0, 0.002);
            BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(1, 2 * edgeI), shape, new EdgeProfileRounded(0.0, edge), color, color, null);
            new StretchedImageIcon(renderedShape, area.width, area.height).paintIcon(c2, g2, area.x, area.y);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        double edge;
        double d2 = edge = Utilities.getUIPropertyBoolean(c2, "Separator.raised") ? this.exteriorEdge_ : this.interiorEdge_;
        if (c2 instanceof JSeparator && ((JSeparator)c2).getOrientation() == 1) {
            return new Dimension(2 * (int)Math.ceil(edge), 0);
        }
        return new Dimension(0, 2 * (int)Math.ceil(edge));
    }
}

