/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.NamedShape;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class CuiSpinnerUI
extends BasicSpinnerUI {
    protected static Logger logger_ = Logger.getLogger(CuiSpinnerUI.class.getName());
    protected static Object super_nextButtonHandler_;
    protected static Object super_previousButtonHandler_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c2) {
        return new CuiSpinnerUI();
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        this.spinner.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent c2) {
        try {
            ((MouseListener)super_nextButtonHandler_).mouseReleased(null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            ((MouseListener)super_previousButtonHandler_).mouseReleased(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.uninstallUI(c2);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension pref = super.getPreferredSize(c2);
        Dimension min = (Dimension)UIManager.get("Spinner.minimumSize");
        Dimension max = (Dimension)UIManager.get("Spinner.maximumSize");
        if (max != null) {
            pref.setSize(Math.min(max.width, pref.width), Math.min(max.height, pref.height));
        }
        if (min != null) {
            pref.setSize(Math.max(min.width, pref.width), Math.max(min.height, pref.height));
        }
        return pref;
    }

    protected Component createButton(final String previousOrNext) {
        Border border;
        Insets margin;
        final int direction = previousOrNext.equals("previous") ? 0 : 1;
        JButton button = new JButton(){
            private Icon icon_;
            {
                this.setRequestFocusEnabled(false);
                this.icon_ = new Icon(){

                    private Dimension getSize() {
                        Insets insets = this.getInsets();
                        int h2 = Math.min((this.getWidth() - (insets.left + insets.right)) / 2, this.getHeight() - (insets.top + insets.bottom));
                        int w2 = 2 * h2;
                        return new Dimension(w2, h2);
                    }

                    @Override
                    public int getIconWidth() {
                        return this.getSize().width;
                    }

                    @Override
                    public int getIconHeight() {
                        return this.getSize().height;
                    }

                    @Override
                    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
                        Dimension size = this.getSize();
                        int w2 = size.width;
                        int h2 = size.height;
                        if (size.width <= 0 || size.height <= 0) {
                            return;
                        }
                        float[][] p2 = new float[][]{{0.0f, 0.0f, w2, 0.0f, (float)w2 / 2.0f, h2}, {0.0f, h2, w2, h2, (float)w2 / 2.0f, 0.0f}};
                        int i2 = direction;
                        String shapeID = "SpinnerButton[" + i2 + "," + this.getWidth() + "x" + this.getHeight() + "]";
                        Shape shape = (Shape)Utilities.shapeCache_.get(shapeID);
                        if (shape == null) {
                            GeneralPath path = new GeneralPath();
                            path.moveTo(p2[i2][0], p2[i2][1]);
                            path.lineTo(p2[i2][2], p2[i2][3]);
                            path.lineTo(p2[i2][4], p2[i2][5]);
                            path.closePath();
                            shape = new NamedShape(shapeID, path);
                            Utilities.shapeCache_.put(shapeID, shape);
                        }
                        EdgeProfileRounded profile = new EdgeProfileRounded(0.0, 0.0);
                        Color interiorColor = !CuiSpinnerUI.this.spinner.isEnabled() ? UIManager.getColor("P4") : (!this.getModel().isPressed() ? this.getForeground() : this.getBackground());
                        Color exteriorColor = new Color(0, true);
                        Rectangle cutout = null;
                        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(size, shape, profile, interiorColor, exteriorColor, cutout);
                        g2.drawImage(renderedShape, x2, y2, null);
                    }
                };
            }

            @Override
            public void updateUI() {
                if (this.getClientProperty("Spinner." + previousOrNext + ".uiLock") == null) {
                    super.updateUI();
                }
            }

            @Override
            public Icon getIcon() {
                return this.icon_;
            }

            @Override
            public Dimension getPreferredSize() {
                Insets insets = this.getInsets();
                int size = CuiSpinnerUI.this.spinner.getEditor() != null ? ((CuiSpinnerUI)CuiSpinnerUI.this).spinner.getEditor().getPreferredSize().height : 0;
                return new Dimension(Math.max(size, (int)Math.ceil(2.0 * CuiLookAndFeel.getInteriorEdge()) + insets.left + insets.right), Math.max(size, (int)Math.ceil(2.0 * CuiLookAndFeel.getInteriorEdge()) + insets.top + insets.bottom));
            }
        };
        Color color = Utilities.getUIPropertyColor(this.spinner, "Spinner." + previousOrNext + ".background");
        if (color != null) {
            button.setBackground(color);
        }
        if ((color = Utilities.getUIPropertyColor(this.spinner, "Spinner." + previousOrNext + ".foreground")) != null) {
            button.setForeground(color);
        }
        if ((margin = Utilities.getUIPropertyInsets(this.spinner, "Spinner." + previousOrNext + ".margin")) != null) {
            button.setMargin(margin);
        }
        if ((border = Utilities.getUIPropertyBorder(this.spinner, "Spinner." + previousOrNext + ".border")) != null) {
            button.setBorder(border);
        }
        button.putClientProperty("Spinner." + previousOrNext + ".uiLock", Boolean.TRUE);
        if (super_nextButtonHandler_ == null) {
            try {
                Field nextButtonHandler = BasicSpinnerUI.class.getDeclaredField("nextButtonHandler");
                nextButtonHandler.setAccessible(true);
                super_nextButtonHandler_ = nextButtonHandler.get(null);
                Field previousButtonHandler = BasicSpinnerUI.class.getDeclaredField("previousButtonHandler");
                previousButtonHandler.setAccessible(true);
                super_previousButtonHandler_ = previousButtonHandler.get(null);
            }
            catch (Exception ex) {
                logger_.log(Level.WARNING, "" + ex, ex);
            }
        }
        if (previousOrNext.equals("next") && super_nextButtonHandler_ != null) {
            button.addActionListener((ActionListener)super_nextButtonHandler_);
            button.addMouseListener((MouseListener)super_nextButtonHandler_);
        }
        if (previousOrNext.equals("previous") && super_previousButtonHandler_ != null) {
            button.addActionListener((ActionListener)super_previousButtonHandler_);
            button.addMouseListener((MouseListener)super_previousButtonHandler_);
        }
        this.spinner.putClientProperty("Spinner." + previousOrNext, button);
        return button;
    }

    @Override
    protected Component createPreviousButton() {
        return this.createButton("previous");
    }

    @Override
    protected Component createNextButton() {
        return this.createButton("next");
    }

    @Override
    protected JComponent createEditor() {
        JFormattedTextField text;
        JComponent editor = super.createEditor();
        Border border = Utilities.getUIPropertyBorder(this.spinner, "Spinner.text.border");
        if (editor instanceof JSpinner.DefaultEditor && (text = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            editor.setBorder(null);
            editor.setBackground(null);
            Insets margin = Utilities.getUIPropertyInsets(this.spinner, "Spinner.text.margin");
            if (margin != null) {
                text.setMargin(margin);
            }
            if (border != null) {
                text.setBorder(border);
            }
            text.setName("SpinnerText");
            this.spinner.putClientProperty("Spinner.text", text);
        } else {
            if (border != null) {
                editor.setBorder(border);
            }
            editor.setName("SpinnerText");
            this.spinner.putClientProperty("Spinner.text", editor);
        }
        return editor;
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent editor) {
        JFormattedTextField text;
        super.replaceEditor(oldEditor, editor);
        Border border = Utilities.getUIPropertyBorder(this.spinner, "Spinner.text.border");
        if (editor instanceof JSpinner.DefaultEditor && (text = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            editor.setBorder(null);
            editor.setBackground(null);
            Insets margin = Utilities.getUIPropertyInsets(this.spinner, "Spinner.text.margin");
            if (margin != null) {
                text.setMargin(margin);
            }
            if (border != null) {
                text.setBorder(border);
            }
            this.spinner.putClientProperty("Spinner.text", text);
        } else {
            if (border != null) {
                editor.setBorder(border);
            }
            editor.setName("SpinnerText");
            this.spinner.putClientProperty("Spinner.text", editor);
        }
    }
}

