/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileOgee;
import com.ge.med.ptk.shape.NamedShape;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.metal.MetalSplitPaneUI;

public class CuiSplitPaneUI
extends MetalSplitPaneUI {
    protected int textureStep_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c2) {
        return new CuiSplitPaneUI();
    }

    @Override
    public void installUI(JComponent c2) {
        this.textureStep_ = Math.max(4, (int)Math.round(4.0 * CuiLookAndFeel.getScale()));
        super.installUI(c2);
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new BasicSplitPaneDivider(this){

            @Override
            public void paint(Graphics g2) {
                int pad;
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle lbb = this.leftButton != null ? this.leftButton.getBounds() : new Rectangle();
                Rectangle rbb = this.rightButton != null ? this.rightButton.getBounds() : new Rectangle();
                Point location = new Point(0, 0);
                Dimension size = this.getSize();
                if (this.orientation == 0) {
                    pad = Math.max(0, Math.max(location.x, Math.max(lbb.x + lbb.width, rbb.x + rbb.width)) - location.x);
                    location.x += pad;
                    size.width -= pad;
                } else {
                    pad = Math.max(0, Math.max(location.y, Math.max(lbb.y + lbb.height, rbb.y + rbb.height)) - location.y);
                    location.y += pad;
                    size.height -= pad;
                }
                Insets insets = this.getInsets();
                if (insets != null) {
                    location.x += insets.left;
                    location.y += insets.top;
                    size.width -= insets.left + insets.right;
                    size.height -= insets.top + insets.bottom;
                }
                Color interiorColor = this.getBackground();
                Color exteriorColor = Color.white;
                int textureCount = (this.orientation == 0 ? size.height : size.width) / CuiSplitPaneUI.this.textureStep_;
                double ins = (double)CuiSplitPaneUI.this.textureStep_ * 5.0 / 16.0;
                double inr = (double)CuiSplitPaneUI.this.textureStep_ * 1.0 / 4.0;
                double our = (double)CuiSplitPaneUI.this.textureStep_ * 1.0 / 8.0;
                String shapeID = "SplitPane[" + ins + "," + CuiSplitPaneUI.this.textureStep_ + "," + inr + "]";
                Shape shape = (Shape)Utilities.shapeCache_.get(shapeID);
                if (shape == null) {
                    shape = new NamedShape(shapeID, new RoundRectangle2D.Double(ins, ins, (double)CuiSplitPaneUI.this.textureStep_ - 2.0 * ins, (double)CuiSplitPaneUI.this.textureStep_ - 2.0 * ins, inr, inr));
                    Utilities.shapeCache_.put(shapeID, shape);
                }
                BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(CuiSplitPaneUI.this.textureStep_, CuiSplitPaneUI.this.textureStep_), shape, new EdgeProfileOgee(inr, our, 0.5), interiorColor, interiorColor, null);
                if (this.orientation == 0) {
                    StretchedImageIcon stretched = new StretchedImageIcon(renderedShape, size.width, CuiSplitPaneUI.this.textureStep_);
                    for (int i2 = 0; i2 < textureCount; ++i2) {
                        stretched.paintIcon(this, g2, location.x, location.y + i2 * CuiSplitPaneUI.this.textureStep_);
                    }
                } else {
                    StretchedImageIcon stretched = new StretchedImageIcon(renderedShape, CuiSplitPaneUI.this.textureStep_, size.height);
                    for (int i3 = 0; i3 < textureCount; ++i3) {
                        stretched.paintIcon(this, g2, location.x + i3 * CuiSplitPaneUI.this.textureStep_, location.y);
                    }
                }
                super.paint(g2);
            }

            @Override
            protected JButton createLeftOneTouchButton() {
                JButton b2 = super.createLeftOneTouchButton();
                b2.setBackground(new Color(0, true));
                return b2;
            }

            @Override
            protected JButton createRightOneTouchButton() {
                JButton b2 = super.createRightOneTouchButton();
                b2.setBackground(new Color(0, true));
                return b2;
            }
        };
    }
}

