/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.border.CuiToolPaletteBorder;
import com.ge.med.ptk.graphics.RenderedShapeFactory;
import com.ge.med.ptk.graphics.StretchedImageIcon;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.shape.EdgeProfileRounded;
import com.ge.med.ptk.shape.NamedShape;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class CuiTabbedPaneUI
extends BasicTabbedPaneUI
implements SwingConstants {
    protected double tabCornerSlope_;
    protected int tabCornerHeight_;
    protected Dimension tabMinimumSize_;
    protected Dimension tabMaximumSize_;
    protected Color selectedBackground_;
    protected Color unselectedBackground_;
    protected Color selectedForeground_;
    protected Color unselectedForeground_;
    protected Insets tabInsets_;
    protected Border contentBorder_;
    protected double interiorEdge_;
    protected double cornerRadius_;
    protected boolean rotateTitles_;
    protected int verticalAlignment_;
    protected int horizontalAlignment_;
    protected int verticalTextPosition_;
    protected int horizontalTextPosition_;
    protected int textIconGap_;
    protected String[] clippedText_;
    protected PropertyChangeListener propertyChangeListener_ = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String name = e2.getPropertyName();
            if (!("TabbedPane.tabCornerSlope".equals(name) || "TabbedPane.tabCornerHeight".equals(name) || "TabbedPane.tabMinimumSize".equals(name) || "TabbedPane.tabMaximumSize".equals(name) || "TabbedPane.tabInsets".equals(name) || "TabbedPane.contentBorder".equals(name) || "TabbedPane.selected".equals(name) || "TabbedPane.unselected".equals(name) || "TabbedPane.selectedForeground".equals(name) || "TabbedPane.unselectedForeground".equals(name) || "TabbedPane.rotateTitles".equals(name) || "TabbedPane.verticalAlignment".equals(name) || "TabbedPane.horizontalAlignment".equals(name) || "TabbedPane.verticalTextPosition".equals(name) || "TabbedPane.horizontalTextPosition".equals(name) || "TabbedPane.textIconGap".equals(name))) {
                return;
            }
            JTabbedPane tabPane = (JTabbedPane)e2.getSource();
            CuiTabbedPaneUI.this.uninstallUI(tabPane);
            CuiTabbedPaneUI.this.installUI(tabPane);
            tabPane.revalidate();
            tabPane.repaint();
        }
    };

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c2) {
        return new CuiTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c2) {
        this.tabCornerSlope_ = (double)Utilities.getUIPropertyInt(c2, "TabbedPane.tabCornerSlope") / 100.0;
        if (this.tabCornerSlope_ < 0.1 || this.tabCornerSlope_ > 9.0) {
            this.tabCornerSlope_ = 0.4;
        }
        this.tabCornerHeight_ = Utilities.getUIPropertyInt(c2, "TabbedPane.tabCornerHeight");
        this.tabMinimumSize_ = Utilities.getUIPropertyDimension(c2, "TabbedPane.tabMinimumSize");
        if (this.tabMinimumSize_ == null) {
            this.tabMinimumSize_ = new Dimension(0, 0);
        }
        this.tabMaximumSize_ = Utilities.getUIPropertyDimension(c2, "TabbedPane.tabMaximumSize");
        if (this.tabMaximumSize_ == null) {
            this.tabMaximumSize_ = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        }
        this.tabInsets_ = Utilities.getUIPropertyInsets(c2, "TabbedPane.tabInsets");
        if (this.tabInsets_ == null) {
            this.tabInsets_ = new Insets(0, 0, 0, 0);
        }
        this.contentBorder_ = Utilities.getUIPropertyBorder(c2, "TabbedPane.contentBorder");
        if (this.contentBorder_ == null) {
            this.contentBorder_ = new EmptyBorder(0, 0, 0, 0);
        }
        this.selectedBackground_ = Utilities.getUIPropertyColor(c2, "TabbedPane.selected");
        this.unselectedBackground_ = Utilities.getUIPropertyColor(c2, "TabbedPane.unselected");
        this.selectedForeground_ = Utilities.getUIPropertyColor(c2, "TabbedPane.selectedForeground");
        this.unselectedForeground_ = Utilities.getUIPropertyColor(c2, "TabbedPane.unselectedForeground");
        this.rotateTitles_ = Utilities.getUIPropertyBoolean(c2, "TabbedPane.rotateTitles");
        this.verticalAlignment_ = Utilities.getUIPropertyInt(c2, "TabbedPane.verticalAlignment");
        this.horizontalAlignment_ = Utilities.getUIPropertyInt(c2, "TabbedPane.horizontalAlignment");
        this.verticalTextPosition_ = Utilities.getUIPropertyInt(c2, "TabbedPane.verticalTextPosition");
        this.horizontalTextPosition_ = Utilities.getUIPropertyInt(c2, "TabbedPane.horizontalTextPosition");
        this.textIconGap_ = Utilities.getUIPropertyInt(c2, "TabbedPane.textIconGap");
        this.interiorEdge_ = CuiLookAndFeel.getInteriorEdge();
        this.cornerRadius_ = CuiLookAndFeel.getCornerRadius();
        super.installUI(c2);
        this.tabPane.addPropertyChangeListener(this.propertyChangeListener_);
        this.tabPane.setOpaque(true);
    }

    @Override
    public void uninstallUI(JComponent c2) {
        this.tabPane.setOpaque(false);
        this.tabPane.removePropertyChangeListener(this.propertyChangeListener_);
        super.uninstallUI(c2);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        if (this.clippedText_ == null || this.clippedText_.length != this.tabPane.getTabCount()) {
            this.clippedText_ = new String[this.tabPane.getTabCount()];
        }
        Utilities.antiAlias((Graphics2D)g2);
        super.paint(g2, c2);
    }

    protected int calculateUnpaddedTabWidth(int placement, int index, FontMetrics metrics) {
        boolean rotate = placement == 2 || placement == 4;
        Icon icon = this.getIconForTab(index);
        String text = this.tabPane.getTitleAt(index);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        int vA = this.verticalAlignment_;
        int vP = this.verticalTextPosition_;
        int hA = this.horizontalAlignment_;
        int hP = this.horizontalTextPosition_;
        int vAA = vA;
        int vPP = vP;
        switch (placement) {
            case 3: {
                int n2 = vA == 1 ? 3 : (vA = vA == 3 ? 1 : 0);
                vP = vP == 1 ? 3 : (vP == 3 ? 1 : 0);
                break;
            }
            case 2: {
                int n3 = hA == 2 || hA == 10 ? 1 : (vA = hA == 4 || hA == 11 ? 3 : 0);
                int n4 = hP == 2 || hP == 10 ? 1 : (vP = hP == 4 || hP == 11 ? 3 : 0);
                int n5 = vAA == 1 ? 2 : (hA = vAA == 3 ? 4 : 0);
                hP = vPP == 1 ? 2 : (vPP == 3 ? 4 : 0);
                break;
            }
            case 4: {
                int n6 = hA == 2 || hA == 10 ? 1 : (vA = hA == 4 || hA == 11 ? 3 : 0);
                int n7 = hP == 2 || hP == 10 ? 1 : (vP = hP == 4 || hP == 11 ? 3 : 0);
                int n8 = vAA == 1 ? 4 : (hA = vAA == 3 ? 2 : 0);
                hP = vPP == 1 ? 4 : (vPP == 3 ? 2 : 0);
            }
        }
        View v2 = this.getTextViewForTab(index);
        if (v2 != null) {
            this.tabPane.putClientProperty("html", v2);
        }
        Utilities.layoutCompoundLabel(this.tabPane, metrics, text, icon, vA, hA, vP, hP, viewR, iconR, textR, this.textIconGap_, rotate && this.rotateTitles_ ? 1 : 0);
        this.tabPane.putClientProperty("html", null);
        Rectangle textIconR = iconR.union(textR);
        return textIconR.width;
    }

    @Override
    protected int calculateTabWidth(int placement, int index, FontMetrics metrics) {
        boolean rotate = placement == 2 || placement == 4;
        Insets insets = this.getTabInsets(placement, index);
        return Math.max(!rotate ? this.tabMinimumSize_.width : this.tabMinimumSize_.height, Math.min(!rotate ? this.tabMaximumSize_.width : this.tabMaximumSize_.height, this.calculateUnpaddedTabWidth(placement, index, metrics) + (insets.left + insets.right)));
    }

    protected int calculateUnpaddedTabHeight(int placement, int index, int fontHeight) {
        boolean rotate = placement == 2 || placement == 4;
        Icon icon = this.getIconForTab(index);
        String text = this.tabPane.getTitleAt(index);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = this.tabPane.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        int vA = this.verticalAlignment_;
        int vP = this.verticalTextPosition_;
        int hA = this.horizontalAlignment_;
        int hP = this.horizontalTextPosition_;
        int vAA = vA;
        int vPP = vP;
        switch (placement) {
            case 3: {
                int n2 = vA == 1 ? 3 : (vA = vA == 3 ? 1 : 0);
                vP = vP == 1 ? 3 : (vP == 3 ? 1 : 0);
                break;
            }
            case 2: {
                int n3 = hA == 2 || hA == 10 ? 1 : (vA = hA == 4 || hA == 11 ? 3 : 0);
                int n4 = hP == 2 || hP == 10 ? 1 : (vP = hP == 4 || hP == 11 ? 3 : 0);
                int n5 = vAA == 1 ? 2 : (hA = vAA == 3 ? 4 : 0);
                hP = vPP == 1 ? 2 : (vPP == 3 ? 4 : 0);
                break;
            }
            case 4: {
                int n6 = hA == 2 || hA == 10 ? 1 : (vA = hA == 4 || hA == 11 ? 3 : 0);
                int n7 = hP == 2 || hP == 10 ? 1 : (vP = hP == 4 || hP == 11 ? 3 : 0);
                int n8 = vAA == 1 ? 4 : (hA = vAA == 3 ? 2 : 0);
                hP = vPP == 1 ? 4 : (vPP == 3 ? 2 : 0);
            }
        }
        View v2 = this.getTextViewForTab(index);
        if (v2 != null) {
            this.tabPane.putClientProperty("html", v2);
        }
        Utilities.layoutCompoundLabel(this.tabPane, metrics, text, icon, vA, hA, vP, hP, viewR, iconR, textR, this.textIconGap_, rotate && this.rotateTitles_ ? 1 : 0);
        this.tabPane.putClientProperty("html", null);
        Rectangle textIconR = iconR.union(textR);
        return textIconR.height;
    }

    @Override
    protected int calculateTabHeight(int placement, int index, int fontHeight) {
        boolean rotate = placement == 2 || placement == 4;
        Insets insets = this.getTabInsets(placement, index);
        return Math.max(!rotate ? this.tabMinimumSize_.height : this.tabMinimumSize_.width, Math.min(!rotate ? this.tabMaximumSize_.height : this.tabMaximumSize_.width, this.calculateUnpaddedTabHeight(placement, index, fontHeight) + (insets.top + insets.bottom)));
    }

    @Override
    protected void layoutLabel(int placement, FontMetrics metrics, int index, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR, boolean selected) {
        boolean rotate = placement == 2 || placement == 4;
        Insets i2 = this.getTabInsets(placement, index);
        viewR = new Rectangle(viewR.x + i2.left, viewR.y + i2.top, viewR.width - (i2.left + i2.right), viewR.height - (i2.top + i2.bottom));
        iconR.y = 0;
        iconR.x = 0;
        textR.y = 0;
        textR.x = 0;
        View v2 = this.getTextViewForTab(index);
        if (v2 != null) {
            this.tabPane.putClientProperty("html", v2);
        }
        int vA = this.verticalAlignment_;
        int vP = this.verticalTextPosition_;
        int hA = this.horizontalAlignment_;
        int hP = this.horizontalTextPosition_;
        int vAA = vA;
        int vPP = vP;
        switch (placement) {
            case 3: {
                int n2 = vA == 1 ? 3 : (vA = vA == 3 ? 1 : 0);
                vP = vP == 1 ? 3 : (vP == 3 ? 1 : 0);
                break;
            }
            case 2: {
                int n3 = hA == 2 || hA == 10 ? 1 : (vA = hA == 4 || hA == 11 ? 3 : 0);
                int n4 = hP == 2 || hP == 10 ? 1 : (vP = hP == 4 || hP == 11 ? 3 : 0);
                int n5 = vAA == 1 ? 2 : (hA = vAA == 3 ? 4 : 0);
                hP = vPP == 1 ? 2 : (vPP == 3 ? 4 : 0);
                break;
            }
            case 4: {
                int n6 = hA == 2 || hA == 10 ? 1 : (vA = hA == 4 || hA == 11 ? 3 : 0);
                int n7 = hP == 2 || hP == 10 ? 1 : (vP = hP == 4 || hP == 11 ? 3 : 0);
                int n8 = vAA == 1 ? 4 : (hA = vAA == 3 ? 2 : 0);
                hP = vPP == 1 ? 4 : (vPP == 3 ? 2 : 0);
            }
        }
        this.clippedText_[index] = Utilities.layoutCompoundLabel(this.tabPane, metrics, text, icon, vA, hA, vP, hP, viewR, iconR, textR, this.textIconGap_, rotate && this.rotateTitles_ ? 1 : 0);
        this.tabPane.putClientProperty("html", null);
    }

    @Override
    protected void paintFocusIndicator(Graphics g2, int placement, Rectangle[] rects, int index, Rectangle iconRect, Rectangle textRect, boolean selected) {
    }

    @Override
    protected void paintText(Graphics g2, int placement, Font font, FontMetrics metrics, int index, String text, Rectangle textRect, boolean selected) {
        boolean enabled;
        int mnemIndex;
        boolean rotate = placement == 2 || placement == 4;
        g2.setFont(font);
        View v2 = this.getTextViewForTab(index);
        if (v2 != null) {
            Utilities.paintView(v2, g2, textRect, rotate && this.rotateTitles_ ? 1 : 0);
            return;
        }
        try {
            mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(index);
        }
        catch (NoSuchMethodError nsm) {
            mnemIndex = -1;
        }
        boolean bl = enabled = this.tabPane.isEnabled() && this.tabPane.isEnabledAt(index);
        Color textColor = !enabled ? Utilities.getUIPropertyColor(this.tabPane, "TabbedPane.disabledForeground") : (selected ? (this.selectedForeground_ != null ? this.selectedForeground_ : this.tabPane.getForeground()) : (this.unselectedForeground_ != null ? this.unselectedForeground_ : this.tabPane.getForegroundAt(index)));
        Utilities.drawStringUnderlineCharAt(g2, this.clippedText_[index], mnemIndex, textRect.x, textRect.y + metrics.getAscent(), textColor, !enabled && this.tabPane.getClientProperty("test.noDrop") == null ? Utilities.getUIPropertyColor(this.tabPane, "TabbedPane.disabledDropShadow") : null, rotate && this.rotateTitles_ ? 1 : 0, this.tabPane);
    }

    protected Color getSelectedBackground() {
        Color color;
        Component component = this.tabPane.getSelectedComponent();
        if (component != null && component.isOpaque() && (color = component.getBackground()) != null) {
            return color;
        }
        color = this.selectedBackground_;
        if (color != null) {
            return color;
        }
        return this.tabPane.getBackground();
    }

    @Override
    protected void paintTabBackground(Graphics g2, int placement, int index, int x2, int y2, int w2, int h2, boolean selected) {
    }

    @Override
    protected Insets getTabInsets(int placement, int index) {
        Insets rotatedInsets = new Insets(0, 0, 0, 0);
        CuiTabbedPaneUI.rotateInsets(this.tabInsets_, rotatedInsets, placement);
        return rotatedInsets;
    }

    @Override
    protected Insets getTabAreaInsets(int placement) {
        return new Insets(0, 0, 0, 0);
    }

    protected Rectangle getContentBounds(int placement) {
        Insets insets = this.tabPane.getInsets();
        Rectangle content = new Rectangle(insets.left, insets.top, this.tabPane.getWidth() - (insets.right + insets.left), this.tabPane.getHeight() - (insets.top + insets.bottom));
        switch (placement) {
            case 1: {
                content.y += this.calculateTabAreaHeight(placement, this.runCount, this.maxTabHeight);
                content.height -= content.y - insets.top;
                break;
            }
            case 2: {
                content.x += this.calculateTabAreaWidth(placement, this.runCount, this.maxTabWidth);
                content.width -= content.x - insets.left;
                break;
            }
            case 3: {
                content.height -= this.calculateTabAreaHeight(placement, this.runCount, this.maxTabHeight);
                break;
            }
            case 4: {
                content.width -= this.calculateTabAreaWidth(placement, this.runCount, this.maxTabWidth);
            }
        }
        return content;
    }

    protected static Shape createShape(int[] outline, int[][] sequence, int[][] move, int[][] point, double[] x2, double[] y2, boolean flip) {
        int ix = flip ? 1 : 0;
        int iy = flip ? 0 : 1;
        GeneralPath path = new GeneralPath();
        for (int o2 = 0; o2 < outline.length; ++o2) {
            for (int s2 = 0; s2 < sequence[outline[o2]].length; ++s2) {
                int[] m2 = move[sequence[outline[o2]][s2]];
                float[] p1 = new float[]{(float)x2[point[m2[0]][0]], (float)y2[point[m2[0]][1]]};
                if (o2 == 0 && s2 == 0) {
                    path.moveTo(p1[ix], p1[iy]);
                    continue;
                }
                if (m2.length == 1) {
                    path.lineTo(p1[ix], p1[iy]);
                    continue;
                }
                float[] p0 = new float[]{(float)x2[point[m2[1]][0]], (float)y2[point[m2[1]][1]]};
                float[] pt0 = new float[]{(float)path.getCurrentPoint().getX(), (float)path.getCurrentPoint().getY()};
                float[] pt1 = new float[]{p0[ix], p0[iy]};
                float[] ct0 = new float[]{(2.0f * p1[ix] + pt0[0]) / 3.0f, (2.0f * p1[iy] + pt0[1]) / 3.0f};
                float[] ct1 = new float[]{(2.0f * p1[ix] + pt1[0]) / 3.0f, (2.0f * p1[iy] + pt1[1]) / 3.0f};
                path.curveTo(ct0[0], ct0[1], ct1[0], ct1[1], pt1[0], pt1[1]);
            }
        }
        path.closePath();
        return path;
    }

    protected static Shape createShape(int[] outline, int[][] move, int[][] point, double[] x2, double[] y2, boolean swap) {
        int ix = swap ? 1 : 0;
        int iy = swap ? 0 : 1;
        GeneralPath path = new GeneralPath();
        for (int o2 = 0; o2 < outline.length; ++o2) {
            int[] m2 = move[outline[o2]];
            float[] p1 = new float[]{(float)x2[point[m2[0]][0]], (float)y2[point[m2[0]][1]]};
            if (o2 == 0) {
                path.moveTo(p1[ix], p1[iy]);
                continue;
            }
            if (m2.length == 1) {
                path.lineTo(p1[ix], p1[iy]);
                continue;
            }
            float[] p0 = new float[]{(float)x2[point[m2[1]][0]], (float)y2[point[m2[1]][1]]};
            float[] pt0 = new float[]{(float)path.getCurrentPoint().getX(), (float)path.getCurrentPoint().getY()};
            float[] pt1 = new float[]{p0[ix], p0[iy]};
            float[] ct0 = new float[]{(2.0f * p1[ix] + pt0[0]) / 3.0f, (2.0f * p1[iy] + pt0[1]) / 3.0f};
            float[] ct1 = new float[]{(2.0f * p1[ix] + pt1[0]) / 3.0f, (2.0f * p1[iy] + pt1[1]) / 3.0f};
            path.curveTo(ct0[0], ct0[1], ct1[0], ct1[1], pt1[0], pt1[1]);
        }
        path.closePath();
        return path;
    }

    protected Border getContentBorder() {
        Border border = (Border)this.tabPane.getClientProperty("TabbedPane.contentBorder");
        if (border == null) {
            border = this.contentBorder_;
        }
        return border;
    }

    @Override
    protected Insets getContentBorderInsets(int placement) {
        Border border = this.getContentBorder();
        return border != null ? border.getBorderInsets(this.tabPane) : new Insets(0, 0, 0, 0);
    }

    @Override
    protected void paintContentBorder(Graphics g2, int placement, int selected) {
        Rectangle content = this.getContentBounds(placement);
        this.paintContentBorder(g2, placement, selected, content.x, content.y, content.width, content.height);
    }

    @Override
    protected void paintTabBorder(Graphics g2, int placement, int index, int x2, int y2, int w2, int h2, boolean selected) {
        boolean first;
        int across;
        boolean horizontal = placement == 1 || placement == 3;
        boolean flip = placement == 3 || placement == 4;
        int along = horizontal ? w2 : h2;
        int n2 = across = horizontal ? h2 : w2;
        if (along < 1 || across < 1) {
            return;
        }
        Rectangle content = this.getContentBounds(placement);
        boolean bl = horizontal ? x2 == content.x : (first = y2 == content.y);
        boolean last = horizontal ? x2 + w2 == content.x + content.width : y2 + h2 == content.y + content.height;
        double cornerRadius = this.cornerRadius_ * 1.2;
        double insideRadius = 0.01;
        int cornerAcross = Math.min(this.tabCornerHeight_, Math.min(across, (int)Math.ceil(((double)along - 2.0 * cornerRadius) / this.tabCornerSlope_)));
        if (across - cornerAcross > 0 && (double)(across - cornerAcross) < cornerRadius + insideRadius) {
            cornerAcross = across;
        }
        if (cornerAcross > 0 && (double)cornerAcross < 2.0 * cornerRadius) {
            cornerAcross = 0;
        }
        double cornerAlong = (double)cornerAcross * this.tabCornerSlope_;
        double straightAcross = across - cornerAcross;
        double straightAlong = (double)along - cornerAlong;
        double outsideRadius = Math.min(cornerRadius, Math.min((double)across / 2.0, straightAlong / 2.0));
        int alongUnstretched = Math.min(along, 2 * (int)Math.ceil(cornerAlong + outsideRadius) + 1);
        int acrossUnstretched = Math.min(across, 2 * (int)Math.ceil((double)cornerAcross + outsideRadius) + 1);
        String shapeID = "Tab[" + alongUnstretched + "x" + acrossUnstretched + "," + placement + "," + (first ? 1 : 0) + (last ? 1 : 0) + "]";
        Shape shape = (Shape)Utilities.shapeCache_.get(shapeID);
        if (shape == null) {
            double margin = this.interiorEdge_ + 1.0;
            double leading = 0.0;
            double trailing = alongUnstretched;
            double kneeAlong = trailing - cornerAlong;
            double[] pointsAlong = new double[]{leading - margin, leading - insideRadius, leading, leading + outsideRadius, kneeAlong - outsideRadius, kneeAlong, kneeAlong + outsideRadius * this.tabCornerSlope_, trailing - outsideRadius * this.tabCornerSlope_, trailing - insideRadius * this.tabCornerSlope_, trailing, trailing + insideRadius, trailing + margin};
            double outside = 0.0;
            double inside = acrossUnstretched;
            double kneeAcross = cornerAcross;
            double[] pointsAcross = new double[]{outside, outside + outsideRadius, kneeAcross - outsideRadius, kneeAcross, kneeAcross + outsideRadius, inside - insideRadius, inside, inside - insideRadius, inside, inside + margin};
            for (int i2 = 0; flip && i2 < pointsAcross.length; ++i2) {
                pointsAcross[i2] = (double)acrossUnstretched - pointsAcross[i2];
            }
            int[][] points = new int[][]{{2, 1}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {5, 1}, {6, 1}, {7, 2}, {9, 3}, {9, 4}, {8, 7}, {9, 7}, {9, 8}, {10, 8}, {11, 8}, {11, 9}, {9, 9}, {2, 9}, {0, 9}, {0, 8}, {1, 8}, {2, 8}, {2, 7}, {0, 6}, {1, 6}, {2, 6}, {2, 5}};
            int[][] moves = new int[][]{{0}, {1, 2}, {3}, {4, 5}, {4, 6}, {7}, {8, 9}, {10}, {11}, {12, 13}, {14}, {15}, {16}, {17}, {18}, {19}, {20}, {21, 22}, {23}, {24}, {25, 26}};
            int[][] sequences = new int[][]{{0, 1, 2, 4, 5, 6, 8}, {0, 1, 2, 3, 8}, {0, 1, 2, 4, 7}, {9, 10, 11}, {12}, {14, 15, 16, 17}, {13}, {14, 18, 19, 20}};
            int[] nArray = new int[3];
            nArray[0] = straightAcross > 0.0 ? (cornerAcross > 0 ? 0 : 1) : 2;
            nArray[1] = !last ? 3 : 4;
            nArray[2] = !first ? 5 : 6;
            int[] outline = nArray;
            shape = new NamedShape(shapeID, CuiTabbedPaneUI.createShape(outline, sequences, moves, points, pointsAlong, pointsAcross, !horizontal));
            Utilities.shapeCache_.put(shapeID, shape);
        }
        Insets ti = this.getTabInsets(placement, index);
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(horizontal ? alongUnstretched : acrossUnstretched, horizontal ? acrossUnstretched : alongUnstretched), shape, new EdgeProfileRounded(this.interiorEdge_, 0.0), selected ? this.getSelectedBackground() : (this.unselectedBackground_ != null ? this.unselectedBackground_ : this.tabPane.getBackgroundAt(index)), this.tabPane.isOpaque() ? this.tabPane.getBackground() : new Color(0, true), null);
        new StretchedImageIcon(renderedShape, w2, h2).paintIcon(this.tabPane.getComponentAt(index), g2, x2, y2);
    }

    protected void paintContentBorder(Graphics g2, int placement, int index, int x2, int y2, int w2, int h2) {
        boolean first;
        Border border = this.getContentBorder();
        Component component = this.tabPane.getSelectedComponent();
        Insets insets = null;
        try {
            insets = border != null ? border.getBorderInsets(component) : null;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (w2 <= 0 || h2 <= 0 || border == null || insets == null || insets.top <= 0 && insets.left <= 0 && insets.bottom <= 0 && insets.right <= 0) {
            return;
        }
        try {
            border.paintBorder(component, g2, x2, y2, w2, h2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (index < 0) {
            return;
        }
        Rectangle tab = this.getTabBounds(this.tabPane, index);
        if (tab == null) {
            return;
        }
        if (placement == 1 && tab.y + tab.height != y2 || placement == 2 && tab.x + tab.width != x2 || placement == 3 && y2 + h2 != tab.y || placement == 4 && x2 + w2 != tab.x) {
            return;
        }
        if (placement == 1 && insets.top <= 0 || placement == 2 && insets.left <= 0 || placement == 3 && insets.bottom <= 0 || placement == 4 && insets.right <= 0) {
            return;
        }
        if (!(border instanceof CuiToolPaletteBorder)) {
            if (!(border instanceof CuiBorder)) {
                return;
            }
            CuiBorder cb = (CuiBorder)border;
            boolean[] iev = cb.getInteriorEdgeVisible();
            if (!(cb.getExteriorEdge() == 0.0 && cb.getInteriorEdge() == this.interiorEdge_ && iev[0] && iev[1] && iev[2] && iev[3])) {
                return;
            }
        }
        boolean horizontal = placement == 1 || placement == 3;
        boolean flip = placement == 3 || placement == 4;
        int along = horizontal ? tab.width : tab.height;
        int across = (int)Math.ceil(this.interiorEdge_);
        boolean bl = horizontal ? tab.x == x2 : (first = tab.y == y2);
        boolean last = horizontal ? tab.x + tab.width == x2 + w2 : tab.y + tab.height == y2 + h2;
        boolean slant = (double)across <= 30.0 && (double)along >= (double)across * 0.4;
        int alongUnstretched = Math.min(along, 2 * (int)Math.ceil(this.interiorEdge_ * 1.4) + 1);
        int acrossUnstretched = across;
        String shapeID = "TabBorder[" + alongUnstretched + "x" + acrossUnstretched + "," + placement + "," + (first ? 1 : 0) + (last ? 1 : 0) + (slant ? 1 : 0) + "]";
        Shape shape = (Shape)Utilities.shapeCache_.get(shapeID);
        if (shape == null) {
            double insideRadius = 0.01;
            double margin = this.interiorEdge_ + 1.0;
            double leading = 0.0;
            double trailing = alongUnstretched;
            double[] pointsAlong = new double[]{leading - insideRadius - margin, leading - insideRadius, leading, trailing - insideRadius * this.tabCornerSlope_ - margin * this.tabCornerSlope_, trailing - insideRadius * this.tabCornerSlope_, trailing, trailing + insideRadius, trailing + insideRadius + margin};
            double outside = 0.0;
            double inside = acrossUnstretched;
            double[] pointsAcross = new double[]{outside - insideRadius - margin, outside - insideRadius, outside, outside + insideRadius, inside + margin};
            for (int i2 = 0; flip && i2 < pointsAcross.length; ++i2) {
                pointsAcross[i2] = (double)acrossUnstretched - pointsAcross[i2];
            }
            int[][] points = new int[][]{{2, 4}, {0, 4}, {0, 2}, {1, 2}, {2, 2}, {2, 1}, {2, 0}, {3, 0}, {5, 0}, {4, 1}, {5, 1}, {5, 2}, {6, 2}, {7, 2}, {5, 3}, {7, 4}, {5, 4}};
            int[][] moves = new int[][]{{0}, {1}, {2}, {3}, {4, 5}, {6}, {7}, {8}, {9}, {10}, {11, 12}, {11, 14}, {13}, {15}, {16}};
            int[][] sequences = new int[][]{{0, 5}, {1, 2, 3, 4, 5}, {6, 8, 11, 14}, {6, 8, 10, 12, 13}, {7, 14}, {7, 9, 10, 12, 13}};
            int[] outline = new int[]{first ? 0 : 1, (slant ? 2 : 4) + (last ? 0 : 1)};
            shape = new NamedShape(shapeID, CuiTabbedPaneUI.createShape(outline, sequences, moves, points, pointsAlong, pointsAcross, !horizontal));
            Utilities.shapeCache_.put(shapeID, shape);
        }
        BufferedImage renderedShape = RenderedShapeFactory.getRenderedShape(new Dimension(horizontal ? alongUnstretched : acrossUnstretched, horizontal ? acrossUnstretched : alongUnstretched), shape, new EdgeProfileRounded(this.interiorEdge_, 0.0), this.getSelectedBackground(), Color.white, null);
        Point location = placement == 1 ? new Point(tab.x, tab.y + tab.height) : (placement == 2 ? new Point(tab.x + tab.width, tab.y) : (placement == 3 ? new Point(tab.x, tab.y - across) : new Point(tab.x - across, tab.y)));
        new StretchedImageIcon(renderedShape, horizontal ? along : across, horizontal ? across : along).paintIcon(component, g2, location.x, location.y);
    }
}

