/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.text.View;

public class CuiToggleButtonUI
extends MetalToggleButtonUI {
    protected static CuiToggleButtonUI ToggleButtonUI_ = null;
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static ComponentUI createUI(JComponent c2) {
        return ToggleButtonUI_ != null ? ToggleButtonUI_ : (ToggleButtonUI_ = new CuiToggleButtonUI());
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        c2.setOpaque(false);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        boolean rotate = b2.getClientProperty("vertical") == Boolean.TRUE;
        int gap = 0;
        rotate = rotate || !b2.getComponentOrientation().isHorizontal();
        gap = b2.getIconTextGap();
        Dimension pref = Utilities.getPreferredButtonSize(b2, gap, rotate ? 1 : 0);
        if (pref.height % 2 != 0) {
            ++pref.height;
        }
        Dimension min = (Dimension)UIManager.get("ToggleButton.minimumSize");
        Dimension max = (Dimension)UIManager.get("ToggleButton.maximumSize");
        if (max != null) {
            pref.setSize(Math.min(max.width, pref.width), Math.min(max.height, pref.height));
        }
        if (min != null) {
            pref.setSize(Math.max(min.width, pref.width), Math.max(min.height, pref.height));
        }
        return pref;
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Utilities.antiAlias((Graphics2D)g2);
        AbstractButton b2 = (AbstractButton)c2;
        ButtonModel model = b2.getModel();
        Insets i2 = c2.getInsets();
        CuiToggleButtonUI.viewRect.x = i2.left;
        CuiToggleButtonUI.viewRect.y = i2.top;
        CuiToggleButtonUI.viewRect.width = c2.getWidth() - (i2.left + i2.right);
        CuiToggleButtonUI.viewRect.height = c2.getHeight() - (i2.top + i2.bottom);
        CuiToggleButtonUI.textRect.height = 0;
        CuiToggleButtonUI.textRect.width = 0;
        CuiToggleButtonUI.textRect.y = 0;
        CuiToggleButtonUI.textRect.x = 0;
        CuiToggleButtonUI.iconRect.height = 0;
        CuiToggleButtonUI.iconRect.width = 0;
        CuiToggleButtonUI.iconRect.y = 0;
        CuiToggleButtonUI.iconRect.x = 0;
        boolean rotate = c2.getClientProperty("vertical") == Boolean.TRUE || !c2.getComponentOrientation().isHorizontal();
        int textIconGap = b2.getIconTextGap();
        Icon icon = b2.getIcon();
        Font font = b2.getFont();
        g2.setFont(font);
        String text = Utilities.layoutCompoundLabel(c2, g2.getFontMetrics(), b2.getText(), icon, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, textIconGap, rotate ? 1 : 0);
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g2, b2);
        }
        if (icon != null) {
            this.paintIcon(g2, c2, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v2 = (View)c2.getClientProperty("html");
            if (v2 != null) {
                Utilities.paintView(v2, g2, textRect, rotate ? 1 : 0);
            } else {
                this.paintText(g2, b2, textRect, text);
            }
        }
        if (b2.isFocusPainted() && b2.hasFocus()) {
            this.paintFocus(g2, b2, viewRect, textRect, iconRect);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g2, AbstractButton b2) {
        if (!Utilities.paintButtonBackground(g2, b2, "ToggleButton")) {
            super.paintButtonPressed(g2, b2);
        }
    }

    @Override
    protected void paintText(Graphics g2, AbstractButton b2, Rectangle textRect, String text) {
        Utilities.paintText(g2, b2, "ToggleButton", textRect, text);
    }

    @Override
    protected void paintText(Graphics g2, JComponent c2, Rectangle textRect, String text) {
        Utilities.paintText(g2, (AbstractButton)c2, "ToggleButton", textRect, text);
    }

    @Override
    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b2.isBorderPainted() && b2.getBorder() instanceof CuiBorder) {
            return;
        }
        super.paintFocus(g2, b2, viewRect, textRect, iconRect);
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        Utilities.paintButtonBackground(g2, (AbstractButton)c2, "ToggleButton");
        super.update(g2, c2);
    }
}

