/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class CuiTreeControlIcon
implements Icon,
UIResource,
Serializable {
    protected int size_;
    protected boolean open_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public CuiTreeControlIcon() {
        this(11, false);
    }

    public CuiTreeControlIcon(int size, boolean open) {
        this.size_ = (int)Math.round((double)size * CuiLookAndFeel.getScale());
        this.open_ = open;
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        Color background;
        int weight = Math.max(1, this.size_ / 10);
        if (this.size_ > 25 && weight % 2 != this.size_ % 2) {
            ++weight;
        }
        if ((background = UIManager.getColor("P7")) == null) {
            background = c2.getBackground();
        }
        g2.setColor(background);
        g2.fillRect(x2, y2, this.size_, this.size_);
        Color foreground = UIManager.getColor("P11");
        if (foreground == null) {
            foreground = c2.getForeground();
        }
        g2.setColor(foreground);
        for (int i2 = 0; i2 < weight; ++i2) {
            g2.drawRect(x2 + i2, y2 + i2, this.size_ - 2 * i2 - 1, this.size_ - 2 * i2 - 1);
        }
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g2).fill(new Rectangle2D.Double(x2 + 2 * weight, (double)y2 + (double)(this.size_ - weight) / 2.0, this.size_ - 4 * weight, weight));
        if (!this.open_) {
            ((Graphics2D)g2).fill(new Rectangle2D.Double((double)x2 + (double)(this.size_ - weight) / 2.0, y2 + 2 * weight, weight, this.size_ - 4 * weight));
        }
    }

    @Override
    public int getIconWidth() {
        return this.size_;
    }

    @Override
    public int getIconHeight() {
        return this.size_;
    }
}

