/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.border.CuiBorder;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.laf.CuiTheme;
import com.ge.med.ptk.laf.DefaultTextUtilities;
import com.ge.med.ptk.laf.TextUtilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.text.View;

public class Utilities {
    protected static Logger logger_ = Logger.getLogger(Utilities.class.getName());
    protected static TextUtilities textUtilities_;
    protected static Font albany_;
    protected static Font albanyBold_;
    protected static Font geLogoFont_;
    private static Rectangle viewRect;
    private static Rectangle textRect;
    private static Rectangle iconRect;
    private static Insets viewInsets;
    public static Map shapeCache_;
    private static boolean[] rescale_;
    private static double[] scale_;
    private static boolean scaleFlag_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public static TextUtilities getTextUtilities() {
        return textUtilities_ != null ? textUtilities_ : (textUtilities_ = new DefaultTextUtilities());
    }

    public static void setTextUtilities(TextUtilities textUtilities) {
        textUtilities_ = textUtilities;
    }

    public static void paintView(View v2, Graphics g2, Rectangle rect, int rotate) {
        Utilities.antiAlias((Graphics2D)g2);
        Utilities.getTextUtilities().paintView(v2, g2, rect, rotate);
    }

    public static void drawString(Graphics g2, String str, int x2, int y2) {
        Utilities.antiAlias((Graphics2D)g2);
        Utilities.getTextUtilities().drawString(g2, str, x2, y2);
    }

    public static void drawString(Graphics g2, AttributedCharacterIterator iterator, int x2, int y2) {
        Utilities.antiAlias((Graphics2D)g2);
        Utilities.getTextUtilities().drawString(g2, iterator, x2, y2);
    }

    public static void drawChars(Graphics g2, char[] data, int offset, int length, int x2, int y2) {
        Utilities.antiAlias((Graphics2D)g2);
        Utilities.getTextUtilities().drawString(g2, new String(data, offset, length), x2, y2);
    }

    public static void drawBytes(Graphics g2, byte[] data, int offset, int length, int x2, int y2) {
        Utilities.antiAlias((Graphics2D)g2);
        Utilities.getTextUtilities().drawString(g2, new String(data, 0, offset, length), x2, y2);
    }

    public static void drawString(Graphics2D g2, String str, int x2, int y2) {
        Utilities.antiAlias(g2);
        Utilities.getTextUtilities().drawString(g2, str, x2, y2);
    }

    public static void drawString(Graphics2D g2, String str, float x2, float y2) {
        Utilities.antiAlias(g2);
        Utilities.getTextUtilities().drawString(g2, str, x2, y2);
    }

    public static void drawString(Graphics2D g2, AttributedCharacterIterator iterator, int x2, int y2) {
        Utilities.antiAlias(g2);
        Utilities.getTextUtilities().drawString(g2, iterator, x2, y2);
    }

    public static void drawString(Graphics2D g2, AttributedCharacterIterator iterator, float x2, float y2) {
        Utilities.antiAlias(g2);
        Utilities.getTextUtilities().drawString(g2, iterator, x2, y2);
    }

    public static void drawString(Graphics g2, String text, int underlinedChar, int x2, int y2) {
        Utilities.antiAlias((Graphics2D)g2);
        Utilities.getTextUtilities().drawString(g2, text, underlinedChar, x2, y2);
    }

    public static void drawStringUnderlineCharAt(Graphics g2, String text, int index, int x2, int y2) {
        Utilities.antiAlias((Graphics2D)g2);
        Utilities.getTextUtilities().drawStringUnderlineCharAt(g2, text, index, x2, y2, 0, null);
    }

    public static void drawStringUnderlineCharAt(Graphics g2, String text, int index, int x2, int y2, int rotate, JComponent c2) {
        Utilities.antiAlias((Graphics2D)g2);
        Utilities.getTextUtilities().drawStringUnderlineCharAt(g2, text, index, x2, y2, rotate, c2);
    }

    public static String layoutCompoundLabel(JComponent c2, FontMetrics fm, String text, Icon icon, int vAlign, int hAlign, int vTextPos, int hTextPos, Rectangle viewR, Rectangle iconR, Rectangle textR, int gap) {
        return Utilities.getTextUtilities().layoutCompoundLabel(c2, fm, text, icon, vAlign, hAlign, vTextPos, hTextPos, viewR, iconR, textR, gap, 0);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text, Icon icon, int vAlign, int hAlign, int vTextPos, int hTextPos, Rectangle viewR, Rectangle iconR, Rectangle textR, int gap) {
        return Utilities.getTextUtilities().layoutCompoundLabel(fm, text, icon, vAlign, hAlign, vTextPos, hTextPos, viewR, iconR, textR, gap, 0);
    }

    public static String layoutCompoundLabel(JComponent c2, FontMetrics fm, String text, Icon icon, int vAlign, int hAlign, int vTextPos, int hTextPos, Rectangle viewR, Rectangle iconR, Rectangle textR, int gap, int rotate) {
        return Utilities.getTextUtilities().layoutCompoundLabel(c2, fm, text, icon, vAlign, hAlign, vTextPos, hTextPos, viewR, iconR, textR, gap, rotate);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text, Icon icon, int vAlign, int hAlign, int vTextPos, int hTextPos, Rectangle viewR, Rectangle iconR, Rectangle textR, int gap, int rotate) {
        return Utilities.getTextUtilities().layoutCompoundLabel(fm, text, icon, vAlign, hAlign, vTextPos, hTextPos, viewR, iconR, textR, gap, rotate);
    }

    public static void drawStringUnderlineCharAt(Graphics g2, String text, int underlinedIndex, int x2, int y2, Color color, Color dropColor) {
        Utilities.drawStringUnderlineCharAt(g2, text, underlinedIndex, x2, y2, color, dropColor, 0, null);
    }

    public static void drawStringUnderlineCharAt(Graphics g2, String text, int underlinedIndex, int x2, int y2, Color color, Color dropColor, int rotate, JComponent c2) {
        if (dropColor != null) {
            g2.setColor(dropColor);
            Utilities.drawStringUnderlineCharAt(g2, text, underlinedIndex, x2 + (Utilities.monitor(1) + 1) / 2, y2 + (Utilities.monitor(1) + 1) / 2, rotate, c2);
        }
        g2.setColor(color);
        Utilities.drawStringUnderlineCharAt(g2, text, underlinedIndex, x2, y2, rotate, c2);
    }

    public static Font getAlbanyFont() {
        return albany_ != null ? albany_ : (albany_ = Utilities.getJarFont("Albany AMT", "alb.ttf"));
    }

    public static Font getAlbanyBoldFont() {
        return albanyBold_ != null ? albanyBold_ : (albanyBold_ = Utilities.getJarFont("Albany AMT Bold", "albb.ttf"));
    }

    public static Font getGELogoFont() {
        return geLogoFont_ != null ? geLogoFont_ : (geLogoFont_ = Utilities.getJarFont("GE Logo Font", "GELOF___.TTF"));
    }

    protected static Font getJarFont(String name, String ttf) {
        try {
            Font f2 = Font.createFont(0, CuiTheme.class.getClassLoader().getResourceAsStream(ttf));
            try {
                if (System.getProperty("os.name").equals("Irix") && ttf.startsWith("alb") && Toolkit.getDefaultToolkit().getFontMetrics(f2.deriveFont(12.0f)).stringWidth("A") < 7) {
                    f2 = new Font("sansserif", ttf.equals("alb.ttf") ? 0 : 1, 12);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return f2;
        }
        catch (Exception ex) {
            return Font.decode(name);
        }
    }

    public static Object getUIProperty(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) != null) {
            return value;
        }
        return UIManager.get(key);
    }

    public static Color getUIPropertyColor(JComponent component, String key) {
        return Utilities.getUIPropertyColor(component, key, null);
    }

    public static Color getUIPropertyColor(JComponent component, String key, Color fallback) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Color || (value = UIManager.get(key)) instanceof Color) {
            return (Color)value;
        }
        return fallback;
    }

    public static Border getUIPropertyBorder(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Border) {
            return (Border)value;
        }
        value = UIManager.get(key);
        if (value instanceof Border) {
            return (Border)value;
        }
        return null;
    }

    public static Insets getUIPropertyInsets(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Insets) {
            return (Insets)value;
        }
        value = UIManager.get(key);
        if (value instanceof Insets) {
            return (Insets)value;
        }
        return null;
    }

    public static Icon getUIPropertyIcon(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Icon) {
            return (Icon)value;
        }
        value = UIManager.get(key);
        if (value instanceof Icon) {
            return (Icon)value;
        }
        return null;
    }

    public static Dimension getUIPropertyDimension(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Dimension) {
            return (Dimension)value;
        }
        value = UIManager.get(key);
        if (value instanceof Dimension) {
            return (Dimension)value;
        }
        return null;
    }

    public static int getUIPropertyInt(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Integer) {
            return (Integer)value;
        }
        value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public static boolean getUIPropertyBoolean(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Boolean) {
            return (Boolean)value;
        }
        value = UIManager.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    protected static Color getAncestorBackground(Component component) {
        Component c2 = component;
        while (c2 != null) {
            Color color;
            if ((c2 = c2.getParent()) == null || !c2.isOpaque() || (color = c2.getBackground()) == null) continue;
            return color.getAlpha() == 255 ? color : new Color(0, true);
        }
        return Color.white;
    }

    public static void antiAlias(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, g2.getFont().getSize() >= CuiLookAndFeel.getTextAntialiasing() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    public static Dimension getPreferredButtonSize(AbstractButton b2, int gap) {
        return Utilities.getPreferredButtonSize(b2, gap, 0);
    }

    public static Dimension getPreferredButtonSize(AbstractButton b2, int gap, int rotate) {
        Icon icon = b2.getIcon();
        String text = b2.getText();
        Font font = b2.getFont();
        FontMetrics fm = b2.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        Utilities.layoutCompoundLabel(b2, fm, text, icon, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewR, iconR, textR, gap, rotate);
        Rectangle r2 = iconR.union(textR);
        Insets insets = b2.getInsets();
        return new Dimension(r2.width + (insets.left + insets.right), r2.height + (insets.top + insets.bottom));
    }

    protected static void paintText(Graphics g2, AbstractButton b2, String classKey, Rectangle textRect, String text) {
        FontMetrics fm = g2.getFontMetrics();
        boolean rotate = b2.getClientProperty("vertical") == Boolean.TRUE;
        int mnemIndex = -1;
        rotate = rotate || !b2.getComponentOrientation().isHorizontal();
        mnemIndex = b2.getDisplayedMnemonicIndex();
        if (!b2.isEnabled()) {
            Color color = Utilities.getUIPropertyColor(b2, classKey + ".disabledText");
            if (color == null) {
                color = b2.getForeground();
            }
            Utilities.drawStringUnderlineCharAt(g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent(), color, Utilities.getUIPropertyColor(b2, classKey + ".disabledDropShadow"), rotate ? 1 : 0, b2);
        } else {
            Color color;
            if (!b2.isSelected() && !b2.getModel().isPressed() || !b2.isContentAreaFilled() || !b2.isBorderPainted() || (color = Utilities.getUIPropertyColor(b2, classKey + ".selectionForeground")) == null) {
                color = b2.getForeground();
            }
            Utilities.drawStringUnderlineCharAt(g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent(), color, null, rotate ? 1 : 0, b2);
        }
    }

    protected static boolean paintButtonBackground(Graphics g2, AbstractButton b2, String classKey) {
        if (b2.isOpaque() || !b2.isContentAreaFilled() || !b2.isBorderPainted()) {
            return false;
        }
        if (!b2.isEnabled()) {
            return true;
        }
        if (b2.getModel().isPressed()) {
            g2.setColor(Utilities.getUIPropertyColor(b2, classKey + ".press", Color.gray));
        } else if (b2.isSelected()) {
            g2.setColor(Utilities.getUIPropertyColor(b2, classKey + ".select", Color.gray));
        } else {
            g2.setColor(b2.getBackground());
        }
        Insets i2 = b2.getInsets();
        g2.fillRect(i2.left, i2.top, b2.getWidth() - (i2.left + i2.right), b2.getHeight() - (i2.top + i2.bottom));
        return true;
    }

    public static Dimension getCheckBoxOrRadioButtonPreferredSize(JComponent c2, Icon defaultIcon) {
        if (c2.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b2 = (AbstractButton)c2;
        String text = b2.getText();
        Icon buttonIcon = b2.getIcon();
        if (buttonIcon == null) {
            buttonIcon = defaultIcon;
        }
        Font font = b2.getFont();
        FontMetrics fm = b2.getFontMetrics(font);
        Utilities.viewRect.y = 0;
        Utilities.viewRect.x = 0;
        Utilities.viewRect.width = Short.MAX_VALUE;
        Utilities.viewRect.height = Short.MAX_VALUE;
        Utilities.iconRect.height = 0;
        Utilities.iconRect.width = 0;
        Utilities.iconRect.y = 0;
        Utilities.iconRect.x = 0;
        Utilities.textRect.height = 0;
        Utilities.textRect.width = 0;
        Utilities.textRect.y = 0;
        Utilities.textRect.x = 0;
        boolean rotate = b2.getClientProperty("vertical") == Boolean.TRUE;
        int iconTextGap = 4;
        rotate = rotate || !b2.getComponentOrientation().isHorizontal();
        iconTextGap = b2.getIconTextGap();
        Utilities.layoutCompoundLabel(c2, fm, text, buttonIcon, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, text == null ? 0 : b2.getIconTextGap(), rotate ? 1 : 0);
        int x1 = Math.min(Utilities.iconRect.x, Utilities.textRect.x);
        int x2 = Math.max(Utilities.iconRect.x + Utilities.iconRect.width, Utilities.textRect.x + Utilities.textRect.width);
        int y1 = Math.min(Utilities.iconRect.y, Utilities.textRect.y);
        int y2 = Math.max(Utilities.iconRect.y + Utilities.iconRect.height, Utilities.textRect.y + Utilities.textRect.height);
        int width = x2 - x1;
        int height = y2 - y1;
        viewInsets = b2.getInsets(viewInsets);
        return new Dimension(width += Utilities.viewInsets.left + Utilities.viewInsets.right, height += Utilities.viewInsets.top + Utilities.viewInsets.bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void paintCheckBoxOrRadioButton(Graphics g2, AbstractButton b2, String classKey, Object lock, Icon defaultIcon, Color disabledTextColor, Color focusColor) {
        Object object = lock;
        synchronized (object) {
            ButtonModel model = b2.getModel();
            Dimension size = b2.getSize();
            int w2 = size.width;
            int h2 = size.height;
            Font f2 = b2.getFont();
            g2.setFont(f2);
            FontMetrics fm = g2.getFontMetrics();
            Rectangle viewRect = new Rectangle(size);
            Rectangle iconRect = new Rectangle();
            Rectangle textRect = new Rectangle();
            Insets i2 = b2.getInsets();
            viewRect.x += i2.left;
            viewRect.y += i2.top;
            viewRect.width -= i2.right + viewRect.x;
            viewRect.height -= i2.bottom + viewRect.y;
            Icon altIcon = b2.getIcon();
            Object selectedIcon = null;
            Object disabledIcon = null;
            boolean rotate = b2.getClientProperty("vertical") == Boolean.TRUE;
            int iconTextGap = 4;
            rotate = rotate || !b2.getComponentOrientation().isHorizontal();
            iconTextGap = b2.getIconTextGap();
            String text = Utilities.layoutCompoundLabel(b2, fm, b2.getText(), altIcon != null ? altIcon : defaultIcon, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, iconTextGap, rotate ? 1 : 0);
            if (b2.isContentAreaFilled() && b2.isBorderPainted() && b2.isEnabled()) {
                if (model.isPressed() || model.isSelected()) {
                    g2.setColor(Utilities.getUIPropertyColor(b2, classKey + (model.isPressed() ? ".press" : ".select"), Color.gray));
                } else {
                    g2.setColor(b2.getBackground());
                }
                Insets in = b2.isOpaque() ? new Insets(0, 0, 0, 0) : b2.getInsets();
                g2.fillRect(in.left, in.top, size.width - (in.left + in.right), size.height - (in.top + in.bottom));
            }
            if (altIcon != null) {
                if (!model.isEnabled()) {
                    altIcon = model.isSelected() ? b2.getDisabledSelectedIcon() : b2.getDisabledIcon();
                } else if (model.isPressed() && model.isArmed()) {
                    altIcon = b2.getPressedIcon();
                    if (altIcon == null) {
                        altIcon = b2.getSelectedIcon();
                    }
                } else if (model.isSelected()) {
                    if (b2.isRolloverEnabled() && model.isRollover()) {
                        altIcon = b2.getRolloverSelectedIcon();
                        if (altIcon == null) {
                            altIcon = b2.getSelectedIcon();
                        }
                    } else {
                        altIcon = b2.getSelectedIcon();
                    }
                } else if (b2.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b2.getRolloverIcon();
                }
                if (altIcon == null) {
                    altIcon = b2.getIcon();
                }
                altIcon.paintIcon(b2, g2, iconRect.x, iconRect.y);
            } else {
                defaultIcon.paintIcon(b2, g2, iconRect.x, iconRect.y);
            }
            if (text != null) {
                View v2 = (View)b2.getClientProperty("html");
                if (v2 != null) {
                    Utilities.paintView(v2, g2, textRect, rotate ? 1 : 0);
                } else {
                    int mnemIndex = -1;
                    mnemIndex = b2.getDisplayedMnemonicIndex();
                    if (model.isEnabled()) {
                        Color color;
                        if (!b2.isSelected() && !b2.getModel().isPressed() || !b2.isBorderPainted() || !b2.isContentAreaFilled() || (color = Utilities.getUIPropertyColor(b2, classKey + ".borderedSelectionForeground")) == null) {
                            color = b2.getForeground();
                        }
                        Utilities.drawStringUnderlineCharAt(g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent(), color, null, rotate ? 1 : 0, b2);
                    } else {
                        Utilities.drawStringUnderlineCharAt(g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent(), disabledTextColor, b2.getClientProperty("test.noDrop") == null ? Utilities.getUIPropertyColor(b2, classKey + ".disabledDropShadow") : null, rotate ? 1 : 0, b2);
                    }
                }
            }
            if (b2.hasFocus() && b2.isFocusPainted() && (!b2.isBorderPainted() || !(b2.getBorder() instanceof CuiBorder))) {
                g2.setColor(focusColor);
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)g2).draw(new RoundRectangle2D.Double(CuiLookAndFeel.getExteriorEdge() + 0.5, CuiLookAndFeel.getExteriorEdge() + 0.5, (double)w2 - 2.0 * CuiLookAndFeel.getExteriorEdge() - 1.0, (double)h2 - 2.0 * CuiLookAndFeel.getExteriorEdge() - 1.0, 2.0 * CuiLookAndFeel.getCornerRadius(), 2.0 * CuiLookAndFeel.getCornerRadius()));
            }
        }
    }

    private static void initScale() {
        int[] scale = new int[]{100};
        try {
            StringTokenizer tk = new StringTokenizer(System.getProperty("ptk.scale", "100"), ",");
            scale = new int[tk.countTokens()];
            for (int i2 = 0; i2 < scale.length; ++i2) {
                scale[i2] = Integer.parseInt(tk.nextToken());
            }
        }
        catch (Exception ex) {
            logger_.log(Level.WARNING, "" + ex, ex);
        }
        rescale_ = new boolean[scale.length];
        scale_ = new double[scale.length];
        for (int i3 = 0; i3 < scale.length; ++i3) {
            Utilities.rescale_[i3] = scale[i3] > 0 && scale[i3] != 100;
            if (!Utilities.rescale_[i3]) continue;
            Utilities.scale_[i3] = (double)scale[i3] / 100.0;
        }
        scaleFlag_ = true;
    }

    public static double monitor(double raw) {
        if (!scaleFlag_) {
            Utilities.initScale();
        }
        return rescale_[0] ? raw * scale_[0] : raw;
    }

    public static int monitor(int raw) {
        if (!scaleFlag_) {
            Utilities.initScale();
        }
        return rescale_[0] ? (int)Math.ceil((double)raw * scale_[0]) : raw;
    }

    public static Integer monitor(Integer raw) {
        return raw == null ? null : new Integer(Utilities.monitor((int)raw));
    }

    public static Dimension monitor(Dimension raw) {
        return raw == null ? null : new Dimension(Utilities.monitor(raw.width), Utilities.monitor(raw.height));
    }

    public static Point monitor(Point raw) {
        return raw == null ? null : new Point(Utilities.monitor(raw.x), Utilities.monitor(raw.y));
    }

    public static Rectangle monitor(Rectangle raw) {
        return raw == null ? null : new Rectangle(Utilities.monitor(raw.x), Utilities.monitor(raw.y), Utilities.monitor(raw.width), Utilities.monitor(raw.height));
    }

    public static Insets monitor(Insets raw) {
        return raw == null ? null : new Insets(Utilities.monitor(raw.top), Utilities.monitor(raw.left), Utilities.monitor(raw.bottom), Utilities.monitor(raw.right));
    }

    public static InsetsUIResource monitor(InsetsUIResource raw) {
        return raw == null ? null : new InsetsUIResource(Utilities.monitor(raw.top), Utilities.monitor(raw.left), Utilities.monitor(raw.bottom), Utilities.monitor(raw.right));
    }

    public static double monitor(double raw, int i2) {
        if (!scaleFlag_) {
            Utilities.initScale();
        }
        return rescale_[i2 < rescale_.length ? i2 : 0] ? raw * scale_[i2 < scale_.length ? i2 : 0] : raw;
    }

    public static int monitor(int raw, int i2) {
        if (!scaleFlag_) {
            Utilities.initScale();
        }
        return rescale_[i2 < rescale_.length ? i2 : 0] ? (int)Math.ceil((double)raw * scale_[i2 < scale_.length ? i2 : 0]) : raw;
    }

    public static Integer monitor(Integer raw, int i2) {
        return raw == null ? null : new Integer(Utilities.monitor((int)raw, i2));
    }

    public static Dimension monitor(Dimension raw, int i2) {
        return raw == null ? null : new Dimension(Utilities.monitor(raw.width, i2), Utilities.monitor(raw.height, i2));
    }

    public static Point monitor(Point raw, int i2) {
        return raw == null ? null : new Point(Utilities.monitor(raw.x, i2), Utilities.monitor(raw.y, i2));
    }

    public static Rectangle monitor(Rectangle raw, int i2) {
        return raw == null ? null : new Rectangle(Utilities.monitor(raw.x, i2), Utilities.monitor(raw.y, i2), Utilities.monitor(raw.width, i2), Utilities.monitor(raw.height, i2));
    }

    public static Insets monitor(Insets raw, int i2) {
        return raw == null ? null : new Insets(Utilities.monitor(raw.top, i2), Utilities.monitor(raw.left, i2), Utilities.monitor(raw.bottom, i2), Utilities.monitor(raw.right, i2));
    }

    public static InsetsUIResource monitor(InsetsUIResource raw, int i2) {
        return raw == null ? null : new InsetsUIResource(Utilities.monitor(raw.top, i2), Utilities.monitor(raw.left, i2), Utilities.monitor(raw.bottom, i2), Utilities.monitor(raw.right, i2));
    }

    static {
        viewRect = new Rectangle();
        textRect = new Rectangle();
        iconRect = new Rectangle();
        viewInsets = new Insets(0, 0, 0, 0);
        shapeCache_ = new HashMap();
        rescale_ = new boolean[]{false};
        scale_ = new double[]{1.0};
        scaleFlag_ = false;
    }
}

