/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.shape;

import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.utilities.VersionStamp;

public class EdgeProfileFrame
implements EdgeProfile {
    protected double width_;
    protected double innerEdge_;
    protected double outerEdge_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8 202102030211 (Sun Microsystems Inc.|1.6.0_45|50.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public EdgeProfileFrame() {
        this(Math.ceil(CuiLookAndFeel.getExteriorEdge() + CuiLookAndFeel.getInteriorEdge()), CuiLookAndFeel.getExteriorEdge(), CuiLookAndFeel.getInteriorEdge());
    }

    public EdgeProfileFrame(double width) {
        this(width, CuiLookAndFeel.getExteriorEdge(), CuiLookAndFeel.getInteriorEdge());
    }

    public EdgeProfileFrame(double width, double innerEdge, double outerEdge) {
        this.width_ = width;
        this.innerEdge_ = innerEdge;
        this.outerEdge_ = outerEdge;
    }

    @Override
    public double getInteriorWidth() {
        return this.width_;
    }

    @Override
    public double getExteriorWidth() {
        return 0.0;
    }

    @Override
    public double getSlope(double distanceFromShape) {
        double slope;
        if (distanceFromShape <= 0.0 || distanceFromShape >= this.width_) {
            return 0.0;
        }
        if (distanceFromShape < this.outerEdge_) {
            double d2 = distanceFromShape;
            slope = (this.outerEdge_ - d2) * (this.outerEdge_ - d2) / (this.outerEdge_ * this.outerEdge_);
        } else if (distanceFromShape < this.width_ - this.innerEdge_) {
            slope = 0.0;
        } else {
            double d3 = this.width_ - distanceFromShape;
            slope = -1.0 * (this.innerEdge_ - d3) * (this.innerEdge_ - d3) / (this.innerEdge_ * this.innerEdge_);
        }
        return slope;
    }

    public String toString() {
        return "EdgeProfileFrame[" + this.width_ + "," + this.innerEdge_ + "," + this.outerEdge_ + "]";
    }
}

