/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.JnPoint2D;
import java.io.Serializable;

public abstract class CPointBase
extends JnVector3d
implements Cloneable,
Serializable {
    public static final byte IMAGE = 0;
    public static final byte DISPLAY = 1;
    public static final byte RAS = 2;
    public static final byte NORMALIZED = 3;
    public static final byte LPS = 4;
    public static final byte VOXEL = 5;
    private static String[] csysname = new String[]{"IMAGE", "DISPLAY", "RAS", "NORMALIZED", "LPS", "VOXEL"};
    public byte csystem = (byte)2;

    public CPointBase() {
    }

    public CPointBase(byte csystem) {
        this.csystem = csystem;
    }

    public CPointBase(double[] p2, byte csystem) {
        this.setPoint(p2[0], p2[1], p2[2], csystem);
    }

    public CPointBase(double x2, double y2, double z2, byte csystem) {
        this.setPoint(x2, y2, z2, csystem);
    }

    public CPointBase(int x2, int y2, int z2, byte csystem) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.csystem = csystem;
    }

    public static String getCSystem(byte csystem_val) {
        return csysname[csystem_val];
    }

    @Override
    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")_" + csysname[this.csystem];
    }

    public final void setPoint(CPointBase cp) {
        this.setPoint(cp.x, cp.y, cp.z, cp.csystem);
    }

    public final void setPoint(double x2, double y2, double z2, byte csystem) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.csystem = csystem;
    }

    public final void setPoint(CPointBase p0, CPointBase p2) {
        this.x = p2.x - p0.x;
        this.y = p2.y - p0.y;
        this.z = p2.z - p0.z;
        this.csystem = p2.csystem;
    }

    public final void setPoint(JnPoint2D p0, JnPoint2D p2) {
        this.x = p2.getX() - p0.getX();
        this.y = p2.getY() - p0.getY();
        this.z = 0.0;
        this.csystem = 1;
    }
}

