/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.render.XpDrawableFactory;
import com.ge.med.terra.jami.render.XpImage2DRenderer;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpJImage2DRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.util.List;

public class JImage2DVc
extends XpImage2DVc {
    private static final String uiClassID = "XpImage2DRenderer";
    private CTransform _tempTrans = new CTransform();
    private static String defaultRenderer = null;
    private XpImage2DRenderer implementation = null;
    private long _paintCount = 0L;
    private boolean enabled = true;
    private String rendererType = "";
    private boolean clipGraphics = true;

    public JImage2DVc() {
        this.initializeImageVc(null);
    }

    public JImage2DVc(String rendererType) {
        this.initializeImageVc(rendererType);
    }

    private void initializeImageVc(String rType) {
        this.setDoubleBuffered(true);
        this.rendererType = rType;
        this.setBackground(Color.black);
        if (defaultRenderer == null) {
            defaultRenderer = XpPropertiesManager.getProperty("jami.render", "com.ge.med.terra.jami.render.XpJImage2DRenderer");
            XpLog.logger().config("JAMI: Using " + defaultRenderer + " renderer.");
        }
        if (this.rendererType == null) {
            this.rendererType = defaultRenderer;
        }
        this.implementation = this.createImage2DRenderer(this.rendererType);
    }

    protected XpImage2DRenderer createImage2DRenderer(String implType) {
        XpImage2DRenderer impl = (XpImage2DRenderer)XpPropertiesManager.create(implType);
        if (impl == null) {
            XpLog.logger().warning("Cannot create implementation " + implType + ",  will use pure java instead.");
            impl = new XpJImage2DRenderer();
        }
        this.setUI(impl);
        return impl;
    }

    @Override
    public boolean contains(int x2, int y2) {
        return this.enabled;
    }

    @Override
    public final void setImageRenderAttributes(XpImageRenderAttributes attr) {
        this.implementation.setImageRenderAttributes(attr);
    }

    public final XpImage2DRenderer getImageRenderer() {
        return this.implementation;
    }

    @Override
    public final XpImageRenderAttributes getImageRenderAttributes() {
        return this.implementation.getImageRenderAttributes();
    }

    @Override
    public XpImagePixelAttributes getImagePixelAttributes(int layer) {
        return this.implementation.getImagePixelAttributes(layer);
    }

    @Override
    public final void setImage(XpImage image) {
        this.implementation.setImage(image);
        super.setImage(image);
    }

    @Override
    public final void setImageLayers(List imgLayers) {
        this.implementation.setImageLayers(imgLayers);
    }

    @Override
    public final void setImage(RenderedImage image) {
        this.implementation.setImage(image);
    }

    @Override
    public void refreshImage() {
        this.implementation.refreshImage();
    }

    @Override
    public final XpImageOrientation getDisplayOrientation() {
        return this.implementation.getDisplayOrientation();
    }

    @Override
    public final XpImage getFrame() {
        return this.implementation.getFrame();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x2, int y2, int width, int height) {
        return 0 == (infoflags & 1) && 0 == (infoflags & 2);
    }

    @Override
    public final RenderedImage getImage() {
        return this.implementation.getImage();
    }

    @Override
    public CTransform getTransform(byte in, byte out) {
        if (in == 0 && out == 1) {
            return this.implementation.getTransform();
        }
        if (in == 1 && out == 0) {
            CTransform ct = this.implementation.getTransform();
            ct.inverse(this._tempTrans);
            return this._tempTrans;
        }
        return super.getTransform(in, out);
    }

    public final AffineTransform getTransform2D() {
        return this.implementation.getTransform2D();
    }

    @Override
    public final void setImageClip(Shape s2) {
        this.implementation.setImageClip(s2);
    }

    @Override
    public final Shape getImageClip() {
        return this.implementation.getImageClip();
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        ++this._paintCount;
    }

    @Override
    public final void paintChildren(Graphics g2) {
        if (this.clipGraphics) {
            this.implementation.applyClip((Graphics2D)g2);
        }
        super.paintChildren(g2);
        if (this.clipGraphics) {
            this.implementation.clearClip((Graphics2D)g2);
        }
    }

    @Override
    public final void setClipGraphics(boolean clipGraphics) {
        this.clipGraphics = clipGraphics;
    }

    @Override
    public final boolean isClipGraphics() {
        return this.clipGraphics;
    }

    @Override
    public final long getPaintCount() {
        return this._paintCount;
    }

    @Override
    public void updateUI() {
        this.implementation = this.createImage2DRenderer(defaultRenderer);
        XpLog.logger().config("XpImage2DVc: UpdateUI");
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public Shape getClipShape() {
        return this.implementation.getClipShape();
    }

    @Override
    public void setClipShape(Shape clipShape) {
        this.implementation.setClipShape(clipShape);
    }

    @Override
    public final Object getInterpolationHint() {
        return this.implementation.getInterpolationHint();
    }

    @Override
    public final void setInterpolationHint(Object interpolationHint) {
        this.implementation.setInterpolationHint(interpolationHint);
    }

    public final void configPipeline(int pipelineStage, boolean execute) {
        this.implementation.configPipeline(pipelineStage, execute);
    }

    @Override
    public final void setFitToViewport(boolean fToViewport) {
        this.implementation.setFitToViewport(fToViewport);
    }

    @Override
    public final boolean getFitToViewport() {
        return this.implementation.getFitToViewport();
    }

    @Override
    public final void setDrawableFactory(XpDrawableFactory drwF) {
        this.implementation.setDrawableFactory(drwF);
    }

    public final XpDrawableFactory getDrawableFactory() {
        return this.implementation.getDrawableFactory();
    }

    @Override
    public final void refreshImageRenderAttributes() {
        this.implementation.refreshImageRenderAttributes();
    }

    @Override
    public boolean isFusionCapable() {
        return true;
    }

    @Override
    public int getImageLayer() {
        return this.getImageRenderer().getImageLayer();
    }

    @Override
    public void selectImageLayer(int layer) {
        this.getImageRenderer().selectImageLayer(layer);
    }

    @Override
    public int getNumImageLayers() {
        return this.getImageRenderer().getNumImageLayers();
    }

    @Override
    public void dispose() {
        this.getImageRenderer().dispose();
    }

    @Override
    public List getImageLayers() {
        return this.getImageRenderer().getImageLayers();
    }

    @Override
    public void setPixelCombiner(XjFusionPixelCombiner fpc) {
        this.getImageRenderer().setPixelCombiner(fpc);
    }

    @Override
    public XjFusionPixelCombiner getPixelCombiner() {
        return this.getImageRenderer().getPixelCombiner();
    }

    @Override
    public AffineTransform getAffineTransform() {
        return this.getImageRenderer().getAffineTransform();
    }

    @Override
    public long getRenderTimeStamp() {
        return this.getImageRenderer().getRenderTimeStamp();
    }
}

