/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSelectableOwner;
import com.ge.med.terra.jami.XpSelectionManager;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpUserAnnotationVc;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.capable.UserAnnoCapable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

public class XpAppContext {
    private static Color SELECTED_COLOR = Color.yellow;
    private static Color UNSELECTED_COLOR = Color.cyan;
    private static boolean shadowed = false;
    private static XpAppContext app = null;
    private XpSelectionManager sm = null;

    private XpAppContext() {
        String smClass = XpPropertiesManager.getProperty("jami.selectionmanager", null);
        this.sm = smClass != null ? this.createSelectionManager(smClass) : new DSelectionManager();
    }

    private XpSelectionManager createSelectionManager(String implType) {
        XpSelectionManager implementation = (XpSelectionManager)XpPropertiesManager.create(implType);
        if (implementation == null) {
            XpLog.logger().warning("Cannot create implementation " + implType + ",  will use default selection manager.");
            implementation = new DSelectionManager();
        }
        return implementation;
    }

    public final XpSelectionManager getSelectionManager() {
        return this.sm;
    }

    public static XpAppContext instance() {
        if (app == null) {
            app = new XpAppContext();
        }
        return app;
    }

    public static final Color getSelectedColor() {
        return SELECTED_COLOR;
    }

    public static final Color getUnSelectedColor() {
        return UNSELECTED_COLOR;
    }

    public static final void setSelectedColor(Color scolor) {
        SELECTED_COLOR = scolor;
    }

    public static final void setUnSelectedColor(Color uscolor) {
        UNSELECTED_COLOR = uscolor;
    }

    public static final void setShadowed(boolean shadow) {
        shadowed = shadow;
    }

    public static final boolean isShadowed() {
        return shadowed;
    }

    private static class AWTRecorder
    implements AWTEventListener {
        private AWTRecorder() {
        }

        private int buttonMask(int mod) {
            boolean b3;
            int bmask = 0;
            boolean b1 = 0 != (mod & 0x10);
            boolean b2 = 0 != (mod & 8);
            boolean bl = b3 = 0 != (mod & 4);
            if (b1) {
                bmask |= 0x10;
            }
            if (b2) {
                bmask |= 8;
            }
            if (b3) {
                bmask |= 4;
            }
            return bmask;
        }

        @Override
        public void eventDispatched(AWTEvent e2) {
            if (e2 instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e2;
                Component c2 = (Component)me.getSource();
                int mod = me.getModifiers();
                if (e2 instanceof MouseWheelEvent) {
                    MouseWheelEvent mwe = (MouseWheelEvent)e2;
                } else if (me.getID() != 502 && me.getID() != 501 && (me.getID() == 503 || me.getID() == 506)) {
                    Point p2 = c2.getLocationOnScreen();
                }
            } else if (e2 instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)e2;
                System.err.println("-- KeyEvent[" + ke.getSource() + "]");
            } else if (e2 instanceof FocusEvent) {
                FocusEvent fe = (FocusEvent)e2;
                String name0 = fe.getComponent().toString().substring(0, fe.getComponent().toString().indexOf("["));
                String name1 = "" + fe.getOppositeComponent();
                System.err.println("-- FocusEvent: " + name0 + "   " + name1);
            }
        }
    }

    private static class DSelectionManager
    extends KeyAdapter
    implements XpSelectionManager,
    MouseListener {
        private List selected = new ArrayList();
        PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        private DSelectionManager() {
        }

        @Override
        public final List getSelected() {
            return this.selected;
        }

        @Override
        public final void addComponent(Component c2) {
            if (c2 instanceof XpSelectableOwner) {
                XpSelectableOwner so = (XpSelectableOwner)((Object)c2);
                Selectable[] s2 = so.getSelectable();
                if (s2 != null) {
                    for (int i2 = 0; i2 < s2.length; ++i2) {
                        this.addSelectable(s2[i2]);
                    }
                }
            } else if (c2 instanceof Selectable) {
                this.addSelectable((Selectable)((Object)c2));
            }
            c2.addKeyListener(this);
            c2.addMouseListener(this);
        }

        @Override
        public final void removeComponent(Component c2) {
            if (c2 instanceof XpSelectableOwner) {
                XpSelectableOwner so = (XpSelectableOwner)((Object)c2);
                Selectable[] s2 = so.getSelectable();
                if (s2 != null) {
                    for (int i2 = 0; i2 < s2.length; ++i2) {
                        this.removeSelectable(s2[i2]);
                    }
                }
            } else if (c2 instanceof Selectable) {
                this.removeSelectable((Selectable)((Object)c2));
            }
            c2.removeKeyListener(this);
            c2.removeMouseListener(this);
        }

        @Override
        public final void addSelectable(Selectable s2) {
            if (s2 != null) {
                this.clear();
                this.select(s2);
            }
        }

        @Override
        public final void removeSelectable(Selectable s2) {
            if (s2 != null) {
                this.selected.remove(s2);
                s2.setSelected(false);
                this.pcs.firePropertyChange("ComponentSelection", s2, null);
            }
        }

        private void deleteTheSelectable(Selectable s2, Object source) {
            if (s2 instanceof RoiActor) {
                ROICapable rc;
                RoiActor ra = (RoiActor)s2;
                XpImageRoiVc roivc = (XpImageRoiVc)source;
                if (roivc != null && (rc = (ROICapable)((Object)roivc.findParentByClass(roivc, ROICapable.class))) != null) {
                    XpImage2DVc ivc = (XpImage2DVc)roivc.findParentByClass(roivc, XpImage2DVc.class);
                    if (ivc != null) {
                        ivc.requestFocus();
                    }
                    rc.remove(ra);
                }
            } else if (s2 instanceof XpUserAnnotationModel) {
                UserAnnoCapable uac;
                XpUserAnnotationModel uam = (XpUserAnnotationModel)s2;
                XpUserAnnotationVc uavc = (XpUserAnnotationVc)source;
                if (uavc != null && (uac = (UserAnnoCapable)((Object)uavc.findParentByClass(uavc, UserAnnoCapable.class))) != null) {
                    XpImage2DVc ivc = (XpImage2DVc)uavc.findParentByClass(uavc, XpImage2DVc.class);
                    if (ivc != null) {
                        ivc.requestFocus();
                    }
                    uac.remove(uam);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            int key = ke.getKeyCode();
            Object source = ke.getSource();
            if (key == 127) {
                int len = this.selected.size();
                if (len > 0) {
                    for (int i2 = 0; i2 < len; ++i2) {
                        Selectable s2 = (Selectable)this.selected.get(0);
                        this.deleteTheSelectable(s2, source);
                    }
                } else if (source instanceof XpSelectableOwner) {
                    XpSelectableOwner so = (XpSelectableOwner)source;
                    Selectable[] s3 = so.getSelectable();
                    this.deleteTheSelectable(s3[0], so);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
        }

        private void select(Selectable s2) {
            s2.setSelected(true);
            if (s2.isSelected()) {
                this.selected.add(s2);
                this.pcs.firePropertyChange("ComponentSelection", null, s2);
            }
        }

        private void doSelect(MouseEvent me) {
            boolean multi = 0 != (me.getModifiers() & 1);
            Object source = me.getSource();
            if (source instanceof XpSelectableOwner) {
                int ncleared = 0;
                if (!multi) {
                    ncleared = this.clear();
                }
                XpSelectableOwner so = (XpSelectableOwner)source;
                Selectable[] sel = so.getSelectable();
                int nselected = 0;
                if (sel != null) {
                    for (int i2 = 0; i2 < sel.length; ++i2) {
                        this.select(sel[i2]);
                        ++nselected;
                    }
                }
                if (nselected == 0 && ncleared > 0) {
                    this.pcs.firePropertyChange("ComponentSelection", null, null);
                }
            } else {
                this.clearSelection();
            }
            Component c2 = (Component)source;
            c2.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent me) {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            Object o2 = me.getSource();
            if (o2 instanceof Component) {
                ((Component)o2).requestFocus();
            }
            this.doSelect(me);
        }

        private int clear() {
            int len = this.selected.size();
            int ncleared = 0;
            for (int i2 = 0; i2 < len; ++i2) {
                Selectable s2 = (Selectable)this.selected.get(i2);
                if (!s2.isSelected()) continue;
                s2.setSelected(false);
                ++ncleared;
            }
            this.selected.clear();
            return ncleared;
        }

        @Override
        public final void clearSelection() {
            if (this.clear() > 0) {
                this.pcs.firePropertyChange("ComponentSelection", null, null);
            }
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l2) {
            this.pcs.addPropertyChangeListener(l2);
        }

        @Override
        public void addPropertyChangeListener(String name, PropertyChangeListener l2) {
            this.pcs.addPropertyChangeListener(name, l2);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l2) {
            this.pcs.removePropertyChangeListener(l2);
        }

        @Override
        public void removePropertyChangeListener(String name, PropertyChangeListener l2) {
            this.pcs.removePropertyChangeListener(name, l2);
        }
    }
}

