/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.ClipCapable;
import com.ge.med.idc.XjDicomObjectFrame;
import com.ge.med.jnu.JnMatrix;
import com.ge.med.jnu.JnVector;
import com.ge.med.jnu.geom.Point2DXmlAdapter;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpGeomUtilsBase;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.capable.CPISerializable;
import com.ge.med.terra.jami.capable.GraphicEditable;
import com.ge.med.terra.jami.filter.XpImageLut;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.roi.XpPolygonRoi;
import com.ge.med.terra.jami.roi.XpRectangularRoi;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlSeeAlso(value={DisplayedArea.class})
public class XpCPI {
    private static final double EPSILON = 1.0E-4;
    private static JnMatrix m = new JnMatrix(3, 3);
    private static JnVector b = new JnVector(3);
    private static JnVector v0 = new JnVector(3);
    private static JnVector v1 = new JnVector(3);
    private static XpDicomElement sopInstanceUID = new XpDicomElement(8, 24);
    private static XpDicomElement sopClassUID = new XpDicomElement(8, 22);
    private static Point2D tempPt1 = new Point2D.Double();
    private static Point2D tempPt2 = new Point2D.Double();
    private static Point2D tempPt3 = new Point2D.Double();
    private static boolean debug = false;
    private static boolean editable = true;
    private static double SMALL_NUM = 0.001;
    private static final int VP_DIM = 512;
    public static final String SCALE_TO_FIT = "SCALE TO FIT";
    public static final String TRUE_SIZE = "TRUE SIZE";
    public static final String MAGNIFY = "MAGNIFY";
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String CENTER = "CENTER";
    public static final String POINT = "POINT";
    public static final String POLYLINE = "POLYLINE";
    public static final String INTERPOLATED = "INTERPOLATED";
    public static final String CIRCLE = "CIRCLE";
    public static final String ELLIPSE = "ELLIPSE";
    public static final String RECTANGULAR = "RECTANGULAR";
    public static final String CIRCULAR = "CIRCULAR";
    public static final String POLYGONAL = "POLYGONAL";
    public static final String USER = "USER";
    public static final String AUTOMATED = "AUTOMATED";
    public static final String BITMAP = "BITMAP";
    public static final String IDENTITY = "IDENTITY";
    public static final String INVERSE = "INVERSE";
    private List<DisplayedArea> displayedAreaModule = new ArrayList<DisplayedArea>();
    private List<GraphicAnnotation> graphicAnnoModule = new ArrayList<GraphicAnnotation>();
    private List<SoftcopyVoiLut> softcopyVoiModule = new ArrayList<SoftcopyVoiLut>();
    private SoftcopyPresentationLut softPresModule = new SoftcopyPresentationLut();
    private ModalityLut modalityLutModule = new ModalityLut();
    private SpatialTransformation st = new SpatialTransformation();
    private DisplayShutter idShutter = null;
    private DisplayShutter dShutter = null;
    private BitmapDisplayShutter bdShutter = null;
    private int nImages = 0;
    private List<String> cpiSerializeables = new ArrayList<String>();

    public List getDisplayedAreaModule() {
        return this.displayedAreaModule;
    }

    public void setDisplayedAreaModule(List displayedAreaModule) {
        this.displayedAreaModule = displayedAreaModule;
    }

    public List getGraphicAnnoModule() {
        return this.graphicAnnoModule;
    }

    public void setGraphicAnnoModule(List graphicAnnoModule) {
        this.graphicAnnoModule = graphicAnnoModule;
    }

    public List getSoftcopyVoiModule() {
        return this.softcopyVoiModule;
    }

    public void setSoftcopyVoiModule(List softcopyVoiModule) {
        this.softcopyVoiModule = softcopyVoiModule;
    }

    public SoftcopyPresentationLut getSoftPresModule() {
        return this.softPresModule;
    }

    public void setSoftPresModule(SoftcopyPresentationLut softPresModule) {
        this.softPresModule = softPresModule;
    }

    public ModalityLut getModalityLutModule() {
        return this.modalityLutModule;
    }

    public void setModalityLutModule(ModalityLut modalityLutModule) {
        this.modalityLutModule = modalityLutModule;
    }

    public SpatialTransformation getSt() {
        return this.st;
    }

    public void setSt(SpatialTransformation st) {
        this.st = st;
    }

    public DisplayShutter getIdShutter() {
        return this.idShutter;
    }

    public void setIdShutter(DisplayShutter idShutter) {
        this.idShutter = idShutter;
    }

    public DisplayShutter getdShutter() {
        return this.dShutter;
    }

    public void setdShutter(DisplayShutter dShutter) {
        this.dShutter = dShutter;
    }

    public BitmapDisplayShutter getBdShutter() {
        return this.bdShutter;
    }

    public void setBdShutter(BitmapDisplayShutter bdShutter) {
        this.bdShutter = bdShutter;
    }

    public int getNImages() {
        return this.nImages;
    }

    public final List<DisplayedArea> getDisplayedArea() {
        return this.displayedAreaModule;
    }

    public final DisplayShutter getDisplayShutter(int coordSystem) {
        if (coordSystem == 0) {
            return this.idShutter;
        }
        return this.dShutter;
    }

    public final void setDisplayShutter(DisplayShutter ds, int coordSystem) {
        if (coordSystem == 0) {
            this.idShutter = ds;
        } else {
            this.dShutter = ds;
        }
    }

    public final BitmapDisplayShutter getBitmapDisplayShutter() {
        return this.bdShutter;
    }

    public final List<GraphicAnnotation> getGraphicAnnotation() {
        return this.graphicAnnoModule;
    }

    public final List<SoftcopyVoiLut> getSoftcopyVoiLut() {
        return this.softcopyVoiModule;
    }

    public final SoftcopyPresentationLut getSoftcopyPresentationLut() {
        return this.softPresModule;
    }

    public final ModalityLut getModalityLut() {
        return this.modalityLutModule;
    }

    public static void setDebug(boolean db) {
        debug = db;
    }

    public static void setEditable(boolean edit) {
        editable = edit;
    }

    public final SpatialTransformation getSpatialTransformation() {
        return this.st;
    }

    public final void setSpatialTransformation(XpImageOrientation ior) {
        this.st.flipHorizontal = ior.getFlip();
        double angle = ior.getAngle();
        this.st.angle = this.st.flipHorizontal ? -angle : angle;
    }

    private static List<Point2D> dupPointList(List<Point2D> data) {
        ArrayList<Point2D> dupdata = new ArrayList<Point2D>();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            Point2D p2 = data.get(i2);
            Point2D.Double np = new Point2D.Double();
            np.setLocation(p2);
            dupdata.add(np);
        }
        return dupdata;
    }

    public static RoiActor createROI(String graphicType, List<Point2D> gdata, boolean filled, byte csystem, String objectClass) {
        RoiActor ra;
        block44: {
            ra = null;
            if (objectClass != null && !"".equals(objectClass)) {
                try {
                    Object o2;
                    Class<?> c2 = Class.forName(objectClass);
                    Class[] argTypes = new Class[]{List.class, Boolean.TYPE, Byte.TYPE};
                    Method m2 = c2.getMethod("createRoiActor", argTypes);
                    if (Modifier.isStatic(m2.getModifiers()) && RoiActor.class.isAssignableFrom(m2.getReturnType()) && (o2 = m2.invoke(null, gdata, filled, csystem)) != null && o2.getClass().equals(c2)) {
                        ra = (RoiActor)o2;
                        if (ra instanceof GraphicEditable) {
                            GraphicEditable er = ra;
                            er.setEditable(editable);
                        }
                        return ra;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (debug) {
                        cnfe.printStackTrace();
                    }
                }
                catch (SecurityException e2) {
                    if (debug) {
                        e2.printStackTrace();
                    }
                }
                catch (NoSuchMethodException e3) {
                    if (debug) {
                        e3.printStackTrace();
                    }
                }
                catch (IllegalArgumentException e4) {
                    if (debug) {
                        e4.printStackTrace();
                    }
                }
                catch (IllegalAccessException e5) {
                    if (debug) {
                        e5.printStackTrace();
                    }
                }
                catch (InvocationTargetException e6) {
                    if (!debug) break block44;
                    e6.printStackTrace();
                }
            }
        }
        if (debug) {
            System.out.println("createRoiActor: no valid factory method found or factory method failed to create object");
        }
        if (!graphicType.equals(POINT)) {
            if (graphicType.equals(POLYLINE)) {
                int npts = gdata.size();
                List<Point2D> rgdata = XpCPI.dupPointList(gdata);
                boolean isRect = false;
                if (npts == 5) {
                    Point2D p1 = rgdata.get(0);
                    Point2D p2 = rgdata.get(1);
                    Point2D p3 = rgdata.get(2);
                    Point2D p4 = rgdata.get(3);
                    Point2D p5 = rgdata.get(4);
                    if (p1.getX() == p5.getX() && p1.getY() == p5.getY()) {
                        double cx = (p1.getX() + p2.getX() + p3.getX() + p4.getX()) / 4.0;
                        double cy = (p1.getY() + p2.getY() + p3.getY() + p4.getY()) / 4.0;
                        double angle = Math.atan((p1.getY() - p2.getY()) / (p2.getX() - p1.getX()));
                        XpGeomUtils gu = new XpGeomUtils();
                        gu.getRotatedPoint(p1.getX(), p1.getY(), angle, cx, cy, p1);
                        gu.getRotatedPoint(p2.getX(), p2.getY(), angle, cx, cy, p2);
                        gu.getRotatedPoint(p3.getX(), p3.getY(), angle, cx, cy, p3);
                        gu.getRotatedPoint(p4.getX(), p4.getY(), angle, cx, cy, p4);
                        gu.getRotatedPoint(p5.getX(), p5.getY(), angle, cx, cy, p5);
                        double diff1 = Math.abs(p2.getX() - p3.getX());
                        double diff2 = Math.abs(p1.getX() - p4.getX());
                        if (diff1 < SMALL_NUM && diff2 < SMALL_NUM) {
                            if (debug) {
                                System.out.println("A RECTANGLE FOUND....");
                            }
                            double ulX = Double.MAX_VALUE;
                            double ulY = Double.MAX_VALUE;
                            double brX = Double.MIN_VALUE;
                            double brY = Double.MIN_VALUE;
                            for (int i2 = 0; i2 < rgdata.size(); ++i2) {
                                Point2D p6 = rgdata.get(i2);
                                double x2 = p6.getX();
                                double y2 = p6.getY();
                                if (x2 < ulX) {
                                    ulX = x2;
                                }
                                if (x2 > brX) {
                                    brX = x2;
                                }
                                if (y2 < ulY) {
                                    ulY = y2;
                                }
                                if (!(y2 > brY)) continue;
                                brY = y2;
                            }
                            double w2 = Math.abs(ulX - brX);
                            double h2 = Math.abs(ulY - brY);
                            Rectangle2D.Double r2 = new Rectangle2D.Double(ulX, ulY, w2, h2);
                            XpRectangularRoi.Rectangle xrr = new XpRectangularRoi.Rectangle(r2);
                            xrr.setAngle(angle);
                            ra = xrr;
                            isRect = true;
                        }
                    }
                }
                if (!isRect) {
                    Point2D[] pts = new Point2D[npts];
                    for (int i3 = 0; i3 < npts; ++i3) {
                        Point2D p7 = gdata.get(i3);
                        double x3 = p7.getX();
                        double y3 = p7.getY();
                        pts[i3] = new Point2D.Double(x3, y3);
                    }
                    boolean doHandles = true;
                    if (pts.length > 50) {
                        doHandles = false;
                    }
                    ra = new XpPolygonRoi(pts, false, doHandles);
                }
            } else if (graphicType.equals(INTERPOLATED)) {
                int npts = gdata.size();
                Point2D[] pts = new Point2D[npts];
                for (int i4 = 0; i4 < npts; ++i4) {
                    Point2D p8 = gdata.get(i4);
                    double x4 = p8.getX();
                    double y4 = p8.getY();
                    pts[i4] = new Point2D.Double(x4, y4);
                }
                boolean doHandles = true;
                if (pts.length > 50) {
                    doHandles = false;
                }
                ra = new XpPolygonRoi(pts, false, doHandles);
            } else if (graphicType.equals(CIRCLE)) {
                Point2D center = gdata.get(0);
                Point2D circ = gdata.get(1);
                double cx = center.getX();
                double cy = center.getY();
                double dx = circ.getX() - cx;
                double dy = circ.getY() - cy;
                double radius = Math.sqrt(dx * dx + dy * dy);
                double x5 = cx - radius;
                double y5 = cy - radius;
                double dim = 2.0 * radius;
                Ellipse2D.Double e7 = new Ellipse2D.Double(x5, y5, dim, dim);
                ra = new XpRectangularRoi.Ellipse(e7);
            } else if (graphicType.equals(ELLIPSE)) {
                List<Point2D> rgdata = XpCPI.dupPointList(gdata);
                double ulX = Double.MAX_VALUE;
                double ulY = Double.MAX_VALUE;
                double brX = Double.MIN_VALUE;
                double brY = Double.MIN_VALUE;
                Point2D p1 = rgdata.get(0);
                Point2D p2 = rgdata.get(1);
                Point2D p3 = rgdata.get(2);
                Point2D p4 = rgdata.get(3);
                double cx = (p1.getX() + p2.getX() + p3.getX() + p4.getX()) / 4.0;
                double cy = (p1.getY() + p2.getY() + p3.getY() + p4.getY()) / 4.0;
                double num = p1.getY() - p2.getY();
                double denom = p2.getX() - p1.getX();
                if (Math.abs(denom) > 1.0E-4 || Math.abs(num) > 1.0E-4) {
                    double angle = 0.0;
                    if (Math.abs(denom) > 1.0E-4) {
                        angle = Math.atan(num / denom);
                    }
                    XpGeomUtils gu = new XpGeomUtils();
                    gu.getRotatedPoint(p1.getX(), p1.getY(), angle, cx, cy, p1);
                    gu.getRotatedPoint(p2.getX(), p2.getY(), angle, cx, cy, p2);
                    gu.getRotatedPoint(p3.getX(), p3.getY(), angle, cx, cy, p3);
                    gu.getRotatedPoint(p4.getX(), p4.getY(), angle, cx, cy, p4);
                    for (int i5 = 0; i5 < rgdata.size(); ++i5) {
                        Point2D p9 = rgdata.get(i5);
                        double x6 = p9.getX();
                        double y6 = p9.getY();
                        if (x6 < ulX) {
                            ulX = x6;
                        }
                        if (x6 > brX) {
                            brX = x6;
                        }
                        if (y6 < ulY) {
                            ulY = y6;
                        }
                        if (!(y6 > brY)) continue;
                        brY = y6;
                    }
                    double w3 = Math.abs(ulX - brX);
                    double h3 = Math.abs(ulY - brY);
                    Ellipse2D.Double e8 = new Ellipse2D.Double(ulX, ulY, w3, h3);
                    XpRectangularRoi.Ellipse rr = new XpRectangularRoi.Ellipse(e8);
                    rr.setAngle(angle);
                    ra = rr;
                }
            }
        }
        if (ra instanceof GraphicEditable) {
            GraphicEditable er = ra;
            er.setEditable(editable);
        }
        return ra;
    }

    public static XpCPI createCPI(List<XpImageScene> scenes, Dimension vpDim, boolean sharedIRA) {
        int len = scenes.size();
        XpMedicalImage[] imgs = new XpMedicalImage[len];
        XpImageRenderAttributes[] iras = new XpImageRenderAttributes[len];
        List[] rois = new List[len];
        List[] uannos = new List[len];
        for (int i2 = 0; i2 < len; ++i2) {
            XpImageScene is = scenes.get(i2);
            imgs[i2] = (XpMedicalImage)is.getFrame();
            iras[i2] = is.getImageRenderAttributes();
            rois[i2] = is.getRois();
            uannos[i2] = is.getUserAnnos();
        }
        return XpCPI.createCPI(imgs, iras, rois, uannos, vpDim, sharedIRA);
    }

    @Deprecated
    public static XpCPI createCPI(XpMedicalImage[] imgs, XpImageRenderAttributes[] iras, List[] arois, List[] auannos, Dimension vpDim, boolean sharedIRA, boolean multiFrame) {
        XpCPI cpi = new XpCPI();
        XpCPI.add2CPI(imgs, iras, arois, auannos, vpDim, sharedIRA, multiFrame, cpi);
        return cpi;
    }

    public static XpCPI createCPI(XpMedicalImage[] imgs, XpImageRenderAttributes[] iras, List[] arois, List[] auannos, Dimension vpDim, boolean sharedIRA) {
        XpCPI cpi = new XpCPI();
        XpCPI.add2CPI(imgs, iras, arois, auannos, vpDim, sharedIRA, cpi);
        return cpi;
    }

    public static void addDisplayShutter(Shape s2, int coordSys, int shutterPValue, XpCPI cpi) {
        DisplayShutter dsh = null;
        if (coordSys == 1) {
            dsh = cpi.dShutter = new DisplayShutter();
        } else if (coordSys == 0) {
            dsh = cpi.idShutter = new DisplayShutter();
        }
        if (dsh != null) {
            dsh.coordSystem = coordSys;
            if (s2 instanceof Ellipse2D) {
                Ellipse2D e2 = (Ellipse2D)s2;
                dsh.shutterShape = CIRCULAR;
                dsh.circularCenter.setLocation(e2.getCenterX(), e2.getCenterY());
                dsh.circularRadius = e2.getWidth() / 2.0;
            } else if (s2 instanceof Rectangle2D || s2 instanceof RoundRectangle2D) {
                RectangularShape r2 = (RectangularShape)s2;
                dsh.shutterShape = RECTANGULAR;
                dsh.rectULPoint.setLocation(r2.getX(), r2.getY());
                dsh.rectBRPoint.setLocation(r2.getX() + r2.getWidth(), r2.getY() + r2.getHeight());
            } else if (s2 instanceof Line2D) {
                Line2D l2 = (Line2D)s2;
                dsh.shutterShape = POLYGONAL;
                dsh.polygonalVertices = new ArrayList<Point2D>();
                Point2D p1 = l2.getP1();
                Point2D p2 = l2.getP2();
                dsh.polygonalVertices.add(new Point2D.Double(p1.getX(), p1.getY()));
                dsh.polygonalVertices.add(new Point2D.Double(p2.getX(), p2.getY()));
            } else if (s2 instanceof GeneralPath) {
                GeneralPath gp = (GeneralPath)s2;
                dsh.shutterShape = POLYGONAL;
                dsh.polygonalVertices = new ArrayList<Point2D>();
                AffineTransform identity = new AffineTransform();
                PathIterator pi = gp.getPathIterator(identity);
                double[] coords = new double[2];
                while (!pi.isDone()) {
                    pi.currentSegment(coords);
                    dsh.polygonalVertices.add(new Point2D.Double(coords[0], coords[1]));
                    pi.next();
                }
            }
            dsh.shutterPValue = shutterPValue;
        }
    }

    public static void applyBitmapDisplayShutter(BitmapDisplayShutter bds, XpImageRenderAttributes ira) {
        int[] cmap = new int[]{-16777216};
        int w2 = bds.overlayPlane.cols;
        int h2 = bds.overlayPlane.rows;
        byte[] idxmap = new byte[w2 * h2];
        for (int i2 = 0; i2 < idxmap.length; ++i2) {
            idxmap[i2] = bds.overlayPlane.overlayData[i2] != 0 ? 0 : -1;
        }
        XpColorOverlay co = new XpColorOverlay(idxmap, cmap, w2, h2);
        ira.setColorOverlay(co);
    }

    public static void setBitmapDisplayShutter(XpColorOverlay co, int shutterPValue, XpCPI cpi) {
        cpi.bdShutter = new BitmapDisplayShutter();
        System.out.println("Setting bmap display shutter...");
        int w2 = co.getWidth();
        int h2 = co.getHeight();
        cpi.bdShutter.shutterPValue = shutterPValue;
        cpi.bdShutter.overlayPlane.cols = w2;
        cpi.bdShutter.overlayPlane.rows = h2;
        Object clayer = co.getOverlay();
        int layerOffset = co.getOffset();
        int layerLength = co.getLength();
        if (clayer instanceof byte[]) {
            byte[] idxmap = (byte[])clayer;
            byte[] bitmap = new byte[layerLength];
            cpi.bdShutter.overlayPlane.overlayData = bitmap;
            for (int i2 = 0; i2 < layerLength; ++i2) {
                bitmap[i2] = idxmap[i2 + layerOffset] < 0 ? (byte)0 : 1;
            }
        } else {
            short[] idxmap = (short[])clayer;
            byte[] bitmap = new byte[layerLength];
            cpi.bdShutter.overlayPlane.overlayData = bitmap;
            for (int i3 = 0; i3 < layerLength; ++i3) {
                bitmap[i3] = idxmap[i3 + layerOffset] < 0 ? (byte)0 : 1;
            }
        }
        cpi.bdShutter.overlayPlane.nBitAllocated = 1;
        cpi.bdShutter.overlayPlane.overlayOrigin.setLocation(1.0, 1.0);
        cpi.bdShutter.overlayPlane.overlaySubType = USER;
        cpi.bdShutter.overlayPlane.overlayType = "G";
        cpi.bdShutter.overlayPlane.overlayDescription = "BITMAP_SHUTTER";
        cpi.bdShutter.overlayPlane.overlayLabel = "BITMAP_SHUTTER";
    }

    @Deprecated
    public static void add2CPI(XpMedicalImage[] imgs, XpImageRenderAttributes[] iras, List[] arois, List[] auannos, Dimension vpDim, boolean sharedIRA, boolean multiFrame, XpCPI cpi) {
        XpCPI.add2CPI(imgs, iras, arois, auannos, vpDim, sharedIRA, cpi);
    }

    public static void add2CPI(XpMedicalImage[] imgs, XpImageRenderAttributes[] iras, List[] arois, List[] auannos, Dimension vpDim, boolean sharedIRA, XpCPI cpi) {
        Rectangle viewport = new Rectangle();
        XpGeomUtils gu = new XpGeomUtils();
        AffineTransform tx = new AffineTransform();
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        viewport.width = (int)vpDim.getWidth();
        viewport.height = (int)vpDim.getHeight();
        viewport.width = 512;
        viewport.height = 512;
        int[] rgbs = null;
        Integer[] lutData = null;
        IndexColorModel prevLut = null;
        XpImageOrientation effOrientation = new XpImageOrientation();
        XpGeomUtilsBase.getDisplayOrientation(imgs[0].getAzimuth(), iras[0].getImageOrientation(), effOrientation);
        cpi.setSpatialTransformation(effOrientation);
        DisplayedArea dispArea = null;
        GraphicAnnotation gAnnot = null;
        SoftcopyVoiLut voiLUT = null;
        boolean first = true;
        for (int i2 = 0; i2 < imgs.length; ++i2) {
            XpImageRenderAttributes ira = iras[i2];
            XpMedicalImage mi = imgs[i2];
            int w2 = mi.getSlice().width;
            int h2 = mi.getSlice().height;
            mi.getValue(sopInstanceUID);
            mi.getValue(sopClassUID);
            boolean create = false;
            if (!sharedIRA || first) {
                create = true;
            }
            if (create) {
                dispArea = new DisplayedArea();
                voiLUT = new SoftcopyVoiLut();
                cpi.getDisplayedArea().add(dispArea);
                cpi.getSoftcopyVoiLut().add(voiLUT);
            }
            XpCPI.addOrUpdateFrame(mi, sharedIRA, dispArea.refImgSequence);
            if (!sharedIRA || first) {
                dispArea.pixelMagnificationRatio = 1.0;
                switch (ira.getPresentationSizeMode()) {
                    case 102: {
                        dispArea.presSize = MAGNIFY;
                        break;
                    }
                    case 100: {
                        dispArea.presSize = SCALE_TO_FIT;
                        break;
                    }
                    case 101: {
                        dispArea.presSize = TRUE_SIZE;
                    }
                }
                double pdX = mi.getPixelDimensionX();
                double pdY = mi.getPixelDimensionY();
                dispArea.presPixelSpacing.setLocation(pdX, pdY);
                try {
                    if (debug) {
                        System.out.println("BUILD CPI: Saving pan (" + ira.getPanX() + "," + ira.getPanY() + ")");
                    }
                    gu.calcDisplayedAreaTransform(viewport, ira, w2, h2, true, tx);
                    if (debug) {
                        System.out.println("BUILD CPI: disp area tx=" + tx);
                    }
                    ((Point2D)p1).setLocation(1.0, 1.0);
                    tx.inverseTransform(p1, p2);
                    dispArea.tlDisplay.setLocation(((Point2D)p2).getX(), ((Point2D)p2).getY());
                    ((Point2D)p1).setLocation(viewport.width, viewport.height);
                    tx.inverseTransform(p1, p2);
                    dispArea.brDisplay.setLocation(((Point2D)p2).getX(), ((Point2D)p2).getY());
                    if (debug) {
                        System.out.println("BUILD CPI: tl=" + dispArea.tlDisplay + "  br=" + dispArea.brDisplay);
                    }
                }
                catch (NoninvertibleTransformException ex) {
                    System.err.println("GSPS: Cannot invert current Affine Transform !!!");
                }
            }
            XpCPI.addOrUpdateFrame(mi, sharedIRA, voiLUT.refImgSequence);
            if (!sharedIRA || first) {
                double wl;
                double ww = ira.getWindowWidth();
                voiLUT.windowCenter = wl = ira.getWindowLevel();
                voiLUT.windowWidth = ww;
                voiLUT.wwwlExplanation = "GEMS JAMI ww/wl setting";
            }
            boolean ivideo = ira.isVideoInverted();
            IndexColorModel lut = ira.getColormap();
            SoftcopyPresentationLut spl = cpi.getSoftcopyPresentationLut();
            if (cpi.nImages == 0) {
                String string = spl.pLutShape = ivideo ? INVERSE : IDENTITY;
                if (lut != null) {
                    int len = lut.getMapSize();
                    if (rgbs == null || rgbs.length != len) {
                        rgbs = new int[len];
                    }
                    lut.getRGBs(rgbs);
                    if (XpCPI.isGreyScaleMap(rgbs)) {
                        spl.lutExplanation = "" + lut;
                        spl.lutDescriptor = new Integer[3];
                        short ilen = (short)len;
                        if (len == 65536) {
                            ilen = 0;
                        }
                        spl.lutDescriptor[0] = new Integer(ilen);
                        spl.lutDescriptor[1] = new Integer(0);
                        spl.lutDescriptor[2] = new Integer(8);
                        if (lutData == null || prevLut != lut) {
                            lutData = XpCPI.getLutData(rgbs);
                        }
                        prevLut = lut;
                        spl.lutData = lutData;
                    }
                }
            } else {
                String spl_lut;
                String lutExplanation;
                boolean ivid;
                boolean bl = ivid = spl.pLutShape == INVERSE;
                if (ivid != ivideo) {
                    spl.pLutShape = IDENTITY;
                }
                if (!(lutExplanation = "" + lut).equals(spl_lut = "" + spl.lutExplanation)) {
                    spl.lutData = null;
                    spl.lutDescriptor = null;
                    spl.lutExplanation = null;
                }
            }
            GraphicLayer roiLayer = new GraphicLayer("GRX LAYER 0");
            List uannot = auannos[i2];
            List rois = arois[i2];
            int nrois = rois.size();
            int nannos = uannot.size();
            if (nrois > 0 || nannos > 0) {
                int j2;
                gAnnot = new GraphicAnnotation(roiLayer);
                cpi.getGraphicAnnotation().add(gAnnot);
                XpCPI.addOrUpdateFrame(mi, false, gAnnot.refImgSequence);
                for (j2 = 0; j2 < rois.size(); ++j2) {
                    Point2D[] pts;
                    RoiActor ra = (RoiActor)rois.get(j2);
                    GraphicObject gobj = new GraphicObject();
                    gobj.graphicUnits = 0;
                    gobj.filled = false;
                    gobj.objectClass = ra.getClass().getName();
                    GSPSGraphic description = ra.gspsDescription();
                    if (description == null) continue;
                    if (debug) {
                        System.out.println("*** GSPS DESCRIPTION: " + description);
                    }
                    if ((pts = description.getPoints()) != null) {
                        for (int idx = 0; idx < pts.length; ++idx) {
                            Point2D.Double p3 = new Point2D.Double(pts[idx].getX(), pts[idx].getY());
                            if (debug) {
                                System.out.println("*** adding point: " + pts[idx]);
                            }
                            gobj.graphicData.add(p3);
                        }
                    }
                    gobj.graphicType = description.getGraphicType();
                    gobj.filled = description.isGraphicFilled();
                    gobj.graphicUnits = 0;
                    gAnnot.graphicSequence.add(gobj);
                }
                for (j2 = 0; j2 < uannot.size(); ++j2) {
                    boolean showTarget;
                    XpUserAnnotationModel uam = (XpUserAnnotationModel)uannot.get(j2);
                    TextObject tobj = new TextObject();
                    CPoint textPoint = uam.getTextAnchor();
                    CPoint target = uam.getTarget();
                    tobj.anchorUnits = target.csystem;
                    tobj.bboxUnits = textPoint.csystem;
                    tobj.anchorPoint.setLocation(target.x, target.y);
                    double bb_x = textPoint.x;
                    double bb_y = textPoint.y;
                    double bb_w = uam.getWidth();
                    double bb_h = uam.getHeight();
                    if (tobj.bboxUnits == 1) {
                        bb_x /= vpDim.getWidth();
                        bb_y /= vpDim.getHeight();
                        bb_w /= vpDim.getWidth();
                        bb_h /= vpDim.getHeight();
                        tobj.bboxUnits = (byte)3;
                    }
                    tobj.boundingBox.setFrame(bb_x, bb_y, bb_w, bb_h);
                    tobj.anchorVisibility = showTarget = uam.isShowTarget();
                    tobj.bboxJustification = LEFT;
                    tobj.textValue = uam.getText();
                    gAnnot.textSequence.add(tobj);
                }
            }
            if (first) {
                first = false;
            }
            ++cpi.nImages;
        }
    }

    private static boolean isGreyScaleMap(int[] rgbs) {
        for (int i2 = 0; i2 < rgbs.length; ++i2) {
            int rgb = rgbs[i2];
            int red = rgb & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb >> 16 & 0xFF;
            if (red == green && green == blue) continue;
            return false;
        }
        return true;
    }

    private static Integer[] getLutData(int[] rgbs) {
        Integer[] lutData = new Integer[rgbs.length];
        for (int i2 = 0; i2 < rgbs.length; ++i2) {
            int rgb = rgbs[i2];
            int red = rgb & 0xFF;
            lutData[i2] = new Integer(red);
        }
        return lutData;
    }

    private static int[] getLutData(Integer[] data, Integer[] lutDesc) {
        int nbits = lutDesc[2];
        int maxval = (int)Math.pow(2.0, nbits);
        int[] rgbs = new int[data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            int val = data[i2];
            double n2 = (double)val / (double)maxval * 255.0;
            int grey = (int)n2 & 0xFF;
            rgbs[i2] = grey << 16 & 0xFF0000 | grey << 8 & 0xFF00 | grey & 0xFF;
        }
        return rgbs;
    }

    public static void clearGraphics(List scenes) {
        int len = scenes.size();
        for (int i2 = 0; i2 < len; ++i2) {
            XpImageScene is = (XpImageScene)scenes.get(i2);
            is.getRois().clear();
            is.getUserAnnos().clear();
        }
    }

    private static Shape getShape(DisplayShutter ds) {
        Shape s2 = null;
        if (ds.shutterShape.equals(RECTANGULAR)) {
            Point2D ul = ds.rectULPoint;
            Point2D br = ds.rectBRPoint;
            double w2 = Math.abs(ul.getX() - br.getX());
            double h2 = Math.abs(ul.getY() - br.getY());
            s2 = new Rectangle2D.Double(ul.getX(), ul.getY(), w2, h2);
        } else if (ds.shutterShape.equals(CIRCULAR)) {
            double r2 = ds.circularRadius;
            double x2 = ds.circularCenter.getX() - r2;
            double y2 = ds.circularCenter.getY() - r2;
            s2 = new Ellipse2D.Double(x2, y2, 2.0 * r2, 2.0 * r2);
        }
        if (ds.shutterShape.equals(POLYGONAL)) {
            GeneralPath gp = new GeneralPath();
            gp.reset();
            int len = ds.polygonalVertices.size();
            for (int i2 = 0; i2 < len; ++i2) {
                Point2D p2 = ds.polygonalVertices.get(i2);
                if (i2 == 0) {
                    gp.moveTo((float)p2.getX(), (float)p2.getY());
                    continue;
                }
                gp.lineTo((float)p2.getX(), (float)p2.getY());
            }
            if (len > 2) {
                Point2D p3 = ds.polygonalVertices.get(0);
                gp.lineTo((float)p3.getX(), (float)p3.getY());
            }
            s2 = gp;
        }
        return s2;
    }

    public static void applyCPI(XpCPI cpi, ClipCapable cc) {
        Shape s2;
        DisplayShutter ds = cpi.getDisplayShutter(1);
        DisplayShutter ids = cpi.getDisplayShutter(0);
        if (ds != null && (s2 = XpCPI.getShape(ds)) != null) {
            cc.setClipShape(s2);
        }
        if (ids != null && (s2 = XpCPI.getShape(ids)) != null) {
            cc.setImageClip(s2);
        }
    }

    public static void putAllImages(List<XpImageScene> sceneList, List<GSPSFrame> refImgSequence) {
        int nscenes = sceneList.size();
        XpMedicalImage[] imgs = new XpMedicalImage[nscenes];
        for (int i2 = 0; i2 < nscenes; ++i2) {
            XpImageScene is = sceneList.get(i2);
            imgs[i2] = (XpMedicalImage)is.getFrame();
        }
        XpDicomElement sopinstanceUID = new XpDicomElement(8, 24);
        HashMap<String, GSPSFrame> mapSOPInstanceUID = new HashMap<String, GSPSFrame>();
        for (int i3 = 0; i3 < imgs.length; ++i3) {
            boolean isMultiFrame;
            GSPSFrame gspsFrame;
            XpMedicalImage im = imgs[i3];
            String sopinstance = null;
            int result = imgs[i3].getValue(sopinstanceUID);
            if (result == 0) {
                sopinstance = (String)sopinstanceUID.value;
            }
            if (null == (gspsFrame = (GSPSFrame)mapSOPInstanceUID.get(sopinstance))) {
                gspsFrame = XpCPI.createSimpleFrame(im);
                mapSOPInstanceUID.put(sopinstance, gspsFrame);
            }
            if (!(isMultiFrame = XpCPI.isMultiFrame(im))) continue;
            int frameNum = XpCPI.getFrameNumber(im);
            gspsFrame.ReferencedFrameNum.add(frameNum + 1);
        }
        Collection allFrames = mapSOPInstanceUID.values();
        for (GSPSFrame frame : allFrames) {
            refImgSequence.add(frame);
        }
    }

    public void applyCPI(List<XpImageScene> sceneList) {
        int i2;
        List refImgSeq;
        int i3;
        Dimension vpDim = new Dimension(512, 512);
        int nscenes = sceneList.size();
        DisplayedArea dispArea = null;
        GraphicAnnotation gAnnot = null;
        SoftcopyVoiLut voiLUT = null;
        List<DisplayedArea> lda = this.getDisplayedArea();
        List<SoftcopyVoiLut> svl = this.getSoftcopyVoiLut();
        List<GraphicAnnotation> ga = this.getGraphicAnnotation();
        SpatialTransformation st = this.getSpatialTransformation();
        SoftcopyPresentationLut spl = this.getSoftcopyPresentationLut();
        int imgWidth = 0;
        int imgHeight = 0;
        PLutIndexColorModel icm = null;
        SceneCache scenes = new SceneCache(sceneList);
        for (i3 = 0; i3 < lda.size(); ++i3) {
            dispArea = lda.get(i3);
            refImgSeq = dispArea.refImgSequence;
            if (refImgSeq.size() != 0) continue;
            XpCPI.putAllImages(sceneList, refImgSeq);
        }
        for (i3 = 0; i3 < svl.size(); ++i3) {
            voiLUT = svl.get(i3);
            refImgSeq = voiLUT.refImgSequence;
            if (refImgSeq.size() != 0) continue;
            XpCPI.putAllImages(sceneList, refImgSeq);
        }
        for (i3 = 0; i3 < ga.size(); ++i3) {
            gAnnot = ga.get(i3);
            refImgSeq = gAnnot.refImgSequence;
            if (refImgSeq.size() != 0) continue;
            XpCPI.putAllImages(sceneList, refImgSeq);
        }
        for (i3 = 0; i3 < nscenes; ++i3) {
            XpImageScene is = scenes.get(i3);
            XpImageRenderAttributes ira = is.getImageRenderAttributes();
            ira.setVideoInverted(spl.pLutShape.equals(INVERSE));
            String lutExplanation = spl.lutExplanation;
            Integer[] lutDesc = spl.lutDescriptor;
            Integer[] lutData = spl.lutData;
            if (lutExplanation != null) {
                IndexColorModel ic;
                if (lutExplanation.equals("g1")) {
                    ic = XpImageLut.g1().getLUT();
                    ira.setColormap(ic);
                } else if (lutExplanation.equals("g2")) {
                    ic = XpImageLut.g2().getLUT();
                    ira.setColormap(ic);
                } else if (lutExplanation.equals("g3")) {
                    ic = XpImageLut.g3().getLUT();
                    ira.setColormap(ic);
                } else if (lutData != null) {
                    if (icm == null) {
                        int[] rgbs = XpCPI.getLutData(lutData, lutDesc);
                        icm = new PLutIndexColorModel(lutExplanation, 16, rgbs.length, rgbs, 0, false, -1, 1);
                    }
                    ira.setColormap(icm);
                }
            }
            is.setImageRenderAttributes(ira);
            XpImage img = is.getFrame();
            imgWidth = img.getSlice().width;
            imgHeight = img.getSlice().height;
        }
        int len = ga.size();
        for (i2 = 0; i2 < len; ++i2) {
            gAnnot = ga.get(i2);
            List<GraphicObject> rois = gAnnot.graphicSequence;
            List<TextObject> uannos = gAnnot.textSequence;
            int nframes = gAnnot.refImgSequence.size();
            for (int j2 = 0; j2 < nframes; ++j2) {
                GSPSFrame frame = (GSPSFrame)gAnnot.refImgSequence.get(j2);
                XpImageScene[] isArr = scenes.getScene(frame);
                for (int p2 = 0; p2 < isArr.length; ++p2) {
                    XpImageScene is = isArr[p2];
                    if (is == null) continue;
                    if (debug) {
                        System.out.println("ROI's: Found Image Scene: " + sceneList.indexOf(is));
                    }
                    int nrois = rois.size();
                    for (int k2 = 0; k2 < nrois; ++k2) {
                        GraphicObject gobj = rois.get(k2);
                        ArrayList<Point2D> lp2d = new ArrayList<Point2D>();
                        for (int ll = 0; gobj.graphicData != null && ll < gobj.graphicData.size(); ++ll) {
                            lp2d.add(new Point2D.Double(gobj.graphicData.get(ll).getX(), gobj.graphicData.get(ll).getY()));
                        }
                        RoiActor ra = XpCPI.createROI(gobj.graphicType, lp2d, gobj.filled, gobj.graphicUnits, gobj.objectClass);
                        if ("true".equalsIgnoreCase(XpPropertiesManager.getProperty("reset.roi.number.per.port", "true")) && ra instanceof XpStatisticsRoi) {
                            ((XpStatisticsRoi)ra).setRoiLabel("" + (k2 + 1));
                        }
                        if (ra == null) continue;
                        is.add(ra);
                    }
                    int nannos = uannos.size();
                    for (int k3 = 0; k3 < nannos; ++k3) {
                        TextObject tobj = uannos.get(k3);
                        double bbX = tobj.boundingBox.getX();
                        double bbY = tobj.boundingBox.getY();
                        byte csystem = tobj.bboxUnits;
                        CPoint anchor = new CPoint(bbX, bbY, 0.0, csystem);
                        CPoint target = new CPoint(tobj.anchorPoint.getX(), tobj.anchorPoint.getY(), 0.0, tobj.anchorUnits);
                        String text = tobj.textValue;
                        XpUserAnnotationModel uam = new XpUserAnnotationModel(text, anchor, target);
                        is.add(uam);
                        uam.setShowTarget(tobj.anchorVisibility);
                        if (!tobj.anchorVisibility) {
                            uam.setShowBorder(false);
                        }
                        if (editable) continue;
                        uam.setEditable(false);
                        uam.setResize(false);
                    }
                }
            }
        }
        len = lda.size();
        for (i2 = 0; i2 < len; ++i2) {
            dispArea = lda.get(i2);
            int nframes = dispArea.refImgSequence.size();
            for (int j3 = 0; j3 < nframes; ++j3) {
                GSPSFrame frame = (GSPSFrame)dispArea.refImgSequence.get(j3);
                XpImageScene[] isArr = scenes.getScene(frame);
                for (int p3 = 0; p3 < isArr.length; ++p3) {
                    double angle;
                    XpImageScene scene2 = isArr[p3];
                    if (scene2 == null) continue;
                    XpImage img = scene2.getFrame();
                    imgWidth = img.getSlice().width;
                    imgHeight = img.getSlice().height;
                    if (debug) {
                        System.out.println("tlhc=" + dispArea.tlDisplay);
                    }
                    if (debug) {
                        System.out.println("brhc=" + dispArea.brDisplay);
                    }
                    double uzoom = dispArea.pixelMagnificationRatio;
                    double tx = dispArea.tlDisplay.getX();
                    double ty = dispArea.tlDisplay.getY();
                    double bx = dispArea.brDisplay.getX();
                    double by = dispArea.brDisplay.getY();
                    double px = bx;
                    double py = ty;
                    double[] data = new double[]{tx, ty, 1.0, bx, by, 1.0, px, py, 1.0};
                    double[] dataX = new double[]{1.0, vpDim.getWidth(), vpDim.getWidth()};
                    double[] dataY = new double[]{1.0, vpDim.getHeight(), 1.0};
                    m.set(data);
                    try {
                        b.set(dataX);
                        m.LUDSolve(b, v0);
                        b.set(dataY);
                        m.LUDSolve(b, v1);
                    }
                    catch (Exception e2) {
                        int k4;
                        System.err.println("ERROR Solving Linear System.");
                        System.err.println("tlhc[" + i2 + "]=" + dispArea.tlDisplay);
                        System.err.println("brhc[" + i2 + "]=" + dispArea.brDisplay);
                        System.err.print("data: ");
                        for (k4 = 0; k4 < data.length; ++k4) {
                            System.err.print("" + data[k4] + " ");
                        }
                        System.err.println("");
                        System.err.print("dataX: ");
                        for (k4 = 0; k4 < dataX.length; ++k4) {
                            System.err.print("" + dataX[k4] + " ");
                        }
                        System.err.println("");
                        System.err.print("dataY: ");
                        for (k4 = 0; k4 < dataY.length; ++k4) {
                            System.err.print("" + dataY[k4] + " ");
                        }
                        System.err.println("");
                        continue;
                    }
                    double m00 = XpCPI.v0.data[0];
                    double m01 = XpCPI.v0.data[1];
                    double m02 = XpCPI.v0.data[2];
                    double m10 = XpCPI.v1.data[0];
                    double m11 = XpCPI.v1.data[1];
                    double m12 = XpCPI.v1.data[2];
                    AffineTransform at = new AffineTransform(m00, m10, m01, m11, m02, m12);
                    double vp_tx = 0.5 * vpDim.getWidth();
                    double vp_ty = 0.5 * vpDim.getHeight();
                    double im_tx = 0.5 * (double)imgWidth;
                    double im_ty = 0.5 * (double)imgHeight;
                    tempPt1.setLocation(im_tx, im_ty);
                    at.transform(tempPt1, tempPt2);
                    tempPt1.setLocation(vpDim.getWidth() / 2.0, vpDim.getHeight() / 2.0);
                    try {
                        at.inverseTransform(tempPt1, tempPt2);
                    }
                    catch (NoninvertibleTransformException ex1) {
                        ex1.printStackTrace();
                    }
                    double panx = im_tx - tempPt2.getX();
                    double pany = im_ty - tempPt2.getY();
                    if (debug) {
                        System.out.println("-------------------------------------------------------------");
                        System.out.println("APPLY CPI: tlhc[" + i2 + "]=" + dispArea.tlDisplay);
                        System.out.println("APPLY CPI: brhc[" + i2 + "]=" + dispArea.brDisplay);
                        System.out.println("APPLY CPI: panX =" + panx + " panY=" + pany);
                        System.out.println("APPLY CPI: imgWidth=" + imgWidth + "  imgHeight=" + imgHeight + "  txCenter=" + tempPt2);
                        System.out.println("APPLY CPI: vpDIM          =" + vpDim);
                        System.out.println("APPLY CPI: AffineTransform=" + at);
                        System.out.println("-------------------------------------------------------------");
                    }
                    double zoom = 1.0;
                    try {
                        if (imgWidth >= imgHeight) {
                            tempPt1.setLocation(vpDim.getWidth(), vp_ty);
                            at.inverseTransform(tempPt1, tempPt2);
                            tempPt1.setLocation(0.0, vp_ty);
                            at.inverseTransform(tempPt1, tempPt3);
                            double px1 = tempPt2.getX();
                            double px2 = tempPt3.getX();
                            double diffX = Math.abs(px2 - px1);
                            zoom = (double)imgWidth / diffX;
                        } else {
                            tempPt1.setLocation(vp_tx, vpDim.getHeight());
                            at.inverseTransform(tempPt1, tempPt2);
                            tempPt1.setLocation(vp_tx, 0.0);
                            at.inverseTransform(tempPt1, tempPt3);
                            double diffY = Math.abs(tempPt3.getY() - tempPt2.getY());
                            zoom = (double)imgHeight / diffY;
                        }
                    }
                    catch (NoninvertibleTransformException ex) {
                        System.err.println("ERROR inverting affine transform....");
                        continue;
                    }
                    int psmode = 100;
                    if (dispArea.presSize.equals(MAGNIFY)) {
                        zoom = uzoom;
                        psmode = 102;
                    } else if (dispArea.presSize.equals(TRUE_SIZE)) {
                        psmode = 101;
                    }
                    if (debug) {
                        System.out.println("-- ZOOM = " + zoom + " PRES. SIZE=" + dispArea.presSize);
                    }
                    XpImageRenderAttributes ira = scene2.getImageRenderAttributes();
                    ira.setPan(panx, pany);
                    XpImageOrientation ior = ira.getImageOrientation();
                    double stangle = st.angle;
                    if (st.flipHorizontal) {
                        stangle = -stangle;
                    }
                    ior.apply(stangle, st.flipHorizontal);
                    if (debug) {
                        System.out.println("APPLY CPI: px=" + panx + "  py=" + pany + "  angle=" + st.angle + "  flip=" + st.flipHorizontal);
                    }
                    ira.setZoom(zoom);
                    ira.setPresentationSizeMode(psmode);
                    scene2.setImageRenderAttributes(ira);
                    if (img instanceof XpMedicalImage && (angle = XpImageUtils.gehcAzimuth((XpMedicalImage)img)) != 0.0) {
                        XpImageOrientation eff = new XpImageOrientation();
                        eff.rotate(-Math.toRadians(angle));
                        int iorstate = ior.getState();
                        if (angle == 270.0) {
                            System.err.println("iorstate=" + iorstate);
                            ior.setPan(-panx, -pany);
                            double tmpval = 0.0;
                            switch (iorstate) {
                                case 0: {
                                    tmpval = panx;
                                    panx = -pany;
                                    pany = tmpval;
                                    break;
                                }
                                case 1: {
                                    pany = -pany;
                                    panx = -panx;
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                                case 3: {
                                    tmpval = panx;
                                    panx = pany;
                                    pany = -tmpval;
                                    break;
                                }
                                case 4: {
                                    tmpval = panx;
                                    panx = pany;
                                    pany = tmpval;
                                    break;
                                }
                                case 5: {
                                    panx = -panx;
                                    break;
                                }
                                case 6: {
                                    pany = -pany;
                                    break;
                                }
                                case 7: {
                                    tmpval = panx;
                                    panx = -pany;
                                    pany = -tmpval;
                                }
                            }
                            ior.setPan(panx, pany);
                        }
                        eff.apply(ior);
                        ior.set(eff);
                    }
                    ira.setImageOrientation(ior);
                    scene2.setImageRenderAttributes(ira);
                }
                if (!debug) continue;
                System.out.println("-------------------------------------------");
            }
        }
        if (debug) {
            System.out.println("-------------------------------------------------------------");
        }
        len = svl.size();
        if (debug) {
            System.out.println("APPLY CPI: SOFTCOPY VOI LUT MODULE, sz = " + len);
        }
        for (i2 = 0; i2 < len; ++i2) {
            voiLUT = svl.get(i2);
            if (!voiLUT.wwwlSpecified) continue;
            double ww = voiLUT.windowWidth;
            double wl = voiLUT.windowCenter;
            int nframes = voiLUT.refImgSequence.size();
            for (int j4 = 0; j4 < nframes; ++j4) {
                GSPSFrame frame = (GSPSFrame)voiLUT.refImgSequence.get(j4);
                XpImageScene[] isArr = scenes.getScene(frame);
                for (int p4 = 0; p4 < nframes; ++p4) {
                    XpImageScene is = isArr[p4];
                    if (is == null) continue;
                    XpImageRenderAttributes ira = is.getImageRenderAttributes();
                    ira.setWindowing(ww, wl);
                    is.setImageRenderAttributes(ira);
                }
            }
        }
    }

    public static GSPSFrame createSimpleFrame(XpMedicalImage img) {
        img.getValue(sopInstanceUID);
        img.getValue(sopClassUID);
        GSPSFrame gspsFrame = new GSPSFrame();
        gspsFrame.SOPClassUID = (String)XpCPI.sopClassUID.value;
        gspsFrame.SOPInstanceUID = (String)XpCPI.sopInstanceUID.value;
        return gspsFrame;
    }

    public static boolean isMultiFrame(XpMedicalImage img) {
        XjDicomObjectFrame xjImg;
        XjDicomObjectFrame.MultiFrameType imgType;
        boolean multiFrame = false;
        XpMedicalImage refImg = img;
        if (refImg instanceof XjDicomObjectFrame && !(imgType = (xjImg = (XjDicomObjectFrame)((Object)refImg)).getMultiFrameType()).equals((Object)XjDicomObjectFrame.MultiFrameType.SINGLE_FRAME)) {
            multiFrame = true;
        }
        return multiFrame;
    }

    public static int getFrameNumber(XpMedicalImage img) {
        XjDicomObjectFrame frameImg = (XjDicomObjectFrame)((Object)img);
        return frameImg.getFrameNumber();
    }

    private static void addOrUpdateFrame(XpMedicalImage mi, boolean sharedIRA, List<GSPSFrame> refImgSequence) {
        boolean isMultiFrame;
        GSPSFrame frame = null;
        if (sharedIRA && refImgSequence.size() > 0) {
            for (GSPSFrame f2 : refImgSequence) {
                if (!f2.SOPInstanceUID.equals(XpCPI.sopInstanceUID.value)) continue;
                frame = f2;
                break;
            }
        }
        if (!sharedIRA || refImgSequence.size() == 0 || frame == null) {
            frame = XpCPI.createSimpleFrame(mi);
            refImgSequence.add(frame);
        }
        if (isMultiFrame = XpCPI.isMultiFrame(mi)) {
            int frameNum = XpCPI.getFrameNumber(mi);
            frame.ReferencedFrameNum.add(frameNum + 1);
        }
    }

    public List<String> getCpiSerializeables() {
        return this.cpiSerializeables;
    }

    public void setCpiSerializeables(List<String> cpiSerializeables) {
        this.cpiSerializeables = cpiSerializeables;
    }

    public void add2cpi(CPISerializable cpis) {
        this.cpiSerializeables.add(cpis.getClass().getName() + ":" + cpis.getCPIInfo());
    }

    public void save(OutputStream os) {
        try {
            JAXBContext jaxbC = JAXBContext.newInstance((Class[])new Class[]{XpCPI.class});
            Marshaller jaxbM = jaxbC.createMarshaller();
            jaxbM.setProperty("jaxb.formatted.output", (Object)true);
            jaxbM.marshal((Object)this, os);
            os.close();
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static RoiActor createROI(String graphicType, List<Point2D> gdata, boolean filled, byte csystem) {
        return XpCPI.createROI(graphicType, gdata, filled, csystem, null);
    }

    public static XpCPI restore(InputStream is) {
        try {
            JAXBContext jaxbC = JAXBContext.newInstance((Class[])new Class[]{XpCPI.class});
            Unmarshaller jaxbU = jaxbC.createUnmarshaller();
            Object result = jaxbU.unmarshal(is);
            if (result instanceof XpCPI) {
                System.out.println("restoring cpi");
                XpCPI cpi = (XpCPI)result;
                return cpi;
            }
        }
        catch (JAXBException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    private static class PLutIndexColorModel
    extends IndexColorModel {
        private String plutName = "";

        public PLutIndexColorModel(String lutName, int bits, int size, int[] cmap, int start, boolean hasalpha, int trans, int transferType) {
            super(bits, size, cmap, start, hasalpha, trans, transferType);
            this.plutName = lutName;
        }

        @Override
        public final String toString() {
            return this.plutName;
        }
    }

    private static class SceneCache {
        private List<XpImageScene> scenes = null;
        private Map<String, XpImageScene> cache = new HashMap<String, XpImageScene>();
        private boolean cacheBuild = true;

        public SceneCache(List scenes) {
            this.scenes = scenes;
        }

        public XpImageScene[] getScene(GSPSFrame frame) {
            int len = this.scenes.size();
            XpImageScene[] imgScenes = null;
            if (frame.ReferencedFrameNum.size() > 0) {
                ArrayList<XpImageScene> imgSceneList = new ArrayList<XpImageScene>();
                for (int i2 = 0; i2 < this.scenes.size(); ++i2) {
                    XpImage xpImg = this.scenes.get(i2).getFrame();
                    if (!(xpImg instanceof XpMedicalImage)) continue;
                    XpMedicalImage img = (XpMedicalImage)xpImg;
                    img.getValue(sopInstanceUID);
                    int frameNumber = XpCPI.getFrameNumber(img);
                    if (sopInstanceUID.value == null) continue;
                    String str = (String)sopInstanceUID.value;
                    Integer frameIndex = new Integer(frameNumber + 1);
                    if (!str.equals(frame.SOPInstanceUID) || !frame.ReferencedFrameNum.contains(frameIndex)) continue;
                    imgSceneList.add(this.scenes.get(i2));
                }
                imgScenes = imgSceneList.toArray(new XpImageScene[imgSceneList.size()]);
                return imgScenes;
            }
            if (this.cacheBuild) {
                this.cacheBuild = false;
                for (int i3 = 0; i3 < len; ++i3) {
                    XpImageScene is = this.scenes.get(i3);
                    XpImage img = is.getFrame();
                    if (!(img instanceof XpMedicalImage)) continue;
                    XpMedicalImage mimg = (XpMedicalImage)img;
                    mimg.getValue(sopInstanceUID);
                    if (sopInstanceUID.value == null) continue;
                    this.cache.put((String)sopInstanceUID.value, is);
                }
            }
            imgScenes = new XpImageScene[]{this.cache.get(frame.SOPInstanceUID)};
            return imgScenes;
        }

        public XpImageScene get(int i2) {
            return this.scenes.get(i2);
        }

        public final int size() {
            return this.scenes.size();
        }
    }

    public static class SpatialTransformation {
        public double angle = 0.0;
        public boolean flipHorizontal = false;
    }

    public static class GraphicLayer {
        public String layerUID = "Graphic Layer";
        public int layerOrder = 1;
        public short recommendedLuminance = (short)-1;
        public short[] recommendedRGB = new short[3];
        public String layerDescription = null;

        public GraphicLayer(String description) {
            this.layerDescription = description;
            for (int i2 = 0; i2 < this.recommendedRGB.length; ++i2) {
                this.recommendedRGB[i2] = -1;
            }
        }

        public GraphicLayer() {
            this(null);
        }
    }

    public static class GraphicObject {
        public byte graphicUnits = 0;
        public int graphicDim = 2;
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public List<Point2D> graphicData = new ArrayList<Point2D>();
        public String graphicType = "";
        public boolean filled = false;
        public String objectClass = "";
    }

    public static class TextObject {
        public byte bboxUnits = 1;
        public byte anchorUnits = 0;
        public String textValue = null;
        public CPIRectangle2D boundingBox = new CPIRectangle2D();
        public String bboxJustification = "LEFT";
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public Point2D anchorPoint = new Point2D.Double();
        public boolean anchorVisibility = false;
    }

    public static class CPIRectangle2D {
        private double x;
        private double y;
        private double width;
        private double height;

        public void setFrame(double bb_x, double bb_y, double bb_w, double bb_h) {
            this.x = bb_x;
            this.y = bb_y;
            this.width = bb_w;
            this.height = bb_h;
        }

        public double getX() {
            return this.x;
        }

        public double getWidth() {
            return this.width;
        }

        @XmlElement
        public void setWidth(double width) {
            this.width = width;
        }

        public double getHeight() {
            return this.height;
        }

        @XmlElement
        public void setHeight(double height) {
            this.height = height;
        }

        @XmlElement
        public void setX(double x2) {
            this.x = x2;
        }

        @XmlElement
        public void setY(double y2) {
            this.y = y2;
        }

        public double getY() {
            return this.y;
        }

        public void setRect(double tlbbX, double tlbbY, double w2, double h2) {
            this.x = tlbbX;
            this.y = tlbbY;
            this.width = w2;
            this.height = h2;
        }
    }

    public static class LUTItem {
        public int numEntries = 0;
        public int firstValue = 0;
        public int numBits = 16;
        public String lutExplanation = "";
        public Vector lutData = new Vector();
    }

    public static class OverlayPlane {
        @XmlElement
        public int rows = 0;
        @XmlElement
        public int cols = 0;
        @XmlElement
        public String overlayType = "";
        @XmlElement
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public Point2D overlayOrigin = new Point2D.Double();
        @XmlElement
        public int nBitAllocated = 0;
        @XmlElement
        public byte[] overlayData = null;
        @XmlElement
        public String overlayDescription = "";
        @XmlElement
        public String overlaySubType = "";
        @XmlElement
        public String overlayLabel = "";
        @XmlElement
        public double roiArea = 0.0;
        @XmlElement
        public double roiMean = 0.0;
        @XmlElement
        public double roiStdDev = 0.0;
    }

    public static class BitmapDisplayShutter {
        public final String shutterShape = "BITMAP";
        @XmlElement
        public OverlayPlane overlayPlane = new OverlayPlane();
        public int shutterPValue = 0;
    }

    public static class DisplayShutter {
        public int coordSystem = 1;
        public String shutterShape = "";
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public Point2D rectULPoint = new Point2D.Double();
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public Point2D rectBRPoint = new Point2D.Double();
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public Point2D circularCenter = new Point2D.Double();
        @XmlElement
        public double circularRadius = 0.0;
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public List<Point2D> polygonalVertices = null;
        @XmlElement
        public int shutterPValue = 0;
    }

    public static class SoftcopyPresentationLut {
        public Integer[] lutDescriptor = null;
        public String lutExplanation = null;
        public Integer[] lutData = null;
        public String pLutShape = "IDENTITY";
    }

    public static class SoftcopyVoiLut
    extends GSPSItem {
        public LUTItem lItem = new LUTItem();
        public double windowCenter = 0.0;
        public double windowWidth = 0.0;
        public String wwwlExplanation = "";
        public boolean wwwlSpecified = true;
    }

    public static class ModalityLut {
        public Integer[] lutDescriptor = null;
        public String lutExplanation = null;
        public String modalityLUTType = "";
        public Integer[] lutData = null;
        public double rescaleIntercept = 0.0;
        public double rescaleSlope = 1.0;
    }

    public static class GraphicAnnotation
    extends GSPSItem {
        public GraphicLayer grxLayer = null;
        public List<TextObject> textSequence = new ArrayList<TextObject>();
        public List<GraphicObject> graphicSequence = new ArrayList<GraphicObject>();

        public GraphicAnnotation(GraphicLayer grxLayer) {
            this.grxLayer = grxLayer;
        }

        public GraphicAnnotation() {
            this(null);
        }
    }

    public static class DisplayedArea
    extends GSPSItem {
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public Point2D tlDisplay = new Point2D.Double();
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public Point2D brDisplay = new Point2D.Double();
        @XmlElement
        public String presSize = "SCALE TO FIT";
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public Point2D presPixelSpacing = new Point2D.Double();
        @XmlJavaTypeAdapter(value=Point2DXmlAdapter.class)
        public Point2D presPixelAspectRatio = new Point2D.Double();
        public double pixelMagnificationRatio = 1.0;

        public Long[] getGSPSTopLeft() {
            return new Long[]{new Long((long)Math.floor(this.tlDisplay.getX())), new Long((long)Math.floor(this.tlDisplay.getY()))};
        }

        public Long[] getGSPSBottomRight() {
            return new Long[]{new Long((long)Math.ceil(this.brDisplay.getX())), new Long((long)Math.ceil(this.brDisplay.getY()))};
        }
    }

    @XmlSeeAlso(value={DisplayedArea.class, GraphicAnnotation.class, SoftcopyVoiLut.class})
    public static abstract class GSPSItem {
        public List<GSPSFrame> refImgSequence = new ArrayList<GSPSFrame>();
    }

    public static class GSPSFrame {
        public String SOPClassUID = "";
        public String SOPInstanceUID = "";
        public Set<Integer> ReferencedFrameNum = new TreeSet<Integer>();
    }
}

