/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class XpComponentSave {
    private final JFrame jf = new JFrame("Offscreen");
    private final JPanel jp = new JPanel();
    private Robot robot = null;
    private Rectangle tmpRect = new Rectangle();
    public static final int RGB = 0;
    public static final int LUMINANCE_16 = 1;
    public static final int LUMINANCE_8 = 2;
    public static final int LUMINANCE_1 = 3;
    public static final int BYTE_BGR = 4;
    public static final int ARGB = 5;

    public XpComponentSave() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    private static int getBufferedType(int type) {
        if (type == 2) {
            return 10;
        }
        if (type == 1) {
            return 11;
        }
        if (type == 0) {
            return 1;
        }
        if (type == 5) {
            return 2;
        }
        if (type == 4) {
            return 5;
        }
        return 12;
    }

    public static BufferedImage getBufferedImage(JComponent jc, int type) {
        Dimension d2 = jc.getSize();
        int w2 = (int)d2.getWidth();
        int h2 = (int)d2.getHeight();
        return XpComponentSave.getBufferedImage(jc, w2, h2, type);
    }

    public static BufferedImage getBufferedImage(JComponent jc, int w2, int h2, int type) {
        BufferedImage bi = new BufferedImage(w2, h2, XpComponentSave.getBufferedType(type));
        Graphics g2 = bi.getGraphics();
        jc.paint(g2);
        return bi;
    }

    public BufferedImage renderOffscreen(JComponent jc, int w2, int h2, int type) {
        jc.setPreferredSize(new Dimension(w2, h2));
        this.jf.setContentPane(jc);
        this.jf.pack();
        BufferedImage bi = XpComponentSave.getBufferedImage(jc, type);
        return bi;
    }

    public void renderOffscreen(JComponent jc, BufferedImage destination) {
        int w2 = destination.getWidth();
        int h2 = destination.getHeight();
        jc.setPreferredSize(new Dimension(w2, h2));
        this.jf.setContentPane(jc);
        this.jf.pack();
        Graphics g2 = destination.getGraphics();
        jc.paint(g2);
        this.jf.setContentPane(this.jp);
    }

    public final void saveJPEG(JComponent offscreenJC, int w2, int h2, String fname) {
        BufferedImage bi = this.renderOffscreen(offscreenJC, w2, h2, 0);
        XpComponentSave.imageSave(bi, "jpeg", fname);
    }

    public static void offscreenSave(JComponent jc, String imgFormat, String fileName, int type) {
        BufferedImage bi = XpComponentSave.getBufferedImage(jc, type);
        XpComponentSave.imageSave(bi, imgFormat, fileName);
    }

    public final void screenSave(JComponent jc, String imgFormat, String fileName) {
        BufferedImage bi = this.getScreenRendering(jc);
        XpComponentSave.imageSave(bi, imgFormat, fileName);
    }

    public static void imageSave(RenderedImage rimg, String imgFormat, String fileName) {
        try {
            File f2 = new File(fileName);
            ImageIO.write(rimg, imgFormat, f2);
        }
        catch (IOException ex) {
            System.err.println("ERROR: Writing to " + fileName);
        }
    }

    public final BufferedImage getScreenRendering(JComponent jc) {
        Point p2 = jc.getLocationOnScreen();
        Rectangle r2 = jc.getVisibleRect();
        int x2 = (int)p2.getX();
        int y2 = (int)p2.getY();
        int w2 = (int)r2.getWidth();
        int h2 = (int)r2.getHeight();
        this.tmpRect.setBounds(x2, y2, w2, h2);
        BufferedImage bi = this.robot.createScreenCapture(this.tmpRect);
        return bi;
    }
}

