/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.capable.SliceListener;
import com.ge.med.terra.jami.capable.SliceSourceCapable;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.border.Border;

public class XpFrameVisualizer
extends XpSingularPort
implements WindowLevelCapable,
PanZoomCapable,
PropertyChangeListener,
SliceSourceCapable {
    private XpImageScene fscene = null;
    private int selectionState = 0;
    private XpMedicalImage[] soleImage = new XpMedicalImage[1];
    private boolean drawBorder = true;
    private Border primaryBorder = null;
    private Border secondaryBorder = null;
    private List sliceListeners = new ArrayList();

    public XpFrameVisualizer() {
    }

    @Override
    public final XpMedicalImage[] getImages() {
        XpImage img = this.fscene.getFrame();
        if (img instanceof XpMedicalImage) {
            this.soleImage[0] = (XpMedicalImage)img;
            return this.soleImage;
        }
        return null;
    }

    @Override
    public final XpImage getImageAt(int idx) {
        XpImage img = this.fscene.getFrame();
        return img;
    }

    @Override
    public void setImageRenderAttributes(XpImageRenderAttributes attr) {
        super.setImageRenderAttributes(attr);
        if (this.fscene != null && attr != null) {
            this.fscene.setImageRenderAttributes(attr);
        }
    }

    @Override
    public Object clone() {
        String rtype = this.getRendererType();
        XpFrameVisualizer fv = null;
        fv = rtype != null ? new XpFrameVisualizer(rtype) : new XpFrameVisualizer();
        fv.setSize(this.getSize());
        fv.setPreferredSize(this.getPreferredSize());
        if (this.fscene != null) {
            XpImageScene newscene = (XpImageScene)this.fscene.clone();
            fv.setFrameScene(newscene, this.getMedicalImageVc().getDicomSource());
        }
        this.copyObject(fv);
        return fv;
    }

    public XpFrameVisualizer(String rendererType) {
        super(rendererType);
    }

    public XpFrameVisualizer(RmRenderSession rs, String remote2DRenderer) {
        super(rs, remote2DRenderer);
    }

    @Override
    public final void initializeImageViewport() {
        this.setAutoRepaint(false);
    }

    public final XpImageScene getScene() {
        return this.fscene;
    }

    @Override
    public final XpImage getFrame() {
        if (this.fscene != null) {
            return this.fscene.getFrame();
        }
        return null;
    }

    @Override
    public final int getFrameIndex() {
        if (this.fscene != null) {
            return 0;
        }
        return -1;
    }

    public final void setFrameScene(XpImageScene fs, XpDicomObject dobj) {
        if (this.fscene != null) {
            this.fscene.removePropertyChangeListener("IRA_PROP", this);
        }
        boolean changeScene = false;
        if (this.fscene != fs) {
            changeScene = true;
        }
        this.fscene = fs;
        XpImage img = null;
        if (fs != null) {
            img = fs.getFrame();
        }
        XpMedicalImage2DVc mivc = this.getMedicalImageVc();
        mivc.setMedicalImage(img, dobj);
        if (fs != null) {
            mivc.setVisible(true);
            List imgLayers = fs.getImageLayers();
            mivc.setImageLayers(imgLayers);
            XpImageRenderAttributes ira = fs.getImageRenderAttributes();
            mivc.setImageRenderAttributes(ira);
            this.refreshSelection();
            this.syncScene();
            fs.addPropertyChangeListener("IRA_PROP", this);
        } else {
            mivc.setVisible(false);
            this.syncScene();
        }
        if (changeScene) {
            this.notifySliceListeners();
        }
    }

    public final void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public final boolean isDrawBorder() {
        return this.drawBorder;
    }

    public final Border getPrimaryBorder() {
        return this.primaryBorder;
    }

    public final void setPrimaryBorder(Border bd) {
        this.primaryBorder = bd;
    }

    public final Border getSecondaryBorder() {
        return this.secondaryBorder;
    }

    public final void setSecondaryBorder(Border bd) {
        this.secondaryBorder = bd;
    }

    public final void refreshSelection() {
        if (this.fscene != null) {
            int selected = this.fscene.getSelectedState();
            Border b2 = null;
            if (this.drawBorder) {
                if (selected == 1) {
                    b2 = this.getPrimaryBorder();
                } else if (selected == 2) {
                    b2 = this.getSecondaryBorder();
                }
            }
            Border oldBorder = this.getMedicalImageVc().getImageVc().getBorder();
            if (this.selectionState != selected || oldBorder != b2) {
                this.getMedicalImageVc().getImageVc().setBorder(b2);
            }
            this.selectionState = selected;
        } else {
            this.getMedicalImageVc().getImageVc().setBorder(null);
        }
    }

    @Override
    public final void add(RoiActor ra) {
        if (this.fscene != null) {
            this.fscene.add(ra);
            this.syncScene();
        }
    }

    @Override
    public final List getRois() {
        if (this.fscene != null) {
            return this.fscene.getRois();
        }
        return null;
    }

    @Override
    public final boolean remove(RoiActor ra) {
        boolean res = false;
        if (this.fscene != null) {
            res = this.fscene.remove(ra);
            this.syncScene();
        }
        return res;
    }

    @Override
    public final RoiActor getRoi() {
        if (this.fscene != null) {
            return this.fscene.getRoi();
        }
        return null;
    }

    @Override
    public final void add(XpUserAnnotationModel m2) {
        if (this.fscene != null) {
            this.fscene.add(m2);
            this.syncScene();
        }
    }

    @Override
    public final boolean remove(XpUserAnnotationModel m2) {
        boolean res = false;
        if (this.fscene != null) {
            res = this.fscene.remove(m2);
            this.syncScene();
        }
        return res;
    }

    @Override
    public final List getUserAnnos() {
        if (this.fscene != null) {
            return this.fscene.getUserAnnos();
        }
        return null;
    }

    @Override
    public final void propertyChange(PropertyChangeEvent pce) {
        XpImageRenderAttributes ira;
        if (pce.getPropertyName().equals("IRA_PROP") && (ira = (XpImageRenderAttributes)pce.getNewValue()) != null && !ira.equals(this.getImageRenderAttributes())) {
            this.setImageRenderAttributes(ira);
        }
    }

    protected void notifySliceListeners() {
        int len = this.sliceListeners.size();
        if (len > 0) {
            XpMedicalImage2DVc mivc = this.getMedicalImageVc();
            XpImage mi = mivc.getFrame();
            XpSlice activeSlice = null;
            if (mi != null) {
                activeSlice = mi.getSlice();
            }
            for (int i2 = 0; i2 < len; ++i2) {
                SliceListener sl = (SliceListener)this.sliceListeners.get(i2);
                sl.setActiveSlice(this, activeSlice);
            }
        }
    }

    @Override
    public final void addSliceListener(SliceListener sl) {
        if (this.sliceListeners.contains(sl)) {
            return;
        }
        this.sliceListeners.add(sl);
    }

    @Override
    public final void removeSliceListener(SliceListener sl) {
        this.sliceListeners.remove(sl);
    }

    @Override
    public void setColorMap(int[] cMap) {
        IndexColorModel colorModel = null;
        if (cMap != null) {
            colorModel = new IndexColorModel(16, cMap.length, cMap, 0, false, -1, 1);
        }
        XpMedicalImage2DVc mivc = this.getMedicalImageVc();
        XpImageRenderAttributes ira = mivc.getImageRenderAttributes();
        ira.setColormap(colorModel);
        mivc.setImageRenderAttributes(ira);
    }
}

