/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.jnu.geom.JnAffineTransform;
import com.ge.med.jnu.geom.JnLine2D;
import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.jnu.geom.JnRectangle;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.capable.CTransformCapable;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;

public abstract class XpGeomUtilsBase {
    protected static final double SMALL_NUM = 1.0E-8;
    protected static final double epsilon = 1.0E-5;
    public static double MM_PER_INCH = 25.4;
    protected static double DOTS_PER_MM = 72.0 / MM_PER_INCH;
    private double[] buff1 = new double[6];
    private double[] buff2 = new double[6];
    private CPoint _cp0 = new CPoint();
    private CPoint _cp1 = new CPoint();
    private CPoint tmpPoint = new CPoint();
    private JnPoint2D t1 = new JnPoint2D.Double();
    private JnPoint2D t2 = new JnPoint2D.Double();
    private JnPoint2D t3 = new JnPoint2D.Double();
    private JnPoint2D t4 = new JnPoint2D.Double();
    private JnPoint2D t5 = new JnPoint2D.Double();
    private JnPoint2D t6 = new JnPoint2D.Double();
    private JnAffineTransform temp = new JnAffineTransform();
    protected XpImageOrientation ior = new XpImageOrientation();
    protected double sinangle = 0.0;
    protected double cosangle = 1.0;
    protected double prevAngle = 0.0;

    public final boolean calcInverse(JnAffineTransform input, JnAffineTransform output) {
        input.getMatrix(this.buff1);
        double m00 = this.buff1[0];
        double m10 = this.buff1[1];
        double m01 = this.buff1[2];
        double m11 = this.buff1[3];
        double m02 = this.buff1[4];
        double m12 = this.buff1[5];
        double det = m00 * m11 - m10 * m01;
        if (det < 1.0E-5 && det > -1.0E-5) {
            return false;
        }
        double detinv = 1.0 / det;
        double i00 = m11 * detinv;
        double i10 = -m10 * detinv;
        double i01 = -m01 * detinv;
        double i11 = m00 * detinv;
        double i02 = (m01 * m12 - m11 * m02) * detinv;
        double i12 = (m02 * m10 - m00 * m12) * detinv;
        output.setTransform(i00, i10, i01, i11, i02, i12);
        return true;
    }

    public final void calcDragVector(JnPoint2D p1, JnPoint2D p0, byte csystem, CTransformCapable ctc, CPoint dragV) {
        if (csystem == 1) {
            dragV.setPoint(p1, p0);
            return;
        }
        this.tmpPoint.setPoint(p0.getX(), p0.getY(), 1.0, (byte)1);
        ctc.transform(this.tmpPoint, this._cp0, csystem);
        this.tmpPoint.setPoint(p1.getX(), p1.getY(), 1.0, (byte)1);
        ctc.transform(this.tmpPoint, this._cp1, csystem);
        this._cp1.subtract(this._cp0);
        dragV.setPoint(this._cp1);
    }

    public final void rotate(JnPoint2D inPt, double angle, double tx, double ty, JnPoint2D outPt) {
        if (angle != this.prevAngle) {
            this.sinangle = Math.sin(angle);
            this.cosangle = Math.cos(angle);
            this.prevAngle = angle;
        }
        double x2 = inPt.getX() + tx;
        double y2 = inPt.getY() + ty;
        double rx = this.cosangle * x2 - this.sinangle * y2;
        double ry = this.sinangle * x2 + this.cosangle * y2;
        x2 = rx - tx;
        y2 = ry - ty;
        outPt.setLocation(x2, y2);
    }

    public static double dot_product(JnPoint2D p1, JnPoint2D p2) {
        return p1.getX() * p2.getX() + p1.getY() * p2.getY();
    }

    public static double norm(JnPoint2D p1) {
        return Math.sqrt(XpGeomUtilsBase.dot_product(p1, p1));
    }

    public static double distance(JnPoint2D p1, JnPoint2D p2) {
        double dx = p1.getX() - p2.getX();
        double dy = p1.getY() - p2.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static void add(JnPoint2D p1, JnPoint2D p2, JnPoint2D res) {
        res.setLocation(p1.getX() + p2.getX(), p1.getY() + p2.getY());
    }

    public static void sub(JnPoint2D p1, JnPoint2D p2, JnPoint2D res) {
        res.setLocation(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }

    public static double angle(JnPoint2D p1, JnPoint2D p2) {
        double n2;
        double dot = XpGeomUtilsBase.dot_product(p1, p2);
        double n1 = XpGeomUtilsBase.norm(p1);
        double prod = n1 * (n2 = XpGeomUtilsBase.norm(p2));
        if (prod != 0.0) {
            return Math.acos(dot / prod);
        }
        return 0.0;
    }

    public static void multiplyByScalar(double scalar, JnPoint2D p2) {
        double x2 = p2.getX() * scalar;
        double y2 = p2.getY() * scalar;
        p2.setLocation(x2, y2);
    }

    public double distPointToSegment(JnPoint2D P2, JnPoint2D P0, JnPoint2D P1) {
        this.t1.setLocation(P1.getX() - P0.getX(), P1.getY() - P0.getY());
        this.t2.setLocation(P2.getX() - P0.getX(), P2.getY() - P0.getY());
        double c1 = XpGeomUtilsBase.dot_product(this.t1, this.t2);
        if (c1 <= 0.0) {
            return XpGeomUtilsBase.distance(P2, P0);
        }
        double c2 = XpGeomUtilsBase.dot_product(this.t1, this.t1);
        if (c2 <= c1) {
            return XpGeomUtilsBase.distance(P2, P1);
        }
        double b2 = c1 / c2;
        XpGeomUtilsBase.multiplyByScalar(b2, this.t1);
        XpGeomUtilsBase.add(P0, this.t1, this.t3);
        return XpGeomUtilsBase.distance(P2, this.t3);
    }

    public double perp(JnPoint2D p1, JnPoint2D p2) {
        return p1.getX() * p2.getY() - p1.getY() * p2.getX();
    }

    public int intersect2DSegments(JnLine2D S1, JnLine2D S2, JnPoint2D I0, JnPoint2D I1) {
        this.t4.setLocation(0.0, 0.0);
        this.t5.setLocation(0.0, 0.0);
        this.t1.setLocation(S1.getX2() - S1.getX1(), S1.getY2() - S1.getY1());
        this.t2.setLocation(S2.getX2() - S2.getX1(), S2.getY2() - S2.getY1());
        this.t3.setLocation(S1.getX1() - S2.getX1(), S1.getY1() - S2.getY1());
        double D = this.perp(this.t1, this.t2);
        if (Math.abs(D) < 1.0E-8) {
            double tmp1;
            double tmp0;
            if (this.perp(this.t1, this.t3) != 0.0 || this.perp(this.t2, this.t3) != 0.0) {
                return 0;
            }
            double du = XpGeomUtilsBase.dot_product(this.t1, this.t1);
            double dv = XpGeomUtilsBase.dot_product(this.t2, this.t2);
            if (du == 0.0 && dv == 0.0) {
                if (!S1.getP1().equals(S2.getP1())) {
                    return 0;
                }
                I0.setLocation(S1.getP1());
                return 1;
            }
            if (du == 0.0) {
                if (XpGeomUtilsBase.inSegment(S1.getP1(), S2) == 0) {
                    return 0;
                }
                I0.setLocation(S1.getP1());
                return 1;
            }
            if (dv == 0.0) {
                if (XpGeomUtilsBase.inSegment(S2.getP1(), S1) == 0) {
                    return 0;
                }
                I0.setLocation(S2.getP1());
                return 1;
            }
            this.t4.setLocation(S1.getX2() - S2.getX1(), S1.getY2() - S2.getY1());
            if (this.t2.getX() != 0.0) {
                tmp0 = this.t3.getX() / this.t2.getX();
                tmp1 = this.t4.getX() / this.t2.getX();
            } else {
                tmp0 = this.t3.getY() / this.t2.getY();
                tmp1 = this.t4.getY() / this.t2.getY();
            }
            if (tmp0 > tmp1) {
                double tmp = tmp0;
                tmp0 = tmp1;
                tmp1 = tmp;
            }
            if (tmp0 > 1.0 || tmp1 < 0.0) {
                return 0;
            }
            tmp0 = tmp0 < 0.0 ? 0.0 : tmp0;
            double d2 = tmp1 = tmp1 > 1.0 ? 1.0 : tmp1;
            if (tmp0 == tmp1) {
                this.t5.setLocation(this.t2);
                XpGeomUtilsBase.multiplyByScalar(tmp0, this.t5);
                XpGeomUtilsBase.add(this.t5, S2.getP1(), I0);
                return 1;
            }
            this.t5.setLocation(this.t2);
            XpGeomUtilsBase.multiplyByScalar(tmp0, this.t5);
            XpGeomUtilsBase.add(S2.getP1(), this.t5, I0);
            this.t5.setLocation(this.t2);
            XpGeomUtilsBase.multiplyByScalar(tmp1, this.t5);
            XpGeomUtilsBase.add(S2.getP1(), this.t5, I1);
            return 2;
        }
        double sI = this.perp(this.t2, this.t3) / D;
        if (sI < 0.0 || sI > 1.0) {
            return 0;
        }
        double tI = this.perp(this.t1, this.t3) / D;
        if (tI < 0.0 || tI > 1.0) {
            return 0;
        }
        this.t5.setLocation(this.t1);
        XpGeomUtilsBase.multiplyByScalar(sI, this.t5);
        XpGeomUtilsBase.add(S1.getP1(), this.t5, I0);
        return 1;
    }

    public static int inSegment(JnPoint2D P2, JnLine2D S2) {
        if (S2.getX1() != S2.getX2()) {
            if (S2.getX1() <= P2.getX() && P2.getX() <= S2.getX2()) {
                return 1;
            }
            if (S2.getX1() >= P2.getX() && P2.getX() >= S2.getX2()) {
                return 1;
            }
        } else {
            if (S2.getY1() <= P2.getY() && P2.getY() <= S2.getY2()) {
                return 1;
            }
            if (S2.getY1() >= P2.getY() && P2.getY() >= S2.getY2()) {
                return 1;
            }
        }
        return 0;
    }

    public static boolean containsCoord(int x2, int y2, JnPoint2D p1, JnPoint2D p2, int vicinity) {
        int x1 = x2 - vicinity;
        int y1 = y2 - vicinity;
        int x22 = x2 + vicinity;
        int y22 = y2 + vicinity;
        if (XpGeomUtilsBase.intersects(x1, y1, x22, y22, (int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY())) {
            return true;
        }
        return XpGeomUtilsBase.intersects(x1, y22, x22, y1, (int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
    }

    public static boolean intersects(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int x43 = x4 - x3;
        int y13 = y1 - y3;
        int y43 = y4 - y3;
        int x13 = x1 - x3;
        int x21 = x2 - x1;
        int y21 = y2 - y1;
        int denom = y43 * x21 - x43 * y21;
        int n1 = x43 * y13 - y43 * x13;
        int n2 = x21 * y13 - y21 * x13;
        if (denom == 0 && (n1 == 0 || n2 == 0)) {
            return !(x1 < x3 && x1 < x4 && x2 < x3 && x2 < x4 || x1 > x3 && x1 > x4 && x2 > x3 && x2 > x4 || y1 < y3 && y1 < y4 && y2 < y3 && y2 < y4) && (y1 <= y3 || y1 <= y4 || y2 <= y3 || y2 <= y4);
        }
        if (denom == 0) {
            return false;
        }
        double ua = (double)n1 / (double)denom;
        double ub = (double)n2 / (double)denom;
        return ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0;
    }

    public XpImageOrientation getEffectiveRotation(double azimuth) {
        this.ior.clear();
        double angle = Math.toRadians(azimuth);
        this.ior.rotate(angle);
        return this.ior;
    }

    public static final XpImageOrientation getDisplayOrientation(double azimuth, XpImageOrientation user_ior, XpImageOrientation result) {
        if (azimuth != 0.0) {
            result.clear();
            double angle = Math.toRadians(azimuth);
            result.rotate(angle);
            result.apply(user_ior);
        } else {
            result.set(user_ior);
        }
        return result;
    }

    public final void calcAffineTransform(JnPoint2D ul, JnPoint2D ur, JnPoint2D br, int imgWidth, int imgHeight, int outWidth, int outHeight, JnAffineTransform tx) {
        double PIXEL_OFFSETX = 0.0;
        double PIXEL_OFFSETY = 0.0;
        double c2 = ul.getX() + 0.0;
        double f2 = ul.getY() + 0.0;
        double a2 = (ur.getX() + 0.0 - c2) / (double)imgWidth;
        double d2 = (ur.getY() + 0.0 - f2) / (double)imgWidth;
        double b2 = (br.getX() + 0.0 - c2 - a2 * (double)imgWidth) / (double)imgHeight;
        double e2 = (br.getY() + 0.0 - f2 - d2 * (double)imgWidth) / (double)imgHeight;
        tx.setTransform(a2, d2, b2, e2, c2, f2);
    }

    public final void calcAffineTransform(JnRectangle viewport, XpImageRenderAttributes ira, int imageWidth, int imageHeight, double azimuth, boolean fitToViewport, double psizeX, double psizeY, JnAffineTransform tx) {
        this.calcAffineTransform(viewport, ira, imageWidth, imageHeight, azimuth, fitToViewport, DOTS_PER_MM, psizeX, psizeY, tx);
    }

    public final void calcAffineTransform(JnRectangle viewport, XpImageRenderAttributes ira, int imageWidth, int imageHeight, double azimuth, boolean fitToViewport, double dpmm, double psizeX, double psizeY, JnAffineTransform tx) {
        double zy;
        double zx;
        boolean fitViewport;
        int w2 = imageWidth;
        int h2 = imageHeight;
        double vpWidth = viewport.getWidth();
        double vpHeight = viewport.getHeight();
        double zoom = ira.getZoom();
        XpImageOrientation orientation = ira.getImageOrientation();
        if (azimuth != 0.0) {
            XpImageOrientation orient = this.getEffectiveRotation(azimuth);
            orient.apply(orientation);
            orientation = orient;
        }
        tx.setToIdentity();
        double fitToX = 1.0;
        double fitToY = 1.0;
        int psmode = ira.getPresentationSizeMode();
        boolean bl = fitViewport = fitToViewport && psmode == 100;
        if (fitViewport && w2 > 0 && h2 > 0) {
            fitToX = vpWidth / (double)w2;
            fitToY = vpHeight / (double)h2;
        }
        if (psmode == 101) {
            double dotsize = 1.0 / dpmm;
            zoom = 1.0;
            fitToX = psizeX / dotsize;
            fitToY = psizeY / dotsize;
        }
        zoom = (zx = zoom * fitToX) < (zy = zoom * fitToY) ? zx : zy;
        double vp_tx = (double)viewport.x + 0.5 * (double)viewport.width;
        double vp_ty = (double)viewport.y + 0.5 * (double)viewport.height;
        tx.translate(vp_tx, vp_ty);
        tx.scale(zoom, zoom);
        JnAffineTransform orientTx = orientation.getJnTransform();
        tx.concatenate(orientTx);
        tx.translate(-0.5 * (double)w2, -0.5 * (double)h2);
    }

    public final void calcDisplayedAreaTransform(JnRectangle viewport, XpImageRenderAttributes ira, int imageWidth, int imageHeight, boolean fitToViewport, JnAffineTransform tx) {
        double zy;
        double zx;
        int w2 = imageWidth;
        int h2 = imageHeight;
        double vpWidth = viewport.getWidth();
        double vpHeight = viewport.getHeight();
        double zoom = ira.getZoom();
        this.ior.set(ira.getImageOrientation());
        this.ior.reset();
        tx.setToIdentity();
        double fitToX = 1.0;
        double fitToY = 1.0;
        if (fitToViewport && w2 > 0 && h2 > 0) {
            fitToX = vpWidth / (double)w2;
            fitToY = vpHeight / (double)h2;
        }
        zoom = (zx = zoom * fitToX) < (zy = zoom * fitToY) ? zx : zy;
        double vp_tx = (double)viewport.x + 0.5 * (double)viewport.width;
        double vp_ty = (double)viewport.y + 0.5 * (double)viewport.height;
        tx.translate(vp_tx, vp_ty);
        tx.scale(zoom, zoom);
        JnAffineTransform orientTx = this.ior.getJnTransform();
        tx.concatenate(orientTx);
        tx.translate(-0.5 * (double)w2, -0.5 * (double)h2);
    }

    public final void getRotatedPoint(double x2, double y2, double ang, double cx, double cy, JnPoint2D p2) {
        this.temp.setToIdentity();
        this.temp.rotate(ang, cx, cy);
        this.t6.setLocation(x2, y2);
        this.temp.transform(this.t6, p2);
    }
}

