/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.jnu.geom.JnAffineTransform;
import com.ge.med.jnu.geom.JnPoint2D;
import com.ge.med.terra.jami.XpImageOrientationBase;

public final class XpImageOrientation
extends XpImageOrientationBase {
    private static final double EPSILON = 1.0E-6;
    private static final JnAffineTransform flipMat = new JnAffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    private static final double DEG_90 = 1.5707963267948966;
    private static final double DEG_270 = 4.71238898038469;
    private static final double DEG_360 = Math.PI * 2;
    private boolean flip = false;
    private double angle = 0.0;
    private JnAffineTransform tx = new JnAffineTransform();
    private JnAffineTransform temp = new JnAffineTransform();

    public XpImageOrientation() {
        this.clear();
    }

    @Override
    public final JnAffineTransform getJnTransform() {
        return this.tx;
    }

    public XpImageOrientation(XpImageOrientation orientation) {
        this.angle = orientation.angle;
        this.flip = orientation.flip;
        this.temp = new JnAffineTransform(orientation.temp);
        this.tx = new JnAffineTransform(orientation.tx);
    }

    public final void reset() {
        if (this.flip) {
            this.flip_horizontal();
        }
        this.rotate(-this.angle);
    }

    public final void clear() {
        this.flip = false;
        this.angle = 0.0;
        this.tx.setToIdentity();
        this.temp.setToIdentity();
    }

    public final void rotate(double incAngle) {
        this.angle += incAngle;
        this.temp.setToRotation(incAngle);
        this.tx.preConcatenate(this.temp);
    }

    private void flip_horizontal() {
        this.flip = !this.flip;
        this.angle = -this.angle;
        this.tx.preConcatenate(flipMat);
    }

    public static XpImageOrientation createFromState(int state) {
        XpImageOrientation ior = new XpImageOrientation();
        ior.fillFromState(state);
        return ior;
    }

    public final int getState() {
        return this.getState(this.angle, this.flip);
    }

    private int getState(double angle, boolean flip) {
        double roundValueDeg;
        double diff;
        int quotient;
        double degAngle = Math.toDegrees(angle);
        double cAngle = degAngle - (double)(360 * (quotient = (int)(degAngle / 360.0)));
        if (cAngle < 0.0) {
            cAngle = 360.0 + cAngle;
        }
        if ((diff = Math.abs((roundValueDeg = (double)Math.round(cAngle)) - cAngle)) < 1.0E-6) {
            cAngle = roundValueDeg;
        }
        double quadrant = cAngle / 90.0;
        int iangle = (int)quadrant;
        if ((iangle %= 4) == 0 && !flip) {
            return 0;
        }
        if (iangle == 1 && !flip) {
            return 1;
        }
        if (iangle == 3 && !flip) {
            return 2;
        }
        if (iangle == 2 && !flip) {
            return 3;
        }
        if (iangle == 0 && flip) {
            return 4;
        }
        if (iangle == 1 && flip) {
            return 5;
        }
        if (iangle == 3 && flip) {
            return 6;
        }
        if (iangle == 2 && flip) {
            return 7;
        }
        return 0;
    }

    private final void fillFromState(int state) {
        this.tx.setToIdentity();
        switch (state) {
            case 0: {
                this.angle = 0.0;
                this.flip = false;
                break;
            }
            case 1: {
                this.angle = 1.5707963267948966;
                this.flip = false;
                break;
            }
            case 2: {
                this.angle = 4.71238898038469;
                this.flip = false;
                break;
            }
            case 3: {
                this.angle = Math.PI;
                this.flip = false;
                break;
            }
            case 4: {
                this.angle = 0.0;
                this.flip = true;
                break;
            }
            case 5: {
                this.angle = 1.5707963267948966;
                this.flip = true;
                break;
            }
            case 6: {
                this.angle = 4.71238898038469;
                this.flip = true;
                break;
            }
            case 7: {
                this.angle = Math.PI;
                this.flip = true;
            }
        }
    }

    public final void apply(XpImageOrientation ior) {
        double incAngle = ior.angle;
        if (ior.flip) {
            this.flip = !this.flip;
            incAngle += Math.PI;
        }
        this.angle += incAngle;
        this.tx.preConcatenate(ior.tx);
    }

    public final void apply(double angle, boolean flip) {
        if (this.flip != flip) {
            this.flip_horizontal();
        }
        this.rotate(angle);
    }

    public final void flipVertical() {
        this.flip_horizontal();
        this.rotate(Math.PI);
    }

    public final void flipHorizontal() {
        this.flip_horizontal();
    }

    public final void rotateRight() {
        this.rotate(1.5707963267948966);
    }

    public final void rotateLeft() {
        this.rotate(-1.5707963267948966);
    }

    public final void rotate180() {
        this.rotate(Math.PI);
    }

    public final double getAngle() {
        return this.angle;
    }

    public final boolean getFlip() {
        return this.flip;
    }

    public final void setAngle(double rotAngle) {
        this.rotate(rotAngle - this.angle);
    }

    public final String toString() {
        int state = this.getState(this.angle, this.flip);
        switch (state) {
            case 0: {
                return "0";
            }
            case 1: {
                return "90";
            }
            case 2: {
                return "270";
            }
            case 3: {
                return "180";
            }
            case 4: {
                return "0F";
            }
            case 5: {
                return "90F";
            }
            case 6: {
                return "270F";
            }
            case 7: {
                return "180F";
            }
        }
        String flipstr = this.flip ? "F" : "";
        return "" + this.angle + "" + flipstr;
    }

    public final void set(XpImageOrientation io) {
        if (io == this) {
            return;
        }
        this.angle = io.angle;
        this.flip = io.flip;
        this.tx.setTransform(io.tx);
    }

    public final double getPanX() {
        return this.tx.getTranslateX();
    }

    public final double getPanY() {
        return this.tx.getTranslateY();
    }

    @Override
    public final void setPan(double x2, double y2) {
        double px = this.tx.getTranslateX();
        double py = this.tx.getTranslateY();
        this.temp.setToTranslation(x2 - px, y2 - py);
        this.tx.preConcatenate(this.temp);
    }

    public final void setPan(JnPoint2D p2) {
        this.setPan(p2.getX(), p2.getY());
    }

    public final boolean equals(Object o2) {
        XpImageOrientation ior = (XpImageOrientation)o2;
        return ior.flip == this.flip && ior.angle == this.angle;
    }
}

