/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.capable.Replicable;

public class XpIndexPrism
implements Replicable {
    private int _len;
    private int[] _size;
    private int[] _index;
    private int[] _offset;
    private int[] _register;

    public XpIndexPrism(int[] size) {
        this.allocate(size);
    }

    public XpIndexPrism() {
        int[] size = new int[]{1};
        this.allocate(size);
    }

    public XpIndexPrism(XpIndexPrism other) {
        int i2;
        this.allocate(other._size);
        if (null != this._index) {
            for (i2 = 0; i2 < this._len; ++i2) {
                this._index[i2] = other._index[i2];
            }
        }
        if (null != other._offset) {
            this.allocateOffset();
            for (i2 = 0; i2 < this.getDimensions() * this._len; ++i2) {
                this._offset[i2] = other._offset[i2];
            }
        }
        if (null != this._register) {
            for (i2 = 0; i2 < other._register.length; ++i2) {
                this._register[i2] = other._register[i2];
            }
        }
    }

    @Override
    public Object clone() {
        XpIndexPrism ip = new XpIndexPrism(this);
        return ip;
    }

    public static boolean isArrayEqual(int[] a2, int[] b2) {
        boolean equality = true;
        if (a2 != null && b2 != null && a2.length == b2.length) {
            for (int i2 = 0; i2 < a2.length; ++i2) {
                equality = equality && a2[i2] == b2[i2];
            }
        } else if (a2 != null || b2 != null) {
            equality = false;
        }
        return equality;
    }

    public boolean equals(Object obj) {
        XpIndexPrism ip = (XpIndexPrism)obj;
        boolean equality = true;
        equality = equality && this._len == ip._len;
        equality = equality && XpIndexPrism.isArrayEqual(this._size, ip._size);
        equality = equality && XpIndexPrism.isArrayEqual(this._index, ip._index);
        equality = equality && XpIndexPrism.isArrayEqual(this._offset, ip._offset);
        return equality;
    }

    public final int getDimensions() {
        return this._size.length;
    }

    public final int getSize(int dim) {
        return dim < 0 ? 0 : (dim >= this.getDimensions() ? this.getDimensions() - 1 : this._size[dim]);
    }

    public final int getTotalSize() {
        return this._len;
    }

    public final int getAddress(int[] pos) {
        int addr = 0;
        for (int i2 = this.getDimensions() - 1; i2 >= 0; --i2) {
            if (pos[i2] < 0 || pos[i2] >= this.getSize(i2)) {
                return -1;
            }
            addr = (addr + pos[i2]) * (i2 > 0 ? this.getSize(i2 - 1) : 1);
        }
        return addr;
    }

    public final int getIndex(int[] pos) {
        int addr = this.getAddress(pos = this.addOffset(pos));
        return addr < 0 || null == this._index ? -1 : this._index[addr];
    }

    public final void setIndex(int[] pos, int index) {
        int addr = this.getAddress(pos = this.addOffset(pos));
        if (addr >= 0 && null != this._index) {
            this._index[addr] = index;
        }
    }

    public final boolean findIndex(int index, int[] pos) {
        int m2 = this.getTotalSize();
        for (int i2 = 0; i2 < m2; ++i2) {
            if (this._index[i2] != index) continue;
            return this.getPosition(i2, pos);
        }
        return false;
    }

    public void loadIndices(int[] indexArray) {
        for (int i2 = 0; i2 < this._len; ++i2) {
            this._index[i2] = indexArray[i2];
        }
    }

    public final void loadIdentity() {
        for (int i2 = 0; i2 < this._len; ++i2) {
            this._index[i2] = i2;
        }
    }

    public void setOffset(int offsetDimension, int value, int[] plane) {
        if (null == this._offset) {
            this.allocateOffset();
        }
        boolean shift = true;
        for (int i2 = 0; i2 < this._len; ++i2) {
            int k2 = i2;
            shift = true;
            for (int j2 = 0; j2 < this.getDimensions(); ++j2) {
                if (plane[j2] != -1 && plane[j2] != k2 % this.getSize(j2)) {
                    shift = false;
                    break;
                }
                k2 /= this.getSize(j2);
            }
            if (!shift) continue;
            this._offset[i2 * this.getDimensions() + offsetDimension] = value;
        }
    }

    public void clearOffsets() {
        if (null != this._offset) {
            for (int i2 = 0; i2 < this.getDimensions() * this._len; ++i2) {
                this._offset[i2] = 0;
            }
        }
    }

    public void print(int xdim, int ydim, int[] pos) {
        int i2;
        int[] p2 = new int[this.getDimensions()];
        for (i2 = 0; i2 < this.getDimensions(); ++i2) {
            System.out.print(i2 > 0 ? "x" : "" + this.getSize(i2));
            p2[i2] = pos[i2];
        }
        System.out.println(" prism plane (" + xdim + "," + ydim + ":");
        for (int j2 = 0; j2 < this.getSize(ydim); ++j2) {
            p2[ydim] = j2;
            for (i2 = 0; i2 < this.getSize(xdim); ++i2) {
                p2[xdim] = i2;
                int val = this.getIndex(p2);
                if (val < 0) {
                    System.out.print("... ");
                    continue;
                }
                System.out.print(val);
            }
            System.out.println("");
        }
    }

    private boolean getPosition(int address, int[] pos) {
        int m2 = this.getTotalSize();
        for (int i2 = this.getDimensions() - 1; i2 >= 0; --i2) {
            pos[i2] = address / (m2 /= this.getSize(i2));
            if (pos[i2] < 0 || pos[i2] >= this.getSize(i2)) {
                return false;
            }
            address -= pos[i2] * m2;
        }
        return true;
    }

    private int[] addOffset(int[] pos) {
        int addr;
        int i2;
        int[] reg = this._register;
        for (i2 = 0; i2 < this.getDimensions(); ++i2) {
            reg[i2] = pos[i2];
        }
        if (null != this._offset && (addr = this.getAddress(pos)) >= 0) {
            for (i2 = 0; i2 < this.getDimensions(); ++i2) {
                int n2 = i2;
                reg[n2] = reg[n2] + this._offset[addr * this.getDimensions() + i2];
            }
        }
        return reg;
    }

    private void allocate(int[] size) {
        this._len = 0;
        this._size = null;
        this._index = null;
        this._offset = null;
        if (size.length > 0) {
            int i2;
            this._register = new int[size.length];
            this._size = new int[size.length];
            this._len = 1;
            for (i2 = 0; i2 < size.length; ++i2) {
                this._size[i2] = size[i2];
                this._len *= size[i2];
            }
            this._index = new int[this._len];
            for (i2 = 0; i2 < this._len; ++i2) {
                this._index[i2] = -1;
            }
        }
    }

    private void allocateOffset() {
        int sz = this.getDimensions() * this._len;
        this._offset = new int[sz];
        this.clearOffsets();
    }
}

