/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

public class XpResponseCurve {
    protected double X1 = 100.0;
    protected double X2 = 250.0;
    protected double K1 = 0.2;
    protected double K2 = 3.0;
    protected double A;

    public XpResponseCurve(double X1, double X2, double K1, double K2) {
        this.X1 = X1;
        this.X2 = X2;
        this.K1 = K1;
        this.K2 = K2;
        this.init();
    }

    public XpResponseCurve() {
        this.init();
    }

    private void init() {
        this.A = Math.log(this.K2) / (this.X2 - this.X1);
    }

    public double response(double x2, double delta) {
        int sgn = 1;
        if (x2 < 0.0) {
            x2 = -x2;
            delta = -delta;
            sgn = -1;
        }
        double result = x2;
        if (delta <= this.X1 && delta >= 0.0) {
            result = Math.floor(x2 + this.K1 * delta);
        } else if (delta < 0.0 && delta >= -this.X1) {
            result = Math.ceil(x2 + this.K1 * delta);
        } else if (delta < -this.X1) {
            result = x2 <= this.K1 * this.X1 ? Math.ceil(x2 + this.K1 * delta) : Math.floor(Math.exp(this.A * (delta + this.X1) + Math.log(x2 - this.K1 * this.X1)));
        } else if (delta > this.X1) {
            result = Math.ceil(Math.exp(this.A * (delta - this.X1) + Math.log(x2 + this.K1 * this.X1)));
        }
        return (double)sgn * result;
    }
}

